/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.coverage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import org.h2.test.coverage.Tokenizer;

public class Coverage {
    static final String IMPORT = "import " + (class$org$h2$test$coverage$Coverage == null ? (class$org$h2$test$coverage$Coverage = Coverage.class$("org.h2.test.coverage.Coverage")) : class$org$h2$test$coverage$Coverage).getPackage().getName() + ".Profile";
    ArrayList files = new ArrayList();
    ArrayList exclude = new ArrayList();
    Tokenizer tokenizer;
    Writer writer;
    Writer data;
    String token = "";
    String add = "";
    String file;
    int index = 0;
    int indent = 0;
    int line;
    String last;
    String word;
    String function;
    boolean perClass;
    boolean perFunction = true;
    static /* synthetic */ Class class$org$h2$test$coverage$Coverage;

    void printUsage() {
        System.out.println("Usage:\n- copy all your source files to another directory\n  (be carefull, they will be modified - don't take originals!)\n- java " + this.getClass().getName() + " <directory>\n" + "  this will modified the source code and create 'profile.txt'\n" + "- compile the modified source files\n" + "- run your main application\n" + "- after the application exits, a file 'notcovered.txt' is created,\n" + "  which contains the class names, function names and line numbers\n" + "  of code that has not been covered\n\n" + "Options:\n" + "-r     recurse all subdirectories\n" + "-e     exclude files\n" + "-c     coverage on a per-class basis\n" + "-f     coverage on a per-function basis\n" + "<dir>  directory name (. for current directory)");
    }

    public static void main(String[] arg) {
        new Coverage().run(arg);
    }

    void run(String[] arg) {
        if (arg.length == 0 || arg[0].equals("-?")) {
            this.printUsage();
            return;
        }
        Coverage c = new Coverage();
        int recurse = 1;
        for (int i = 0; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equals("-r")) {
                recurse = 100;
                continue;
            }
            if (s.equals("-c")) {
                c.perClass = true;
                continue;
            }
            if (s.equals("-f")) {
                c.perFunction = true;
                continue;
            }
            if (s.equals("-e")) {
                c.addExclude(arg[++i]);
                continue;
            }
            c.addDir(s, recurse);
        }
        try {
            c.data = new BufferedWriter(new FileWriter("profile.txt"));
            c.processAll();
            c.data.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void addExclude(String file) {
        this.exclude.add(file);
    }

    boolean isExcluded(String s) {
        for (int i = 0; i < this.exclude.size(); ++i) {
            if (!s.startsWith(this.exclude.get(i).toString())) continue;
            return true;
        }
        return false;
    }

    void addDir(String path, int recurse) {
        File f = new File(path);
        if (f.isFile() && path.endsWith(".java")) {
            if (!this.isExcluded(path)) {
                this.files.add(path);
            }
        } else if (f.isDirectory() && recurse > 0) {
            String[] list = f.list();
            for (int i = 0; i < list.length; ++i) {
                this.addDir(path + "/" + list[i], recurse - 1);
            }
        }
    }

    void processAll() {
        int len = this.files.size();
        long time = System.currentTimeMillis();
        for (int i = 0; i < len; ++i) {
            long t2 = System.currentTimeMillis();
            if (t2 - time > 1000L || i >= len - 1) {
                System.out.println(i + 1 + " of " + len + " " + 100 * i / len + "%");
                time = t2;
            }
            String fileName = (String)this.files.get(i);
            this.processFile(fileName);
        }
    }

    void processFile(String name) {
        this.file = name;
        int i = this.file.lastIndexOf(46);
        if (i != -1) {
            this.file = this.file.substring(0, i);
        }
        while (true) {
            if ((i = this.file.indexOf(47)) < 0) {
                i = this.file.indexOf(92);
            }
            if (i < 0) break;
            this.file = this.file.substring(0, i) + "." + this.file.substring(i + 1);
        }
        if (name.endsWith("Coverage.java") || name.endsWith("Tokenizer.java") || name.endsWith("Profile.java")) {
            return;
        }
        File f = new File(name);
        File fnew = new File(name + ".new");
        String key = name;
        key = key.replace('\\', '.');
        try {
            this.writer = new BufferedWriter(new FileWriter(fnew));
            BufferedReader r = new BufferedReader(new FileReader(f));
            this.tokenizer = new Tokenizer(r);
            this.indent = 0;
            try {
                this.process();
            }
            catch (Exception e) {
                ((Reader)r).close();
                this.writer.close();
                e.printStackTrace();
                this.printError(e.getMessage());
                throw e;
            }
            ((Reader)r).close();
            this.writer.close();
            File fbak = new File(name + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            if (this.perClass) {
                this.nextDebug();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printError(e.getMessage());
        }
    }

    void read() throws Exception {
        this.last = this.token;
        String write = this.token;
        this.token = null;
        this.tokenizer.initToken();
        int i = this.tokenizer.nextToken();
        if (i != -1) {
            this.token = this.tokenizer.getString();
            if (this.token == null) {
                this.token = "" + (char)i;
            } else if (i == 39) {
                this.token = this.tokenizer.getToken();
            } else if (i == 34) {
                this.token = this.tokenizer.getToken();
            } else {
                write = write == null ? "" : write + " ";
            }
        }
        if (!(write != null && (write.equals("else ") || write.equals("else") || write.equals("super ") || write.equals("super") || write.equals("this ") || write.equals("this") || write.equals("} ") || write.equals("}")) || this.add == null || this.add.equals(""))) {
            this.writeLine();
            this.write(this.add);
            if (!this.perClass) {
                this.nextDebug();
            }
        }
        this.add = "";
        if (write != null) {
            this.write(write);
        }
    }

    void readThis(String s) throws Exception {
        if (!this.token.equals(s)) {
            throw new Exception("Expected: " + s + " got:" + this.token);
        }
        this.read();
    }

    void process() throws Exception {
        boolean imp = false;
        this.read();
        while (true) {
            if (this.token != null && !this.token.equals("{")) {
                if (this.token.equals(";") && !imp) {
                    this.write(";" + IMPORT);
                    imp = true;
                }
                this.read();
                continue;
            }
            this.processClass();
            if (this.token == null) break;
        }
    }

    void processInit() throws Exception {
        while (true) {
            if (this.token.equals("{")) {
                this.read();
                this.processInit();
                continue;
            }
            if (this.token.equals("}")) {
                this.read();
                return;
            }
            this.read();
        }
    }

    void processClass() throws Exception {
        int type = 0;
        while (this.token != null) {
            if (this.token.equals("class")) {
                this.read();
                type = 1;
                continue;
            }
            if (this.token.equals("=")) {
                this.read();
                type = 2;
                continue;
            }
            if (this.token.equals("static")) {
                this.word = "static";
                this.read();
                type = 3;
                continue;
            }
            if (this.token.equals("(")) {
                this.word = this.last + "(";
                this.read();
                if (!this.token.equals(")")) {
                    this.word = this.word + this.token;
                }
                type = 3;
                continue;
            }
            if (this.token.equals(",")) {
                this.read();
                this.word = this.word + "," + this.token;
                continue;
            }
            if (this.token.equals(")")) {
                this.word = this.word + ")";
                this.read();
                continue;
            }
            if (this.token.equals(";")) {
                this.read();
                type = 0;
                continue;
            }
            if (this.token.equals("{")) {
                this.read();
                if (type == 1) {
                    this.processClass();
                    continue;
                }
                if (type == 2) {
                    this.processInit();
                    continue;
                }
                if (type != 3) continue;
                this.writeLine();
                this.setLine();
                this.processFunction();
                this.writeLine();
                continue;
            }
            if (this.token.equals("}")) {
                this.read();
                break;
            }
            this.read();
        }
    }

    void processBraket() throws Exception {
        while (true) {
            if (this.token.equals("(")) {
                this.read();
                this.processBraket();
                continue;
            }
            if (this.token.equals(")")) {
                this.read();
                return;
            }
            this.read();
        }
    }

    void processFunction() throws Exception {
        this.function = this.word;
        this.writeLine();
        do {
            this.processStatement();
        } while (!this.token.equals("}"));
        this.read();
        this.writeLine();
    }

    void processBlockOrStatement() throws Exception {
        if (!this.token.equals("{")) {
            this.write("{ //++");
            this.writeLine();
            this.setLine();
            this.processStatement();
            this.write("} //++");
            this.writeLine();
        } else {
            this.read();
            this.setLine();
            this.processFunction();
        }
    }

    void processStatement() throws Exception {
        while (true) {
            if (this.token.equals("while") || this.token.equals("for") || this.token.equals("synchronized")) {
                this.read();
                this.readThis("(");
                this.processBraket();
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                return;
            }
            if (this.token.equals("if")) {
                this.read();
                this.readThis("(");
                this.processBraket();
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                if (this.token.equals("else")) {
                    this.read();
                    ++this.indent;
                    this.processBlockOrStatement();
                    --this.indent;
                }
                return;
            }
            if (this.token.equals("try")) {
                this.read();
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                while (true) {
                    if (this.token.equals("catch")) {
                        this.read();
                        this.readThis("(");
                        this.processBraket();
                        ++this.indent;
                        this.processBlockOrStatement();
                        --this.indent;
                        continue;
                    }
                    if (!this.token.equals("finally")) break;
                    this.read();
                    ++this.indent;
                    this.processBlockOrStatement();
                    --this.indent;
                }
                return;
            }
            if (this.token.equals("{")) {
                if (this.last.equals(")")) {
                    this.read();
                    this.processClass();
                    return;
                }
                if (this.last.equals("]")) {
                    while (!this.token.equals("}")) {
                        this.read();
                    }
                    this.read();
                    return;
                }
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                return;
            }
            if (this.token.equals("do")) {
                this.read();
                ++this.indent;
                this.processBlockOrStatement();
                this.readThis("while");
                this.readThis("(");
                this.processBraket();
                this.readThis(";");
                this.setLine();
                --this.indent;
                return;
            }
            if (this.token.equals("case")) {
                this.add = "";
                this.read();
                while (!this.token.equals(":")) {
                    this.read();
                }
                this.read();
                this.setLine();
                continue;
            }
            if (this.token.equals("default")) {
                this.add = "";
                this.read();
                this.readThis(":");
                this.setLine();
                continue;
            }
            if (this.token.equals("switch")) {
                this.read();
                this.readThis("(");
                this.processBraket();
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                return;
            }
            if (this.token.equals("class")) {
                this.read();
                this.processClass();
                return;
            }
            if (this.token.equals("(")) {
                this.read();
                this.processBraket();
                continue;
            }
            if (this.token.equals("=")) {
                this.read();
                if (!this.token.equals("{")) continue;
                this.read();
                this.processInit();
                continue;
            }
            if (this.token.equals(";")) {
                this.read();
                this.setLine();
                return;
            }
            if (this.token.equals("}")) {
                return;
            }
            this.read();
        }
    }

    void setLine() throws Exception {
        this.add = this.add + "Profile.visit(" + this.index + ");";
        this.line = this.tokenizer.getLine();
    }

    void nextDebug() throws Exception {
        if (this.perFunction) {
            int i = this.function.indexOf("(");
            String func = i < 0 ? this.function : this.function.substring(0, i);
            String fileLine = this.file + "." + func + "(";
            i = this.file.lastIndexOf(46);
            String fil = i < 0 ? this.file : this.file.substring(i + 1);
            fileLine = fileLine + fil + ".java:" + this.line + ")";
            this.data.write(fileLine + " " + this.last + "\r\n");
        } else {
            this.data.write(this.file + " " + this.line + "\r\n");
        }
        ++this.index;
    }

    void writeLine() throws Exception {
        this.write("\r\n");
        for (int i = 0; i < this.indent; ++i) {
            this.writer.write(32);
        }
    }

    void write(String s) throws Exception {
        this.writer.write(s);
    }

    void printError(String error) {
        System.out.println("");
        System.out.println("File:" + this.file);
        System.out.println("ERROR: " + error);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

