/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.tools.SimpleResultSet;

public class TestFunctions
extends TestBase {
    Statement stat;

    public void test() throws Exception {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        this.stat = conn.createStatement();
        this.test("abs(null)", null);
        this.test("abs(1)", "1");
        this.test("abs(1)", "1");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        this.stat.execute("CREATE ALIAS ADDROW FOR \"" + this.getClass().getName() + ".addRow\"");
        ResultSet rs = this.stat.executeQuery("CALL ADDROW(1, 'Hello')");
        rs.next();
        this.check(rs.getInt(1), 1L);
        rs = this.stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getString(2), "Hello");
        this.checkFalse(rs.next());
        rs = this.stat.executeQuery("CALL ADDROW(2, 'World')");
        this.stat.execute("CREATE ALIAS SEL FOR \"" + this.getClass().getName() + ".select\"");
        rs = this.stat.executeQuery("CALL SEL('SELECT * FROM TEST ORDER BY ID')");
        this.check(rs.getMetaData().getColumnCount(), 2L);
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getString(2), "Hello");
        rs.next();
        this.check(rs.getInt(1), 2L);
        this.check(rs.getString(2), "World");
        this.checkFalse(rs.next());
        rs = this.stat.executeQuery("SELECT SEL('SELECT * FROM TEST WHERE ID=' || ID) FROM TEST ORDER BY ID");
        this.check(rs.getMetaData().getColumnCount(), 1L);
        rs.next();
        this.check("((1, Hello))", rs.getString(1));
        rs.next();
        this.check("((2, World))", rs.getString(1));
        this.checkFalse(rs.next());
        rs = this.stat.executeQuery("SELECT SEL('SELECT * FROM TEST ORDER BY ID') FROM DUAL");
        this.check(rs.getMetaData().getColumnCount(), 1L);
        rs.next();
        this.check("((1, Hello), (2, World))", rs.getString(1));
        this.checkFalse(rs.next());
        try {
            rs = this.stat.executeQuery("CALL SEL('ERROR')");
            this.error("expected error");
        }
        catch (SQLException e) {
            this.check("42001", e.getSQLState());
        }
        this.stat.execute("CREATE ALIAS SIMPLE FOR \"" + this.getClass().getName() + ".simpleResultSet\"");
        rs = this.stat.executeQuery("CALL SIMPLE(2)");
        this.check(rs.getMetaData().getColumnCount(), 2L);
        rs.next();
        this.check(rs.getInt(1), 0L);
        this.check(rs.getString(2), "Hello");
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getString(2), "World");
        this.checkFalse(rs.next());
        rs = this.stat.executeQuery("SELECT * FROM SIMPLE(1)");
        this.check(rs.getMetaData().getColumnCount(), 2L);
        rs.next();
        this.check(rs.getInt(1), 0L);
        this.check(rs.getString(2), "Hello");
        this.checkFalse(rs.next());
        this.stat.execute("CREATE ALIAS ARRAY FOR \"" + this.getClass().getName() + ".getArray\"");
        rs = this.stat.executeQuery("CALL ARRAY()");
        this.check(rs.getMetaData().getColumnCount(), 2L);
        rs.next();
        this.check(rs.getInt(1), 0L);
        this.check(rs.getString(2), "Hello");
        this.checkFalse(rs.next());
        this.stat.execute("CREATE ALIAS ROOT FOR \"" + this.getClass().getName() + ".root\"");
        rs = this.stat.executeQuery("CALL ROOT(9)");
        rs.next();
        this.check(rs.getInt(1), 3L);
        this.checkFalse(rs.next());
        rs = this.stat.executeQuery("CALL CASE WHEN -9 < 0 THEN 0 ELSE ROOT(-9) END");
        rs.next();
        this.check(rs.getInt(1), 0L);
        this.checkFalse(rs.next());
        conn.close();
    }

    void test(String sql, String value) throws Exception {
        ResultSet rs = this.stat.executeQuery("CALL " + sql);
        rs.next();
        String s = rs.getString(1);
        this.check(value, s);
    }

    public static int addRow(Connection conn, int id, String name) throws SQLException {
        conn.createStatement().execute("INSERT INTO TEST VALUES(" + id + ", '" + name + "')");
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM TEST");
        rs.next();
        int result = rs.getInt(1);
        rs.close();
        return result;
    }

    public static ResultSet select(Connection conn, String sql) throws SQLException {
        return conn.createStatement().executeQuery(sql);
    }

    public static Object[] getArray() {
        return new Object[]{new Integer(0), "Hello"};
    }

    public static ResultSet simpleResultSet(Integer count) throws SQLException {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("ID", 4, 10, 0);
        rs.addColumn("NAME", 12, 255, 0);
        if (count != null) {
            if (count >= 1) {
                rs.addRow(new Object[]{new Integer(0), "Hello"});
            }
            if (count >= 2) {
                rs.addRow(new Object[]{new Integer(1), "World"});
            }
        }
        return rs;
    }

    public static int root(int value) {
        if (value < 0) {
            new Exception("function called but should not").printStackTrace();
        }
        return (int)Math.sqrt(value);
    }
}

