/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.ac3;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sourceforge.jffmpeg.GPLLicense;
import net.sourceforge.jffmpeg.JMFCodec;
import net.sourceforge.jffmpeg.codecs.audio.ac3.AC3Exception;
import net.sourceforge.jffmpeg.codecs.audio.ac3.Quantizer;
import net.sourceforge.jffmpeg.codecs.audio.ac3.SoundOutput;
import net.sourceforge.jffmpeg.codecs.audio.ac3.data.Tables;
import net.sourceforge.jffmpeg.codecs.utils.BitStream;
import net.sourceforge.jffmpeg.codecs.utils.FFMpegException;

public class AC3Decoder
implements Codec,
GPLLicense,
JMFCodec {
    public static final boolean debug = false;
    int bias = 0;
    public static final int SYNC_BYTES = 2935;
    public static final int HEADER_LENGTH = 7;
    public static final int A52_CHANNEL = 0;
    public static final int A52_MONO = 1;
    public static final int A52_STEREO = 2;
    public static final int A52_3F = 3;
    public static final int A52_2F1R = 4;
    public static final int A52_3F1R = 5;
    public static final int A52_2F2R = 6;
    public static final int A52_3F2R = 7;
    public static final int A52_CHANNEL1 = 8;
    public static final int A52_CHANNEL2 = 9;
    public static final int A52_DOLBY = 10;
    public static final int A52_CHANNEL_MASK = 15;
    public static final int A52_LFE = 16;
    public static final int A52_ADJUST_LEVEL = 32;
    private static double LEVEL_PLUS6DB = 2.0;
    private static double LEVEL_PLUS3DB = 1.4142135623730951;
    private static double LEVEL_3DB = 0.7071067811865476;
    private static double LEVEL_45DB = 0.5946035575013605;
    private static double LEVEL_6DB = 0.5;
    private static final int EXP_REUSE = 0;
    private static final int EXP_D15 = 1;
    private static final int EXP_D25 = 2;
    private static final int EXP_D45 = 3;
    private static final int DELTA_BIT_REUSE = 0;
    private static final int DELTA_BIT_NEW = 1;
    private static final int DELTA_BIT_NONE = 2;
    private static final int DELTA_BIT_RESERVED = 3;
    private int flags;
    private int sample_rate;
    private int bit_rate;
    private int frame_length;
    private int fscod;
    private int halfrate;
    private int acmod;
    private double clev;
    private double slev;
    private boolean lfeon;
    private int language;
    public static final int MAX_CHANNELS = 5;
    public static final int MAX_BANDS = 18;
    public static final int EXPONENT_SIZE = 256;
    public static final int MAX_DELT_BA_SIZE = 50;
    private double level = 200.0;
    public boolean dynrnge = false;
    private double dynrng;
    private int chincpl;
    private boolean phsflginu;
    private int ncplbnd;
    private int cplstrtbnd;
    private int cplstrtmant;
    private int cplendmant;
    private int cplbndstrc;
    private double[][] cplco = new double[5][18];
    private int rematflg;
    private int[] endmant = new int[5];
    private byte[] cpl_expbapExp = new byte[256];
    private byte[][] fbw_expbapExp = new byte[5][256];
    private byte[] lfe_expbapExp = new byte[256];
    private byte[] cpl_expbapBap = new byte[256];
    private byte[][] fbw_expbapBap = new byte[5][256];
    private byte[] lfe_expbapBap = new byte[256];
    private int bai;
    private int cplbaBai;
    private int cplbaDeltbae;
    private int[] cplbaDeltba = new int[50];
    private int[] baBai = new int[5];
    private int[] baDeltbae = new int[5];
    private int[][] baDeltba = new int[5][50];
    private int lfebaBai;
    private int lfebaDeltbae;
    private int[] lfebaDeltba = new int[50];
    private int csnroffst;
    private int cplfleak;
    private int cplsleak;
    private int lfsr_state = 1;
    private Quantizer quant = new Quantizer();
    private double[] samplesOut = new double[3584];
    private boolean downmixed;
    BitStream in = new BitStream();
    public static final int[] halfRate = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3};
    public static final int[] rate = new int[]{32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, 448, 512, 576, 640};
    public static final int[] lfeonValues = new int[]{16, 16, 4, 4, 4, 1, 4, 1};
    public static final double[] clevValues = new double[]{LEVEL_3DB, LEVEL_45DB, LEVEL_6DB, LEVEL_45DB};
    public static final double[] slevValues = new double[]{LEVEL_3DB, LEVEL_6DB, 0.0, LEVEL_6DB};
    public final byte[] exp_1 = Tables.getExponentTable1();
    public final byte[] exp_2 = Tables.getExponentTable2();
    public final byte[] exp_3 = Tables.getExponentTable3();
    public final int[] dither_lutp = Tables.getDitherLoopupTable();
    public final double[] scale_factor = Tables.getScaleFactors();
    public final double[] q_1_0 = Tables.getQ10Table();
    public final double[] q_1_1 = Tables.getQ11Table();
    public final double[] q_1_2 = Tables.getQ12Table();
    public final double[] q_2_0 = Tables.getQ20Table();
    public final double[] q_2_1 = Tables.getQ21Table();
    public final double[] q_2_2 = Tables.getQ22Table();
    public final double[] q_3 = Tables.getQ3Table();
    public final double[] q_4_0 = Tables.getQ40Table();
    public final double[] q_4_1 = Tables.getQ41Table();
    public final double[] q_5 = Tables.getQ5Table();
    SoundOutput soundOutput = new SoundOutput();
    public static final int[] nfchansValues = new int[]{2, 1, 2, 3, 3, 4, 4, 5, 1, 1, 2};
    public static final int[] cplstrtbndValues = new int[]{31, 35, 37, 39, 41, 42, 43, 44, 45, 45, 46, 46, 47, 47, 48, 48};
    public static final int[] rematrix_band = new int[]{25, 37, 61, 253};
    private static final int[] slowgainValues = new int[]{1344, 1240, 1144, 1040};
    private static final int[] dbpbValues = new int[]{3072, 1280, 768, 256};
    private static final int[] floorValues = new int[]{2320, 2384, 2448, 2512, 2576, 2704, 2832, 5120};
    private static final int[][] hthValues = Tables.getBitAllocHthTable();
    private static final int[] zeroBaArray = new int[50];
    private static final byte[] bapTable = Tables.getBitAllocBapTable();
    private static final int[] bndTable = Tables.getBitAllocBndTable();
    private static final int[] laTable = Tables.getBitAllocLaTable();
    private AudioFormat inputFormat;
    private boolean readSyncBlock = true;

    private boolean a52_syncinfo() throws FFMpegException {
        while (this.in.showBits(16) != 2935) {
            this.in.getBits(8);
            if (this.in.availableBits() > 56) continue;
            return false;
        }
        this.in.getBits(16);
        this.in.getBits(16);
        int n = this.in.getBits(8);
        int n2 = this.in.getBits(8);
        int n3 = this.in.getBits(8);
        int n4 = halfRate[n2 >> 3];
        int n5 = n3 >> 5;
        this.flags = ((n3 & 0xF8) == 80 ? 10 : n5) | ((n3 & lfeonValues[n5]) != 0 ? 16 : 0);
        int n6 = n & 0x3F;
        if (n6 >= 38) {
            throw new AC3Exception("Unknown rate");
        }
        this.bit_rate = rate[n6 >> 1] * 1000 >> n4;
        switch (n & 0xC0) {
            case 0: {
                this.sample_rate = 48000 >> n4;
                this.frame_length = 4 * rate[n6 >> 1];
                break;
            }
            case 64: {
                this.sample_rate = 44100 >> n4;
                this.frame_length = 2 * (320 * rate[n6 >> 1] / 147 + (n6 & 1));
                break;
            }
            case 128: {
                this.sample_rate = 32000 >> n4;
                this.frame_length = 6 * rate[n6 >> 1];
                break;
            }
            default: {
                throw new AC3Exception("Unrecognised sample rate multiplier");
            }
        }
        this.in.seek(this.in.getPos() - 56);
        return true;
    }

    private void a52_frame() throws FFMpegException {
        this.in.getBits(32);
        this.fscod = this.in.getBits(3);
        this.in.getBits(5);
        int n = this.in.getBits(5);
        if (n >= halfRate.length) {
            throw new FFMpegException("Illegal half rate");
        }
        this.halfrate = halfRate[n];
        this.in.getBits(3);
        this.acmod = this.in.getBits(3);
        if (this.acmod != 2 || this.in.getBits(2) == 2) {
            // empty if block
        }
        this.clev = 0.0;
        if ((this.acmod & 1) != 0 && this.acmod != 1) {
            this.clev = clevValues[this.in.getBits(2)];
        }
        this.slev = 0.0;
        if ((this.acmod & 4) != 0) {
            this.slev = slevValues[this.in.getBits(2)];
        }
        this.lfeon = this.in.getTrueFalse();
        this.level = 2.0;
        this.downmix_init(this.acmod);
        this.level *= 2.0;
        this.dynrng = this.level;
        this.dynrnge = false;
        boolean bl = this.acmod == 0;
        do {
            this.in.getBits(5);
            if (this.in.getTrueFalse()) {
                this.in.getBits(8);
            }
            if (this.in.getTrueFalse()) {
                this.language = this.in.getBits(8);
            }
            if (!this.in.getTrueFalse()) continue;
            this.in.getBits(7);
        } while (!(bl = !bl));
        this.in.getBits(2);
        if (this.in.getTrueFalse()) {
            this.in.getBits(14);
        }
        if (this.in.getTrueFalse()) {
            this.in.getBits(14);
        }
        if (this.in.getTrueFalse()) {
            int n2 = this.in.getBits(6);
            this.in.seek(this.in.getPos() + n2 * 8);
        }
    }

    private void a52_block() throws FFMpegException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = nfchansValues[this.acmod];
        boolean[] blArray = new boolean[5];
        for (int i = 0; i < n12; ++i) {
            blArray[i] = this.in.getTrueFalse();
        }
        boolean[] blArray2 = new boolean[5];
        for (n11 = 0; n11 < n12; ++n11) {
            blArray2[n11] = this.in.getTrueFalse();
        }
        int n13 = n11 = this.acmod == 0 ? 1 : 0;
        do {
            if (!this.in.getTrueFalse()) continue;
            n10 = this.bitstream_get_2(8);
            if (!this.dynrnge) continue;
            this.dynrng = (double)((n10 & 0x1F | 0x20) << 13) * this.scale_factor[2 - (n10 >> 5)] * this.level;
        } while ((n11 = n11 == 0 ? 1 : 0) == 0);
        if (this.in.getTrueFalse()) {
            this.chincpl = 0;
            if (this.in.getTrueFalse()) {
                for (n10 = 0; n10 < n12; ++n10) {
                    this.chincpl |= this.in.getBits(1) << n10;
                }
                switch (this.acmod) {
                    case 0: 
                    case 1: {
                        throw new AC3Exception("Invalid mode");
                    }
                    case 2: {
                        this.phsflginu = this.in.getTrueFalse();
                    }
                }
                n10 = this.in.getBits(4);
                n9 = this.in.getBits(4);
                if (n9 + 3 - n10 < 0) {
                    throw new AC3Exception("Invalid values");
                }
                this.ncplbnd = n9 + 3 - n10;
                this.cplstrtbnd = cplstrtbndValues[n10];
                this.cplstrtmant = n10 * 12 + 37;
                this.cplendmant = n9 * 12 + 73;
                this.cplbndstrc = 0;
                n8 = this.ncplbnd;
                for (n7 = 0; n7 < n8 - 1; ++n7) {
                    if (!this.in.getTrueFalse()) continue;
                    this.cplbndstrc |= 1 << n7;
                    --this.ncplbnd;
                }
            }
        }
        if (this.chincpl != 0) {
            n10 = 0;
            for (n9 = 0; n9 < n12; ++n9) {
                if ((this.chincpl >> n9 & 1) == 0 || !this.in.getTrueFalse()) continue;
                n10 = 1;
                n8 = 3 * this.in.getBits(2);
                for (n7 = 0; n7 < this.ncplbnd; ++n7) {
                    n6 = this.in.getBits(4);
                    n5 = this.in.getBits(4);
                    n5 = n6 == 15 ? (n5 <<= 14) : (n5 | 0x10) << 13;
                    this.cplco[n9][n7] = (double)n5 * this.scale_factor[n6 + n8];
                }
            }
            if (this.acmod == 2 && this.phsflginu && n10 != 0) {
                for (n9 = 0; n9 < this.ncplbnd; ++n9) {
                    if (!this.in.getTrueFalse()) continue;
                    this.cplco[1][n9] = -this.cplco[1][n9];
                }
            }
        }
        if (this.acmod == 2 && this.in.getTrueFalse()) {
            this.rematflg = 0;
            n10 = this.chincpl != 0 ? this.cplstrtmant : 253;
            n9 = 0;
            do {
                this.rematflg |= this.in.getBits(1) << n9;
            } while (rematrix_band[n9++] < n10);
        }
        n10 = 0;
        n9 = 0;
        if (this.chincpl != 0) {
            n10 = this.in.getBits(2);
        }
        int[] nArray = new int[5];
        for (n7 = 0; n7 < n12; ++n7) {
            nArray[n7] = this.in.getBits(2);
        }
        if (this.lfeon) {
            n9 = this.in.getBits(1);
        }
        for (n7 = 0; n7 < n12; ++n7) {
            if (nArray[n7] == 0) continue;
            if ((this.chincpl >> n7 & 1) != 0) {
                this.endmant[n7] = this.cplstrtmant;
                continue;
            }
            n6 = this.in.getBits(6);
            if (n6 > 60) {
                throw new AC3Exception("chbwcod too large");
            }
            this.endmant[n7] = n6 * 3 + 73;
        }
        n7 = 0;
        if (n10 != 0) {
            n7 = 64;
            n6 = (this.cplendmant - this.cplstrtmant) / (3 << n10 - 1);
            n5 = (byte)(this.in.getBits(4) << 1);
            this.parse_exponents(n10, n6, (byte)n5, this.cpl_expbapExp, this.cplstrtmant);
        }
        for (n6 = 0; n6 < n12; ++n6) {
            if (nArray[n6] == 0) continue;
            n7 |= 1 << n6;
            n5 = 3 << nArray[n6] - 1;
            n4 = (this.endmant[n6] + n5 - 4) / n5;
            this.fbw_expbapExp[n6][0] = (byte)this.in.getBits(4);
            this.parse_exponents(nArray[n6], n4, this.fbw_expbapExp[n6][0], this.fbw_expbapExp[n6], 1);
            this.in.getBits(2);
        }
        if (n9 != 0) {
            n7 |= 0x20;
            this.lfe_expbapExp[0] = (byte)this.in.getBits(4);
            this.parse_exponents(n9, 2, this.lfe_expbapExp[0], this.lfe_expbapExp, 1);
        }
        if (this.in.getTrueFalse()) {
            n7 = 127;
            this.bai = this.in.getBits(11);
        }
        if (this.in.getTrueFalse()) {
            n7 = 127;
            this.csnroffst = this.in.getBits(6);
            if (this.chincpl != 0) {
                this.cplbaBai = this.in.getBits(7);
            }
            for (n6 = 0; n6 < n12; ++n6) {
                this.baBai[n6] = this.in.getBits(7);
            }
            if (this.lfeon) {
                this.lfebaBai = this.in.getBits(7);
            }
        }
        if (this.chincpl != 0 && this.in.getTrueFalse()) {
            n7 |= 0x40;
            this.cplfleak = 9 - this.in.getBits(3);
            this.cplsleak = 9 - this.in.getBits(3);
        }
        if (this.in.getTrueFalse()) {
            n7 = 127;
            if (this.chincpl != 0) {
                this.cplbaDeltbae = this.in.getBits(2);
            }
            for (n6 = 0; n6 < n12; ++n6) {
                this.baDeltbae[n6] = this.in.getBits(2);
            }
            if (this.chincpl != 0 && this.cplbaDeltbae == 1) {
                this.parse_deltba(this.cplbaDeltba);
            }
            for (n6 = 0; n6 < n12; ++n6) {
                if (this.baDeltbae[n6] != 1) continue;
                this.parse_deltba(this.baDeltba[n6]);
            }
        }
        if (n7 != 0) {
            if (this.zero_snr_offsets(n12)) {
                for (n6 = 0; n6 < this.cpl_expbapBap.length; ++n6) {
                    this.cpl_expbapBap[n6] = 0;
                }
                for (n6 = 0; n6 < n12; ++n6) {
                    for (n5 = 0; n5 < this.fbw_expbapBap[n6].length; ++n5) {
                        this.fbw_expbapBap[n6][n5] = 0;
                    }
                }
                for (n6 = 0; n6 < this.lfe_expbapBap.length; ++n6) {
                    this.lfe_expbapBap[n6] = 0;
                }
            } else {
                if (this.chincpl != 0 && (n7 & 0x40) != 0) {
                    this.a52_bit_allocate(this.cplbaBai, this.cplbaDeltbae, this.cplbaDeltba, this.cplstrtbnd, this.cplstrtmant, this.cplendmant, this.cplfleak << 8, this.cplsleak << 8, this.cpl_expbapExp, this.cpl_expbapBap);
                }
                for (n6 = 0; n6 < n12; ++n6) {
                    if ((n7 & 1 << n6) == 0) continue;
                    this.a52_bit_allocate(this.baBai[n6], this.baDeltbae[n6], this.baDeltba[n6], 0, 0, this.endmant[n6], 0, 0, this.fbw_expbapExp[n6], this.fbw_expbapBap[n6]);
                }
                if (this.lfeon && (n7 & 0x20) != 0) {
                    this.lfebaDeltbae = 2;
                    this.a52_bit_allocate(this.lfebaBai, this.lfebaDeltbae, this.lfebaDeltba, 0, 0, 7, 0, 0, this.lfe_expbapExp, this.lfe_expbapBap);
                }
            }
        }
        if (this.in.getTrueFalse()) {
            n6 = this.in.getBits(9);
            this.in.seek(this.in.getPos() + n6 * 8);
        }
        n6 = 0;
        n6 += 256;
        double[] dArray = new double[5];
        this.a52_downmix_coeff(dArray, this.acmod, this.dynrng, this.clev, this.slev);
        n4 = 0;
        this.quant.setQ1Pointer(-1);
        this.quant.setQ2Pointer(-1);
        this.quant.setQ4Pointer(-1);
        for (n3 = 0; n3 < n12; ++n3) {
            this.coeff_get(this.samplesOut, n6 + 256 * n3, this.fbw_expbapExp[n3], this.fbw_expbapBap[n3], this.quant, dArray[n3], blArray2[n3], this.endmant[n3]);
            if ((this.chincpl >> n3 & 1) != 0) {
                if (n4 == 0) {
                    n4 = 1;
                    this.coeff_get_coupling(n12, dArray, this.samplesOut, n6, this.quant, blArray2);
                }
                n2 = this.cplendmant;
            } else {
                n2 = this.endmant[n3];
            }
            do {
                this.samplesOut[n6 + 256 * n3 + n2] = 0.0;
            } while (++n2 < 256);
        }
        if (this.acmod == 2) {
            n3 = 0;
            n2 = 13;
            n = this.endmant[0] < this.endmant[1] ? this.endmant[0] : this.endmant[1];
            int n14 = this.rematflg;
            do {
                int n15;
                if ((n14 & 1) == 0) {
                    n14 >>= 1;
                    n2 = rematrix_band[n3++];
                    continue;
                }
                n14 >>= 1;
                if ((n15 = rematrix_band[n3++]) > n) {
                    n15 = n;
                }
                do {
                    double d = this.samplesOut[n6 + n2];
                    double d2 = this.samplesOut[n6 + n2 + 256];
                    this.samplesOut[n6 + n2] = d + d2;
                    this.samplesOut[n6 + n2 + 256] = d - d2;
                } while (++n2 < n15);
            } while (n2 < n);
        }
        if (this.lfeon) {
            this.coeff_get(this.samplesOut, n6 - 256, this.lfe_expbapExp, this.lfe_expbapBap, this.quant, 0.0, false, 7);
            for (n3 = 7; n3 < 256; ++n3) {
                this.samplesOut[n6 - 256 + n3] = 0.0;
            }
            this.soundOutput.a52_imdct_512(this.samplesOut, n6 - 256, n6 - 256 + 1536, this.bias);
        }
        n3 = 0;
        if (2 < n12) {
            for (n3 = 1; n3 < n12 && blArray[n3] == blArray[0]; ++n3) {
            }
        }
        if (n3 < n12) {
            if (this.downmixed) {
                this.downmixed = false;
            }
            for (n3 = 0; n3 < n12; ++n3) {
                if (dArray[n3] != 0.0) {
                    if (blArray[n3]) {
                        this.soundOutput.a52_imdct_256(this.samplesOut, n6 + 256 * n3, n6 + 1536 + 256 * n3, this.bias);
                        continue;
                    }
                    this.soundOutput.a52_imdct_512(this.samplesOut, n6 + 256 * n3, n6 + 1536 + 256 * n3, this.bias);
                    continue;
                }
                for (n2 = 0; n2 < 256; ++n2) {
                    this.samplesOut[n6 + 256 * n3 + n2] = 0.0;
                }
            }
        } else {
            n = 0;
            if (!this.downmixed) {
                this.downmixed = true;
            }
            if (blArray[0]) {
                for (n3 = 0; n3 < n12; ++n3) {
                    this.soundOutput.a52_imdct_256(this.samplesOut, n6 + 256 * n3, n6 + 1536 + 256 * n3, n);
                }
            } else {
                for (n3 = 0; n3 < n12; ++n3) {
                    this.soundOutput.a52_imdct_512(this.samplesOut, n6 + 256 * n3, n6 + 1536 + 256 * n3, n);
                }
            }
        }
    }

    private void a52_bit_allocate(int n, int n2, int[] nArray, int n3, int n4, int n5, int n6, int n7, byte[] byArray, byte[] byArray2) {
        int n8;
        int n9;
        int n10;
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        int n11 = 63 + 20 * (this.bai >> 7 & 3) >> this.halfrate;
        int n12 = 128 + 128 * (n & 7);
        int n13 = 15 + 2 * (this.bai >> 9) >> this.halfrate;
        int n14 = slowgainValues[this.bai >> 5 & 3];
        int n15 = dbpbValues[this.bai >> 3 & 3];
        int[] nArray2 = hthValues[this.fscod];
        if (n2 == 2) {
            nArray = zeroBaArray;
        }
        int n16 = floorValues[this.bai & 7];
        int n17 = 960 - 64 * this.csnroffst - 4 * (n >> 3) + n16;
        n16 >>= 5;
        int n18 = n3;
        int n19 = n4;
        if (n4 == 0) {
            n10 = 0;
            n19 = n5 - 1;
            do {
                if (n18 < n19) {
                    if (byArray3[n18 + 1] == byArray3[n18] - 2) {
                        n10 = 384;
                    } else if (n10 != 0 && byArray3[n18 + 1] > byArray3[n18]) {
                        n10 -= 64;
                    }
                }
                n9 = 128 * byArray3[n18];
                n8 = n9 + n12 + n10;
                if (n9 > n15) {
                    n8 -= n9 - n15 >> 2;
                }
                if (n8 > nArray2[n18 >> this.halfrate]) {
                    n8 = nArray2[n18 >> this.halfrate];
                }
                n8 = (n8 -= n17 + 128 * nArray[n18]) > 0 ? 0 : -n8 >> 5;
                byArray4[n18] = bapTable[156 + (n8 -= n16) + 4 * byArray3[n18]];
            } while (++n18 < 3 || n18 < 7 && byArray3[n18] > byArray3[n18 - 1]);
            n6 = n9 + n12;
            n7 = n9 + n14;
            while (n18 < 7) {
                if (n18 < n19) {
                    if (byArray3[n18 + 1] == byArray3[n18] - 2) {
                        n10 = 384;
                    } else if (n10 != 0 && byArray3[n18 + 1] > byArray3[n18]) {
                        n10 -= 64;
                    }
                }
                if ((n6 += n11) > (n9 = 128 * byArray3[n18]) + n12) {
                    n6 = n9 + n12;
                }
                if ((n7 += n13) > n9 + n14) {
                    n7 = n9 + n14;
                }
                int n20 = n8 = n6 + n10 < n7 ? n6 + n10 : n7;
                if (n9 > n15) {
                    n8 -= n9 - n15 >> 2;
                }
                if (n8 > nArray2[n18 >> this.halfrate]) {
                    n8 = nArray2[n18 >> this.halfrate];
                }
                n8 = (n8 -= n17 + 128 * nArray[n18]) > 0 ? 0 : -n8 >> 5;
                byArray4[n18] = bapTable[156 + (n8 -= n16) + 4 * byArray3[n18]];
                ++n18;
            }
            if (n5 == 7) {
                return;
            }
            do {
                if (byArray3[n18 + 1] == byArray3[n18] - 2) {
                    n10 = 320;
                } else if (n10 != 0 && byArray3[n18 + 1] > byArray3[n18]) {
                    n10 -= 64;
                }
                n9 = 128 * byArray3[n18];
                if ((n6 += n11) > n9 + n12) {
                    n6 = n9 + n12;
                }
                if ((n7 += n13) > n9 + n14) {
                    n7 = n9 + n14;
                }
                int n21 = n8 = n6 + n10 < n7 ? n6 + n10 : n7;
                if (n9 > n15) {
                    n8 -= n9 - n15 >> 2;
                }
                if (n8 > nArray2[n18 >> this.halfrate]) {
                    n8 = nArray2[n18 >> this.halfrate];
                }
                n8 = (n8 -= n17 + 128 * nArray[n18]) > 0 ? 0 : -n8 >> 5;
                byArray4[n18] = bapTable[156 + (n8 -= n16) + 4 * byArray3[n18]];
            } while (++n18 < 20);
            while (n10 > 128) {
                n10 -= 128;
                n9 = 128 * byArray3[n18];
                if ((n6 += n11) > n9 + n12) {
                    n6 = n9 + n12;
                }
                if ((n7 += n13) > n9 + n14) {
                    n7 = n9 + n14;
                }
                int n22 = n8 = n6 + n10 < n7 ? n6 + n10 : n7;
                if (n9 > n15) {
                    n8 -= n9 - n15 >> 2;
                }
                if (n8 > nArray2[n18 >> this.halfrate]) {
                    n8 = nArray2[n18 >> this.halfrate];
                }
                n8 = (n8 -= n17 + 128 * nArray[n18]) > 0 ? 0 : -n8 >> 5;
                byArray4[n18] = bapTable[156 + (n8 -= n16) + 4 * byArray3[n18]];
                ++n18;
            }
            n19 = n18;
        }
        do {
            n10 = n19;
            int n23 = bndTable[n18 - 20] < n5 ? bndTable[n18 - 20] : n5;
            n9 = 128 * byArray3[n19++];
            while (n19 < n23) {
                int n24 = 128 * byArray3[n19++];
                int n25 = n24 - n9;
                switch (n25 >> 9) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: {
                        n9 = n24;
                        break;
                    }
                    case -1: {
                        n9 = n24 + laTable[-n25 >> 1];
                        break;
                    }
                    case 0: {
                        n9 += laTable[n25 >> 1];
                    }
                }
            }
            if ((n6 += n11) > n9 + n12) {
                n6 = n9 + n12;
            }
            if ((n7 += n13) > n9 + n14) {
                n7 = n9 + n14;
            }
            int n26 = n8 = n6 < n7 ? n6 : n7;
            if (n9 > n15) {
                n8 -= n9 - n15 >> 2;
            }
            if (n8 > nArray2[n18 >> this.halfrate]) {
                n8 = nArray2[n18 >> this.halfrate];
            }
            n8 = (n8 -= n17 + 128 * nArray[n18]) > 0 ? 0 : -n8 >> 5;
            n8 -= n16;
            ++n18;
            n19 = n10;
            do {
                byArray4[n19] = bapTable[156 + n8 + 4 * byArray3[n19]];
            } while (++n19 < n23);
        } while (n19 < n5);
    }

    private boolean zero_snr_offsets(int n) {
        if (this.csnroffst != 0 || this.chincpl != 0 && this.cplbaBai >> 3 != 0 || this.lfeon && this.lfebaBai >> 3 != 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.baBai[i] >> 3 == 0) continue;
            return false;
        }
        return true;
    }

    private int dither_gen() {
        int n = this.dither_lutp[this.lfsr_state >> 8] ^ this.lfsr_state << 8;
        n = (n & 0x8000) != 0 ? (n |= 0xFFFF0000) : (n &= 0xFFFF);
        this.lfsr_state = n & 0xFFFF;
        return n;
    }

    private void coeff_get(double[] dArray, int n, byte[] byArray, byte[] byArray2, Quantizer quantizer, double d, boolean bl, int n2) throws FFMpegException {
        int n3;
        double[] dArray2 = new double[25];
        for (n3 = 0; n3 <= 24; ++n3) {
            dArray2[n3] = this.scale_factor[n3] * d;
        }
        block9: for (n3 = 0; n3 < n2; ++n3) {
            byte by = byArray2[n3];
            switch (by) {
                case 0: {
                    int n4;
                    if (bl) {
                        n4 = this.dither_gen();
                        dArray[n + n3] = (double)n4 * dArray2[byArray[n3]] * LEVEL_3DB;
                        continue block9;
                    }
                    dArray[n + n3] = 0.0;
                    continue block9;
                }
                case -1: {
                    if (quantizer.getQ1Pointer() >= 0) {
                        dArray[n + n3] = quantizer.getQ1()[quantizer.getQ1Pointer()] * dArray2[byArray[n3]];
                        quantizer.setQ1Pointer(quantizer.getQ1Pointer() - 1);
                        continue block9;
                    }
                    int n4 = this.in.getBits(5);
                    quantizer.setQ1Pointer(1);
                    quantizer.getQ1()[0] = this.q_1_2[n4];
                    quantizer.getQ1()[1] = this.q_1_1[n4];
                    dArray[n + n3] = this.q_1_0[n4] * dArray2[byArray[n3]];
                    continue block9;
                }
                case -2: {
                    if (quantizer.getQ2Pointer() >= 0) {
                        dArray[n + n3] = quantizer.getQ2()[quantizer.getQ2Pointer()] * dArray2[byArray[n3]];
                        quantizer.setQ2Pointer(quantizer.getQ2Pointer() - 1);
                        continue block9;
                    }
                    int n4 = this.in.getBits(7);
                    quantizer.setQ2Pointer(1);
                    quantizer.getQ2()[0] = this.q_2_2[n4];
                    quantizer.getQ2()[1] = this.q_2_1[n4];
                    dArray[n + n3] = this.q_2_0[n4] * dArray2[byArray[n3]];
                    continue block9;
                }
                case 3: {
                    dArray[n + n3] = this.q_3[this.in.getBits(3)] * dArray2[byArray[n3]];
                    continue block9;
                }
                case -3: {
                    if (quantizer.getQ4Pointer() == 0) {
                        dArray[n + n3] = quantizer.getQ4()[0] * dArray2[byArray[n3]];
                        quantizer.setQ4Pointer(-1);
                        continue block9;
                    }
                    int n4 = this.in.getBits(7);
                    quantizer.setQ4Pointer(0);
                    quantizer.getQ4()[0] = this.q_4_1[n4];
                    dArray[n + n3] = this.q_4_0[n4] * dArray2[byArray[n3]];
                    continue block9;
                }
                case 4: {
                    dArray[n + n3] = this.q_5[this.in.getBits(4)] * dArray2[byArray[n3]];
                    continue block9;
                }
                default: {
                    int n4 = this.bitstream_get_2(by);
                    dArray[n + n3] = (double)(n4 << 16 - by) * dArray2[byArray[n3]];
                }
            }
        }
    }

    private int bitstream_get_2(int n) {
        int n2 = this.in.getBits(n);
        if ((n2 & 1 << n - 1) != 0) {
            n2 |= -1 << n;
        }
        return n2;
    }

    private void coeff_get_coupling(int n, double[] dArray, double[] dArray2, int n2, Quantizer quantizer, boolean[] blArray) throws FFMpegException {
        double[] dArray3 = new double[5];
        byte[] byArray = this.cpl_expbapExp;
        byte[] byArray2 = this.cpl_expbapBap;
        int n3 = 0;
        int n4 = this.cplbndstrc;
        int n5 = this.cplstrtmant;
        while (n5 < this.cplendmant) {
            int n6 = n5 + 12;
            while ((n4 & 1) != 0) {
                n4 >>= 1;
                n6 += 12;
            }
            n4 >>= 1;
            for (int i = 0; i < n; ++i) {
                dArray3[i] = this.cplco[i][n3] * dArray[i];
            }
            ++n3;
            while (n5 < n6) {
                int n7;
                double d;
                byte by = byArray2[n5];
                switch (by) {
                    case 0: {
                        d = LEVEL_3DB * this.scale_factor[byArray[n5]];
                        for (n7 = 0; n7 < n; ++n7) {
                            if ((this.chincpl >> n7 & 1) == 0) continue;
                            dArray2[n2 + n5 + n7 * 256] = blArray[n7] ? d * dArray3[n7] * (double)this.dither_gen() : 0.0;
                        }
                        ++n5;
                        break;
                    }
                    case -1: {
                        if (quantizer.getQ1Pointer() >= 0) {
                            d = quantizer.getQ1()[quantizer.getQ1Pointer()];
                            quantizer.setQ1Pointer(quantizer.getQ1Pointer() - 1);
                            break;
                        }
                        n7 = this.in.getBits(5);
                        quantizer.setQ1Pointer(1);
                        quantizer.getQ1()[0] = this.q_1_2[n7];
                        quantizer.getQ1()[1] = this.q_1_1[n7];
                        d = this.q_1_0[n7];
                        break;
                    }
                    case -2: {
                        if (quantizer.getQ2Pointer() >= 0) {
                            d = quantizer.getQ2()[quantizer.getQ2Pointer()];
                            quantizer.setQ2Pointer(quantizer.getQ2Pointer() - 1);
                            break;
                        }
                        n7 = this.in.getBits(7);
                        quantizer.setQ2Pointer(1);
                        quantizer.getQ2()[0] = this.q_2_2[n7];
                        quantizer.getQ2()[1] = this.q_2_1[n7];
                        d = this.q_2_0[n7];
                        break;
                    }
                    case 3: {
                        d = this.q_3[this.in.getBits(3)];
                        break;
                    }
                    case -3: {
                        if (quantizer.getQ4Pointer() == 0) {
                            d = quantizer.getQ4()[0];
                            quantizer.setQ4Pointer(-1);
                            break;
                        }
                        n7 = this.in.getBits(7);
                        quantizer.setQ4Pointer(0);
                        quantizer.getQ4()[0] = this.q_4_1[n7];
                        d = this.q_4_0[n7];
                        break;
                    }
                    case 4: {
                        d = this.q_5[this.in.getBits(4)];
                        break;
                    }
                    default: {
                        d = this.bitstream_get_2(by) << 16 - by;
                    }
                }
                if (by == 0) continue;
                d *= this.scale_factor[byArray[n5]];
                for (n7 = 0; n7 < n; ++n7) {
                    if ((this.chincpl >> n7 & 1) == 0) continue;
                    dArray2[n2 + n5 + n7 * 256] = d * dArray3[n7];
                }
                ++n5;
            }
        }
    }

    protected static String show_sample(double d) {
        String string;
        if (d == 0.0) {
            return "0";
        }
        if (d != 0.0) {
            while (d < 1.0 && d > -1.0) {
                d *= 10.0;
            }
            while (d > 10.0 || d < -10.0) {
                d /= 10.0;
            }
        }
        if ((string = Double.toString(d)).length() < 4) {
            string = string + "0000";
        }
        if (string.length() > 4) {
            string = string.substring(0, 4);
        }
        return string;
    }

    private void downmix_init(int n) {
    }

    private void a52_downmix_coeff(double[] dArray, int n, double d, double d2, double d3) {
        switch (n) {
            case 2: {
                dArray[0] = d;
                dArray[1] = d;
                dArray[2] = d;
                dArray[3] = d;
                dArray[4] = d;
                break;
            }
            case 3: {
                dArray[0] = d;
                dArray[1] = d * d2;
                dArray[2] = d;
                dArray[3] = d;
                dArray[4] = d;
                break;
            }
            case 4: {
                dArray[0] = d;
                dArray[1] = d;
                dArray[2] = d * d3 * LEVEL_3DB;
                dArray[3] = d;
                dArray[4] = d;
                break;
            }
            case 5: {
                dArray[0] = d;
                dArray[1] = d * d2;
                dArray[2] = d;
                dArray[3] = d * d3 * LEVEL_3DB;
                dArray[4] = d;
                break;
            }
            case 6: {
                dArray[0] = d;
                dArray[1] = d;
                dArray[2] = d * d3;
                dArray[3] = d * d3;
                dArray[4] = d;
                break;
            }
            case 7: {
                dArray[0] = d;
                dArray[1] = d * d2;
                dArray[2] = d;
                dArray[3] = d * d3;
                dArray[4] = d * d3;
                break;
            }
        }
    }

    private void parse_deltba(int[] nArray) throws FFMpegException {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        n = this.in.getBits(3);
        int n2 = 0;
        do {
            int n3;
            n2 += this.in.getBits(5);
            int n4 = this.in.getBits(4);
            n3 -= (n3 = this.in.getBits(3)) >= 4 ? 3 : 4;
            while (n4-- != 0) {
                nArray[n2++] = n3;
            }
        } while (n-- != 0);
    }

    private void parse_exponents(int n, int n2, byte by, byte[] byArray, int n3) throws FFMpegException {
        while (n2-- != 0) {
            int n4 = this.in.getBits(7);
            if ((0xFF & (by = (byte)(by + this.exp_1[n4]))) > 24) {
                throw new AC3Exception("Exponent too large");
            }
            switch (n) {
                case 3: {
                    byArray[n3++] = by;
                    byArray[n3++] = by;
                }
                case 2: {
                    byArray[n3++] = by;
                }
                case 1: {
                    byArray[n3++] = by;
                }
            }
            by = (byte)(by + this.exp_2[n4]);
            if ((0xFF & by) > 24) {
                throw new AC3Exception("Exponent too large");
            }
            switch (n) {
                case 3: {
                    byArray[n3++] = by;
                    byArray[n3++] = by;
                }
                case 2: {
                    byArray[n3++] = by;
                }
                case 1: {
                    byArray[n3++] = by;
                }
            }
            by = (byte)(by + this.exp_3[n4]);
            if ((0xFF & by) > 24) {
                throw new AC3Exception("Exponent too large");
            }
            switch (n) {
                case 3: {
                    byArray[n3++] = by;
                    byArray[n3++] = by;
                }
                case 2: {
                    byArray[n3++] = by;
                }
                case 1: {
                    byArray[n3++] = by;
                }
            }
        }
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat("ac3")};
    }

    public Format[] getSupportedOutputFormats(Format format) {
        return new Format[]{new AudioFormat("LINEAR")};
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = (AudioFormat)format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        return new AudioFormat("LINEAR", this.inputFormat.getSampleRate(), this.inputFormat.getSampleSizeInBits() > 0 ? this.inputFormat.getSampleSizeInBits() : 16, this.inputFormat.getChannels(), 0, 1);
    }

    public int process(Buffer buffer, Buffer buffer2) {
        buffer2.setFlags(buffer.getFlags());
        buffer2.setTimeStamp(buffer.getTimeStamp());
        buffer2.setDuration(buffer.getDuration());
        try {
            byte[] byArray = (byte[])buffer.getData();
            int n = buffer.getLength();
            buffer2.setLength(0);
            this.in.addData(byArray, 0, n);
            while (this.in.availableBits() > 56) {
                if (this.readSyncBlock) {
                    this.in.seek(this.in.getPos() & 0xFFFFFFF8);
                    if (!this.a52_syncinfo()) continue;
                    this.readSyncBlock = false;
                }
                if (this.in.availableBits() >= this.frame_length * 8) {
                    int n2 = this.in.getPos();
                    this.a52_frame();
                    while (this.in.getPos() - n2 < (this.frame_length - 7) * 8) {
                        this.a52_block();
                        this.soundOutput.getAudioBuffer(this.samplesOut, 2, buffer2);
                    }
                    this.readSyncBlock = true;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.readSyncBlock = true;
            this.in.seek(this.in.getPos() + this.in.availableBits());
            return 1;
        }
        return 0;
    }

    public void open() {
    }

    public void close() {
    }

    public void reset() {
    }

    public String getName() {
        return "ac3";
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    public boolean isCodecAvailable() {
        return true;
    }

    public void setVideoSize(Dimension dimension) {
    }

    public void setEncoding(String string) {
    }

    public void setIsRtp(boolean bl) {
    }

    public void setIsTruncated(boolean bl) {
    }
}

