/*
*  RAL -- Rubrica Addressbook Library
*  file: notes.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_NOTES_H
#define _R_NOTES_H

#include <time.h>
#include <glib.h>
#include <glib-object.h>

#include "date.h"

#define R_NOTES_TYPE             (r_notes_get_type())

#define R_NOTES(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                  R_NOTES_TYPE, RNotes))

#define R_NOTES_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass),  \
                                  R_NOTES_TYPE, RNotesClass))

#define IS_R_NOTES(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                  R_NOTES_TYPE))

#define IS_R_NOTES_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE((klass),  \
                                  R_NOTES_TYPE))

#define R_NOTES_GET_CLASS(klass) (G_TYPE_INSTANCE_GET_CLASS((kls),  \
                                  R_NOTES_TYPE, RNotesClass))



typedef struct _RNotes        RNotes; 
typedef struct _RNotesClass   RNotesClass;
typedef struct _RNotesPrivate RNotesPrivate;


struct _RNotes
{
  GObject parent;
  
  RNotesPrivate* priv;
};


struct _RNotesClass
{
  GObjectClass parent_class;
};


GType         r_notes_get_type (void);
 

RNotes*  r_notes_new    (void);
void     r_notes_free   (RNotes* notes);

gboolean r_notes_search (RNotes* notes, const gchar* str); 

RNotes*  r_notes_copy   (RNotes* notes);

/*    set
*/
void r_notes_set_know_birthday    (RNotes* notes, gboolean know);
void r_notes_set_know_anniversary (RNotes* notes, gboolean know);

void r_notes_set_birthday    (RNotes* notes, gint day, gint month, gint year);
void r_notes_set_anniversary (RNotes* notes, gint day, gint month, gint year);


/*    get
 */
RDate*   r_notes_get_birthday          (RNotes* notes);
RDate*   r_notes_get_anniversary       (RNotes* notes);

gboolean r_notes_have_data             (RNotes* notes);
gboolean r_notes_know_birthday         (RNotes* notes);
gboolean r_notes_know_anniversary      (RNotes* notes);


gchar*   r_notes_get_birth_day         (RNotes* notes);
gchar*   r_notes_get_birth_month       (RNotes* notes);
gchar*   r_notes_get_birth_year        (RNotes* notes);

gchar*   r_notes_get_anniversary_day   (RNotes* notes);
gchar*   r_notes_get_anniversary_month (RNotes* notes);
gchar*   r_notes_get_anniversary_year  (RNotes* notes);

gchar*   r_notes_get_birth_date        (RNotes* notes);
gchar*   r_notes_get_anniversary_date  (RNotes* notes);

void     r_notes_append_other_notes    (RNotes* notes, gchar* other_note);


#endif
