/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.compress.Archive;
import org.apache.commons.compress.ArchiveEntry;
import org.apache.commons.compress.ArchiveException;
import org.apache.commons.compress.PackableObject;
import org.apache.commons.compress.UnpackException;

public abstract class AbstractArchive
extends PackableObject
implements Archive {
    private ArrayList entries = new ArrayList();
    private File archive = null;

    public Archive newInstance() {
        return this.newInstance();
    }

    public void save(File output) throws ArchiveException {
        if (output == null) {
            throw new ArchiveException("Destination directory must not be null.");
        }
        try {
            this.save(new FileOutputStream(output));
        }
        catch (FileNotFoundException e) {
            throw new ArchiveException("This path is not writeable", e);
        }
        this.setArchive(output);
    }

    public void save(FileOutputStream output) throws ArchiveException {
        this.doSave(output);
    }

    protected abstract void doSave(FileOutputStream var1) throws ArchiveException;

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File file) {
        this.archive = file;
    }

    public void add(File file) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(file);
        ArchiveEntry archiveEntry = new ArchiveEntry(file.getName(), is);
        this.entries.add(archiveEntry);
    }

    public void add(ArchiveEntry archiveEntry) {
        this.entries.add(archiveEntry);
    }

    public Iterator getEntryIterator() {
        return this.entries.iterator();
    }

    public void unpack(File unpackDir) throws UnpackException {
        if (unpackDir == null) {
            throw new UnpackException("Destination directory must not be null.");
        }
        if (!unpackDir.isDirectory()) {
            throw new UnpackException("This file must be a valid directory.");
        }
        if (!unpackDir.canWrite()) {
            throw new UnpackException("This path is not writeable");
        }
        this.doUnpack(unpackDir);
    }

    protected abstract void doUnpack(File var1) throws UnpackException;

    public void close() throws IOException {
        Iterator it = this.getEntryIterator();
        while (it.hasNext()) {
            ArchiveEntry ae = (ArchiveEntry)it.next();
            InputStream is = ae.getStream();
            is.close();
        }
    }
}

