/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionIn
extends Condition {
    private Database database;
    private Expression left;
    private ObjectArray values;
    private boolean all;
    private int compareType;

    public ConditionIn(Database database, Expression left, ObjectArray values, boolean all, int compareType) {
        this.database = database;
        this.left = left;
        this.values = values;
        this.all = all;
        this.compareType = compareType;
    }

    public Value getValue(SessionInterface session) throws SQLException {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return l;
        }
        boolean result = this.all;
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            Value r = e.getValue(session);
            boolean value = r == ValueNull.INSTANCE ? false : Comparison.compareNotNull(this.database, l, r, this.compareType);
            if (!value && this.all) {
                result = false;
                break;
            }
            if (!value || this.all) continue;
            result = true;
            break;
        }
        return ValueBoolean.get(result);
    }

    public void mapColumns(TableFilter tableFilter, int level) throws SQLException {
        this.left.mapColumns(tableFilter, level);
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            e.mapColumns(tableFilter, level);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        this.left = this.left.optimize(session);
        boolean constant = this.left.isConstant();
        if (constant && this.left == ValueExpression.NULL) {
            return this.left;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            e = e.optimize(session);
            if (constant && !e.isConstant()) {
                constant = false;
            }
            this.values.set(i, e);
        }
        if (constant) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    public boolean isEvaluatable(int filterLevel) {
        if (!this.left.isEvaluatable(filterLevel)) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            if (e.isEvaluatable(filterLevel)) continue;
            return false;
        }
        return true;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            e.setEvaluatable(tableFilter, b);
        }
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer("(");
        buff.append(this.left.getSQL());
        buff.append(" IN(");
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            Expression e = (Expression)this.values.get(i);
            buff.append(e.getSQL());
        }
        buff.append("))");
        return buff.toString();
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            e.updateAggregate(session);
        }
    }
}

