/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;

public class ExpressionColumn
extends Expression {
    private Database database;
    private String schemaName;
    private String tableAlias;
    private String columnName;
    private TableFilter filter;
    private int filterLevel;
    private Column column;
    private boolean evaluatable;
    private Select select;

    public ExpressionColumn(Database database, Select select, Column column) {
        this.database = database;
        this.select = select;
        this.column = column;
    }

    public ExpressionColumn(Database database, Select select, String schemaName, String tableAlias, String columnName) {
        this.database = database;
        this.select = select;
        this.tableAlias = tableAlias;
        this.columnName = columnName;
    }

    public String getSQL() {
        String sql = this.column != null ? this.column.getSQL() : this.columnName;
        if (this.tableAlias != null) {
            sql = Parser.quoteIdentifier(this.tableAlias) + "." + sql;
        }
        if (this.schemaName != null) {
            sql = Parser.quoteIdentifier(this.schemaName) + "." + sql;
        }
        return sql;
    }

    public TableFilter getTableFilter() {
        return this.filter;
    }

    public void mapColumns(TableFilter tableFilter, int level) throws SQLException {
        if (this.tableAlias != null && !this.tableAlias.equals(tableFilter.getAlias())) {
            return;
        }
        if (this.schemaName != null && !this.schemaName.equals(tableFilter.getTable().getSchema().getName())) {
            return;
        }
        Column[] columns = tableFilter.getTable().getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Column col = columns[i];
            if (!this.columnName.equals(col.getName())) continue;
            if (this.filter == null) {
                this.filterLevel = level;
                this.column = col;
                this.filter = tableFilter;
                break;
            }
            if (this.filterLevel != level || this.filter == tableFilter) continue;
            throw Message.getSQLException(90059, this.columnName);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        if (this.filter == null) {
            String name = this.columnName;
            if (this.tableAlias != null) {
                name = this.tableAlias + "." + name;
                if (this.schemaName != null) {
                    name = this.schemaName + "." + name;
                }
            }
            throw Message.getSQLException(42122, name);
        }
        return this;
    }

    public void updateAggregate(Session session) throws SQLException {
        Value now = this.filter.get().getValue(this.column.getColumnId());
        if (this.select == null) {
            throw Message.getSQLException(90016, this.getSQL());
        }
        HashMap values = this.select.getCurrentGroup();
        Value v = (Value)values.get(this);
        if (v == null) {
            values.put(this, now);
        } else if (!this.database.areEqual(now, v)) {
            throw Message.getSQLException(90016, this.getSQL());
        }
    }

    public Value getValue(SessionInterface session) throws SQLException {
        Value v;
        HashMap values;
        if (this.select != null && (values = this.select.getCurrentGroup()) != null && (v = (Value)values.get(this)) != null) {
            return v;
        }
        Row current = this.filter.get();
        int index = this.column.getColumnId();
        if (current == null) {
            throw Message.getSQLException(90016, this.getSQL());
        }
        return current.getValue(index);
    }

    public int getType() {
        return this.column.getType();
    }

    public boolean isEvaluatable(int filterLevel) {
        return this.evaluatable || filterLevel < this.filterLevel;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (tableFilter == this.filter) {
            this.evaluatable = b;
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public int getScale() {
        return this.column.getScale();
    }

    public long getPrecision() {
        return this.column.getPrecision();
    }

    public String getOriginalColumnName() {
        return this.columnName;
    }

    public String getColumnName() {
        return this.columnName != null ? this.columnName : this.column.getName();
    }

    public String getSchemaName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    public String getTableName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getName();
    }

    public String getAlias() {
        return this.column.getName();
    }

    public boolean isAutoIncrement() {
        return this.column.getSequence() != null;
    }
}

