/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.h2.tools.SimpleRowSource;

public class SimpleResultSet
implements ResultSet,
ResultSetMetaData {
    private ArrayList rows;
    private Object[] currentRow;
    private int rowId = -1;
    private boolean wasNull;
    private SimpleRowSource source;
    private ArrayList columns = new ArrayList();

    public SimpleResultSet() {
        this.rows = new ArrayList();
    }

    public SimpleResultSet(SimpleRowSource source) {
        this.source = source;
    }

    public void addColumn(String name, int sqlType, int precision, int scale) throws SQLException {
        if (this.rows != null && this.rows.size() > 0) {
            throw new SQLException("Cannot add a column after adding rows", "21S02");
        }
        if (name == null) {
            name = "C" + (this.columns.size() + 1);
        }
        Column column = new Column();
        column.name = name;
        column.sqlType = sqlType;
        column.precision = precision;
        column.scale = scale;
        this.columns.add(column);
    }

    public void addRow(Object[] row) throws SQLException {
        if (this.rows == null) {
            throw new SQLException("Cannot add a row when using RowSource", "21S02");
        }
        this.rows.add(row);
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getRow() throws SQLException {
        return this.rowId + 1;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public void close() throws SQLException {
        this.currentRow = null;
        this.rows = null;
        this.columns = null;
        this.rowId = -1;
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    public boolean next() throws SQLException {
        if (this.source != null) {
            ++this.rowId;
            this.currentRow = this.source.readRow();
            if (this.currentRow != null) {
                return true;
            }
        } else if (this.rows != null && this.rowId < this.rows.size()) {
            ++this.rowId;
            if (this.rowId < this.rows.size()) {
                this.currentRow = (Object[])this.rows.get(this.rowId);
                return true;
            }
        }
        this.close();
        return false;
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public byte getByte(int columnIndex) throws SQLException {
        Number v = (Number)this.get(columnIndex);
        return v == null ? (byte)0 : v.byteValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        Number v = (Number)this.get(columnIndex);
        return v == null ? 0.0 : v.doubleValue();
    }

    public float getFloat(int columnIndex) throws SQLException {
        Number v = (Number)this.get(columnIndex);
        return v == null ? 0.0f : v.floatValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        Number v = (Number)this.get(columnIndex);
        return v == null ? 0 : v.intValue();
    }

    public long getLong(int columnIndex) throws SQLException {
        Number v = (Number)this.get(columnIndex);
        return v == null ? 0L : v.longValue();
    }

    public short getShort(int columnIndex) throws SQLException {
        Number v = (Number)this.get(columnIndex);
        return v == null ? (short)0 : v.shortValue();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Boolean v = (Boolean)this.get(columnIndex);
        return v == null ? false : v;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.get(columnIndex);
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.get(columnIndex);
    }

    public String getString(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        return o == null ? null : o.toString();
    }

    public byte getByte(String columnName) throws SQLException {
        Number v = (Number)this.get(columnName);
        return v == null ? (byte)0 : v.byteValue();
    }

    public double getDouble(String columnName) throws SQLException {
        Number v = (Number)this.get(columnName);
        return v == null ? 0.0 : v.doubleValue();
    }

    public float getFloat(String columnName) throws SQLException {
        Number v = (Number)this.get(columnName);
        return v == null ? 0.0f : v.floatValue();
    }

    public int findColumn(String columnName) throws SQLException {
        for (int i = 0; columnName != null && this.columns != null && i < this.columns.size(); ++i) {
            if (!columnName.equalsIgnoreCase(this.getColumn((int)i).name)) continue;
            return i + 1;
        }
        throw new SQLException("Column not found: " + columnName, "42S22");
    }

    public int getInt(String columnName) throws SQLException {
        Number v = (Number)this.get(columnName);
        return v == null ? 0 : v.intValue();
    }

    public long getLong(String columnName) throws SQLException {
        Number v = (Number)this.get(columnName);
        return v == null ? 0L : v.longValue();
    }

    public short getShort(String columnName) throws SQLException {
        Number v = (Number)this.get(columnName);
        return v == null ? (short)0 : v.shortValue();
    }

    public boolean getBoolean(String columnName) throws SQLException {
        Boolean v = (Boolean)this.get(columnName);
        return v == null ? false : v;
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return (byte[])this.get(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.get(columnIndex);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.get(columnIndex);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.get(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.get(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.get(columnName);
    }

    public String getString(String columnName) throws SQLException {
        Object o = this.get(columnName);
        return o == null ? null : o.toString();
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return (BigDecimal)this.get(columnName);
    }

    public Date getDate(String columnName) throws SQLException {
        return (Date)this.get(columnName);
    }

    public Time getTime(String columnName) throws SQLException {
        return (Time)this.get(columnName);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return (Timestamp)this.get(columnName);
    }

    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        return 15;
    }

    public int getColumnType(int columnIndex) throws SQLException {
        return this.getColumn((int)(columnIndex - 1)).sqlType;
    }

    public int getPrecision(int columnIndex) throws SQLException {
        return this.getColumn((int)(columnIndex - 1)).precision;
    }

    public int getScale(int columnIndex) throws SQLException {
        return this.getColumn((int)(columnIndex - 1)).scale;
    }

    public int isNullable(int columnIndex) throws SQLException {
        return 2;
    }

    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        return true;
    }

    public boolean isCurrency(int columnIndex) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        return false;
    }

    public boolean isReadOnly(int columnIndex) throws SQLException {
        return true;
    }

    public boolean isSearchable(int columnIndex) throws SQLException {
        return true;
    }

    public boolean isSigned(int columnIndex) throws SQLException {
        return true;
    }

    public boolean isWritable(int columnIndex) throws SQLException {
        return false;
    }

    public String getCatalogName(int columnIndex) throws SQLException {
        return null;
    }

    public String getColumnClassName(int columnIndex) throws SQLException {
        return null;
    }

    public String getColumnLabel(int columnIndex) throws SQLException {
        return this.getColumn((int)(columnIndex - 1)).name;
    }

    public String getColumnName(int columnIndex) throws SQLException {
        return this.getColumnLabel(columnIndex);
    }

    public String getColumnTypeName(int columnIndex) throws SQLException {
        return null;
    }

    public String getSchemaName(int columnIndex) throws SQLException {
        return null;
    }

    public String getTableName(int columnIndex) throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void afterLast() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void beforeFirst() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void cancelRowUpdates() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateNull(String columnName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void deleteRow() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void insertRow() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void moveToInsertRow() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void refreshRow() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateRow() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean first() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean isAfterLast() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean isBeforeFirst() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean isFirst() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean isLast() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean last() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean previous() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean rowDeleted() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean rowInserted() throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean rowUpdated() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void setFetchSize(int rows) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean absolute(int row) throws SQLException {
        throw this.getUnsupportedException();
    }

    public boolean relative(int rows) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return null;
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return null;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw this.getUnsupportedException();
    }

    public String getCursorName() throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Array getArray(int i) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Blob getBlob(int i) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Clob getClob(int i) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Ref getRef(int i) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public URL getURL(String columnName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Array getArray(String colName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Blob getBlob(String colName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Clob getClob(String colName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Ref getRef(String colName) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw this.getUnsupportedException();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw this.getUnsupportedException();
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw this.getUnsupportedException();
    }

    private SQLException getUnsupportedException() {
        return new SQLException("Feature not supported", "HYC00");
    }

    private Object get(String columnName) throws SQLException {
        return this.get(this.findColumn(columnName));
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new SQLException("Invalid column index " + (columnIndex + 1), "90009");
        }
    }

    private Object get(int columnIndex) throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("No data is available", "02000");
        }
        this.checkColumnIndex(--columnIndex);
        Object o = columnIndex < this.currentRow.length ? this.currentRow[columnIndex] : null;
        this.wasNull = o == null;
        return o;
    }

    private Column getColumn(int i) throws SQLException {
        this.checkColumnIndex(i);
        return (Column)this.columns.get(i);
    }

    private class Column {
        String name;
        int sqlType;
        int precision;
        int scale;

        private Column() {
        }
    }
}

