;;;
;;; Copyright (c) 2003-2008 uim Project http://code.google.com/p/uim/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;; Charset of this file is UTF-8

(require "util.scm")
(require "rk.scm")
(require "generic.scm")

(define-key latin-backspace-key? '("backspace" "<Control>h"))
(define-key latin-commit-key? "return")
;;(define-key latin-multi-key? '("<IgnoreShift>Multi_key"))

;; latin-compose-rule is generated from key sequences in
;; /usr/share/X11/locale/en_US.UTF-8/Compose which uses Multi_key and
;; deadkeys with only ascii characters.

(define latin-compose-rule '(
((("dead-tilde" " "))("~"))
((("dead-tilde" "dead-tilde"))("~"))
((("dead-acute" " "))("'"))
((("dead-acute" "dead-acute"))("´"))
((("dead-grave" " "))("`"))
((("dead-grave" "dead-grave"))("`"))
((("dead-circumflex" " "))("^"))
((("dead-circumflex" "dead-circumflex"))("^"))
((("dead-abovering" " "))("°"))
((("dead-abovering" "dead-abovering"))("°"))
((("dead-macron" " "))("¯"))
((("dead-macron" "dead-macron"))("¯"))
((("dead-breve" " "))("˘"))
((("dead-breve" "dead-breve"))("˘"))
((("dead-abovedot" " "))("˙"))
((("dead-abovedot" "dead-abovedot"))("˙"))
((("dead-diaeresis" "dead-diaeresis"))("¨"))
((("dead-diaeresis" " "))("\""))
((("dead-doubleacute" " "))("˝"))
((("dead-doubleacute" "dead-doubleacute"))("˝"))
((("dead-caron" " "))("ˇ"))
((("dead-caron" "dead-caron"))("ˇ"))
((("dead-cedilla" " "))("¸"))
((("dead-cedilla" "dead-cedilla"))("¸"))
((("dead-ogonek" " "))("˛"))
((("dead-ogonek" "dead-ogonek"))("˛"))
((("dead-iota" " "))("ͺ"))
((("dead-iota" "dead-iota"))("ͺ"))
((("Multi_key" "+" "+"))("#"))
((("Multi_key" "'" " "))("'"))
((("Multi_key" " " "'"))("'"))
((("Multi_key" "A" "T"))("@"))
((("Multi_key" "(" "("))("["))
((("Multi_key" "/" "/"))("\\"))
((("Multi_key" "/" "<"))("\\"))
((("Multi_key" "<" "/"))("\\"))
((("Multi_key" ")" ")"))("]"))
((("Multi_key" "^" " "))("^"))
((("Multi_key" " " "^"))("^"))
((("Multi_key" ">" " "))("^"))
((("Multi_key" " " ">"))("^"))
((("Multi_key" "`" " "))("`"))
((("Multi_key" " " "`"))("`"))
((("Multi_key" "," " "))("¸"))
((("Multi_key" " " ","))("¸"))
((("Multi_key" "(" "-"))("{"))
((("Multi_key" "-" "("))("{"))
((("Multi_key" "/" "^"))("|"))
((("Multi_key" "^" "/"))("|"))
((("Multi_key" "V" "L"))("|"))
((("Multi_key" "L" "V"))("|"))
((("Multi_key" "v" "l"))("|"))
((("Multi_key" "l" "v"))("|"))
((("Multi_key" ")" "-"))("}"))
((("Multi_key" "-" ")"))("}"))
((("Multi_key" "~" " "))("~"))
((("Multi_key" " " "~"))("~"))
((("Multi_key" "-" " "))("~"))
((("Multi_key" " " "-"))("~"))
((("Multi_key" " " " "))(" "))
((("Multi_key" " " "."))(" "))
((("Multi_key" "o" "c"))("©"))
((("Multi_key" "o" "C"))("©"))
((("Multi_key" "O" "c"))("©"))
((("Multi_key" "O" "C"))("©"))
((("Multi_key" "o" "r"))("®"))
((("Multi_key" "o" "R"))("®"))
((("Multi_key" "O" "r"))("®"))
((("Multi_key" "O" "R"))("®"))
((("Multi_key" "." ">"))("›"))
((("Multi_key" "." "<"))("‹"))
((("Multi_key" "." "."))("·"))
((("Multi_key" "!" "^"))("¦"))
((("Multi_key" "!" "!"))("¡"))
((("Multi_key" "p" "!"))("¶"))
((("Multi_key" "P" "!"))("¶"))
((("Multi_key" "+" "-"))("±"))
((("Multi_key" "?" "?"))("¿"))
((("Multi_key" "-" "d"))("đ"))
((("Multi_key" "-" "D"))("Đ"))
((("Multi_key" "s" "s"))("ß"))
((("Multi_key" "o" "e"))("œ"))
((("Multi_key" "O" "E"))("Œ"))
((("Multi_key" "a" "e"))("æ"))
((("Multi_key" "A" "E"))("Æ"))
((("Multi_key" "o" "o"))("°"))
((("Multi_key" "\"" "\\"))("〝"))
((("Multi_key" "\"" "/"))("〞"))
((("Multi_key" "<" "<"))("«"))
((("Multi_key" ">" ">"))("»"))
((("Multi_key" "<" "'"))("‘"))
((("Multi_key" "'" "<"))("‘"))
((("Multi_key" ">" "'"))("’"))
((("Multi_key" "'" ">"))("’"))
((("Multi_key" "," "'"))("‚"))
((("Multi_key" "'" ","))("‚"))
((("Multi_key" "<" "\""))("“"))
((("Multi_key" "\"" "<"))("“"))
((("Multi_key" ">" "\""))("”"))
((("Multi_key" "\"" ">"))("”"))
((("Multi_key" "," "\""))("„"))
((("Multi_key" "\"" ","))("„"))
((("Multi_key" "%" "o"))("‰"))
((("Multi_key" "C" "E"))("₠"))
((("Multi_key" "C" "/"))("₡"))
((("Multi_key" "/" "C"))("₡"))
((("Multi_key" "C" "r"))("₢"))
((("Multi_key" "F" "r"))("₣"))
((("Multi_key" "L" "="))("₤"))
((("Multi_key" "=" "L"))("₤"))
((("Multi_key" "m" "/"))("₥"))
((("Multi_key" "/" "m"))("₥"))
((("Multi_key" "N" "="))("₦"))
((("Multi_key" "=" "N"))("₦"))
((("Multi_key" "P" "t"))("₧"))
((("Multi_key" "R" "s"))("₨"))
((("Multi_key" "W" "="))("₩"))
((("Multi_key" "=" "W"))("₩"))
((("Multi_key" "d" "-"))("₫"))
((("Multi_key" "C" "="))("€"))
((("Multi_key" "=" "C"))("€"))
((("Multi_key" "c" "="))("€"))
((("Multi_key" "=" "c"))("€"))
((("Multi_key" "E" "="))("€"))
((("Multi_key" "=" "E"))("€"))
((("Multi_key" "|" "c"))("¢"))
((("Multi_key" "c" "|"))("¢"))
((("Multi_key" "c" "/"))("¢"))
((("Multi_key" "/" "c"))("¢"))
((("Multi_key" "L" "-"))("£"))
((("Multi_key" "-" "L"))("£"))
((("Multi_key" "Y" "="))("¥"))
((("Multi_key" "=" "Y"))("¥"))
((("Multi_key" "f" "s"))("ſ"))
((("Multi_key" "f" "S"))("ſ"))
((("Multi_key" "-" "-" "."))("–"))
((("Multi_key" "-" "-" "-"))("—"))
((("Multi_key" "#" "b"))("♭"))
((("Multi_key" "#" "f"))("♮"))
((("Multi_key" "#" "#"))("♯"))
((("Multi_key" "s" "o"))("§"))
((("Multi_key" "o" "s"))("§"))
((("Multi_key" "o" "x"))("¤"))
((("Multi_key" "x" "o"))("¤"))
((("Multi_key" "P" "P"))("¶"))
((("Multi_key" "," "-"))("¬"))
((("Multi_key" "-" ","))("¬"))
((("dead-circumflex" "Multi_key" "_" "a"))("ª"))
((("Multi_key" "^" "_" "a"))("ª"))
((("dead-circumflex" "2"))("²"))
((("Multi_key" "^" "2"))("²"))
((("dead-circumflex" "3"))("³"))
((("Multi_key" "^" "3"))("³"))
((("Multi_key" "m" "u"))("µ"))
((("dead-circumflex" "1"))("¹"))
((("Multi_key" "^" "1"))("¹"))
((("dead-circumflex" "Multi_key" "_" "o"))("º"))
((("Multi_key" "^" "_" "o"))("º"))
((("Multi_key" "1" "4"))("¼"))
((("Multi_key" "1" "2"))("½"))
((("Multi_key" "3" "4"))("¾"))
((("dead-grave" "A"))("À"))
((("Multi_key" "`" "A"))("À"))
((("dead-acute" "A"))("Á"))
((("Multi_key" "'" "A"))("Á"))
((("dead-circumflex" "A"))("Â"))
((("Multi_key" "^" "A"))("Â"))
((("dead-tilde" "A"))("Ã"))
((("Multi_key" "~" "A"))("Ã"))
((("dead-diaeresis" "A"))("Ä"))
((("Multi_key" "\"" "A"))("Ä"))
((("dead-abovering" "A"))("Å"))
((("Multi_key" "o" "A"))("Å"))
((("dead-cedilla" "C"))("Ç"))
((("Multi_key" "," "C"))("Ç"))
((("dead-grave" "E"))("È"))
((("Multi_key" "`" "E"))("È"))
((("dead-acute" "E"))("É"))
((("Multi_key" "'" "E"))("É"))
((("dead-circumflex" "E"))("Ê"))
((("Multi_key" "^" "E"))("Ê"))
((("dead-diaeresis" "E"))("Ë"))
((("Multi_key" "\"" "E"))("Ë"))
((("dead-grave" "I"))("Ì"))
((("Multi_key" "`" "I"))("Ì"))
((("dead-acute" "I"))("Í"))
((("Multi_key" "'" "I"))("Í"))
((("dead-circumflex" "I"))("Î"))
((("Multi_key" "^" "I"))("Î"))
((("dead-diaeresis" "I"))("Ï"))
((("Multi_key" "\"" "I"))("Ï"))
((("Multi_key" "D" "H"))("Ð"))
((("dead-tilde" "N"))("Ñ"))
((("Multi_key" "~" "N"))("Ñ"))
((("dead-grave" "O"))("Ò"))
((("Multi_key" "`" "O"))("Ò"))
((("dead-acute" "O"))("Ó"))
((("Multi_key" "'" "O"))("Ó"))
((("dead-circumflex" "O"))("Ô"))
((("Multi_key" "^" "O"))("Ô"))
((("dead-tilde" "O"))("Õ"))
((("Multi_key" "~" "O"))("Õ"))
((("dead-diaeresis" "O"))("Ö"))
((("Multi_key" "\"" "O"))("Ö"))
((("Multi_key" "x" "x"))("×"))
((("Multi_key" "/" "O"))("Ø"))
((("dead-grave" "U"))("Ù"))
((("Multi_key" "`" "U"))("Ù"))
((("dead-acute" "U"))("Ú"))
((("Multi_key" "'" "U"))("Ú"))
((("dead-circumflex" "U"))("Û"))
((("Multi_key" "^" "U"))("Û"))
((("dead-diaeresis" "U"))("Ü"))
((("Multi_key" "\"" "U"))("Ü"))
((("dead-acute" "Y"))("Ý"))
((("Multi_key" "'" "Y"))("Ý"))
((("Multi_key" "T" "H"))("Þ"))
((("dead-grave" "a"))("à"))
((("Multi_key" "`" "a"))("à"))
((("dead-acute" "a"))("á"))
((("Multi_key" "'" "a"))("á"))
((("dead-circumflex" "a"))("â"))
((("Multi_key" "^" "a"))("â"))
((("dead-tilde" "a"))("ã"))
((("Multi_key" "~" "a"))("ã"))
((("dead-diaeresis" "a"))("ä"))
((("Multi_key" "\"" "a"))("ä"))
((("dead-abovering" "a"))("å"))
((("Multi_key" "o" "a"))("å"))
((("dead-cedilla" "c"))("ç"))
((("Multi_key" "," "c"))("ç"))
((("dead-grave" "e"))("è"))
((("Multi_key" "`" "e"))("è"))
((("dead-acute" "e"))("é"))
((("Multi_key" "'" "e"))("é"))
((("dead-circumflex" "e"))("ê"))
((("Multi_key" "^" "e"))("ê"))
((("dead-diaeresis" "e"))("ë"))
((("Multi_key" "\"" "e"))("ë"))
((("dead-grave" "i"))("ì"))
((("Multi_key" "`" "i"))("ì"))
((("dead-acute" "i"))("í"))
((("Multi_key" "'" "i"))("í"))
((("dead-circumflex" "i"))("î"))
((("Multi_key" "^" "i"))("î"))
((("dead-diaeresis" "i"))("ï"))
((("Multi_key" "\"" "i"))("ï"))
((("Multi_key" "d" "h"))("ð"))
((("dead-tilde" "n"))("ñ"))
((("Multi_key" "~" "n"))("ñ"))
((("dead-grave" "o"))("ò"))
((("Multi_key" "`" "o"))("ò"))
((("dead-acute" "o"))("ó"))
((("Multi_key" "'" "o"))("ó"))
((("dead-circumflex" "o"))("ô"))
((("Multi_key" "^" "o"))("ô"))
((("dead-tilde" "o"))("õ"))
((("Multi_key" "~" "o"))("õ"))
((("dead-diaeresis" "o"))("ö"))
((("Multi_key" "\"" "o"))("ö"))
((("Multi_key" ":" "-"))("÷"))
((("Multi_key" "-" ":"))("÷"))
((("Multi_key" "/" "o"))("ø"))
((("dead-grave" "u"))("ù"))
((("Multi_key" "`" "u"))("ù"))
((("dead-acute" "u"))("ú"))
((("Multi_key" "'" "u"))("ú"))
((("dead-circumflex" "u"))("û"))
((("Multi_key" "^" "u"))("û"))
((("dead-diaeresis" "u"))("ü"))
((("Multi_key" "\"" "u"))("ü"))
((("dead-acute" "y"))("ý"))
((("Multi_key" "'" "y"))("ý"))
((("Multi_key" "t" "h"))("þ"))
((("dead-diaeresis" "y"))("ÿ"))
((("Multi_key" "\"" "y"))("ÿ"))
((("dead-macron" "A"))("Ā"))
((("Multi_key" "_" "A"))("Ā"))
((("dead-macron" "a"))("ā"))
((("Multi_key" "_" "a"))("ā"))
((("dead-breve" "A"))("Ă"))
((("Multi_key" "U" "A"))("Ă"))
((("Multi_key" "b" "A"))("Ă"))
((("dead-breve" "a"))("ă"))
((("Multi_key" "U" "a"))("ă"))
((("Multi_key" "b" "a"))("ă"))
((("dead-ogonek" "A"))("Ą"))
((("Multi_key" ";" "A"))("Ą"))
((("dead-ogonek" "a"))("ą"))
((("Multi_key" ";" "a"))("ą"))
((("dead-acute" "C"))("Ć"))
((("Multi_key" "'" "C"))("Ć"))
((("dead-acute" "c"))("ć"))
((("Multi_key" "'" "c"))("ć"))
((("dead-circumflex" "C"))("Ĉ"))
((("Multi_key" "^" "C"))("Ĉ"))
((("dead-circumflex" "c"))("ĉ"))
((("Multi_key" "^" "c"))("ĉ"))
((("dead-abovedot" "C"))("Ċ"))
((("Multi_key" "." "C"))("Ċ"))
((("dead-abovedot" "c"))("ċ"))
((("Multi_key" "." "c"))("ċ"))
((("dead-caron" "C"))("Č"))
((("Multi_key" "c" "C"))("Č"))
((("dead-caron" "c"))("č"))
((("Multi_key" "c" "c"))("č"))
((("dead-caron" "D"))("Ď"))
((("Multi_key" "c" "D"))("Ď"))
((("dead-caron" "d"))("ď"))
((("Multi_key" "c" "d"))("ď"))
((("Multi_key" "/" "D"))("Đ"))
((("Multi_key" "/" "d"))("đ"))
((("dead-macron" "E"))("Ē"))
((("Multi_key" "_" "E"))("Ē"))
((("dead-macron" "e"))("ē"))
((("Multi_key" "_" "e"))("ē"))
((("dead-breve" "E"))("Ĕ"))
((("Multi_key" "U" "E"))("Ĕ"))
((("Multi_key" "b" "E"))("Ĕ"))
((("dead-breve" "e"))("ĕ"))
((("Multi_key" "U" "e"))("ĕ"))
((("Multi_key" "b" "e"))("ĕ"))
((("dead-abovedot" "E"))("Ė"))
((("Multi_key" "." "E"))("Ė"))
((("dead-abovedot" "e"))("ė"))
((("Multi_key" "." "e"))("ė"))
((("dead-ogonek" "E"))("Ę"))
((("Multi_key" ";" "E"))("Ę"))
((("dead-ogonek" "e"))("ę"))
((("Multi_key" ";" "e"))("ę"))
((("dead-caron" "E"))("Ě"))
((("Multi_key" "c" "E"))("Ě"))
((("dead-caron" "e"))("ě"))
((("Multi_key" "c" "e"))("ě"))
((("dead-circumflex" "G"))("Ĝ"))
((("Multi_key" "^" "G"))("Ĝ"))
((("dead-circumflex" "g"))("ĝ"))
((("Multi_key" "^" "g"))("ĝ"))
((("dead-breve" "G"))("Ğ"))
((("Multi_key" "U" "G"))("Ğ"))
((("Multi_key" "b" "G"))("Ğ"))
((("dead-breve" "g"))("ğ"))
((("Multi_key" "U" "g"))("ğ"))
((("Multi_key" "b" "g"))("ğ"))
((("dead-abovedot" "G"))("Ġ"))
((("Multi_key" "." "G"))("Ġ"))
((("dead-abovedot" "g"))("ġ"))
((("Multi_key" "." "g"))("ġ"))
((("dead-cedilla" "G"))("Ģ"))
((("Multi_key" "," "G"))("Ģ"))
((("dead-cedilla" "g"))("ģ"))
((("Multi_key" "," "g"))("ģ"))
((("dead-circumflex" "H"))("Ĥ"))
((("Multi_key" "^" "H"))("Ĥ"))
((("dead-circumflex" "h"))("ĥ"))
((("Multi_key" "^" "h"))("ĥ"))
((("Multi_key" "/" "H"))("Ħ"))
((("Multi_key" "/" "h"))("ħ"))
((("dead-tilde" "I"))("Ĩ"))
((("Multi_key" "~" "I"))("Ĩ"))
((("dead-tilde" "i"))("ĩ"))
((("Multi_key" "~" "i"))("ĩ"))
((("dead-macron" "I"))("Ī"))
((("Multi_key" "_" "I"))("Ī"))
((("dead-macron" "i"))("ī"))
((("Multi_key" "_" "i"))("ī"))
((("dead-breve" "I"))("Ĭ"))
((("Multi_key" "U" "I"))("Ĭ"))
((("Multi_key" "b" "I"))("Ĭ"))
((("dead-breve" "i"))("ĭ"))
((("Multi_key" "U" "i"))("ĭ"))
((("Multi_key" "b" "i"))("ĭ"))
((("dead-ogonek" "I"))("Į"))
((("Multi_key" ";" "I"))("Į"))
((("dead-ogonek" "i"))("į"))
((("Multi_key" ";" "i"))("į"))
((("dead-abovedot" "I"))("İ"))
((("Multi_key" "." "I"))("İ"))
((("dead-abovedot" "i"))("ı"))
((("Multi_key" "i" "."))("ı"))
((("dead-circumflex" "J"))("Ĵ"))
((("Multi_key" "^" "J"))("Ĵ"))
((("dead-circumflex" "j"))("ĵ"))
((("Multi_key" "^" "j"))("ĵ"))
((("dead-cedilla" "K"))("Ķ"))
((("Multi_key" "," "K"))("Ķ"))
((("dead-cedilla" "k"))("ķ"))
((("Multi_key" "," "k"))("ķ"))
((("Multi_key" "k" "k"))("ĸ"))
((("dead-acute" "L"))("Ĺ"))
((("Multi_key" "'" "L"))("Ĺ"))
((("dead-acute" "l"))("ĺ"))
((("Multi_key" "'" "l"))("ĺ"))
((("dead-cedilla" "L"))("Ļ"))
((("Multi_key" "," "L"))("Ļ"))
((("dead-cedilla" "l"))("ļ"))
((("Multi_key" "," "l"))("ļ"))
((("dead-caron" "L"))("Ľ"))
((("Multi_key" "c" "L"))("Ľ"))
((("dead-caron" "l"))("ľ"))
((("Multi_key" "c" "l"))("ľ"))
((("Multi_key" "/" "L"))("Ł"))
((("Multi_key" "/" "l"))("ł"))
((("dead-acute" "N"))("Ń"))
((("Multi_key" "'" "N"))("Ń"))
((("dead-acute" "n"))("ń"))
((("Multi_key" "'" "n"))("ń"))
((("dead-cedilla" "N"))("Ņ"))
((("Multi_key" "," "N"))("Ņ"))
((("dead-cedilla" "n"))("ņ"))
((("Multi_key" "," "n"))("ņ"))
((("dead-caron" "N"))("Ň"))
((("Multi_key" "c" "N"))("Ň"))
((("dead-caron" "n"))("ň"))
((("Multi_key" "c" "n"))("ň"))
((("Multi_key" "N" "G"))("Ŋ"))
((("Multi_key" "n" "g"))("ŋ"))
((("dead-macron" "O"))("Ō"))
((("Multi_key" "_" "O"))("Ō"))
((("dead-macron" "o"))("ō"))
((("Multi_key" "_" "o"))("ō"))
((("dead-breve" "O"))("Ŏ"))
((("Multi_key" "U" "O"))("Ŏ"))
((("Multi_key" "b" "O"))("Ŏ"))
((("dead-breve" "o"))("ŏ"))
((("Multi_key" "U" "o"))("ŏ"))
((("Multi_key" "b" "o"))("ŏ"))
((("dead-doubleacute" "O"))("Ő"))
((("Multi_key" "=" "O"))("Ő"))
((("dead-doubleacute" "o"))("ő"))
((("Multi_key" "=" "o"))("ő"))
((("dead-acute" "R"))("Ŕ"))
((("Multi_key" "'" "R"))("Ŕ"))
((("dead-acute" "r"))("ŕ"))
((("Multi_key" "'" "r"))("ŕ"))
((("dead-cedilla" "R"))("Ŗ"))
((("Multi_key" "," "R"))("Ŗ"))
((("dead-cedilla" "r"))("ŗ"))
((("Multi_key" "," "r"))("ŗ"))
((("dead-caron" "R"))("Ř"))
((("Multi_key" "c" "R"))("Ř"))
((("dead-caron" "r"))("ř"))
((("Multi_key" "c" "r"))("ř"))
((("dead-acute" "S"))("Ś"))
((("Multi_key" "'" "S"))("Ś"))
((("dead-acute" "s"))("ś"))
((("Multi_key" "'" "s"))("ś"))
((("dead-circumflex" "S"))("Ŝ"))
((("Multi_key" "^" "S"))("Ŝ"))
((("dead-circumflex" "s"))("ŝ"))
((("Multi_key" "^" "s"))("ŝ"))
((("dead-cedilla" "S"))("Ş"))
((("Multi_key" "," "S"))("Ş"))
((("dead-cedilla" "s"))("ş"))
((("Multi_key" "," "s"))("ş"))
((("dead-caron" "S"))("Š"))
((("Multi_key" "c" "S"))("Š"))
((("dead-caron" "s"))("š"))
((("Multi_key" "c" "s"))("š"))
((("dead-cedilla" "T"))("Ţ"))
((("Multi_key" "," "T"))("Ţ"))
((("dead-cedilla" "t"))("ţ"))
((("Multi_key" "," "t"))("ţ"))
((("dead-caron" "T"))("Ť"))
((("Multi_key" "c" "T"))("Ť"))
((("dead-caron" "t"))("ť"))
((("Multi_key" "c" "t"))("ť"))
((("Multi_key" "/" "T"))("Ŧ"))
((("Multi_key" "/" "t"))("ŧ"))
((("dead-tilde" "U"))("Ũ"))
((("Multi_key" "~" "U"))("Ũ"))
((("dead-tilde" "u"))("ũ"))
((("Multi_key" "~" "u"))("ũ"))
((("dead-macron" "U"))("Ū"))
((("Multi_key" "_" "U"))("Ū"))
((("dead-macron" "u"))("ū"))
((("Multi_key" "_" "u"))("ū"))
((("dead-breve" "U"))("Ŭ"))
((("Multi_key" "U" "U"))("Ŭ"))
((("Multi_key" "b" "U"))("Ŭ"))
((("dead-breve" "u"))("ŭ"))
((("Multi_key" "U" "u"))("ŭ"))
((("Multi_key" "b" "u"))("ŭ"))
((("dead-abovering" "U"))("Ů"))
((("Multi_key" "o" "U"))("Ů"))
((("dead-abovering" "u"))("ů"))
((("Multi_key" "o" "u"))("ů"))
((("dead-doubleacute" "U"))("Ű"))
((("Multi_key" "=" "U"))("Ű"))
((("dead-doubleacute" "u"))("ű"))
((("Multi_key" "=" "u"))("ű"))
((("dead-ogonek" "U"))("Ų"))
((("Multi_key" ";" "U"))("Ų"))
((("dead-ogonek" "u"))("ų"))
((("Multi_key" ";" "u"))("ų"))
((("dead-circumflex" "W"))("Ŵ"))
((("Multi_key" "^" "W"))("Ŵ"))
((("dead-circumflex" "w"))("ŵ"))
((("Multi_key" "^" "w"))("ŵ"))
((("dead-circumflex" "Y"))("Ŷ"))
((("Multi_key" "^" "Y"))("Ŷ"))
((("dead-circumflex" "y"))("ŷ"))
((("Multi_key" "^" "y"))("ŷ"))
((("dead-diaeresis" "Y"))("Ÿ"))
((("Multi_key" "\"" "Y"))("Ÿ"))
((("dead-acute" "Z"))("Ź"))
((("Multi_key" "'" "Z"))("Ź"))
((("dead-acute" "z"))("ź"))
((("Multi_key" "'" "z"))("ź"))
((("dead-abovedot" "Z"))("Ż"))
((("Multi_key" "." "Z"))("Ż"))
((("dead-abovedot" "z"))("ż"))
((("Multi_key" "." "z"))("ż"))
((("dead-caron" "Z"))("Ž"))
((("Multi_key" "c" "Z"))("Ž"))
((("dead-caron" "z"))("ž"))
((("Multi_key" "c" "z"))("ž"))
((("Multi_key" "/" "b"))("ƀ"))
((("Multi_key" "/" "I"))("Ɨ"))
((("dead-horn" "O"))("Ơ"))
((("Multi_key" "+" "O"))("Ơ"))
((("dead-horn" "o"))("ơ"))
((("Multi_key" "+" "o"))("ơ"))
((("dead-horn" "U"))("Ư"))
((("Multi_key" "+" "U"))("Ư"))
((("dead-horn" "u"))("ư"))
((("Multi_key" "+" "u"))("ư"))
((("Multi_key" "/" "Z"))("Ƶ"))
((("Multi_key" "/" "z"))("ƶ"))
((("dead-caron" "A"))("Ǎ"))
((("Multi_key" "c" "A"))("Ǎ"))
((("dead-caron" "a"))("ǎ"))
((("Multi_key" "c" "a"))("ǎ"))
((("dead-caron" "I"))("Ǐ"))
((("Multi_key" "c" "I"))("Ǐ"))
((("dead-caron" "i"))("ǐ"))
((("Multi_key" "c" "i"))("ǐ"))
((("dead-caron" "O"))("Ǒ"))
((("Multi_key" "c" "O"))("Ǒ"))
((("dead-caron" "o"))("ǒ"))
((("Multi_key" "c" "o"))("ǒ"))
((("dead-caron" "U"))("Ǔ"))
((("Multi_key" "c" "U"))("Ǔ"))
((("dead-caron" "u"))("ǔ"))
((("Multi_key" "c" "u"))("ǔ"))
((("dead-macron" "dead-diaeresis" "U"))("Ǖ"))
((("dead-macron" "Multi_key" "\"" "U"))("Ǖ"))
((("Multi_key" "_" "dead-diaeresis" "U"))("Ǖ"))
((("Multi_key" "_" "\"" "U"))("Ǖ"))
((("dead-macron" "dead-diaeresis" "u"))("ǖ"))
((("dead-macron" "Multi_key" "\"" "u"))("ǖ"))
((("Multi_key" "_" "dead-diaeresis" "u"))("ǖ"))
((("Multi_key" "_" "\"" "u"))("ǖ"))
((("dead-acute" "dead-diaeresis" "U"))("Ǘ"))
((("dead-acute" "Multi_key" "\"" "U"))("Ǘ"))
((("Multi_key" "'" "dead-diaeresis" "U"))("Ǘ"))
((("Multi_key" "'" "\"" "U"))("Ǘ"))
((("dead-acute" "dead-diaeresis" "u"))("ǘ"))
((("dead-acute" "Multi_key" "\"" "u"))("ǘ"))
((("Multi_key" "'" "dead-diaeresis" "u"))("ǘ"))
((("Multi_key" "'" "\"" "u"))("ǘ"))
((("dead-caron" "dead-diaeresis" "U"))("Ǚ"))
((("dead-caron" "Multi_key" "\"" "U"))("Ǚ"))
((("Multi_key" "c" "dead-diaeresis" "U"))("Ǚ"))
((("Multi_key" "c" "\"" "U"))("Ǚ"))
((("dead-caron" "dead-diaeresis" "u"))("ǚ"))
((("dead-caron" "Multi_key" "\"" "u"))("ǚ"))
((("Multi_key" "c" "dead-diaeresis" "u"))("ǚ"))
((("Multi_key" "c" "\"" "u"))("ǚ"))
((("dead-grave" "dead-diaeresis" "U"))("Ǜ"))
((("dead-grave" "Multi_key" "\"" "U"))("Ǜ"))
((("Multi_key" "`" "dead-diaeresis" "U"))("Ǜ"))
((("Multi_key" "`" "\"" "U"))("Ǜ"))
((("dead-grave" "dead-diaeresis" "u"))("ǜ"))
((("dead-grave" "Multi_key" "\"" "u"))("ǜ"))
((("Multi_key" "`" "dead-diaeresis" "u"))("ǜ"))
((("Multi_key" "`" "\"" "u"))("ǜ"))
((("dead-macron" "dead-diaeresis" "A"))("Ǟ"))
((("dead-macron" "Multi_key" "\"" "A"))("Ǟ"))
((("Multi_key" "_" "dead-diaeresis" "A"))("Ǟ"))
((("Multi_key" "_" "\"" "A"))("Ǟ"))
((("dead-macron" "dead-diaeresis" "a"))("ǟ"))
((("dead-macron" "Multi_key" "\"" "a"))("ǟ"))
((("Multi_key" "_" "dead-diaeresis" "a"))("ǟ"))
((("Multi_key" "_" "\"" "a"))("ǟ"))
((("dead-macron" "dead-abovedot" "A"))("Ǡ"))
((("dead-macron" "Multi_key" "." "A"))("Ǡ"))
((("Multi_key" "_" "dead-abovedot" "A"))("Ǡ"))
((("Multi_key" "_" "." "A"))("Ǡ"))
((("dead-macron" "dead-abovedot" "a"))("ǡ"))
((("dead-macron" "Multi_key" "." "a"))("ǡ"))
((("Multi_key" "_" "dead-abovedot" "a"))("ǡ"))
((("Multi_key" "_" "." "a"))("ǡ"))
((("Multi_key" "/" "G"))("Ǥ"))
((("Multi_key" "/" "g"))("ǥ"))
((("dead-caron" "G"))("Ǧ"))
((("Multi_key" "c" "G"))("Ǧ"))
((("dead-caron" "g"))("ǧ"))
((("Multi_key" "c" "g"))("ǧ"))
((("dead-caron" "K"))("Ǩ"))
((("Multi_key" "c" "K"))("Ǩ"))
((("dead-caron" "k"))("ǩ"))
((("Multi_key" "c" "k"))("ǩ"))
((("dead-ogonek" "O"))("Ǫ"))
((("Multi_key" ";" "O"))("Ǫ"))
((("dead-ogonek" "o"))("ǫ"))
((("Multi_key" ";" "o"))("ǫ"))
((("dead-macron" "dead-ogonek" "O"))("Ǭ"))
((("dead-macron" "Multi_key" ";" "O"))("Ǭ"))
((("Multi_key" "_" "dead-ogonek" "O"))("Ǭ"))
((("Multi_key" "_" ";" "O"))("Ǭ"))
((("dead-macron" "dead-ogonek" "o"))("ǭ"))
((("dead-macron" "Multi_key" ";" "o"))("ǭ"))
((("Multi_key" "_" "dead-ogonek" "o"))("ǭ"))
((("Multi_key" "_" ";" "o"))("ǭ"))
((("dead-caron" "j"))("ǰ"))
((("Multi_key" "c" "j"))("ǰ"))
((("dead-acute" "G"))("Ǵ"))
((("Multi_key" "'" "G"))("Ǵ"))
((("dead-acute" "g"))("ǵ"))
((("Multi_key" "'" "g"))("ǵ"))
((("dead-grave" "N"))("Ǹ"))
((("Multi_key" "`" "N"))("Ǹ"))
((("dead-grave" "n"))("ǹ"))
((("Multi_key" "`" "n"))("ǹ"))
((("dead-acute" "dead-abovering" "A"))("Ǻ"))
((("dead-acute" "Multi_key" "o" "A"))("Ǻ"))
((("Multi_key" "'" "dead-abovering" "A"))("Ǻ"))
((("Multi_key" "o" "'" "A"))("Ǻ"))
((("dead-acute" "dead-abovering" "a"))("ǻ"))
((("dead-acute" "Multi_key" "o" "a"))("ǻ"))
((("Multi_key" "'" "dead-abovering" "a"))("ǻ"))
((("Multi_key" "o" "'" "a"))("ǻ"))
((("dead-acute" "Multi_key" "/" "O"))("Ǿ"))
((("Multi_key" "'" "/" "O"))("Ǿ"))
((("dead-acute" "Multi_key" "/" "o"))("ǿ"))
((("Multi_key" "'" "/" "o"))("ǿ"))
((("dead-caron" "H"))("Ȟ"))
((("Multi_key" "c" "H"))("Ȟ"))
((("dead-caron" "h"))("ȟ"))
((("Multi_key" "c" "h"))("ȟ"))
((("dead-abovedot" "A"))("Ȧ"))
((("Multi_key" "." "A"))("Ȧ"))
((("dead-abovedot" "a"))("ȧ"))
((("Multi_key" "." "a"))("ȧ"))
((("dead-cedilla" "E"))("Ȩ"))
((("Multi_key" "," "E"))("Ȩ"))
((("dead-cedilla" "e"))("ȩ"))
((("Multi_key" "," "e"))("ȩ"))
((("dead-macron" "dead-diaeresis" "O"))("Ȫ"))
((("dead-macron" "Multi_key" "\"" "O"))("Ȫ"))
((("Multi_key" "_" "dead-diaeresis" "O"))("Ȫ"))
((("Multi_key" "_" "\"" "O"))("Ȫ"))
((("dead-macron" "dead-diaeresis" "o"))("ȫ"))
((("dead-macron" "Multi_key" "\"" "o"))("ȫ"))
((("Multi_key" "_" "dead-diaeresis" "o"))("ȫ"))
((("Multi_key" "_" "\"" "o"))("ȫ"))
((("dead-macron" "dead-tilde" "O"))("Ȭ"))
((("dead-macron" "Multi_key" "~" "O"))("Ȭ"))
((("Multi_key" "_" "dead-tilde" "O"))("Ȭ"))
((("Multi_key" "_" "~" "O"))("Ȭ"))
((("dead-macron" "dead-tilde" "o"))("ȭ"))
((("dead-macron" "Multi_key" "~" "o"))("ȭ"))
((("Multi_key" "_" "dead-tilde" "o"))("ȭ"))
((("Multi_key" "_" "~" "o"))("ȭ"))
((("dead-abovedot" "O"))("Ȯ"))
((("Multi_key" "." "O"))("Ȯ"))
((("dead-abovedot" "o"))("ȯ"))
((("Multi_key" "." "o"))("ȯ"))
((("dead-macron" "dead-abovedot" "O"))("Ȱ"))
((("dead-macron" "Multi_key" "." "O"))("Ȱ"))
((("Multi_key" "_" "dead-abovedot" "O"))("Ȱ"))
((("Multi_key" "_" "." "O"))("Ȱ"))
((("dead-macron" "dead-abovedot" "o"))("ȱ"))
((("dead-macron" "Multi_key" "." "o"))("ȱ"))
((("Multi_key" "_" "dead-abovedot" "o"))("ȱ"))
((("Multi_key" "_" "." "o"))("ȱ"))
((("dead-macron" "Y"))("Ȳ"))
((("Multi_key" "_" "Y"))("Ȳ"))
((("dead-macron" "y"))("ȳ"))
((("Multi_key" "_" "y"))("ȳ"))
((("Multi_key" "e" "e"))("ə"))
((("Multi_key" "/" "i"))("ɨ"))
((("dead-circumflex" "Multi_key" "_" "h"))("ʰ"))
((("Multi_key" "^" "_" "h"))("ʰ"))
((("dead-circumflex" "Multi_key" "_" "j"))("ʲ"))
((("Multi_key" "^" "_" "j"))("ʲ"))
((("dead-circumflex" "Multi_key" "_" "r"))("ʳ"))
((("Multi_key" "^" "_" "r"))("ʳ"))
((("dead-circumflex" "Multi_key" "_" "w"))("ʷ"))
((("Multi_key" "^" "_" "w"))("ʷ"))
((("dead-circumflex" "Multi_key" "_" "y"))("ʸ"))
((("Multi_key" "^" "_" "y"))("ʸ"))
((("dead-circumflex" "Multi_key" "_" "l"))("ˡ"))
((("Multi_key" "^" "_" "l"))("ˡ"))
((("dead-circumflex" "Multi_key" "_" "s"))("ˢ"))
((("Multi_key" "^" "_" "s"))("ˢ"))
((("dead-circumflex" "Multi_key" "_" "x"))("ˣ"))
((("Multi_key" "^" "_" "x"))("ˣ"))
((("dead-diaeresis" "'"))("̈́"))
((("Multi_key" "\"" "dead-acute"))("̈́"))
((("Multi_key" "\"" "'"))("̈́"))
((("dead-abovedot" "B"))("Ḃ"))
((("Multi_key" "." "B"))("Ḃ"))
((("dead-abovedot" "b"))("ḃ"))
((("Multi_key" "." "b"))("ḃ"))
((("dead-belowdot" "B"))("Ḅ"))
((("Multi_key" "!" "B"))("Ḅ"))
((("dead-belowdot" "b"))("ḅ"))
((("Multi_key" "!" "b"))("ḅ"))
((("dead-acute" "dead-cedilla" "C"))("Ḉ"))
((("dead-acute" "Multi_key" "," "C"))("Ḉ"))
((("Multi_key" "'" "dead-cedilla" "C"))("Ḉ"))
((("Multi_key" "'" "," "C"))("Ḉ"))
((("dead-acute" "dead-cedilla" "c"))("ḉ"))
((("dead-acute" "Multi_key" "," "c"))("ḉ"))
((("Multi_key" "'" "dead-cedilla" "c"))("ḉ"))
((("Multi_key" "'" "," "c"))("ḉ"))
((("dead-abovedot" "D"))("Ḋ"))
((("Multi_key" "." "D"))("Ḋ"))
((("dead-abovedot" "d"))("ḋ"))
((("Multi_key" "." "d"))("ḋ"))
((("dead-belowdot" "D"))("Ḍ"))
((("Multi_key" "!" "D"))("Ḍ"))
((("dead-belowdot" "d"))("ḍ"))
((("Multi_key" "!" "d"))("ḍ"))
((("dead-cedilla" "D"))("Ḑ"))
((("Multi_key" "," "D"))("Ḑ"))
((("dead-cedilla" "d"))("ḑ"))
((("Multi_key" "," "d"))("ḑ"))
((("dead-grave" "dead-macron" "E"))("Ḕ"))
((("dead-grave" "Multi_key" "_" "E"))("Ḕ"))
((("Multi_key" "`" "dead-macron" "E"))("Ḕ"))
((("Multi_key" "`" "_" "E"))("Ḕ"))
((("dead-grave" "dead-macron" "e"))("ḕ"))
((("dead-grave" "Multi_key" "_" "e"))("ḕ"))
((("Multi_key" "`" "dead-macron" "e"))("ḕ"))
((("Multi_key" "`" "_" "e"))("ḕ"))
((("dead-acute" "dead-macron" "E"))("Ḗ"))
((("dead-acute" "Multi_key" "_" "E"))("Ḗ"))
((("Multi_key" "'" "dead-macron" "E"))("Ḗ"))
((("Multi_key" "'" "_" "E"))("Ḗ"))
((("dead-acute" "dead-macron" "e"))("ḗ"))
((("dead-acute" "Multi_key" "_" "e"))("ḗ"))
((("Multi_key" "'" "dead-macron" "e"))("ḗ"))
((("Multi_key" "'" "_" "e"))("ḗ"))
((("dead-breve" "dead-cedilla" "E"))("Ḝ"))
((("dead-breve" "Multi_key" "," "E"))("Ḝ"))
((("Multi_key" "U" "dead-cedilla" "E"))("Ḝ"))
((("Multi_key" "U" "," "E"))("Ḝ"))
((("Multi_key" "b" "dead-cedilla" "E"))("Ḝ"))
((("Multi_key" "b" "," "E"))("Ḝ"))
((("dead-breve" "dead-cedilla" "e"))("ḝ"))
((("dead-breve" "Multi_key" "," "e"))("ḝ"))
((("Multi_key" "U" "dead-cedilla" "e"))("ḝ"))
((("Multi_key" "U" "," "e"))("ḝ"))
((("Multi_key" "b" "dead-cedilla" "e"))("ḝ"))
((("Multi_key" "b" "," "e"))("ḝ"))
((("dead-abovedot" "F"))("Ḟ"))
((("Multi_key" "." "F"))("Ḟ"))
((("dead-abovedot" "f"))("ḟ"))
((("Multi_key" "." "f"))("ḟ"))
((("dead-macron" "G"))("Ḡ"))
((("Multi_key" "_" "G"))("Ḡ"))
((("dead-macron" "g"))("ḡ"))
((("Multi_key" "_" "g"))("ḡ"))
((("dead-abovedot" "H"))("Ḣ"))
((("Multi_key" "." "H"))("Ḣ"))
((("dead-abovedot" "h"))("ḣ"))
((("Multi_key" "." "h"))("ḣ"))
((("dead-belowdot" "H"))("Ḥ"))
((("Multi_key" "!" "H"))("Ḥ"))
((("dead-belowdot" "h"))("ḥ"))
((("Multi_key" "!" "h"))("ḥ"))
((("dead-diaeresis" "H"))("Ḧ"))
((("Multi_key" "\"" "H"))("Ḧ"))
((("dead-diaeresis" "h"))("ḧ"))
((("Multi_key" "\"" "h"))("ḧ"))
((("dead-cedilla" "H"))("Ḩ"))
((("Multi_key" "," "H"))("Ḩ"))
((("dead-cedilla" "h"))("ḩ"))
((("Multi_key" "," "h"))("ḩ"))
((("dead-acute" "dead-diaeresis" "I"))("Ḯ"))
((("dead-acute" "Multi_key" "\"" "I"))("Ḯ"))
((("Multi_key" "'" "dead-diaeresis" "I"))("Ḯ"))
((("Multi_key" "'" "\"" "I"))("Ḯ"))
((("dead-acute" "dead-diaeresis" "i"))("ḯ"))
((("dead-acute" "Multi_key" "\"" "i"))("ḯ"))
((("Multi_key" "'" "dead-diaeresis" "i"))("ḯ"))
((("Multi_key" "'" "\"" "i"))("ḯ"))
((("dead-acute" "K"))("Ḱ"))
((("Multi_key" "'" "K"))("Ḱ"))
((("dead-acute" "k"))("ḱ"))
((("Multi_key" "'" "k"))("ḱ"))
((("dead-belowdot" "K"))("Ḳ"))
((("Multi_key" "!" "K"))("Ḳ"))
((("dead-belowdot" "k"))("ḳ"))
((("Multi_key" "!" "k"))("ḳ"))
((("dead-belowdot" "L"))("Ḷ"))
((("Multi_key" "!" "L"))("Ḷ"))
((("dead-belowdot" "l"))("ḷ"))
((("Multi_key" "!" "l"))("ḷ"))
((("dead-macron" "dead-belowdot" "L"))("Ḹ"))
((("dead-macron" "Multi_key" "!" "L"))("Ḹ"))
((("Multi_key" "_" "dead-belowdot" "L"))("Ḹ"))
((("Multi_key" "_" "!" "L"))("Ḹ"))
((("dead-macron" "dead-belowdot" "l"))("ḹ"))
((("dead-macron" "Multi_key" "!" "l"))("ḹ"))
((("Multi_key" "_" "dead-belowdot" "l"))("ḹ"))
((("Multi_key" "_" "!" "l"))("ḹ"))
((("dead-acute" "M"))("Ḿ"))
((("Multi_key" "'" "M"))("Ḿ"))
((("dead-acute" "m"))("ḿ"))
((("Multi_key" "'" "m"))("ḿ"))
((("dead-abovedot" "M"))("Ṁ"))
((("Multi_key" "." "M"))("Ṁ"))
((("dead-abovedot" "m"))("ṁ"))
((("Multi_key" "." "m"))("ṁ"))
((("dead-belowdot" "M"))("Ṃ"))
((("Multi_key" "!" "M"))("Ṃ"))
((("dead-belowdot" "m"))("ṃ"))
((("Multi_key" "!" "m"))("ṃ"))
((("dead-abovedot" "N"))("Ṅ"))
((("Multi_key" "." "N"))("Ṅ"))
((("dead-abovedot" "n"))("ṅ"))
((("Multi_key" "." "n"))("ṅ"))
((("dead-belowdot" "N"))("Ṇ"))
((("Multi_key" "!" "N"))("Ṇ"))
((("dead-belowdot" "n"))("ṇ"))
((("Multi_key" "!" "n"))("ṇ"))
((("dead-acute" "dead-tilde" "O"))("Ṍ"))
((("dead-acute" "Multi_key" "~" "O"))("Ṍ"))
((("Multi_key" "'" "dead-tilde" "O"))("Ṍ"))
((("Multi_key" "'" "~" "O"))("Ṍ"))
((("dead-acute" "dead-tilde" "o"))("ṍ"))
((("dead-acute" "Multi_key" "~" "o"))("ṍ"))
((("Multi_key" "'" "dead-tilde" "o"))("ṍ"))
((("Multi_key" "'" "~" "o"))("ṍ"))
((("dead-diaeresis" "dead-tilde" "O"))("Ṏ"))
((("dead-diaeresis" "Multi_key" "~" "O"))("Ṏ"))
((("Multi_key" "\"" "dead-tilde" "O"))("Ṏ"))
((("Multi_key" "\"" "~" "O"))("Ṏ"))
((("dead-diaeresis" "dead-tilde" "o"))("ṏ"))
((("dead-diaeresis" "Multi_key" "~" "o"))("ṏ"))
((("Multi_key" "\"" "dead-tilde" "o"))("ṏ"))
((("Multi_key" "\"" "~" "o"))("ṏ"))
((("dead-grave" "dead-macron" "O"))("Ṑ"))
((("dead-grave" "Multi_key" "_" "O"))("Ṑ"))
((("Multi_key" "`" "dead-macron" "O"))("Ṑ"))
((("Multi_key" "`" "_" "O"))("Ṑ"))
((("dead-grave" "dead-macron" "o"))("ṑ"))
((("dead-grave" "Multi_key" "_" "o"))("ṑ"))
((("Multi_key" "`" "dead-macron" "o"))("ṑ"))
((("Multi_key" "`" "_" "o"))("ṑ"))
((("dead-acute" "dead-macron" "O"))("Ṓ"))
((("dead-acute" "Multi_key" "_" "O"))("Ṓ"))
((("Multi_key" "'" "dead-macron" "O"))("Ṓ"))
((("Multi_key" "'" "_" "O"))("Ṓ"))
((("dead-acute" "dead-macron" "o"))("ṓ"))
((("dead-acute" "Multi_key" "_" "o"))("ṓ"))
((("Multi_key" "'" "dead-macron" "o"))("ṓ"))
((("Multi_key" "'" "_" "o"))("ṓ"))
((("dead-acute" "P"))("Ṕ"))
((("Multi_key" "'" "P"))("Ṕ"))
((("dead-acute" "p"))("ṕ"))
((("Multi_key" "'" "p"))("ṕ"))
((("dead-abovedot" "P"))("Ṗ"))
((("Multi_key" "." "P"))("Ṗ"))
((("dead-abovedot" "p"))("ṗ"))
((("Multi_key" "." "p"))("ṗ"))
((("dead-abovedot" "R"))("Ṙ"))
((("Multi_key" "." "R"))("Ṙ"))
((("dead-abovedot" "r"))("ṙ"))
((("Multi_key" "." "r"))("ṙ"))
((("dead-belowdot" "R"))("Ṛ"))
((("Multi_key" "!" "R"))("Ṛ"))
((("dead-belowdot" "r"))("ṛ"))
((("Multi_key" "!" "r"))("ṛ"))
((("dead-macron" "dead-belowdot" "R"))("Ṝ"))
((("dead-macron" "Multi_key" "!" "R"))("Ṝ"))
((("Multi_key" "_" "dead-belowdot" "R"))("Ṝ"))
((("Multi_key" "_" "!" "R"))("Ṝ"))
((("dead-macron" "dead-belowdot" "r"))("ṝ"))
((("dead-macron" "Multi_key" "!" "r"))("ṝ"))
((("Multi_key" "_" "dead-belowdot" "r"))("ṝ"))
((("Multi_key" "_" "!" "r"))("ṝ"))
((("dead-abovedot" "S"))("Ṡ"))
((("Multi_key" "." "S"))("Ṡ"))
((("dead-abovedot" "s"))("ṡ"))
((("Multi_key" "." "s"))("ṡ"))
((("dead-belowdot" "S"))("Ṣ"))
((("Multi_key" "!" "S"))("Ṣ"))
((("dead-belowdot" "s"))("ṣ"))
((("Multi_key" "!" "s"))("ṣ"))
((("dead-abovedot" "dead-acute" "S"))("Ṥ"))
((("dead-abovedot" "Multi_key" "'" "S"))("Ṥ"))
((("Multi_key" "." "dead-acute" "S"))("Ṥ"))
((("Multi_key" "." "'" "S"))("Ṥ"))
((("dead-abovedot" "dead-acute" "s"))("ṥ"))
((("dead-abovedot" "Multi_key" "'" "s"))("ṥ"))
((("Multi_key" "." "dead-acute" "s"))("ṥ"))
((("Multi_key" "." "'" "s"))("ṥ"))
((("dead-abovedot" "dead-caron" "S"))("Ṧ"))
((("dead-abovedot" "Multi_key" "c" "S"))("Ṧ"))
((("Multi_key" "." "dead-caron" "S"))("Ṧ"))
((("Multi_key" "." "c" "S"))("Ṧ"))
((("dead-abovedot" "dead-caron" "s"))("ṧ"))
((("dead-abovedot" "Multi_key" "c" "s"))("ṧ"))
((("Multi_key" "." "dead-caron" "s"))("ṧ"))
((("Multi_key" "." "c" "s"))("ṧ"))
((("dead-abovedot" "dead-belowdot" "S"))("Ṩ"))
((("dead-abovedot" "Multi_key" "!" "S"))("Ṩ"))
((("Multi_key" "." "dead-belowdot" "S"))("Ṩ"))
((("Multi_key" "." "!" "S"))("Ṩ"))
((("dead-abovedot" "dead-belowdot" "s"))("ṩ"))
((("dead-abovedot" "Multi_key" "!" "s"))("ṩ"))
((("Multi_key" "." "dead-belowdot" "s"))("ṩ"))
((("Multi_key" "." "!" "s"))("ṩ"))
((("dead-abovedot" "T"))("Ṫ"))
((("Multi_key" "." "T"))("Ṫ"))
((("dead-abovedot" "t"))("ṫ"))
((("Multi_key" "." "t"))("ṫ"))
((("dead-belowdot" "T"))("Ṭ"))
((("Multi_key" "!" "T"))("Ṭ"))
((("dead-belowdot" "t"))("ṭ"))
((("Multi_key" "!" "t"))("ṭ"))
((("dead-acute" "dead-tilde" "U"))("Ṹ"))
((("dead-acute" "Multi_key" "~" "U"))("Ṹ"))
((("Multi_key" "'" "dead-tilde" "U"))("Ṹ"))
((("Multi_key" "'" "~" "U"))("Ṹ"))
((("dead-acute" "dead-tilde" "u"))("ṹ"))
((("dead-acute" "Multi_key" "~" "u"))("ṹ"))
((("Multi_key" "'" "dead-tilde" "u"))("ṹ"))
((("Multi_key" "'" "~" "u"))("ṹ"))
((("dead-diaeresis" "dead-macron" "U"))("Ṻ"))
((("dead-diaeresis" "Multi_key" "_" "U"))("Ṻ"))
((("Multi_key" "\"" "dead-macron" "U"))("Ṻ"))
((("Multi_key" "\"" "_" "U"))("Ṻ"))
((("dead-diaeresis" "dead-macron" "u"))("ṻ"))
((("dead-diaeresis" "Multi_key" "_" "u"))("ṻ"))
((("Multi_key" "\"" "dead-macron" "u"))("ṻ"))
((("Multi_key" "\"" "_" "u"))("ṻ"))
((("dead-tilde" "V"))("Ṽ"))
((("Multi_key" "~" "V"))("Ṽ"))
((("dead-tilde" "v"))("ṽ"))
((("Multi_key" "~" "v"))("ṽ"))
((("dead-belowdot" "V"))("Ṿ"))
((("Multi_key" "!" "V"))("Ṿ"))
((("dead-belowdot" "v"))("ṿ"))
((("Multi_key" "!" "v"))("ṿ"))
((("dead-grave" "W"))("Ẁ"))
((("Multi_key" "`" "W"))("Ẁ"))
((("dead-grave" "w"))("ẁ"))
((("Multi_key" "`" "w"))("ẁ"))
((("dead-acute" "W"))("Ẃ"))
((("Multi_key" "'" "W"))("Ẃ"))
((("dead-acute" "w"))("ẃ"))
((("Multi_key" "'" "w"))("ẃ"))
((("dead-diaeresis" "W"))("Ẅ"))
((("Multi_key" "\"" "W"))("Ẅ"))
((("dead-diaeresis" "w"))("ẅ"))
((("Multi_key" "\"" "w"))("ẅ"))
((("dead-abovedot" "W"))("Ẇ"))
((("Multi_key" "." "W"))("Ẇ"))
((("dead-abovedot" "w"))("ẇ"))
((("Multi_key" "." "w"))("ẇ"))
((("dead-belowdot" "W"))("Ẉ"))
((("Multi_key" "!" "W"))("Ẉ"))
((("dead-belowdot" "w"))("ẉ"))
((("Multi_key" "!" "w"))("ẉ"))
((("dead-abovedot" "X"))("Ẋ"))
((("Multi_key" "." "X"))("Ẋ"))
((("dead-abovedot" "x"))("ẋ"))
((("Multi_key" "." "x"))("ẋ"))
((("dead-diaeresis" "X"))("Ẍ"))
((("Multi_key" "\"" "X"))("Ẍ"))
((("dead-diaeresis" "x"))("ẍ"))
((("Multi_key" "\"" "x"))("ẍ"))
((("dead-abovedot" "Y"))("Ẏ"))
((("Multi_key" "." "Y"))("Ẏ"))
((("dead-abovedot" "y"))("ẏ"))
((("Multi_key" "." "y"))("ẏ"))
((("dead-circumflex" "Z"))("Ẑ"))
((("Multi_key" "^" "Z"))("Ẑ"))
((("dead-circumflex" "z"))("ẑ"))
((("Multi_key" "^" "z"))("ẑ"))
((("dead-belowdot" "Z"))("Ẓ"))
((("Multi_key" "!" "Z"))("Ẓ"))
((("dead-belowdot" "z"))("ẓ"))
((("Multi_key" "!" "z"))("ẓ"))
((("dead-diaeresis" "t"))("ẗ"))
((("Multi_key" "\"" "t"))("ẗ"))
((("dead-abovering" "w"))("ẘ"))
((("Multi_key" "o" "w"))("ẘ"))
((("dead-abovering" "y"))("ẙ"))
((("Multi_key" "o" "y"))("ẙ"))
((("dead-belowdot" "A"))("Ạ"))
((("Multi_key" "!" "A"))("Ạ"))
((("dead-belowdot" "a"))("ạ"))
((("Multi_key" "!" "a"))("ạ"))
((("dead-hook" "A"))("Ả"))
((("Multi_key" "?" "A"))("Ả"))
((("dead-hook" "a"))("ả"))
((("Multi_key" "?" "a"))("ả"))
((("dead-acute" "dead-circumflex" "A"))("Ấ"))
((("dead-acute" "Multi_key" "^" "A"))("Ấ"))
((("Multi_key" "'" "dead-circumflex" "A"))("Ấ"))
((("Multi_key" "'" "^" "A"))("Ấ"))
((("dead-acute" "dead-circumflex" "a"))("ấ"))
((("dead-acute" "Multi_key" "^" "a"))("ấ"))
((("Multi_key" "'" "dead-circumflex" "a"))("ấ"))
((("Multi_key" "'" "^" "a"))("ấ"))
((("dead-grave" "dead-circumflex" "A"))("Ầ"))
((("dead-grave" "Multi_key" "^" "A"))("Ầ"))
((("Multi_key" "`" "dead-circumflex" "A"))("Ầ"))
((("Multi_key" "`" "^" "A"))("Ầ"))
((("dead-grave" "dead-circumflex" "a"))("ầ"))
((("dead-grave" "Multi_key" "^" "a"))("ầ"))
((("Multi_key" "`" "dead-circumflex" "a"))("ầ"))
((("Multi_key" "`" "^" "a"))("ầ"))
((("dead-hook" "dead-circumflex" "A"))("Ẩ"))
((("dead-hook" "Multi_key" "^" "A"))("Ẩ"))
((("Multi_key" "?" "dead-circumflex" "A"))("Ẩ"))
((("Multi_key" "?" "^" "A"))("Ẩ"))
((("dead-hook" "dead-circumflex" "a"))("ẩ"))
((("dead-hook" "Multi_key" "^" "a"))("ẩ"))
((("Multi_key" "?" "dead-circumflex" "a"))("ẩ"))
((("Multi_key" "?" "^" "a"))("ẩ"))
((("dead-tilde" "dead-circumflex" "A"))("Ẫ"))
((("dead-tilde" "Multi_key" "^" "A"))("Ẫ"))
((("Multi_key" "~" "dead-circumflex" "A"))("Ẫ"))
((("Multi_key" "~" "^" "A"))("Ẫ"))
((("dead-tilde" "dead-circumflex" "a"))("ẫ"))
((("dead-tilde" "Multi_key" "^" "a"))("ẫ"))
((("Multi_key" "~" "dead-circumflex" "a"))("ẫ"))
((("Multi_key" "~" "^" "a"))("ẫ"))
((("dead-circumflex" "dead-belowdot" "A"))("Ậ"))
((("dead-circumflex" "Multi_key" "!" "A"))("Ậ"))
((("Multi_key" "^" "dead-belowdot" "A"))("Ậ"))
((("Multi_key" "^" "!" "A"))("Ậ"))
((("dead-circumflex" "dead-belowdot" "a"))("ậ"))
((("dead-circumflex" "Multi_key" "!" "a"))("ậ"))
((("Multi_key" "^" "dead-belowdot" "a"))("ậ"))
((("Multi_key" "^" "!" "a"))("ậ"))
((("dead-acute" "dead-breve" "A"))("Ắ"))
((("dead-acute" "Multi_key" "U" "A"))("Ắ"))
((("dead-acute" "Multi_key" "b" "A"))("Ắ"))
((("Multi_key" "'" "dead-breve" "A"))("Ắ"))
((("Multi_key" "'" "U" "A"))("Ắ"))
((("Multi_key" "'" "b" "A"))("Ắ"))
((("dead-acute" "dead-breve" "a"))("ắ"))
((("dead-acute" "Multi_key" "U" "a"))("ắ"))
((("dead-acute" "Multi_key" "b" "a"))("ắ"))
((("Multi_key" "'" "dead-breve" "a"))("ắ"))
((("Multi_key" "'" "U" "a"))("ắ"))
((("Multi_key" "'" "b" "a"))("ắ"))
((("dead-grave" "dead-breve" "A"))("Ằ"))
((("dead-grave" "Multi_key" "U" "A"))("Ằ"))
((("dead-grave" "Multi_key" "b" "A"))("Ằ"))
((("Multi_key" "`" "dead-breve" "A"))("Ằ"))
((("Multi_key" "`" "U" "A"))("Ằ"))
((("Multi_key" "`" "b" "A"))("Ằ"))
((("dead-grave" "dead-breve" "a"))("ằ"))
((("dead-grave" "Multi_key" "U" "a"))("ằ"))
((("dead-grave" "Multi_key" "b" "a"))("ằ"))
((("Multi_key" "`" "dead-breve" "a"))("ằ"))
((("Multi_key" "`" "U" "a"))("ằ"))
((("Multi_key" "`" "b" "a"))("ằ"))
((("dead-hook" "dead-breve" "A"))("Ẳ"))
((("dead-hook" "Multi_key" "U" "A"))("Ẳ"))
((("dead-hook" "Multi_key" "b" "A"))("Ẳ"))
((("Multi_key" "?" "dead-breve" "A"))("Ẳ"))
((("Multi_key" "?" "U" "A"))("Ẳ"))
((("Multi_key" "?" "b" "A"))("Ẳ"))
((("dead-hook" "dead-breve" "a"))("ẳ"))
((("dead-hook" "Multi_key" "U" "a"))("ẳ"))
((("dead-hook" "Multi_key" "b" "a"))("ẳ"))
((("Multi_key" "?" "dead-breve" "a"))("ẳ"))
((("Multi_key" "?" "U" "a"))("ẳ"))
((("Multi_key" "?" "b" "a"))("ẳ"))
((("dead-tilde" "dead-breve" "A"))("Ẵ"))
((("dead-tilde" "Multi_key" "U" "A"))("Ẵ"))
((("dead-tilde" "Multi_key" "b" "A"))("Ẵ"))
((("Multi_key" "~" "dead-breve" "A"))("Ẵ"))
((("Multi_key" "~" "U" "A"))("Ẵ"))
((("Multi_key" "~" "b" "A"))("Ẵ"))
((("dead-tilde" "dead-breve" "a"))("ẵ"))
((("dead-tilde" "Multi_key" "U" "a"))("ẵ"))
((("dead-tilde" "Multi_key" "b" "a"))("ẵ"))
((("Multi_key" "~" "dead-breve" "a"))("ẵ"))
((("Multi_key" "~" "U" "a"))("ẵ"))
((("Multi_key" "~" "b" "a"))("ẵ"))
((("dead-breve" "dead-belowdot" "A"))("Ặ"))
((("dead-breve" "Multi_key" "!" "A"))("Ặ"))
((("Multi_key" "U" "dead-belowdot" "A"))("Ặ"))
((("Multi_key" "U" "!" "A"))("Ặ"))
((("Multi_key" "b" "dead-belowdot" "A"))("Ặ"))
((("Multi_key" "b" "!" "A"))("Ặ"))
((("dead-breve" "dead-belowdot" "a"))("ặ"))
((("dead-breve" "Multi_key" "!" "a"))("ặ"))
((("Multi_key" "U" "dead-belowdot" "a"))("ặ"))
((("Multi_key" "U" "!" "a"))("ặ"))
((("Multi_key" "b" "dead-belowdot" "a"))("ặ"))
((("Multi_key" "b" "!" "a"))("ặ"))
((("dead-belowdot" "E"))("Ẹ"))
((("Multi_key" "!" "E"))("Ẹ"))
((("dead-belowdot" "e"))("ẹ"))
((("Multi_key" "!" "e"))("ẹ"))
((("dead-hook" "E"))("Ẻ"))
((("Multi_key" "?" "E"))("Ẻ"))
((("dead-hook" "e"))("ẻ"))
((("Multi_key" "?" "e"))("ẻ"))
((("dead-tilde" "E"))("Ẽ"))
((("Multi_key" "~" "E"))("Ẽ"))
((("dead-tilde" "e"))("ẽ"))
((("Multi_key" "~" "e"))("ẽ"))
((("dead-acute" "dead-circumflex" "E"))("Ế"))
((("dead-acute" "Multi_key" "^" "E"))("Ế"))
((("Multi_key" "'" "dead-circumflex" "E"))("Ế"))
((("Multi_key" "'" "^" "E"))("Ế"))
((("dead-acute" "dead-circumflex" "e"))("ế"))
((("dead-acute" "Multi_key" "^" "e"))("ế"))
((("Multi_key" "'" "dead-circumflex" "e"))("ế"))
((("Multi_key" "'" "^" "e"))("ế"))
((("dead-grave" "dead-circumflex" "E"))("Ề"))
((("dead-grave" "Multi_key" "^" "E"))("Ề"))
((("Multi_key" "`" "dead-circumflex" "E"))("Ề"))
((("Multi_key" "`" "^" "E"))("Ề"))
((("dead-grave" "dead-circumflex" "e"))("ề"))
((("dead-grave" "Multi_key" "^" "e"))("ề"))
((("Multi_key" "`" "dead-circumflex" "e"))("ề"))
((("Multi_key" "`" "^" "e"))("ề"))
((("dead-hook" "dead-circumflex" "E"))("Ể"))
((("dead-hook" "Multi_key" "^" "E"))("Ể"))
((("Multi_key" "?" "dead-circumflex" "E"))("Ể"))
((("Multi_key" "?" "^" "E"))("Ể"))
((("dead-hook" "dead-circumflex" "e"))("ể"))
((("dead-hook" "Multi_key" "^" "e"))("ể"))
((("Multi_key" "?" "dead-circumflex" "e"))("ể"))
((("Multi_key" "?" "^" "e"))("ể"))
((("dead-tilde" "dead-circumflex" "E"))("Ễ"))
((("dead-tilde" "Multi_key" "^" "E"))("Ễ"))
((("Multi_key" "~" "dead-circumflex" "E"))("Ễ"))
((("Multi_key" "~" "^" "E"))("Ễ"))
((("dead-tilde" "dead-circumflex" "e"))("ễ"))
((("dead-tilde" "Multi_key" "^" "e"))("ễ"))
((("Multi_key" "~" "dead-circumflex" "e"))("ễ"))
((("Multi_key" "~" "^" "e"))("ễ"))
((("dead-circumflex" "dead-belowdot" "E"))("Ệ"))
((("dead-circumflex" "Multi_key" "!" "E"))("Ệ"))
((("Multi_key" "^" "dead-belowdot" "E"))("Ệ"))
((("Multi_key" "^" "!" "E"))("Ệ"))
((("dead-circumflex" "dead-belowdot" "e"))("ệ"))
((("dead-circumflex" "Multi_key" "!" "e"))("ệ"))
((("Multi_key" "^" "dead-belowdot" "e"))("ệ"))
((("Multi_key" "^" "!" "e"))("ệ"))
((("dead-hook" "I"))("Ỉ"))
((("Multi_key" "?" "I"))("Ỉ"))
((("dead-hook" "i"))("ỉ"))
((("Multi_key" "?" "i"))("ỉ"))
((("dead-belowdot" "I"))("Ị"))
((("Multi_key" "!" "I"))("Ị"))
((("dead-belowdot" "i"))("ị"))
((("Multi_key" "!" "i"))("ị"))
((("dead-belowdot" "O"))("Ọ"))
((("Multi_key" "!" "O"))("Ọ"))
((("dead-belowdot" "o"))("ọ"))
((("Multi_key" "!" "o"))("ọ"))
((("dead-hook" "O"))("Ỏ"))
((("Multi_key" "?" "O"))("Ỏ"))
((("dead-hook" "o"))("ỏ"))
((("Multi_key" "?" "o"))("ỏ"))
((("dead-acute" "dead-circumflex" "O"))("Ố"))
((("dead-acute" "Multi_key" "^" "O"))("Ố"))
((("Multi_key" "'" "dead-circumflex" "O"))("Ố"))
((("Multi_key" "'" "^" "O"))("Ố"))
((("dead-acute" "dead-circumflex" "o"))("ố"))
((("dead-acute" "Multi_key" "^" "o"))("ố"))
((("Multi_key" "'" "dead-circumflex" "o"))("ố"))
((("Multi_key" "'" "^" "o"))("ố"))
((("dead-grave" "dead-circumflex" "O"))("Ồ"))
((("dead-grave" "Multi_key" "^" "O"))("Ồ"))
((("Multi_key" "`" "dead-circumflex" "O"))("Ồ"))
((("Multi_key" "`" "^" "O"))("Ồ"))
((("dead-grave" "dead-circumflex" "o"))("ồ"))
((("dead-grave" "Multi_key" "^" "o"))("ồ"))
((("Multi_key" "`" "dead-circumflex" "o"))("ồ"))
((("Multi_key" "`" "^" "o"))("ồ"))
((("dead-hook" "dead-circumflex" "O"))("Ổ"))
((("dead-hook" "Multi_key" "^" "O"))("Ổ"))
((("Multi_key" "?" "dead-circumflex" "O"))("Ổ"))
((("Multi_key" "?" "^" "O"))("Ổ"))
((("dead-hook" "dead-circumflex" "o"))("ổ"))
((("dead-hook" "Multi_key" "^" "o"))("ổ"))
((("Multi_key" "?" "dead-circumflex" "o"))("ổ"))
((("Multi_key" "?" "^" "o"))("ổ"))
((("dead-tilde" "dead-circumflex" "O"))("Ỗ"))
((("dead-tilde" "Multi_key" "^" "O"))("Ỗ"))
((("Multi_key" "~" "dead-circumflex" "O"))("Ỗ"))
((("Multi_key" "~" "^" "O"))("Ỗ"))
((("dead-tilde" "dead-circumflex" "o"))("ỗ"))
((("dead-tilde" "Multi_key" "^" "o"))("ỗ"))
((("Multi_key" "~" "dead-circumflex" "o"))("ỗ"))
((("Multi_key" "~" "^" "o"))("ỗ"))
((("dead-circumflex" "dead-belowdot" "O"))("Ộ"))
((("dead-circumflex" "Multi_key" "!" "O"))("Ộ"))
((("Multi_key" "^" "dead-belowdot" "O"))("Ộ"))
((("Multi_key" "^" "!" "O"))("Ộ"))
((("dead-circumflex" "dead-belowdot" "o"))("ộ"))
((("dead-circumflex" "Multi_key" "!" "o"))("ộ"))
((("Multi_key" "^" "dead-belowdot" "o"))("ộ"))
((("Multi_key" "^" "!" "o"))("ộ"))
((("dead-acute" "dead-horn" "O"))("Ớ"))
((("dead-acute" "Multi_key" "+" "O"))("Ớ"))
((("Multi_key" "'" "dead-horn" "O"))("Ớ"))
((("Multi_key" "'" "+" "O"))("Ớ"))
((("dead-acute" "dead-horn" "o"))("ớ"))
((("dead-acute" "Multi_key" "+" "o"))("ớ"))
((("Multi_key" "'" "dead-horn" "o"))("ớ"))
((("Multi_key" "'" "+" "o"))("ớ"))
((("dead-grave" "dead-horn" "O"))("Ờ"))
((("dead-grave" "Multi_key" "+" "O"))("Ờ"))
((("Multi_key" "`" "dead-horn" "O"))("Ờ"))
((("Multi_key" "`" "+" "O"))("Ờ"))
((("dead-grave" "dead-horn" "o"))("ờ"))
((("dead-grave" "Multi_key" "+" "o"))("ờ"))
((("Multi_key" "`" "dead-horn" "o"))("ờ"))
((("Multi_key" "`" "+" "o"))("ờ"))
((("dead-hook" "dead-horn" "O"))("Ở"))
((("dead-hook" "Multi_key" "+" "O"))("Ở"))
((("Multi_key" "?" "dead-horn" "O"))("Ở"))
((("Multi_key" "?" "+" "O"))("Ở"))
((("dead-hook" "dead-horn" "o"))("ở"))
((("dead-hook" "Multi_key" "+" "o"))("ở"))
((("Multi_key" "?" "dead-horn" "o"))("ở"))
((("Multi_key" "?" "+" "o"))("ở"))
((("dead-tilde" "dead-horn" "O"))("Ỡ"))
((("dead-tilde" "Multi_key" "+" "O"))("Ỡ"))
((("Multi_key" "~" "dead-horn" "O"))("Ỡ"))
((("Multi_key" "~" "+" "O"))("Ỡ"))
((("dead-tilde" "dead-horn" "o"))("ỡ"))
((("dead-tilde" "Multi_key" "+" "o"))("ỡ"))
((("Multi_key" "~" "dead-horn" "o"))("ỡ"))
((("Multi_key" "~" "+" "o"))("ỡ"))
((("dead-belowdot" "dead-horn" "O"))("Ợ"))
((("dead-belowdot" "Multi_key" "+" "O"))("Ợ"))
((("Multi_key" "!" "dead-horn" "O"))("Ợ"))
((("Multi_key" "!" "+" "O"))("Ợ"))
((("dead-belowdot" "dead-horn" "o"))("ợ"))
((("dead-belowdot" "Multi_key" "+" "o"))("ợ"))
((("Multi_key" "!" "dead-horn" "o"))("ợ"))
((("Multi_key" "!" "+" "o"))("ợ"))
((("dead-belowdot" "U"))("Ụ"))
((("Multi_key" "!" "U"))("Ụ"))
((("dead-belowdot" "u"))("ụ"))
((("Multi_key" "!" "u"))("ụ"))
((("dead-hook" "U"))("Ủ"))
((("Multi_key" "?" "U"))("Ủ"))
((("dead-hook" "u"))("ủ"))
((("Multi_key" "?" "u"))("ủ"))
((("dead-acute" "dead-horn" "U"))("Ứ"))
((("dead-acute" "Multi_key" "+" "U"))("Ứ"))
((("Multi_key" "'" "dead-horn" "U"))("Ứ"))
((("Multi_key" "'" "+" "U"))("Ứ"))
((("dead-acute" "dead-horn" "u"))("ứ"))
((("dead-acute" "Multi_key" "+" "u"))("ứ"))
((("Multi_key" "'" "dead-horn" "u"))("ứ"))
((("Multi_key" "'" "+" "u"))("ứ"))
((("dead-grave" "dead-horn" "U"))("Ừ"))
((("dead-grave" "Multi_key" "+" "U"))("Ừ"))
((("Multi_key" "`" "dead-horn" "U"))("Ừ"))
((("Multi_key" "`" "+" "U"))("Ừ"))
((("dead-grave" "dead-horn" "u"))("ừ"))
((("dead-grave" "Multi_key" "+" "u"))("ừ"))
((("Multi_key" "`" "dead-horn" "u"))("ừ"))
((("Multi_key" "`" "+" "u"))("ừ"))
((("dead-hook" "dead-horn" "U"))("Ử"))
((("dead-hook" "Multi_key" "+" "U"))("Ử"))
((("Multi_key" "?" "dead-horn" "U"))("Ử"))
((("Multi_key" "?" "+" "U"))("Ử"))
((("dead-hook" "dead-horn" "u"))("ử"))
((("dead-hook" "Multi_key" "+" "u"))("ử"))
((("Multi_key" "?" "dead-horn" "u"))("ử"))
((("Multi_key" "?" "+" "u"))("ử"))
((("dead-tilde" "dead-horn" "U"))("Ữ"))
((("dead-tilde" "Multi_key" "+" "U"))("Ữ"))
((("Multi_key" "~" "dead-horn" "U"))("Ữ"))
((("Multi_key" "~" "+" "U"))("Ữ"))
((("dead-tilde" "dead-horn" "u"))("ữ"))
((("dead-tilde" "Multi_key" "+" "u"))("ữ"))
((("Multi_key" "~" "dead-horn" "u"))("ữ"))
((("Multi_key" "~" "+" "u"))("ữ"))
((("dead-belowdot" "dead-horn" "U"))("Ự"))
((("dead-belowdot" "Multi_key" "+" "U"))("Ự"))
((("Multi_key" "!" "dead-horn" "U"))("Ự"))
((("Multi_key" "!" "+" "U"))("Ự"))
((("dead-belowdot" "dead-horn" "u"))("ự"))
((("dead-belowdot" "Multi_key" "+" "u"))("ự"))
((("Multi_key" "!" "dead-horn" "u"))("ự"))
((("Multi_key" "!" "+" "u"))("ự"))
((("dead-grave" "Y"))("Ỳ"))
((("Multi_key" "`" "Y"))("Ỳ"))
((("dead-grave" "y"))("ỳ"))
((("Multi_key" "`" "y"))("ỳ"))
((("dead-belowdot" "Y"))("Ỵ"))
((("Multi_key" "!" "Y"))("Ỵ"))
((("dead-belowdot" "y"))("ỵ"))
((("Multi_key" "!" "y"))("ỵ"))
((("dead-hook" "Y"))("Ỷ"))
((("Multi_key" "?" "Y"))("Ỷ"))
((("dead-hook" "y"))("ỷ"))
((("Multi_key" "?" "y"))("ỷ"))
((("dead-tilde" "Y"))("Ỹ"))
((("Multi_key" "~" "Y"))("Ỹ"))
((("dead-tilde" "y"))("ỹ"))
((("Multi_key" "~" "y"))("ỹ"))
((("dead-circumflex" "0"))("⁰"))
((("Multi_key" "^" "0"))("⁰"))
((("dead-circumflex" "Multi_key" "_" "i"))("ⁱ"))
((("Multi_key" "^" "_" "i"))("ⁱ"))
((("dead-circumflex" "4"))("⁴"))
((("Multi_key" "^" "4"))("⁴"))
((("dead-circumflex" "5"))("⁵"))
((("Multi_key" "^" "5"))("⁵"))
((("dead-circumflex" "6"))("⁶"))
((("Multi_key" "^" "6"))("⁶"))
((("dead-circumflex" "7"))("⁷"))
((("Multi_key" "^" "7"))("⁷"))
((("dead-circumflex" "8"))("⁸"))
((("Multi_key" "^" "8"))("⁸"))
((("dead-circumflex" "9"))("⁹"))
((("Multi_key" "^" "9"))("⁹"))
((("dead-circumflex" "+"))("⁺"))
((("Multi_key" "^" "+"))("⁺"))
((("dead-circumflex" "="))("⁼"))
((("Multi_key" "^" "="))("⁼"))
((("dead-circumflex" "("))("⁽"))
((("Multi_key" "^" "("))("⁽"))
((("dead-circumflex" ")"))("⁾"))
((("Multi_key" "^" ")"))("⁾"))
((("dead-circumflex" "Multi_key" "_" "n"))("ⁿ"))
((("Multi_key" "^" "_" "n"))("ⁿ"))
((("Multi_key" "_" "0"))("₀"))
((("Multi_key" "_" "1"))("₁"))
((("Multi_key" "_" "2"))("₂"))
((("Multi_key" "_" "3"))("₃"))
((("Multi_key" "_" "4"))("₄"))
((("Multi_key" "_" "5"))("₅"))
((("Multi_key" "_" "6"))("₆"))
((("Multi_key" "_" "7"))("₇"))
((("Multi_key" "_" "8"))("₈"))
((("Multi_key" "_" "9"))("₉"))
((("Multi_key" "_" "+"))("₊"))
((("Multi_key" "_" "="))("₌"))
((("Multi_key" "_" "("))("₍"))
((("Multi_key" "_" ")"))("₎"))
((("dead-circumflex" "Multi_key" "S" "M"))("℠"))
((("Multi_key" "^" "S" "M"))("℠"))
((("dead-circumflex" "Multi_key" "T" "M"))("™"))
((("Multi_key" "^" "T" "M"))("™"))
((("Multi_key" "(" "1" ")"))("①"))
((("Multi_key" "(" "2" ")"))("②"))
((("Multi_key" "(" "3" ")"))("③"))
((("Multi_key" "(" "4" ")"))("④"))
((("Multi_key" "(" "5" ")"))("⑤"))
((("Multi_key" "(" "6" ")"))("⑥"))
((("Multi_key" "(" "7" ")"))("⑦"))
((("Multi_key" "(" "8" ")"))("⑧"))
((("Multi_key" "(" "9" ")"))("⑨"))
((("Multi_key" "(" "1" "0" ")"))("⑩"))
((("Multi_key" "(" "1" "1" ")"))("⑪"))
((("Multi_key" "(" "1" "2" ")"))("⑫"))
((("Multi_key" "(" "1" "3" ")"))("⑬"))
((("Multi_key" "(" "1" "4" ")"))("⑭"))
((("Multi_key" "(" "1" "5" ")"))("⑮"))
((("Multi_key" "(" "1" "6" ")"))("⑯"))
((("Multi_key" "(" "1" "7" ")"))("⑰"))
((("Multi_key" "(" "1" "8" ")"))("⑱"))
((("Multi_key" "(" "1" "9" ")"))("⑲"))
((("Multi_key" "(" "2" "0" ")"))("⑳"))
((("Multi_key" "(" "A" ")"))("Ⓐ"))
((("Multi_key" "(" "B" ")"))("Ⓑ"))
((("Multi_key" "(" "C" ")"))("Ⓒ"))
((("Multi_key" "(" "D" ")"))("Ⓓ"))
((("Multi_key" "(" "E" ")"))("Ⓔ"))
((("Multi_key" "(" "F" ")"))("Ⓕ"))
((("Multi_key" "(" "G" ")"))("Ⓖ"))
((("Multi_key" "(" "H" ")"))("Ⓗ"))
((("Multi_key" "(" "I" ")"))("Ⓘ"))
((("Multi_key" "(" "J" ")"))("Ⓙ"))
((("Multi_key" "(" "K" ")"))("Ⓚ"))
((("Multi_key" "(" "L" ")"))("Ⓛ"))
((("Multi_key" "(" "M" ")"))("Ⓜ"))
((("Multi_key" "(" "N" ")"))("Ⓝ"))
((("Multi_key" "(" "O" ")"))("Ⓞ"))
((("Multi_key" "(" "P" ")"))("Ⓟ"))
((("Multi_key" "(" "Q" ")"))("Ⓠ"))
((("Multi_key" "(" "R" ")"))("Ⓡ"))
((("Multi_key" "(" "S" ")"))("Ⓢ"))
((("Multi_key" "(" "T" ")"))("Ⓣ"))
((("Multi_key" "(" "U" ")"))("Ⓤ"))
((("Multi_key" "(" "V" ")"))("Ⓥ"))
((("Multi_key" "(" "W" ")"))("Ⓦ"))
((("Multi_key" "(" "X" ")"))("Ⓧ"))
((("Multi_key" "(" "Y" ")"))("Ⓨ"))
((("Multi_key" "(" "Z" ")"))("Ⓩ"))
((("Multi_key" "(" "a" ")"))("ⓐ"))
((("Multi_key" "(" "b" ")"))("ⓑ"))
((("Multi_key" "(" "c" ")"))("ⓒ"))
((("Multi_key" "(" "d" ")"))("ⓓ"))
((("Multi_key" "(" "e" ")"))("ⓔ"))
((("Multi_key" "(" "f" ")"))("ⓕ"))
((("Multi_key" "(" "g" ")"))("ⓖ"))
((("Multi_key" "(" "h" ")"))("ⓗ"))
((("Multi_key" "(" "i" ")"))("ⓘ"))
((("Multi_key" "(" "j" ")"))("ⓙ"))
((("Multi_key" "(" "k" ")"))("ⓚ"))
((("Multi_key" "(" "l" ")"))("ⓛ"))
((("Multi_key" "(" "m" ")"))("ⓜ"))
((("Multi_key" "(" "n" ")"))("ⓝ"))
((("Multi_key" "(" "o" ")"))("ⓞ"))
((("Multi_key" "(" "p" ")"))("ⓟ"))
((("Multi_key" "(" "q" ")"))("ⓠ"))
((("Multi_key" "(" "r" ")"))("ⓡ"))
((("Multi_key" "(" "s" ")"))("ⓢ"))
((("Multi_key" "(" "t" ")"))("ⓣ"))
((("Multi_key" "(" "u" ")"))("ⓤ"))
((("Multi_key" "(" "v" ")"))("ⓥ"))
((("Multi_key" "(" "w" ")"))("ⓦ"))
((("Multi_key" "(" "x" ")"))("ⓧ"))
((("Multi_key" "(" "y" ")"))("ⓨ"))
((("Multi_key" "(" "z" ")"))("ⓩ"))
((("Multi_key" "(" "0" ")"))("⓪"))
((("Multi_key" "(" "2" "1" ")"))("㉑"))
((("Multi_key" "(" "2" "2" ")"))("㉒"))
((("Multi_key" "(" "2" "3" ")"))("㉓"))
((("Multi_key" "(" "2" "4" ")"))("㉔"))
((("Multi_key" "(" "2" "5" ")"))("㉕"))
((("Multi_key" "(" "2" "6" ")"))("㉖"))
((("Multi_key" "(" "2" "7" ")"))("㉗"))
((("Multi_key" "(" "2" "8" ")"))("㉘"))
((("Multi_key" "(" "2" "9" ")"))("㉙"))
((("Multi_key" "(" "3" "0" ")"))("㉚"))
((("Multi_key" "(" "3" "1" ")"))("㉛"))
((("Multi_key" "(" "3" "2" ")"))("㉜"))
((("Multi_key" "(" "3" "3" ")"))("㉝"))
((("Multi_key" "(" "3" "4" ")"))("㉞"))
((("Multi_key" "(" "3" "5" ")"))("㉟"))
((("Multi_key" "(" "3" "6" ")"))("㊱"))
((("Multi_key" "(" "3" "7" ")"))("㊲"))
((("Multi_key" "(" "3" "8" ")"))("㊳"))
((("Multi_key" "(" "3" "9" ")"))("㊴"))
((("Multi_key" "(" "4" "0" ")"))("㊵"))
((("Multi_key" "(" "4" "1" ")"))("㊶"))
((("Multi_key" "(" "4" "2" ")"))("㊷"))
((("Multi_key" "(" "4" "3" ")"))("㊸"))
((("Multi_key" "(" "4" "4" ")"))("㊹"))
((("Multi_key" "(" "4" "5" ")"))("㊺"))
((("Multi_key" "(" "4" "6" ")"))("㊻"))
((("Multi_key" "(" "4" "7" ")"))("㊼"))
((("Multi_key" "(" "4" "8" ")"))("㊽"))
((("Multi_key" "(" "4" "9" ")"))("㊾"))
((("Multi_key" "(" "5" "0" ")"))("㊿"))
))

(define latin-set-deadkey-representation
  (lambda ()
    (set-symbol-value! 'dead-grave "`")
    (set-symbol-value! 'dead-acute "´")
    (set-symbol-value! 'dead-circumflex "ˆ")
    (set-symbol-value! 'dead-tilde "˜")
    (set-symbol-value! 'dead-macron "¯")
    (set-symbol-value! 'dead-breve "˘")
    (set-symbol-value! 'dead-abovedot "˙")
    (set-symbol-value! 'dead-diaeresis "¨")
    (set-symbol-value! 'dead-abovering "˚")
    (set-symbol-value! 'dead-doubleacute "˝")
    (set-symbol-value! 'dead-caron "ˇ")
    (set-symbol-value! 'dead-cedilla "¸")
    (set-symbol-value! 'dead-ogonek "˛")
    (set-symbol-value! 'dead-iota "ͺ") ;; represented with U+037A
    ;; no representation chars below
    ;(set-symbol-value! 'dead-belowdot "")
    ;(set-symbol-value! 'dead-hook "")
    ;(set-symbol-value! 'dead-horn "")
))

(define latin-im-rule
  (append ascii-rule latin-compose-rule))

(define ascii-rule
  (map (compose (lambda (entry)
		  (list (list entry) entry))
		list
		charcode->string)
       (iota 95 32)))

;; widgets and actions

;; widgets
(define latin-widgets '(widget_latin_input_mode))

;; default activity for each widgets
(define default-widget_latin_input_mode 'action_latin_input)

;; actions of widget_latin_input_mode
(define latin-input-mode-actions
  '(action_latin_input))

;;; implementations

(register-action 'action_latin_input
		 (lambda (lc)
		   (list
		    'on
		    "L"
		    (N_ "Latin compose")
		    (N_ "Latin Compose Mode")))
		 (lambda (lc)
		   #t)
		 (lambda (lc)
		   ;; set deadkey representaion values
		   (latin-set-deadkey-representation)))

;; Update widget definitions based on action configurations. The
;; procedure is needed for on-the-fly reconfiguration involving the
;; custom API
(define latin-configure-widgets
  (lambda ()
    (register-widget 'widget_latin_input_mode
		     (activity-indicator-new latin-input-mode-actions)
		     (actions-new latin-input-mode-actions))))

(define latin-context-rec-spec
  (append
   context-rec-spec
   '((rk-context         #f)
     (composing?         #f)
     (raw-commit         #t))))

(define-record 'latin-context latin-context-rec-spec)
(define latin-context-new-internal latin-context-new)

(define latin-context-new
  (lambda (id im)
    (let ((lc (latin-context-new-internal id im))
	  (rkc (rk-context-new latin-im-rule #f #f)))
      (latin-context-set-widgets! lc latin-widgets)
      (latin-context-set-rk-context! lc rkc)
      lc)))

(define latin-init-handler
  (lambda (id im arg)
    (latin-context-new id im)))

(define latin-context-flush
  (lambda (lc)
    (rk-flush (latin-context-rk-context lc))
    (latin-context-set-composing?! lc #f)))

(define latin-update-preedit
  (lambda (lc)
    (if (not (latin-context-raw-commit lc))
	(let* ((rkc (latin-context-rk-context lc))
	       (cs (rk-current-seq rkc)))
	  (im-clear-preedit lc)
	  (im-pushback-preedit lc
			       preedit-underline
			       (if cs
				   (nth 0 (cadr cs))
				   (rk-pending rkc)))
	  (im-pushback-preedit lc
			       preedit-cursor
			       "")
	  (im-update-preedit lc))
	(latin-context-set-raw-commit! lc #f))))

(define latin-commit-raw
  (lambda (lc)
    (im-commit-raw lc)
    (latin-context-set-raw-commit! lc #t)))

(define latin-commit
  (lambda (lc)
    (let* ((rkc (latin-context-rk-context lc))
	   (cs (rk-current-seq rkc)))
      (if cs
	  (im-commit lc (car (cadr cs)))
	  (im-commit lc (rk-pending rkc)))
      (latin-context-flush lc))))

(define latin-proc-composing-state
  (lambda (lc key state)
    (let ((rkc (latin-context-rk-context lc)))
      (cond
       ((latin-backspace-key? key state)
	(if (not (rk-backspace rkc))
	    (latin-commit-raw lc)
	    (if (null? (rk-context-seq rkc))
		(latin-context-flush lc))))

       ((latin-commit-key? key state)
	(latin-commit lc))

       ((or (and
	     (symbol? key)
	     (not (or (dead-keys? key)
		      (eq? 'Multi_key key))))
	    (and
	     (eqv? 32 key) ; space
	     (not (string-find (rk-expect rkc) " "))))
	(latin-commit lc)
	(im-commit-raw lc)
	(latin-context-flush lc))

       (else
	(let ((res (rk-push-key! rkc (if (symbol? key)
					 (symbol->string key)
					 (charcode->string key)))))
	  (if (not (rk-partial? rkc))
	      (let ((cs (rk-current-seq rkc)))
		(if (and
		     (= (length (cadr cs)) 1)
		     (not (= (length (car (car cs))) 1)))
		    (latin-commit lc)
		    ;; reset invalid sequence
		    (latin-context-flush lc))))
	  ;; reset invalid sequence
	  (if res
	      (latin-context-flush lc))))))))

(define dead-keys?
  (lambda (key)
    (if (and
	 (symbol? key)
	 (> (string-length (symbol->string key)) 5))
	(let ((keysym-head
	       (string-list-concat
		(list-head (reverse (string-to-list (symbol->string key))) 5))))
	  (if (string=? keysym-head "-daed") ;;reverse
	      #t
	      #f))
	#f)))

(define latin-proc-raw-state
  (lambda (lc key state)
    (cond
     ((or
       (eq? 'Multi_key key)
       (dead-keys? key))
      (latin-context-set-composing?! lc #t)
      (latin-context-set-raw-commit! lc #f)
      (latin-proc-composing-state lc key state))
     (else
      (latin-commit-raw lc)))))

(define latin-press-key-handler
  (lambda (lc key state)
    (if (ichar-control? key)
	(im-commit-raw lc)
	(if (latin-context-composing? lc)
	    (latin-proc-composing-state lc key state)
	    (latin-proc-raw-state lc key state)))
    (latin-update-preedit lc)))

(define latin-release-key-handler
  (lambda (lc key state)
    (if (or (ichar-control? key)
	    (not (latin-context-composing? lc)))
	;; don't discard key release event for apps
	(latin-commit-raw lc))))

(define latin-reset-handler
  (lambda (lc)
    (latin-context-flush lc)))

(define latin-focus-in-handler
  (lambda (lc)
    #f))

(define latin-focus-out-handler
  (lambda (lc)
    (latin-context-flush lc)
    (im-clear-preedit lc)
    (im-update-preedit lc)))

(define latin-place-handler
  (lambda (lc)
    (im-clear-preedit lc)
    (im-update-preedit lc)))

(define latin-displace-handler
  (lambda (lc)
    (let* ((rkc (latin-context-rk-context lc))
	   (pend (rk-pending rkc)))
      (if pend
	  (im-commit lc pend))
      (latin-context-flush lc))))

(latin-configure-widgets)

(register-im
 'latin
 ""
 "UTF-8"
 (N_ "Latin characters")
 (N_ "Latin characters mainly used for Latin and Germanic languages")
 #f
 latin-init-handler
 #f
 context-mode-handler
 latin-press-key-handler
 latin-release-key-handler
 latin-reset-handler
 #f
 #f
 context-prop-activate-handler
 #f
 latin-focus-in-handler
 latin-focus-out-handler
 latin-place-handler
 latin-displace-handler
)
