/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.SessionNotFoundException;
import com.google.common.collect.ListMultimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SQLTable
extends SQLObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(SQLColumn.class, SQLRelationship.class, SQLRelationship.SQLImportedKey.class, SQLIndex.class)));
    private static Logger logger = Logger.getLogger(SQLTable.class);
    protected String remarks = "";
    private String objectType;
    protected List<SQLColumn> columns = new ArrayList<SQLColumn>();
    protected List<SQLRelationship> exportedKeys = new ArrayList<SQLRelationship>();
    protected List<SQLRelationship.SQLImportedKey> importedKeys = new ArrayList<SQLRelationship.SQLImportedKey>();
    private final SQLIndex primaryKeyIndex;
    private List<SQLIndex> indices = new ArrayList<SQLIndex>();
    private boolean columnsPopulated = false;
    private boolean indicesPopulated = false;
    private boolean exportedKeysPopulated = false;
    private boolean importedKeysPopulated = false;

    public SQLTable(SQLObject parent, String name, String remarks, String objectType, boolean startPopulated) throws SQLObjectException {
        this(parent, name, remarks, objectType, startPopulated, new SQLIndex());
    }

    public SQLTable(SQLObject parent, String name, String remarks, String objectType, boolean startPopulated, SQLIndex primaryKey) throws SQLObjectException {
        this(parent, name, remarks, objectType, startPopulated, primaryKey, startPopulated, startPopulated, startPopulated, startPopulated);
    }

    @Constructor
    public SQLTable(@ConstructorParameter(propertyName="parent") SQLObject parent, @ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="remarks") String remarks, @ConstructorParameter(propertyName="objectType") String objectType, @ConstructorParameter(propertyName="populated") boolean startPopulated, @ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="primaryKeyIndex") SQLIndex primaryKeyIndex, @ConstructorParameter(propertyName="columnsPopulated") boolean columnsPopulated, @ConstructorParameter(propertyName="indicesPopulated") boolean indicesPopulated, @ConstructorParameter(propertyName="exportedKeysPopulated") boolean exportedKeysPopulated, @ConstructorParameter(propertyName="importedKeysPopulated") boolean importedKeysPopulated) throws SQLObjectException {
        logger.debug((Object)("NEW TABLE " + name + "@" + this.hashCode()));
        for (SQLIndex.Column wrapper : primaryKeyIndex.getChildrenWithoutPopulating()) {
            if (wrapper.getColumn() == null) {
                throw new SQLObjectException("The primary key of the table " + name + " is not allowed to have calculated columns");
            }
            if (this.columns.contains(wrapper.getColumn())) continue;
            throw new SQLObjectException("The primary key of the table " + name + " contains a column " + wrapper.getColumn() + " that is not " + "part of the table.");
        }
        this.primaryKeyIndex = primaryKeyIndex;
        primaryKeyIndex.setParent(this);
        this.initFolders(startPopulated);
        this.setColumnsPopulated(columnsPopulated);
        this.setIndicesPopulated(indicesPopulated);
        this.setExportedKeysPopulated(exportedKeysPopulated);
        this.setImportedKeysPopulated(importedKeysPopulated);
        this.setup(parent, name, remarks, objectType);
    }

    private void setup(SQLObject parent, String name, String remarks, String objectType) {
        super.setParent(parent);
        super.setName(name);
        this.remarks = remarks;
        this.objectType = objectType;
        super.setPhysicalName(name);
        this.updatePKIndexNameToMatch(null, name);
        if (this.objectType == null) {
            throw new NullPointerException();
        }
    }

    public SQLTable(SQLDatabase parent, boolean startPopulated) throws SQLObjectException {
        this(parent, "", "", "TABLE", startPopulated);
    }

    public SQLTable(SQLDatabase parent, boolean startPopulated, SQLIndex primaryKeyIndex) throws SQLObjectException {
        this(parent, "", "", "TABLE", startPopulated, primaryKeyIndex);
    }

    public SQLTable() {
        this.primaryKeyIndex = new SQLIndex();
        this.primaryKeyIndex.setParent(this);
        this.setup(null, null, null, "TABLE");
    }

    public void initFolders(boolean populated) {
        this.populated = populated;
        this.columnsPopulated = populated;
        this.exportedKeysPopulated = populated;
        this.importedKeysPopulated = populated;
        this.indicesPopulated = populated;
    }

    @Override
    public void updateToMatch(SQLObject source) throws SQLObjectException {
        SQLTable sourceTable = (SQLTable)source;
        this.setName(sourceTable.getName());
        this.setRemarks(sourceTable.getRemarks());
        this.setPhysicalName(sourceTable.getPhysicalName());
        this.setObjectType(sourceTable.getObjectType());
    }

    public SQLTable createInheritingInstance(SQLDatabase parent) throws SQLObjectException {
        return this.createTableFromSource(parent, TransferStyles.REVERSE_ENGINEER, false);
    }

    private SQLTable createTableFromSource(SQLDatabase parent, TransferStyles transferStyle, boolean preserveColumnSource) throws SQLObjectException {
        this.populateColumns();
        this.populateIndices();
        this.populateRelationships();
        this.populateImportedKeys();
        SQLIndex newPKIndex = new SQLIndex();
        SQLTable t = new SQLTable(parent, this.getName(), this.remarks, "TABLE", true, newPKIndex);
        for (Map.Entry<Class<? extends SQLObject>, Throwable> inaccessibleReason : this.getChildrenInaccessibleReasons().entrySet()) {
            t.setChildrenInaccessibleReason(inaccessibleReason.getValue(), inaccessibleReason.getKey(), false);
        }
        t.inherit(this, transferStyle, preserveColumnSource);
        SQLTable.inheritIndices(this, t);
        parent.addChild(t);
        return t;
    }

    public SQLTable createCopy(SQLDatabase parent, boolean preserveColumnSource) throws SQLObjectException {
        return this.createTableFromSource(parent, TransferStyles.COPY, preserveColumnSource);
    }

    private static void inheritIndices(SQLTable source, SQLTable target) throws SQLObjectException {
        for (SQLIndex index : source.getIndices()) {
            if (index.isPrimaryKeyIndex()) {
                target.getPrimaryKeyIndex().updateToMatch(index);
                continue;
            }
            SQLIndex index2 = SQLIndex.getDerivedInstance(index, target);
            target.addIndex(index2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateColumns() throws SQLObjectException {
        if (this.columnsPopulated) {
            return;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                if (this.columns.size() > 0) {
                    throw new IllegalStateException("Can't populate table because it already contains columns");
                }
                logger.debug((Object)("column folder populate starting for table " + this.getName()));
                SQLTable.populateAllColumns(this.getCatalogName(), this.getSchemaName(), this.getName(), this.getParentDatabase(), this.getParent());
                logger.debug((Object)("column folder populate finished for table " + this.getName()));
                this.populateIndices();
            }
        }
    }

    private static synchronized void populateAllColumns(final String catalogName, final String schemaName, final String tableName, final SQLDatabase parentDB, final SQLObject tableContainer) throws SQLObjectException {
        Connection con = null;
        try {
            con = parentDB.getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            final ListMultimap<String, SQLColumn> cols = SQLColumn.fetchColumnsForTable(catalogName, schemaName, tableName, dbmd);
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLTable t;
                        parentDB.begin("Populating all columns");
                        if (cols.isEmpty() && (t = parentDB.getTableByName(catalogName, schemaName, tableName)) != null) {
                            t.setColumnsPopulated(true);
                        }
                        for (String tableName2 : cols.keySet()) {
                            SQLTable table = tableContainer.getChildByName(tableName2, SQLTable.class);
                            if (table == null || table.isColumnsPopulated()) continue;
                            SQLTable.populateColumnsWithList(table, cols.get((Object)tableName2));
                        }
                        parentDB.commit();
                    }
                    catch (Throwable t) {
                        parentDB.rollback(t.getMessage());
                        throw new RuntimeException(t);
                    }
                }
            };
            try {
                parentDB.getRunnableDispatcher().runInForeground(runner);
            }
            catch (SessionNotFoundException e) {
                runner.run();
            }
        }
        catch (SQLException e) {
            throw new SQLObjectException("Failed to populate columns of tables", e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Couldn't close connection. Squishing this exception: ", (Throwable)ex);
                }
            }
        }
    }

    static void populateColumnsWithList(SQLTable table, List<SQLColumn> allChildren) {
        if (!table.isForegroundThread()) {
            throw new IllegalStateException("This method must be called on the foreground thread.");
        }
        boolean populateStart = table.columnsPopulated;
        try {
            int index = table.columns.size();
            for (SQLColumn col : allChildren) {
                table.columns.add(col);
                col.setParent(table);
            }
            table.columnsPopulated = true;
            table.begin("Populating all columns");
            for (SQLColumn col : allChildren) {
                table.fireChildAdded(SQLColumn.class, col, index);
                ++index;
            }
            table.firePropertyChange("columnsPopulated", populateStart, true);
            table.commit();
        }
        catch (Throwable t) {
            table.rollback(t.getMessage());
            for (SQLColumn col : allChildren) {
                table.columns.remove(col);
            }
            table.columnsPopulated = populateStart;
            throw new RuntimeException(t);
        }
    }

    protected synchronized void populateIndices() throws SQLObjectException {
        if (this.indicesPopulated) {
            return;
        }
        if (this.indices.size() > 0) {
            throw new IllegalStateException("Can't populate indices because it already contains children!");
        }
        if (this.objectType.equals("VIEW")) {
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    SQLTable.this.setIndicesPopulated(true);
                }
            });
            return;
        }
        logger.debug((Object)"index folder populate starting");
        Connection con = null;
        try {
            con = this.getParentDatabase().getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            logger.debug((Object)"before addIndicesToTable");
            final List<SQLIndex> indexes = SQLIndex.fetchIndicesForTableAndUpdatePK(dbmd, this);
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    if (SQLTable.this.indicesPopulated) {
                        return;
                    }
                    SQLTable.populateIndicesWithList(SQLTable.this, indexes);
                }
            });
            logger.debug((Object)("found " + this.indices.size() + " indices."));
        }
        catch (SQLException e) {
            throw new SQLObjectException("Failed to populate indices of table " + this.getName(), e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Closing connection failed. Squishing this exception: ", (Throwable)e);
            }
        }
        logger.debug((Object)"index folder populate finished");
    }

    static void populateIndicesWithList(SQLTable table, List<SQLIndex> indices) {
        if (!table.isForegroundThread()) {
            throw new IllegalStateException("This method must be called on the foreground thread.");
        }
        if (!table.columnsPopulated) {
            throw new IllegalStateException("Columns must be populated");
        }
        boolean startPopulated = table.indicesPopulated;
        try {
            for (SQLIndex i : indices) {
                table.indices.add(i);
                i.setParent(table);
            }
            table.indicesPopulated = true;
            table.begin("Populating Indices for Table " + table);
            for (SQLIndex i : indices) {
                table.fireChildAdded(SQLIndex.class, i, table.indices.indexOf(i) + 1);
            }
            table.firePropertyChange("indicesPopulated", startPopulated, true);
            table.commit();
        }
        catch (Throwable t) {
            table.rollback(t.getMessage());
            for (SQLIndex i : indices) {
                table.indices.remove(i);
            }
            table.indicesPopulated = startPopulated;
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateImportedKeys() throws SQLObjectException {
        if (this.importedKeysPopulated) {
            return;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                CachedRowSet crs = null;
                Connection con = null;
                try {
                    con = this.getParentDatabase().getConnection();
                    DatabaseMetaData dbmd = con.getMetaData();
                    crs = new CachedRowSet();
                    ResultSet exportedKeysRS = dbmd.getImportedKeys(this.getCatalogName(), this.getSchemaName(), this.getName());
                    crs.populate(exportedKeysRS);
                    exportedKeysRS.close();
                }
                catch (SQLException ex) {
                    throw new SQLObjectException("Couldn't locate related tables", ex);
                }
                finally {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.warn((Object)"Couldn't close connection", (Throwable)ex);
                    }
                }
                try {
                    while (crs.next()) {
                        if (crs.getInt(9) != 1) {
                            logger.debug((Object)("Got exported key with sequence " + crs.getInt(9) + " on " + crs.getString(5) + "." + crs.getString(6) + "." + crs.getString(7) + ", continuing."));
                            continue;
                        }
                        logger.debug((Object)("Got exported key with sequence " + crs.getInt(9) + " on " + crs.getString(5) + "." + crs.getString(6) + "." + crs.getString(7) + ", populating."));
                        String cat = crs.getString(1);
                        String sch = crs.getString(2);
                        String tab = crs.getString(3);
                        SQLTable pkTable = this.getParentDatabase().getTableByName(cat, sch, tab);
                        if (pkTable == null) {
                            throw new IllegalStateException("While populating table " + SQLObjectUtils.toQualifiedName(this.getParent()) + ", I failed to find child table " + "\"" + cat + "\".\"" + sch + "\".\"" + tab + "\"");
                        }
                        pkTable.populateColumns();
                        pkTable.populateIndices();
                        pkTable.populateRelationships(this);
                    }
                    this.setImportedKeysPopulated(true);
                }
                catch (SQLException ex) {
                    throw new SQLObjectException("Couldn't locate related tables", ex);
                }
                finally {
                    try {
                        if (crs != null) {
                            crs.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.warn((Object)"Couldn't close resultset", (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateExportedKeys() throws SQLObjectException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                this.populateColumns();
                this.populateIndices();
                this.populateRelationships();
            }
        }
    }

    protected synchronized void populateRelationships(SQLTable fkTable) throws SQLObjectException {
        if (this.exportedKeysPopulated) {
            return;
        }
        logger.debug((Object)"SQLTable: relationship populate starting");
        final List<SQLRelationship> newKeys = SQLRelationship.fetchExportedKeys(this, fkTable);
        this.runInForeground(new Runnable(){

            @Override
            public void run() {
                if (SQLTable.this.exportedKeysPopulated) {
                    return;
                }
                SQLTable.populateRelationshipsWithList(SQLTable.this, newKeys);
            }
        });
        logger.debug((Object)"SQLTable: relationship populate finished");
    }

    protected synchronized void populateRelationships() throws SQLObjectException {
        if (this.exportedKeysPopulated) {
            return;
        }
        logger.debug((Object)"SQLTable: relationship populate starting");
        final List<SQLRelationship> newKeys = SQLRelationship.fetchExportedKeys(this, null);
        this.runInForeground(new Runnable(){

            @Override
            public void run() {
                if (SQLTable.this.exportedKeysPopulated) {
                    return;
                }
                SQLTable.populateRelationshipsWithList(SQLTable.this, newKeys);
            }
        });
        logger.debug((Object)"SQLTable: relationship populate finished");
    }

    static void populateRelationshipsWithList(SQLTable table, List<SQLRelationship> allChildren) {
        if (!table.isForegroundThread()) {
            throw new IllegalStateException("This method must be called on the foreground thread.");
        }
        if (!table.columnsPopulated) {
            throw new IllegalStateException("Table must be populated before relationships are added");
        }
        if (!table.indicesPopulated) {
            throw new IllegalStateException("Table indices must be populated before relationships are added");
        }
        boolean startPopulated = table.exportedKeysPopulated;
        ArrayList<SQLRelationship> relsAdded = new ArrayList<SQLRelationship>();
        try {
            for (SQLRelationship addMe : allChildren) {
                addMe.getParent().exportedKeys.add(addMe);
                if (!addMe.getPkTable().isMagicEnabled() || addMe.getFkTable().getImportedKeysWithoutPopulating().contains(addMe.getForeignKey())) continue;
                addMe.getFkTable().importedKeys.add(addMe.getForeignKey());
                relsAdded.add(addMe);
            }
            table.exportedKeysPopulated = true;
            table.begin("Populating relationships for Table " + table);
            for (SQLRelationship addMe : relsAdded) {
                SQLTable pkTable = addMe.getParent();
                if (pkTable.isMagicEnabled()) {
                    SQLTable fkTable = addMe.getFkTable();
                    SQLRelationship.SQLImportedKey foreignKey = addMe.getForeignKey();
                    addMe.attachRelationship(pkTable, fkTable, false, false);
                    fkTable.fireChildAdded(SQLRelationship.SQLImportedKey.class, foreignKey, fkTable.importedKeys.indexOf(foreignKey));
                }
                pkTable.fireChildAdded(SQLRelationship.class, addMe, pkTable.exportedKeys.indexOf(addMe));
            }
            table.firePropertyChange("exportedKeysPopulated", startPopulated, true);
            table.commit();
        }
        catch (SQLObjectException e) {
            table.rollback(e.getMessage());
            for (SQLRelationship rel : relsAdded) {
                rel.getParent().exportedKeys.remove(rel);
                if (!table.isMagicEnabled()) continue;
                rel.getFkTable().importedKeys.remove(rel.getForeignKey());
            }
            table.exportedKeysPopulated = startPopulated;
            throw new SQLObjectRuntimeException(e);
        }
        catch (Throwable t) {
            table.rollback(t.getMessage());
            for (SQLRelationship rel : relsAdded) {
                rel.getParent().exportedKeys.remove(rel);
                rel.getFkTable().importedKeys.remove(rel.getForeignKey());
            }
            table.exportedKeysPopulated = startPopulated;
            throw new RuntimeException(t);
        }
    }

    public void addImportedKey(SQLRelationship.SQLImportedKey r) {
        this.addImportedKey(r, this.importedKeys.size());
    }

    public void addImportedKey(SQLRelationship.SQLImportedKey k, int index) {
        this.importedKeys.add(index, k);
        k.setParent(this);
        this.fireChildAdded(SQLRelationship.SQLImportedKey.class, k, index);
    }

    public boolean removeImportedKey(SQLRelationship.SQLImportedKey k) {
        if (this.isMagicEnabled() && k.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + k.getName() + " of type " + k.getClass() + " as its parent is not " + this.getName());
        }
        k.getRelationship().disconnectRelationship(false);
        int index = this.importedKeys.indexOf(k);
        if (index != -1) {
            this.importedKeys.remove(index);
            this.fireChildRemoved(SQLRelationship.SQLImportedKey.class, k, index);
            return true;
        }
        return false;
    }

    public void addExportedKey(SQLRelationship r) {
        this.addExportedKey(r, this.exportedKeys.size());
    }

    public void addExportedKey(SQLRelationship r, int index) {
        this.exportedKeys.add(index, r);
        r.setParent(this);
        this.fireChildAdded(SQLRelationship.class, r, index);
    }

    public boolean removeExportedKey(SQLRelationship r) {
        if (this.isMagicEnabled() && r.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + r.getName() + " of type " + r.getClass() + " as its parent is not " + this.getName());
        }
        r.disconnectRelationship(true);
        int index = this.exportedKeys.indexOf(r);
        if (index != -1) {
            this.exportedKeys.remove(index);
            this.fireChildRemoved(SQLRelationship.class, r, index);
            return true;
        }
        return false;
    }

    @Transient
    @Accessor
    public int getPkSize() {
        return this.primaryKeyIndex.getChildrenWithoutPopulating().size();
    }

    public void inherit(SQLTable source, TransferStyles transferStyle, boolean preserveColumnSource) throws SQLObjectException {
        this.inherit(this.columns.size(), source, transferStyle, preserveColumnSource);
    }

    public List<SQLColumn> inherit(int pos, SQLTable source, TransferStyles transferStyle, boolean preserveColumnSource) throws SQLObjectException {
        if (source == this) {
            throw new SQLObjectException("Cannot inherit from self");
        }
        int pkSize = this.getPkSize();
        source.populateColumns();
        source.populateIndices();
        boolean addToPK = pos < pkSize;
        ArrayList<SQLColumn> addedColumns = new ArrayList<SQLColumn>();
        this.begin("Inherting columns from source table");
        for (SQLColumn child : source.getColumns()) {
            addedColumns.add(this.inherit(pos, child, addToPK, transferStyle, preserveColumnSource));
            ++pos;
        }
        this.commit();
        return addedColumns;
    }

    public SQLColumn inherit(int pos, SQLColumn sourceCol, boolean addToPK, TransferStyles transferStyle, boolean preserveColumnSource) throws SQLObjectException {
        SQLColumn c;
        if (addToPK && pos > 0 && !this.getColumn(pos - 1).isPrimaryKey()) {
            throw new IllegalArgumentException("Can't inherit new PK column below a non-PK column! Insert pos=" + pos + "; addToPk=" + addToPK);
        }
        switch (transferStyle) {
            case REVERSE_ENGINEER: {
                c = sourceCol.createInheritingInstance(this);
                break;
            }
            case COPY: {
                c = sourceCol.createCopy(this, preserveColumnSource);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown transfer type of " + (Object)((Object)transferStyle));
            }
        }
        this.addColumn(c, addToPK, pos);
        return c;
    }

    @NonProperty
    public SQLColumn getColumn(int index) throws SQLObjectException {
        this.populateColumns();
        return this.columns.get(index);
    }

    @NonProperty
    public SQLColumn getColumnByName(String colName) throws SQLObjectException {
        return this.getColumnByName(colName, true, false);
    }

    @NonProperty
    public SQLColumn getColumnByName(String colName, boolean populate, boolean caseSensitive) throws SQLObjectException {
        if (populate) {
            this.populateColumns();
        }
        if (logger.isDebugEnabled()) {
            // empty if block
        }
        for (SQLColumn col : this.columns) {
            if (caseSensitive) {
                if (!col.getName().equals(colName)) continue;
                logger.debug((Object)"FOUND");
                return col;
            }
            if (!col.getName().equalsIgnoreCase(colName)) continue;
            logger.debug((Object)"FOUND");
            return col;
        }
        logger.debug((Object)"NOT FOUND");
        return null;
    }

    @NonProperty
    public int getColumnIndex(SQLColumn col) throws SQLObjectException {
        List<SQLColumn> columns = this.getColumns();
        int index = columns.indexOf(col);
        if (index == -1) {
            // empty if block
        }
        return index;
    }

    public void addColumn(SQLColumn col) throws SQLObjectException {
        this.addColumn(col, this.columns.size());
    }

    public void addColumn(SQLColumn col, int pos) throws SQLObjectException {
        boolean addToPk = this.getPkSize() > pos;
        this.addColumnWithoutPopulating(col, addToPk, pos);
    }

    public void addColumn(SQLColumn col, boolean addToPk, int pos) throws SQLObjectException {
        this.populateColumns();
        this.addColumnWithoutPopulating(col, addToPk, pos);
    }

    public void addColumnWithoutPopulating(SQLColumn col) {
        this.addColumnWithoutPopulating(col, this.columns.size());
    }

    public void addColumnWithoutPopulating(SQLColumn col, int pos) {
        boolean addToPk = this.getPkSize() > pos;
        this.addColumnWithoutPopulating(col, addToPk, pos);
    }

    public void addColumnWithoutPopulating(SQLColumn col, boolean addToPk, int pos) {
        int pkSize = this.getPkSize();
        if (pos < pkSize && !addToPk || pos > pkSize && addToPk) {
            throw new IllegalArgumentException("The column " + col + " is being " + (addToPk ? "" : "not") + " added to " + "the primary key at position " + pos + " but there are " + pkSize + " pk column(s) so the add position is invalid.");
        }
        if (this.columns.indexOf(col) != -1) {
            col.addReference();
            return;
        }
        this.columns.add(pos, col);
        col.setParent(this);
        this.fireChildAdded(SQLColumn.class, col, pos);
        if (this.isMagicEnabled() && addToPk) {
            this.primaryKeyIndex.addIndexColumn(col);
        }
    }

    public void addIndex(SQLIndex sqlIndex) {
        this.addIndex(sqlIndex, this.indices.size() + 1);
    }

    public void addIndex(SQLIndex sqlIndex, int index) {
        if (sqlIndex == this.primaryKeyIndex) {
            return;
        }
        this.indices.add(index - 1, sqlIndex);
        sqlIndex.setParent(this);
        this.fireChildAdded(SQLIndex.class, sqlIndex, index);
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof SQLColumn) {
            this.addColumnWithoutPopulating((SQLColumn)child, index);
        } else if (child instanceof SQLRelationship) {
            this.addExportedKey((SQLRelationship)child);
        } else if (child instanceof SQLRelationship.SQLImportedKey) {
            this.addImportedKey((SQLRelationship.SQLImportedKey)child);
        } else if (child instanceof SQLIndex) {
            this.addIndex((SQLIndex)child, index);
        } else {
            throw new IllegalArgumentException("The child " + child.getName() + " of type " + child.getClass() + " is not a valid child type of " + this.getClass() + ".");
        }
    }

    public boolean removeColumn(int index) throws SQLObjectException {
        try {
            return this.removeChild(this.columns.get(index));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (ObjectDependentException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeColumn(SQLColumn col) {
        if (this.isMagicEnabled() && col.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + col.getName() + " of type " + col.getClass() + " as its parent is not " + this.getName());
        }
        if (this.isMagicEnabled()) {
            this.primaryKeyIndex.removeColumn(col);
        }
        try {
            this.begin("Removing column " + col.getName());
            int index = this.columns.indexOf(col);
            if (index != -1) {
                this.columns.remove(index);
                this.fireChildRemoved(SQLColumn.class, col, index);
                col.setParent(null);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.commit();
        }
        return false;
    }

    public void changeColumnIndex(int oldIdx, int newIdx, boolean putInPK) throws SQLObjectException {
        SQLColumn col = this.columns.get(oldIdx);
        int pkSize = this.getPkSize();
        if (newIdx < pkSize && !putInPK && !col.isPrimaryKey() || newIdx < pkSize - 1 && !putInPK && col.isPrimaryKey()) {
            putInPK = true;
        } else if (newIdx > pkSize && putInPK && !col.isPrimaryKey() || newIdx > pkSize - 1 && putInPK && col.isPrimaryKey()) {
            putInPK = false;
        }
        try {
            this.begin("Changing column index");
            if (oldIdx != newIdx) {
                this.removeColumn(col);
                this.addColumn(col, putInPK, newIdx);
            } else if (putInPK && !col.isPrimaryKey()) {
                this.primaryKeyIndex.addIndexColumn(col);
            } else if (!putInPK && col.isPrimaryKey()) {
                this.primaryKeyIndex.removeColumn(col);
            }
            this.commit();
        }
        catch (SQLObjectException e) {
            this.rollback(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.rollback(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public List<SQLRelationship> keysOfColumn(SQLColumn col) throws SQLObjectException {
        LinkedList<SQLRelationship> keys = new LinkedList<SQLRelationship>();
        for (SQLRelationship r : this.exportedKeys) {
            if (!r.containsPkColumn(col)) continue;
            keys.add(r);
        }
        for (SQLRelationship r : this.exportedKeys) {
            if (!r.containsFkColumn(col)) continue;
            keys.add(r);
        }
        return keys;
    }

    @Override
    public String toString() {
        return this.getShortDisplayName();
    }

    @Override
    @Transient
    @Accessor
    public String getShortDisplayName() {
        SQLSchema schema = this.getSchema();
        if (schema != null) {
            return schema.getName() + "." + this.getName() + " (" + this.objectType + ")";
        }
        if (this.objectType != null) {
            return this.getName() + " (" + this.objectType + ")";
        }
        return this.getName();
    }

    @Override
    protected void populateImpl() throws SQLObjectException {
        if (this.populated) {
            return;
        }
        try {
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    SQLTable.this.begin("Populating");
                }
            });
            this.populateColumns();
            this.populateIndices();
            this.populateRelationships();
            if (this.columnsPopulated && this.indicesPopulated && this.exportedKeysPopulated) {
                this.populated = true;
            }
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    SQLTable.this.commit();
                }
            });
        }
        catch (SQLObjectException e) {
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    SQLTable.this.rollback(e.getMessage());
                    logger.error((Object)"Sketchy transaction rollback");
                }
            });
            throw e;
        }
        catch (RuntimeException e) {
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    SQLTable.this.rollback(e.getMessage());
                }
            });
            throw e;
        }
    }

    @Override
    @Accessor
    public boolean isPopulated() {
        if (!this.populated && this.isColumnsPopulated() && this.isImportedKeysPopulated() && this.isExportedKeysPopulated() && this.isIndicesPopulated()) {
            this.populated = true;
        }
        return this.populated;
    }

    @NonBound
    public Class<? extends SQLObject> getChildType() {
        return SQLObject.class;
    }

    @Transient
    @Accessor
    public SQLDatabase getParentDatabase() {
        return SQLPowerUtils.getAncestor(this, SQLDatabase.class);
    }

    @Override
    @Accessor
    public SQLObject getParent() {
        return (SQLObject)super.getParent();
    }

    @Mutator
    public void setParent(SQLObject parent) {
        super.setParent(parent);
    }

    @Transient
    @Accessor
    public String getCatalogName() {
        SQLCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return "";
        }
        return catalog.getName();
    }

    @Transient
    @Accessor
    public SQLCatalog getCatalog() {
        return SQLPowerUtils.getAncestor(this, SQLCatalog.class);
    }

    @Transient
    @Accessor
    public String getSchemaName() {
        SQLSchema schema = this.getSchema();
        if (schema == null) {
            return "";
        }
        return schema.getName();
    }

    @Transient
    @Accessor
    public SQLSchema getSchema() {
        return SQLPowerUtils.getAncestor(this, SQLSchema.class);
    }

    @Override
    @Mutator
    public void setPhysicalName(String argName) {
        logger.debug((Object)("About to change table name from \"" + this.getPhysicalName() + "\" to \"" + argName + "\""));
        if (!this.isMagicEnabled() || this.indices == null || this.columns == null) {
            super.setPhysicalName(argName);
        } else {
            try {
                String oldName = this.getPhysicalName() != null ? this.getPhysicalName() : this.getName();
                this.begin("Table Name Change");
                super.setPhysicalName(argName);
                this.updatePKIndexNameToMatch(oldName, argName);
                if (this.isColumnsPopulated()) {
                    for (SQLColumn col : this.getColumns()) {
                        String testingName;
                        if (!col.isAutoIncrementSequenceNameSet() || !(testingName = col.discoverSequenceNameFormat(oldName, col.getPhysicalName())).equals(col.getAutoIncrementSequenceName())) continue;
                        col.setAutoIncrementSequenceName(col.makeAutoIncrementSequenceName());
                    }
                }
            }
            catch (SQLObjectException e) {
                throw new SQLObjectRuntimeException(e);
            }
            finally {
                this.commit();
            }
        }
    }

    @Override
    @Mutator
    public void setName(String name) {
        try {
            this.begin("Setting name and possibly physical or primary key name.");
            if (this.isMagicEnabled()) {
                this.updatePhysicalNameToMatch(this.getName(), name);
            }
            super.setName(name);
            this.commit();
        }
        catch (Throwable t) {
            this.rollback(t.getMessage());
            throw new RuntimeException(t);
        }
    }

    private void updatePKIndexNameToMatch(String oldName, String newName) {
        if (newName != null && this.primaryKeyIndex != null && (this.primaryKeyIndex.getName() == null || "".equals(this.primaryKeyIndex.getName().trim()) || (oldName + "_pk").equals(this.primaryKeyIndex.getName()))) {
            this.primaryKeyIndex.setName(newName + "_pk");
        }
    }

    @Accessor(isInteresting=true)
    public String getRemarks() {
        return this.remarks;
    }

    @Mutator
    public void setRemarks(String argRemarks) {
        String oldRemarks = this.remarks;
        this.remarks = argRemarks;
        this.firePropertyChange("remarks", oldRemarks, argRemarks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonProperty
    public List<SQLColumn> getColumns() throws SQLObjectException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                this.populateColumns();
                return this.getColumnsWithoutPopulating();
            }
        }
    }

    @NonProperty
    public synchronized List<SQLColumn> getColumnsWithoutPopulating() {
        return Collections.unmodifiableList(this.columns);
    }

    @NonProperty
    public List<SQLRelationship.SQLImportedKey> getImportedKeys() throws SQLObjectException {
        this.populateImportedKeys();
        return this.getImportedKeysWithoutPopulating();
    }

    @NonProperty
    public List<SQLRelationship.SQLImportedKey> getImportedKeysWithoutPopulating() {
        return Collections.unmodifiableList(this.importedKeys);
    }

    @NonProperty
    public List<SQLRelationship> getExportedKeys() throws SQLObjectException {
        this.populateExportedKeys();
        return this.getExportedKeysWithoutPopulating();
    }

    @NonProperty
    public List<SQLRelationship> getExportedKeysWithoutPopulating() {
        return Collections.unmodifiableList(this.exportedKeys);
    }

    @NonProperty
    public SQLRelationship getExportedKeyByName(String name) throws SQLObjectException {
        return this.getExportedKeyByName(name, true);
    }

    @NonProperty
    public SQLRelationship getExportedKeyByName(String name, boolean populate) throws SQLObjectException {
        if (populate) {
            this.populateRelationships();
        }
        logger.debug((Object)("Looking for Exported Key [" + name + "] in " + this.exportedKeys));
        for (SQLRelationship r : this.exportedKeys) {
            if (!r.getName().equalsIgnoreCase(name)) continue;
            logger.debug((Object)"FOUND");
            return r;
        }
        logger.debug((Object)"NOT FOUND");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonProperty
    public List<SQLIndex> getUniqueIndices() throws SQLObjectException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                this.populateColumns();
                this.populateIndices();
                ArrayList<SQLIndex> list = new ArrayList<SQLIndex>();
                list.add(this.primaryKeyIndex);
                for (SQLIndex index : this.indices) {
                    if (!index.isUnique()) continue;
                    list.add(index);
                }
                return list;
            }
        }
    }

    @NonProperty
    public SQLIndex getIndexByName(String name) throws SQLObjectException {
        return this.getIndexByName(name, true);
    }

    @NonProperty
    public SQLIndex getIndexByName(String name, boolean populate) throws SQLObjectException {
        if (populate) {
            this.populateColumns();
            this.populateIndices();
        }
        logger.debug((Object)("Looking for Index [" + name + "] in " + this.indices));
        if (this.primaryKeyIndex.getName().equalsIgnoreCase(name)) {
            logger.debug((Object)"Found primary key");
            return this.primaryKeyIndex;
        }
        for (SQLIndex index : this.indices) {
            if (!index.getName().equalsIgnoreCase(name)) continue;
            logger.debug((Object)"FOUND");
            return index;
        }
        logger.debug((Object)"NOT FOUND");
        return null;
    }

    @Accessor
    public boolean isColumnsPopulated() {
        return this.columnsPopulated;
    }

    @Transient
    @Accessor
    public boolean isRelationshipsPopulated() {
        return this.importedKeysPopulated && this.exportedKeysPopulated;
    }

    @Accessor
    public boolean isImportedKeysPopulated() {
        return this.importedKeysPopulated;
    }

    @Accessor
    public boolean isExportedKeysPopulated() {
        return this.exportedKeysPopulated;
    }

    @Accessor
    public boolean isIndicesPopulated() {
        return this.indicesPopulated;
    }

    @Mutator
    public void setColumnsPopulated(boolean columnsPopulated) {
        boolean oldPop = this.columnsPopulated;
        this.columnsPopulated = columnsPopulated;
        this.firePropertyChange("columnsPopulated", oldPop, columnsPopulated);
        if (!columnsPopulated) {
            this.setUnpopulatedIfPartiallyPopulated();
        }
    }

    @Mutator
    public void setImportedKeysPopulated(boolean importedKeysPopulated) {
        boolean oldPop = this.importedKeysPopulated;
        this.importedKeysPopulated = importedKeysPopulated;
        this.firePropertyChange("importedKeysPopulated", oldPop, importedKeysPopulated);
        if (!this.columnsPopulated) {
            this.setUnpopulatedIfPartiallyPopulated();
        }
    }

    @Mutator
    public void setExportedKeysPopulated(boolean exportedKeysPopulated) {
        boolean oldPop = this.exportedKeysPopulated;
        this.exportedKeysPopulated = exportedKeysPopulated;
        this.firePropertyChange("exportedKeysPopulated", oldPop, exportedKeysPopulated);
        if (!this.columnsPopulated) {
            this.setUnpopulatedIfPartiallyPopulated();
        }
    }

    @Mutator
    public void setIndicesPopulated(boolean indicesPopulated) {
        boolean oldPop = this.indicesPopulated;
        this.indicesPopulated = indicesPopulated;
        this.firePropertyChange("indicesPopulated", oldPop, indicesPopulated);
        if (!this.columnsPopulated) {
            this.setUnpopulatedIfPartiallyPopulated();
        }
    }

    private void setUnpopulatedIfPartiallyPopulated() {
        if (this.populated) {
            this.populated = false;
            this.firePropertyChange("populated", true, false);
        }
    }

    @Accessor
    public String getObjectType() {
        return this.objectType;
    }

    @Mutator
    public void setObjectType(String argObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = argObjectType;
        if (this.objectType == null) {
            throw new NullPointerException();
        }
        this.firePropertyChange("objectType", oldObjectType, argObjectType);
    }

    @Transient
    @Accessor
    public SQLIndex getPrimaryKeyIndex() {
        return this.primaryKeyIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<SQLTable> fetchTablesForTableContainer(DatabaseMetaData dbmd, String catalogName, String schemaName) throws SQLObjectException, SQLException {
        ResultSet rs = null;
        try {
            rs = dbmd.getTables(catalogName, schemaName, "%", new String[]{"TABLE", "VIEW"});
            ArrayList<SQLTable> tables = new ArrayList<SQLTable>();
            while (rs.next()) {
                tables.add(new SQLTable(null, rs.getString(3), rs.getString(5), rs.getString(4), false));
            }
            ArrayList<SQLTable> arrayList = tables;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    @NonProperty
    public List<SQLIndex> getIndices() throws SQLObjectException {
        this.populateColumns();
        this.populateIndices();
        ArrayList<SQLIndex> allIndices = new ArrayList<SQLIndex>();
        allIndices.add(this.primaryKeyIndex);
        allIndices.addAll(this.indices);
        return Collections.unmodifiableList(allIndices);
    }

    public String toQualifiedName() {
        return SQLObjectUtils.toQualifiedName(this, SQLDatabase.class);
    }

    public String toQualifiedName(String quote) {
        return SQLObjectUtils.toQualifiedName(this, SQLDatabase.class, quote);
    }

    @Override
    void refresh() throws SQLObjectException {
        throw new UnsupportedOperationException("Individual tables can't be refreshed.");
    }

    public boolean removeIndex(SQLIndex sqlIndex) {
        if (this.isMagicEnabled() && sqlIndex.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + sqlIndex.getName() + " of type " + sqlIndex.getClass() + " as its parent is not " + this.getName());
        }
        int index = this.indices.indexOf(sqlIndex);
        if (index != -1) {
            try {
                this.begin("Removing index " + sqlIndex.getName());
                this.indices.remove(index);
                this.fireChildRemoved(SQLIndex.class, sqlIndex, index + 1);
                sqlIndex.setParent(null);
                this.commit();
                return true;
            }
            catch (Throwable t) {
                this.rollback("Failed to remove the index.");
                throw new RuntimeException(t);
            }
        }
        return false;
    }

    @Override
    public <T extends SPObject> List<T> getChildren(Class<T> type) {
        if (!this.isMagicEnabled()) {
            return this.getChildrenWithoutPopulating(type);
        }
        try {
            if (type != SQLRelationship.SQLImportedKey.class) {
                if (type == SQLColumn.class) {
                    this.populateColumns();
                } else if (type == SQLIndex.class) {
                    this.populateColumns();
                    this.populateIndices();
                } else {
                    this.populate();
                }
            }
            return this.getChildrenWithoutPopulating(type);
        }
        catch (SQLObjectException e) {
            throw new RuntimeException("Could not populate " + this.getName(), e);
        }
    }

    @Override
    public List<? extends SQLObject> getChildrenWithoutPopulating() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.addAll(this.columns);
        children.addAll(this.exportedKeys);
        children.addAll(this.importedKeys);
        children.add(this.primaryKeyIndex);
        children.addAll(this.indices);
        return Collections.unmodifiableList(children);
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof SQLColumn) {
            if (this.isMagicEnabled()) {
                SQLColumn col = (SQLColumn)child;
                for (SQLRelationship.SQLImportedKey k : this.importedKeys) {
                    k.getRelationship().checkColumnLocked(col);
                }
            }
            return this.removeColumn((SQLColumn)child);
        }
        if (child instanceof SQLRelationship) {
            return this.removeExportedKey((SQLRelationship)child);
        }
        if (child instanceof SQLRelationship.SQLImportedKey) {
            return this.removeImportedKey((SQLRelationship.SQLImportedKey)child);
        }
        if (child instanceof SQLIndex) {
            return this.removeIndex((SQLIndex)child);
        }
        return false;
    }

    @Override
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
        for (SQLObject sQLObject : this.getChildrenWithoutPopulating()) {
            sQLObject.removeDependency(dependency);
        }
    }

    @Override
    @Mutator
    public void setPopulated(boolean v) {
        boolean oldPop = this.populated;
        this.populated = v;
        this.columnsPopulated = v;
        this.importedKeysPopulated = v;
        this.exportedKeysPopulated = v;
        this.indicesPopulated = v;
        this.firePropertyChange("populated", oldPop, v);
    }

    void refreshExportedKeys() throws SQLObjectException {
        if (!this.exportedKeysPopulated) {
            logger.debug((Object)("Not refreshing unpopulated exported keys of " + this));
            return;
        }
        final List<SQLRelationship> newRels = SQLRelationship.fetchExportedKeys(this, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("New imported keys of " + this.getName() + ": " + newRels));
        }
        this.runInForeground(new Runnable(){

            @Override
            public void run() {
                try {
                    SQLObjectUtils.refreshChildren(SQLTable.this, newRels, SQLRelationship.class);
                }
                catch (SQLObjectException e) {
                    throw new SQLObjectRuntimeException(e);
                }
            }
        });
    }

    void refreshIndexes() throws SQLObjectException {
        if (!this.isIndicesPopulated()) {
            return;
        }
        Connection con = null;
        try {
            con = this.getParentDatabase().getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            final List<SQLIndex> newIndexes = SQLIndex.fetchIndicesForTableAndUpdatePK(dbmd, this);
            newIndexes.add(0, this.getPrimaryKeyIndex());
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLObjectUtils.refreshChildren(SQLTable.this, newIndexes, SQLIndex.class);
                    }
                    catch (SQLObjectException e) {
                        throw new SQLObjectRuntimeException(e);
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new SQLObjectException("Refresh failed", e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Failed to close connection. Squishing this exception: ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    void removeNotify() {
        int i;
        for (i = this.exportedKeys.size() - 1; i >= 0; --i) {
            this.exportedKeys.get(i).tableDisconnected();
        }
        for (i = this.importedKeys.size() - 1; i >= 0; --i) {
            this.importedKeys.get(i).getRelationship().tableDisconnected();
        }
    }

    public void moveAfterPK(SQLColumn col) throws SQLObjectException {
        int targetIndex = col.isPrimaryKey() ? this.getPkSize() - 1 : this.getPkSize();
        int currentIndex = this.columns.indexOf(col);
        this.changeColumnIndex(currentIndex, targetIndex, false);
    }

    public void addToPK(SQLColumn col) throws SQLObjectException {
        if (!col.isPrimaryKey()) {
            this.moveAfterPK(col);
            this.primaryKeyIndex.addIndexColumn(col);
        }
    }

    void updateRelationshipsForNewIndexColumn(SQLColumn col) {
        if (this.isMagicEnabled()) {
            for (SQLRelationship r : this.exportedKeys) {
                r.fixMappingNewChildInParent(col);
            }
        }
    }

    void updateRelationshipsForRemovedIndexColumns(SQLColumn col) {
        if (this.isMagicEnabled()) {
            for (SQLRelationship r : this.exportedKeys) {
                r.fixMappingChildRemoved(col);
            }
        }
    }

    boolean isPrimaryKey(SQLIndex index) {
        return index == this.primaryKeyIndex;
    }

    boolean isInPrimaryKey(SQLColumn col) {
        return this.primaryKeyIndex.containsColumn(col);
    }

    SQLIndex getPrimaryKeyIndexWithoutPopulating() {
        return this.primaryKeyIndex;
    }

    public static enum TransferStyles {
        REVERSE_ENGINEER,
        COPY;

    }
}

