/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactId;
import fr.jayasoft.ivy.Configuration;
import fr.jayasoft.ivy.ConflictManager;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.DependencyArtifactDescriptor;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.DependencyResolver;
import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.MDArtifact;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.event.resolve.EndResolveDependencyEvent;
import fr.jayasoft.ivy.event.resolve.StartResolveDependencyEvent;
import fr.jayasoft.ivy.filter.Filter;
import fr.jayasoft.ivy.filter.FilterHelper;
import fr.jayasoft.ivy.matcher.MatcherHelper;
import fr.jayasoft.ivy.util.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IvyNode {
    private static final Pattern FALLBACK_CONF_PATTERN = Pattern.compile("(.+)\\((.*)\\)");
    private ModuleRevisionId _id;
    private IvyNode _parent = null;
    private IvyNode _root = null;
    private Collection _path = null;
    private String _parentConf = null;
    private String _rootModuleConf;
    private Map _selectedDeps = new HashMap();
    private Map _evictedDeps = new HashMap();
    private Map _evictedRevs = new HashMap();
    private Map _evicted = new HashMap();
    private Map _callersByRootConf = new HashMap();
    private Map _rootModuleConfs = new HashMap();
    private Map _dependencyArtifactsIncludes = new HashMap();
    private ResolveData _data;
    private Collection _confsToFetch = new HashSet();
    private Collection _fetchedConfigurations = new HashSet();
    private Map _dds = new HashMap();
    private ModuleDescriptor _md;
    private ResolvedModuleRevision _module;
    private Exception _problem = null;
    private boolean _downloaded = false;
    private boolean _searched = false;
    private Map _requiredConfs = new HashMap();
    private boolean _isRoot = false;
    private Map _allCallers = new HashMap();
    private boolean _isCircular = false;
    private Collection _loadedRootModuleConfs = new HashSet();
    private Map _requestedConf = new HashMap();

    public IvyNode(ResolveData data, IvyNode parent, DependencyDescriptor dd) {
        this._id = dd.getDependencyRevisionId();
        this._dds.put(parent, dd);
        this._isRoot = false;
        this.init(data, true);
    }

    public IvyNode(ResolveData data, ModuleDescriptor md) {
        this._id = md.getModuleRevisionId();
        this._md = md;
        this._isRoot = true;
        this._root = this;
        this.init(data, false);
    }

    private void init(ResolveData data, boolean register) {
        this._data = data;
        if (register) {
            this._data.register(this);
        }
    }

    public ConflictManager getConflictManager(ModuleId mid) {
        if (this._md == null) {
            throw new IllegalStateException("impossible to get conflict manager when data has not been loaded");
        }
        ConflictManager cm = this._md.getConflictManager(mid);
        return cm == null ? this._data.getIvy().getDefaultConflictManager() : cm;
    }

    public Collection getResolvedNodes(ModuleId mid, String rootModuleConf) {
        Collection resolved = (Collection)this._selectedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            Iterator iter = resolved.iterator();
            while (iter.hasNext()) {
                IvyNode node = (IvyNode)iter.next();
                ret.add(node.getRealNode());
            }
        }
        return ret;
    }

    public Collection getResolvedRevisions(ModuleId mid, String rootModuleConf) {
        Collection resolved = (Collection)this._selectedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        if (resolved == null) {
            return new HashSet();
        }
        HashSet<ModuleRevisionId> resolvedRevs = new HashSet<ModuleRevisionId>();
        Iterator iter = resolved.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            resolvedRevs.add(node.getId());
            resolvedRevs.add(node.getResolvedId());
        }
        return resolvedRevs;
    }

    public void setResolvedNodes(ModuleId moduleId, String rootModuleConf, Collection resolved) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this._selectedDeps.put(moduleIdConf, new HashSet(resolved));
    }

    public Collection getEvictedNodes(ModuleId mid, String rootModuleConf) {
        Collection resolved = (Collection)this._evictedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            Iterator iter = resolved.iterator();
            while (iter.hasNext()) {
                IvyNode node = (IvyNode)iter.next();
                ret.add(node.getRealNode());
            }
        }
        return ret;
    }

    public Collection getEvictedRevisions(ModuleId mid, String rootModuleConf) {
        Collection evicted = (Collection)this._evictedRevs.get(new ModuleIdConf(mid, rootModuleConf));
        if (evicted == null) {
            return new HashSet();
        }
        return new HashSet(evicted);
    }

    public void setEvictedNodes(ModuleId moduleId, String rootModuleConf, Collection evicted) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this._evictedDeps.put(moduleIdConf, new HashSet(evicted));
        HashSet<ModuleRevisionId> evictedRevs = new HashSet<ModuleRevisionId>();
        Iterator iter = evicted.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            evictedRevs.add(node.getId());
            evictedRevs.add(node.getResolvedId());
        }
        this._evictedRevs.put(moduleIdConf, evictedRevs);
    }

    public boolean isEvicted(String rootModuleConf) {
        this.cleanEvicted();
        return this.getRoot() != this && !this.getRoot().getResolvedRevisions(this.getId().getModuleId(), rootModuleConf).contains(this.getResolvedId());
    }

    public boolean isCompletelyEvicted() {
        this.cleanEvicted();
        if (this.getRoot() == this) {
            return false;
        }
        Iterator iter = this._rootModuleConfs.keySet().iterator();
        while (iter.hasNext()) {
            String conf = (String)iter.next();
            if (this.isEvicted(conf)) continue;
            return false;
        }
        return true;
    }

    private void cleanEvicted() {
        Iterator iter = this._evicted.keySet().iterator();
        while (iter.hasNext()) {
            String rootModuleConf = (String)iter.next();
            EvictionData ed = (EvictionData)this._evicted.get(rootModuleConf);
            Collection sel = ed.getSelected();
            if (sel == null) continue;
            Iterator iterator = sel.iterator();
            while (iterator.hasNext()) {
                IvyNode n = (IvyNode)iterator.next();
                if (!n.getRealNode().equals(this)) continue;
                iter.remove();
            }
        }
    }

    public void markEvicted(String rootModuleConf, IvyNode node, ConflictManager conflictManager, Collection resolved) {
        EvictionData evictionData = new EvictionData(rootModuleConf, node, conflictManager, resolved);
        this.markEvicted(evictionData);
    }

    public void markEvicted(EvictionData evictionData) {
        this._evicted.put(evictionData.getRootModuleConf(), evictionData);
        if (!this._rootModuleConfs.keySet().contains(evictionData.getRootModuleConf())) {
            this._rootModuleConfs.put(evictionData.getRootModuleConf(), null);
        }
        if (evictionData.getSelected() != null) {
            Iterator iter = evictionData.getSelected().iterator();
            while (iter.hasNext()) {
                IvyNode selected = (IvyNode)iter.next();
                selected.updateDataFrom(this, evictionData.getRootModuleConf());
            }
        }
    }

    private void updateDataFrom(IvyNode node, String rootModuleConf) {
        Map nodecallers = (Map)node._callersByRootConf.get(rootModuleConf);
        if (nodecallers != null) {
            HashMap<ModuleRevisionId, Caller> thiscallers = (HashMap<ModuleRevisionId, Caller>)this._callersByRootConf.get(rootModuleConf);
            if (thiscallers == null) {
                thiscallers = new HashMap<ModuleRevisionId, Caller>();
                this._callersByRootConf.put(rootModuleConf, thiscallers);
            }
            Iterator iter = nodecallers.values().iterator();
            while (iter.hasNext()) {
                Caller caller = (Caller)iter.next();
                if (thiscallers.containsKey(caller.getModuleRevisionId())) continue;
                thiscallers.put(caller.getModuleRevisionId(), caller);
            }
        }
        this.updateMapOfSet(node._requiredConfs, this._requiredConfs);
        this.updateMapOfSetForKey(node._rootModuleConfs, this._rootModuleConfs, rootModuleConf);
        this.updateMapOfSetForKey(node._dependencyArtifactsIncludes, this._dependencyArtifactsIncludes, rootModuleConf);
        this.updateConfsToFetch(node._fetchedConfigurations);
        this.updateConfsToFetch(node._confsToFetch);
    }

    private void updateMapOfSet(Map from, Map to) {
        Iterator iter = from.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            this.updateMapOfSetForKey(from, to, key);
        }
    }

    private void updateMapOfSetForKey(Map from, Map to, Object key) {
        Set set = (Set)from.get(key);
        if (set != null) {
            Set toupdate = (Set)to.get(key);
            if (toupdate != null) {
                toupdate.addAll(set);
            } else {
                to.put(key, new HashSet(set));
            }
        }
    }

    public EvictionData getEvictedData(String rootModuleConf) {
        this.cleanEvicted();
        return (EvictionData)this._evicted.get(rootModuleConf);
    }

    public String[] getEvictedConfs() {
        this.cleanEvicted();
        return this._evicted.keySet().toArray(new String[this._evicted.keySet().size()]);
    }

    public Collection getAllEvictingNodes() {
        HashSet allEvictingNodes = null;
        Iterator iter = this._evicted.values().iterator();
        while (iter.hasNext()) {
            EvictionData ed = (EvictionData)iter.next();
            Collection selected = ed.getSelected();
            if (selected == null) continue;
            if (allEvictingNodes == null) {
                allEvictingNodes = new HashSet();
            }
            allEvictingNodes.addAll(selected);
        }
        return allEvictingNodes;
    }

    public Collection getAllEvictingConflictManagers() {
        HashSet<ConflictManager> ret = new HashSet<ConflictManager>();
        Iterator iter = this._evicted.values().iterator();
        while (iter.hasNext()) {
            EvictionData ed = (EvictionData)iter.next();
            ret.add(ed.getConflictManager());
        }
        return ret;
    }

    public IvyNode getParent() {
        return this._parent;
    }

    public void setParent(IvyNode parent) {
        this._parent = parent;
        this._root = null;
        this._path = null;
    }

    public IvyNode getRoot() {
        if (this._root == null) {
            this._root = this.computeRoot();
        }
        return this._root;
    }

    public Collection getPath() {
        if (this._path == null) {
            this._path = this.computePath();
        }
        return this._path;
    }

    private Collection computePath() {
        if (this._parent != null) {
            LinkedHashSet<IvyNode> p = new LinkedHashSet<IvyNode>(this._parent.getPath());
            p.add(this);
            return p;
        }
        return Collections.singletonList(this);
    }

    private IvyNode computeRoot() {
        if (this.isRoot()) {
            return this;
        }
        if (this._parent != null) {
            return this._parent.getRoot();
        }
        return null;
    }

    public String getParentConf() {
        return this._parentConf;
    }

    public void setParentConf(String parentConf) {
        this._parentConf = parentConf;
    }

    public boolean hasConfigurationsToLoad() {
        return !this._confsToFetch.isEmpty();
    }

    public boolean loadData(String conf, boolean shouldBePublic) {
        boolean loaded = false;
        if (!(this.isEvicted(this._rootModuleConf) || !this.hasConfigurationsToLoad() && this.isRootModuleConfLoaded() || this.hasProblem())) {
            this.markRootModuleConfLoaded();
            if (this._md == null) {
                DependencyResolver resolver = this._data.getIvy().getResolver(this.getModuleId());
                if (resolver == null) {
                    Message.error("no resolver found for " + this.getModuleId() + ": check your configuration");
                    this._problem = new RuntimeException("no resolver found for " + this.getModuleId() + ": check your configuration");
                    this._data.getReport().addDependency(this);
                    return false;
                }
                try {
                    Message.debug("\tusing " + resolver + " to resolve " + this.getId());
                    DependencyDescriptor dependencyDescriptor = this.getDependencyDescriptor(this.getParent());
                    this._data.getIvy().fireIvyEvent(new StartResolveDependencyEvent(this._data.getIvy(), resolver, dependencyDescriptor));
                    this._module = resolver.getDependency(dependencyDescriptor, this._data);
                    this._data.getIvy().fireIvyEvent(new EndResolveDependencyEvent(this._data.getIvy(), resolver, dependencyDescriptor, this._module));
                    if (this._module != null) {
                        this._data.getIvy().saveResolver(this._data.getCache(), this._module.getDescriptor(), this._module.getResolver().getName());
                        this._data.getIvy().saveArtResolver(this._data.getCache(), this._module.getDescriptor(), this._module.getArtifactResolver().getName());
                        if (this._data.getIvy().logModuleWhenFound()) {
                            Message.info("\tfound " + this._module.getId() + " in " + this._module.getResolver().getName());
                        } else {
                            Message.verbose("\tfound " + this._module.getId() + " in " + this._module.getResolver().getName());
                        }
                        if (this._data.getIvy().getVersionMatcher().isDynamic(this.getId())) {
                            if (this._data.getIvy().getVersionMatcher().isDynamic(this._module.getId())) {
                                Message.error("impossible to resolve dynamic revision for " + this.getId() + ": check your configuration and make sure revision is part of your pattern");
                                this._problem = new RuntimeException("impossible to resolve dynamic revision");
                                this._data.getReport().addDependency(this);
                                return false;
                            }
                            IvyNode resolved = this._data.getNode(this._module.getId());
                            if (resolved != null) {
                                this._md = this._module.getDescriptor();
                                if (!this.handleConfiguration(loaded, conf, shouldBePublic)) {
                                    return false;
                                }
                                if (resolved._md == null) {
                                    resolved._md = this._md;
                                }
                                if (resolved._module == null) {
                                    resolved._module = this._module;
                                }
                                resolved._downloaded |= this._module.isDownloaded();
                                resolved._searched |= this._module.isSearched();
                                resolved._dds.putAll(this._dds);
                                resolved.updateDataFrom(this, this._rootModuleConf);
                                resolved.loadData(conf, shouldBePublic);
                                DependencyDescriptor dd = dependencyDescriptor;
                                if (dd != null) {
                                    resolved.addDependencyArtifactsIncludes(this._rootModuleConf, dd.getDependencyArtifactsIncludes(this.getParentConf()));
                                }
                                this._data.register(this.getId(), resolved);
                                if (this._data.getIvy().logResolvedRevision()) {
                                    Message.info("\t[" + this._module.getId().getRevision() + "] " + this.getId());
                                } else {
                                    Message.verbose("\t[" + this._module.getId().getRevision() + "] " + this.getId());
                                }
                                return true;
                            }
                        }
                        this._downloaded = this._module.isDownloaded();
                        this._searched = this._module.isSearched();
                    } else {
                        Message.warn("\tmodule not found: " + this.getId());
                        resolver.reportFailure();
                        this._problem = new RuntimeException("not found");
                    }
                }
                catch (Exception e) {
                    this._problem = e;
                }
                if (this._module == null) {
                    this._data.getReport().addDependency(this);
                    return false;
                }
                loaded = true;
                if (this._data.getIvy().getVersionMatcher().isDynamic(this.getId())) {
                    if (this._data.getIvy().logResolvedRevision()) {
                        Message.info("\t[" + this._module.getId().getRevision() + "] " + this.getId());
                    } else {
                        Message.verbose("\t[" + this._module.getId().getRevision() + "] " + this.getId());
                    }
                }
                this._md = this._module.getDescriptor();
                if (this._data.getIvy().getVersionMatcher().isDynamic(this.getId())) {
                    this._data.register(this._module.getId(), this);
                }
                this._confsToFetch.remove("*");
                this.updateConfsToFetch(Arrays.asList(this.resolveSpecialConfigurations(this.getRequiredConfigurations(this.getParent(), this.getParentConf()), this)));
            } else {
                loaded = true;
            }
        }
        if (this.hasProblem()) {
            this._data.getReport().addDependency(this);
            return this.handleConfiguration(loaded, conf, shouldBePublic) && loaded;
        }
        if (!this.handleConfiguration(loaded, conf, shouldBePublic)) {
            return false;
        }
        DependencyDescriptor dd = this.getDependencyDescriptor(this.getParent());
        if (dd != null) {
            this.addDependencyArtifactsIncludes(this._rootModuleConf, dd.getDependencyArtifactsIncludes(this.getParentConf()));
        }
        return loaded;
    }

    private boolean markRootModuleConfLoaded() {
        return this._loadedRootModuleConfs.add(this._rootModuleConf);
    }

    private boolean isRootModuleConfLoaded() {
        return this._loadedRootModuleConfs.contains(this._rootModuleConf);
    }

    private boolean handleConfiguration(boolean loaded, String conf, boolean shouldBePublic) {
        if (this._md != null) {
            String[] confs = this.getRealConfs(conf);
            for (int i = 0; i < confs.length; ++i) {
                Configuration c = this._md.getConfiguration(confs[i]);
                if (c == null) {
                    this._confsToFetch.remove(conf);
                    this._problem = !conf.equals(confs[i]) ? new RuntimeException("configuration(s) not found in " + this + ": " + conf + ". Missing configuration: " + confs[i] + ". It was required from " + this.getParent() + " " + this.getParentConf()) : new RuntimeException("configuration(s) not found in " + this + ": " + confs[i] + ". It was required from " + this.getParent() + " " + this.getParentConf());
                    this._data.getReport().addDependency(this);
                    return false;
                }
                if (shouldBePublic && !this.isRoot() && c.getVisibility() != Configuration.Visibility.PUBLIC) {
                    this._confsToFetch.remove(conf);
                    this._problem = new RuntimeException("configuration not public in " + this + ": " + c + ". It was required from " + this.getParent() + " " + this.getParentConf());
                    this._data.getReport().addDependency(this);
                    return false;
                }
                if (loaded) {
                    this._fetchedConfigurations.add(conf);
                    this._confsToFetch.removeAll(Arrays.asList(confs));
                    this._confsToFetch.remove(conf);
                }
                this.addRootModuleConfigurations(this._rootModuleConf, confs);
            }
        }
        return true;
    }

    private String getDefaultConf(String conf) {
        Matcher m = FALLBACK_CONF_PATTERN.matcher(conf);
        if (m.matches()) {
            return m.group(2);
        }
        return conf;
    }

    private String getMainConf(String conf) {
        Matcher m = FALLBACK_CONF_PATTERN.matcher(conf);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    private boolean isRoot() {
        return this._isRoot;
    }

    public IvyNode getRealNode() {
        return this.getRealNode(false);
    }

    public IvyNode getRealNode(boolean traverse) {
        IvyNode node = this._data.getNode(this.getId());
        if (node != null) {
            if (traverse) {
                node.setParent(this.getParent());
                node.setParentConf(this.getParentConf());
                node.setRootModuleConf(this.getRootModuleConf());
                node.setRequestedConf(this.getRequestedConf());
                node._data = this._data;
            }
            return node;
        }
        return this;
    }

    public Collection getDependencies(String[] confs) {
        if (this._md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        if (Arrays.asList(confs).contains("*")) {
            confs = this._md.getConfigurationsNames();
        }
        HashSet deps = new HashSet();
        for (int i = 0; i < confs.length; ++i) {
            deps.addAll(this.getDependencies(confs[i], false));
        }
        return deps;
    }

    public Collection getDependencies(String conf, boolean traverse) {
        if (this._md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        DependencyDescriptor[] dds = this._md.getDependencies();
        LinkedHashSet<IvyNode> dependencies = new LinkedHashSet<IvyNode>();
        for (int i = 0; i < dds.length; ++i) {
            DependencyDescriptor dd = dds[i];
            String[] dependencyConfigurations = dd.getDependencyConfigurations(conf, this.getRequestedConf());
            if (dependencyConfigurations.length == 0) continue;
            if (this.isDependencyModuleExcluded(dd.getDependencyRevisionId(), conf)) {
                Message.verbose("excluding " + dd.getDependencyRevisionId() + " in " + conf);
                continue;
            }
            IvyNode depNode = this._data.getNode(dd.getDependencyRevisionId());
            if (depNode == null) {
                depNode = new IvyNode(this._data, this, dd);
            } else {
                depNode.addDependencyDescriptor(this, dd);
                if (depNode.hasProblem()) {
                    // empty if block
                }
            }
            List<String> confs = Arrays.asList(this.resolveSpecialConfigurations(dependencyConfigurations, depNode));
            depNode.updateConfsToFetch(confs);
            depNode.setRequiredConfs(this, conf, confs);
            depNode.addCaller(this._rootModuleConf, this, conf, dependencyConfigurations, dd);
            dependencies.add(depNode);
            if (!traverse) continue;
            this.traverse(conf, depNode);
        }
        return dependencies;
    }

    public void traverse(String conf, IvyNode depNode) {
        if (this.getPath().contains(depNode)) {
            IvyContext.getContext().getCircularDependencyStrategy().handleCircularDependency(this.toMrids(this.getPath(), depNode));
        } else {
            depNode.setParent(this);
        }
        depNode.setParentConf(conf);
        depNode.setRootModuleConf(this.getRootModuleConf());
        depNode._data = this._data;
    }

    private ModuleRevisionId[] toMrids(Collection path, IvyNode depNode) {
        ModuleRevisionId[] ret = new ModuleRevisionId[path.size() + 1];
        int i = 0;
        Iterator iter = path.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            ret[i] = node.getId();
            ++i;
        }
        ret[ret.length - 1] = depNode.getId();
        return ret;
    }

    public final String getRequestedConf() {
        return (String)this._requestedConf.get(this.getRootModuleConf());
    }

    public final void setRequestedConf(String requestedConf) {
        this._requestedConf.put(this.getRootModuleConf(), requestedConf);
    }

    private void addDependencyDescriptor(IvyNode parent, DependencyDescriptor dd) {
        this._dds.put(parent, dd);
    }

    private boolean isDependencyModuleExcluded(ModuleRevisionId dependencyRevisionId, String conf) {
        return this.doesCallersExclude(this.getRootModuleConf(), DefaultArtifact.newIvyArtifact(dependencyRevisionId, null));
    }

    public ModuleRevisionId getId() {
        return this._id;
    }

    public void updateConfsToFetch(Collection confs) {
        this._confsToFetch.addAll(confs);
        this._confsToFetch.removeAll(this._fetchedConfigurations);
    }

    public ModuleId getModuleId() {
        return this._id.getModuleId();
    }

    private String[] resolveSpecialConfigurations(String[] dependencyConfigurations, IvyNode node) {
        if (dependencyConfigurations.length == 1 && dependencyConfigurations[0].startsWith("*") && node != null && node.isLoaded()) {
            String conf = dependencyConfigurations[0];
            if ("*".equals(conf)) {
                return node.getDescriptor().getPublicConfigurationsNames();
            }
            List<String> exclusions = Arrays.asList(conf.substring(2).split("\\!"));
            ArrayList<String> ret = new ArrayList<String>(Arrays.asList(node.getDescriptor().getPublicConfigurationsNames()));
            ret.removeAll(exclusions);
            return ret.toArray(new String[ret.size()]);
        }
        return dependencyConfigurations;
    }

    public boolean isLoaded() {
        return this._md != null;
    }

    public ModuleDescriptor getDescriptor() {
        return this._md;
    }

    public String[] getRequiredConfigurations(IvyNode in, String inConf) {
        Collection req = (Collection)this._requiredConfs.get(new NodeConf(in, inConf));
        return req == null ? new String[]{} : req.toArray(new String[req.size()]);
    }

    public String[] getRequiredConfigurations() {
        ArrayList required = new ArrayList(this._confsToFetch.size() + this._fetchedConfigurations.size());
        required.addAll(this._fetchedConfigurations);
        required.addAll(this._confsToFetch);
        return required.toArray(new String[required.size()]);
    }

    private void setRequiredConfs(IvyNode parent, String parentConf, Collection confs) {
        this._requiredConfs.put(new NodeConf(parent, parentConf), new HashSet(confs));
    }

    public Configuration getConfiguration(String conf) {
        if (this._md == null) {
            throw new IllegalStateException("impossible to get configuration when data has not been loaded");
        }
        String defaultConf = this.getDefaultConf(conf);
        Configuration configuration = this._md.getConfiguration(conf = this.getMainConf(conf));
        if (configuration == null) {
            configuration = this._md.getConfiguration(defaultConf);
        }
        return configuration;
    }

    public ResolvedModuleRevision getModuleRevision() {
        return this._module;
    }

    public void addCaller(String rootModuleConf, IvyNode node, String callerConf, String[] dependencyConfs, DependencyDescriptor dd) {
        Caller caller;
        ModuleDescriptor md = node.getDescriptor();
        ModuleRevisionId mrid = node.getId();
        if (mrid.getModuleId().equals(this.getId().getModuleId())) {
            throw new IllegalArgumentException("a module is not authorized to depend on itself: " + this.getId());
        }
        HashMap<ModuleRevisionId, Caller> callers = (HashMap<ModuleRevisionId, Caller>)this._callersByRootConf.get(rootModuleConf);
        if (callers == null) {
            callers = new HashMap<ModuleRevisionId, Caller>();
            this._callersByRootConf.put(rootModuleConf, callers);
        }
        if ((caller = (Caller)callers.get(mrid)) == null) {
            caller = new Caller(md, mrid, dd, node.canExclude(rootModuleConf));
            callers.put(mrid, caller);
        }
        caller.addConfiguration(callerConf, dependencyConfs);
        IvyNode parent = node.getRealNode();
        Iterator iter = parent._allCallers.keySet().iterator();
        while (iter.hasNext()) {
            ModuleId mid = (ModuleId)iter.next();
            this._allCallers.put(mid, parent);
        }
        this._allCallers.put(mrid.getModuleId(), node);
        this._isCircular = this._allCallers.keySet().contains(this.getId().getModuleId());
        if (this._isCircular) {
            IvyContext.getContext().getCircularDependencyStrategy().handleCircularDependency(this.toMrids(this.findPath(this.getId().getModuleId()), this));
        }
    }

    private Collection findPath(ModuleId from) {
        return this.findPath(from, this, new LinkedList());
    }

    private Collection findPath(ModuleId from, IvyNode node, List path) {
        IvyNode parent = (IvyNode)node._allCallers.get(from);
        if (parent == null) {
            throw new IllegalArgumentException("no path from " + from + " to " + this.getId() + " found");
        }
        if (path.contains(parent)) {
            path.add(0, parent);
            Message.verbose("circular dependency found while looking for the path for another one: was looking for " + from + " as a caller of " + path.get(path.size() - 1));
            return path;
        }
        path.add(0, parent);
        if (parent.getId().getModuleId().equals(from)) {
            return path;
        }
        return this.findPath(from, parent, path);
    }

    private boolean canExclude(String rootModuleConf) {
        DependencyDescriptor dd = this.getDependencyDescriptor(this.getParent());
        if (dd != null && dd.canExclude()) {
            return true;
        }
        Caller[] callers = this.getCallers(rootModuleConf);
        for (int i = 0; i < callers.length; ++i) {
            if (!callers[i].canExclude()) continue;
            return true;
        }
        return false;
    }

    public Caller[] getCallers(String rootModuleConf) {
        Map callers = (Map)this._callersByRootConf.get(rootModuleConf);
        if (callers == null) {
            return new Caller[0];
        }
        return callers.values().toArray(new Caller[callers.values().size()]);
    }

    public Caller[] getAllCallers() {
        HashSet all = new HashSet();
        Iterator iter = this._callersByRootConf.values().iterator();
        while (iter.hasNext()) {
            Map callers = (Map)iter.next();
            all.addAll(callers.values());
        }
        return all.toArray(new Caller[all.size()]);
    }

    public String toString() {
        return this.getResolvedId().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IvyNode)) {
            return false;
        }
        IvyNode node = (IvyNode)obj;
        return node.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String[] getConfigurations(String rootModuleConf) {
        Set depConfs = (Set)this._rootModuleConfs.get(rootModuleConf);
        if (depConfs == null) {
            return new String[0];
        }
        return depConfs.toArray(new String[depConfs.size()]);
    }

    public void discardConf(String conf) {
        this.discardConf(this._rootModuleConf, conf);
    }

    public void discardConf(String rootModuleConf, String conf) {
        HashSet depConfs = (HashSet)this._rootModuleConfs.get(rootModuleConf);
        if (depConfs == null) {
            depConfs = new HashSet();
            this._rootModuleConfs.put(rootModuleConf, depConfs);
        }
        if (this._md != null) {
            Configuration c = this._md.getConfiguration(conf);
            if (conf != null) {
                String[] exts = c.getExtends();
                for (int i = 0; i < exts.length; ++i) {
                    this.discardConf(rootModuleConf, exts[i]);
                }
                depConfs.remove(c.getName());
            } else {
                Message.warn("unknown configuration in " + this.getId() + ": " + conf);
            }
        } else {
            depConfs.remove(conf);
        }
    }

    private void addRootModuleConfigurations(String rootModuleConf, String[] dependencyConfs) {
        HashSet<String> depConfs = (HashSet<String>)this._rootModuleConfs.get(rootModuleConf);
        if (depConfs == null) {
            depConfs = new HashSet<String>();
            this._rootModuleConfs.put(rootModuleConf, depConfs);
        }
        if (this._md != null) {
            for (int i = 0; i < dependencyConfs.length; ++i) {
                Configuration conf = this._md.getConfiguration(dependencyConfs[i]);
                if (conf != null) {
                    String[] exts = conf.getExtends();
                    this.addRootModuleConfigurations(rootModuleConf, exts);
                    depConfs.add(conf.getName());
                    continue;
                }
                Message.warn("unknown configuration in " + this.getId() + ": " + dependencyConfs[i]);
            }
        } else {
            for (int i = 0; i < dependencyConfs.length; ++i) {
                depConfs.add(dependencyConfs[i]);
            }
        }
    }

    public String[] getRootModuleConfigurations() {
        return this._rootModuleConfs.keySet().toArray(new String[this._rootModuleConfs.size()]);
    }

    public Artifact[] getAllArtifacts() {
        HashSet<Artifact> ret = new HashSet<Artifact>();
        Iterator it = this._rootModuleConfs.keySet().iterator();
        while (it.hasNext()) {
            String rootModuleConf = (String)it.next();
            ret.addAll(Arrays.asList(this.getArtifacts(rootModuleConf)));
        }
        return ret.toArray(new Artifact[ret.size()]);
    }

    public Artifact[] getSelectedArtifacts(Filter artifactFilter) {
        Collection<Artifact> ret = new HashSet();
        Iterator it = this._rootModuleConfs.keySet().iterator();
        while (it.hasNext()) {
            String rootModuleConf = (String)it.next();
            if (this.isEvicted(rootModuleConf)) continue;
            ret.addAll(Arrays.asList(this.getArtifacts(rootModuleConf)));
        }
        ret = FilterHelper.filter(ret, artifactFilter);
        return ret.toArray(new Artifact[ret.size()]);
    }

    public Artifact[] getArtifacts(String rootModuleConf) {
        Iterator iter;
        Set confs = (Set)this._rootModuleConfs.get(rootModuleConf);
        if (confs == null) {
            return new Artifact[0];
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Set includes = (Set)this._dependencyArtifactsIncludes.get(rootModuleConf);
        if (this._md.isDefault() && includes != null && !includes.isEmpty()) {
            Iterator it = includes.iterator();
            while (it.hasNext()) {
                DependencyArtifactDescriptor dad = (DependencyArtifactDescriptor)it.next();
                artifacts.add(new MDArtifact(this._md, dad.getName(), dad.getType(), dad.getExt(), dad.getUrl(), null));
            }
        } else if (includes == null || includes.isEmpty()) {
            iter = confs.iterator();
            while (iter.hasNext()) {
                String conf = (String)iter.next();
                artifacts.addAll(Arrays.asList(this._md.getArtifacts(conf)));
            }
        } else {
            Object arts;
            HashMap<ArtifactId, Object> allArtifacts = new HashMap<ArtifactId, Object>();
            Iterator iter2 = confs.iterator();
            while (iter2.hasNext()) {
                String conf = (String)iter2.next();
                arts = this._md.getArtifacts(conf);
                for (int i = 0; i < ((Artifact[])arts).length; ++i) {
                    allArtifacts.put(arts[i].getId().getArtifactId(), arts[i]);
                }
            }
            Iterator it = includes.iterator();
            while (it.hasNext()) {
                DependencyArtifactDescriptor dad = (DependencyArtifactDescriptor)it.next();
                arts = IvyNode.findArtifactsMatching(dad, allArtifacts);
                if (arts.isEmpty()) {
                    Message.error("a required artifact is not listed by module descriptor: " + dad.getId());
                    it.remove();
                    continue;
                }
                Message.debug(this + " in " + rootModuleConf + ": including " + arts);
                artifacts.addAll((Collection<Artifact>)arts);
            }
        }
        iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            boolean excluded = this.doesCallersExclude(rootModuleConf, artifact);
            if (!excluded) continue;
            Message.debug(this + " in " + rootModuleConf + ": excluding " + artifact);
            iter.remove();
        }
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    private boolean doesCallersExclude(String rootModuleConf, Artifact artifact) {
        return this.doesCallersExclude(rootModuleConf, artifact, new Stack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesCallersExclude(String rootModuleConf, Artifact artifact, Stack callersStack) {
        if (callersStack.contains(this.getId())) {
            return false;
        }
        callersStack.push(this.getId());
        try {
            Caller[] callers = this.getCallers(rootModuleConf);
            if (callers.length == 0) {
                boolean bl = false;
                return bl;
            }
            ArrayList callersNodes = new ArrayList();
            for (int i = 0; i < callers.length; ++i) {
                if (!callers[i].canExclude()) {
                    boolean bl = false;
                    return bl;
                }
                ModuleDescriptor md = callers[i].getModuleDescriptor();
                if (this.doesExclude(md, rootModuleConf, callers[i].getCallerConfigurations(), this, callers[i].getDependencyDescriptor(), artifact, callersStack)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            callersStack.pop();
        }
    }

    private boolean doesExclude(ModuleDescriptor md, String rootModuleConf, String[] moduleConfs, IvyNode dependency, DependencyDescriptor dd, Artifact artifact, Stack callersStack) {
        if (dd != null && dd.doesExclude(moduleConfs, artifact.getId().getArtifactId())) {
            return true;
        }
        IvyNode c = this._data.getNode(md.getModuleRevisionId());
        if (c != null) {
            return c.doesCallersExclude(rootModuleConf, artifact, callersStack);
        }
        return false;
    }

    private static DependencyDescriptor getDependencyDescriptor(ModuleDescriptor md, IvyNode dependency) {
        if (md != null) {
            DependencyDescriptor[] dds = md.getDependencies();
            for (int i = 0; i < dds.length; ++i) {
                if (!dds[i].getDependencyId().equals(dependency.getModuleId())) continue;
                return dds[i];
            }
        }
        return null;
    }

    private static Collection findArtifactsMatching(DependencyArtifactDescriptor dad, Map allArtifacts) {
        ArrayList ret = new ArrayList();
        Iterator iter = allArtifacts.keySet().iterator();
        while (iter.hasNext()) {
            ArtifactId aid = (ArtifactId)iter.next();
            if (!MatcherHelper.matches(dad.getMatcher(), dad.getId(), aid)) continue;
            ret.add(allArtifacts.get(aid));
        }
        return ret;
    }

    private void addDependencyArtifactsIncludes(String rootModuleConf, DependencyArtifactDescriptor[] dependencyArtifacts) {
        this.addDependencyArtifacts(rootModuleConf, dependencyArtifacts, this._dependencyArtifactsIncludes);
    }

    private void addDependencyArtifacts(String rootModuleConf, DependencyArtifactDescriptor[] dependencyArtifacts, Map artifactsMap) {
        HashSet<DependencyArtifactDescriptor> depArtifacts = (HashSet<DependencyArtifactDescriptor>)artifactsMap.get(rootModuleConf);
        if (depArtifacts == null) {
            depArtifacts = new HashSet<DependencyArtifactDescriptor>();
            artifactsMap.put(rootModuleConf, depArtifacts);
        }
        depArtifacts.addAll(Arrays.asList(dependencyArtifacts));
    }

    public long getPublication() {
        if (this._module != null) {
            return this._module.getPublicationDate().getTime();
        }
        return 0L;
    }

    public DependencyDescriptor getDependencyDescriptor(IvyNode parent) {
        return (DependencyDescriptor)this._dds.get(parent);
    }

    public boolean hasProblem() {
        return this._problem != null;
    }

    public ModuleRevisionId getResolvedId() {
        if (this._md != null && this._md.getResolvedModuleRevisionId().getRevision() != null) {
            return this._md.getResolvedModuleRevisionId();
        }
        if (this._module != null) {
            return this._module.getId();
        }
        return this.getId();
    }

    public Exception getProblem() {
        return this._problem;
    }

    public boolean isDownloaded() {
        return this._downloaded;
    }

    public boolean isSearched() {
        return this._searched;
    }

    public String getRootModuleConf() {
        return this._rootModuleConf;
    }

    public void setRootModuleConf(String rootModuleConf) {
        if (this._rootModuleConf != null && !this._rootModuleConf.equals(rootModuleConf)) {
            this._confsToFetch.clear();
        }
        if (rootModuleConf != null && rootModuleConf.equals(this._rootModuleConf)) {
            this._selectedDeps.put(new ModuleIdConf(this._id.getModuleId(), rootModuleConf), Collections.singleton(this));
        }
        this._rootModuleConf = rootModuleConf;
    }

    public String[] getConfsToFetch() {
        return this._confsToFetch.toArray(new String[this._confsToFetch.size()]);
    }

    public boolean isCircular() {
        return this._isCircular;
    }

    public boolean isFetched(String conf) {
        return this._fetchedConfigurations.contains(conf);
    }

    public EvictionData getEvictionDataInRoot(String rootModuleConf, IvyNode parent) {
        IvyNode root = parent.getRoot();
        Collection selectedNodes = root.getResolvedNodes(this.getModuleId(), rootModuleConf);
        Iterator iter = selectedNodes.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.getResolvedId().equals(this.getResolvedId())) continue;
            return null;
        }
        return new EvictionData(rootModuleConf, parent, root.getConflictManager(this.getModuleId()), selectedNodes);
    }

    public static IvyNode getRoot(IvyNode parent) {
        IvyNode root = parent;
        HashSet<IvyNode> path = new HashSet<IvyNode>();
        path.add(root);
        while (root.getParent() != null && !root.isRoot()) {
            if (path.contains(root.getParent())) {
                return root;
            }
            root = root.getParent();
            path.add(root);
        }
        return root;
    }

    public IvyNode findNode(ModuleRevisionId mrid) {
        return this._data.getNode(mrid);
    }

    public String[] getRealConfs(String conf) {
        if (this._md == null) {
            return new String[]{conf};
        }
        String defaultConf = this.getDefaultConf(conf);
        if (this._md.getConfiguration(conf = this.getMainConf(conf)) == null) {
            if ("".equals(defaultConf)) {
                return new String[0];
            }
            conf = defaultConf;
        }
        if (conf.startsWith("*")) {
            return this.resolveSpecialConfigurations(new String[]{conf}, this);
        }
        if (conf.indexOf(44) != -1) {
            String[] confs = conf.split(",");
            for (int i = 0; i < confs.length; ++i) {
                confs[i] = confs[i].trim();
            }
        }
        return new String[]{conf};
    }

    protected boolean isTransitive() {
        return this._data.isTransitive() && this.getDependencyDescriptor(this.getParent()).isTransitive() && this.isParentConfTransitive();
    }

    protected boolean isParentConfTransitive() {
        String conf = this.getParent().getRequestedConf();
        if (conf == null) {
            return true;
        }
        Configuration parentConf = this.getParent().getConfiguration(conf);
        return parentConf.isTransitive();
    }

    public ResolveData getResolveData() {
        return this._data;
    }

    private static final class ModuleIdConf {
        private ModuleId _moduleId;
        private String _conf;

        public ModuleIdConf(ModuleId mid, String conf) {
            this._moduleId = mid;
            this._conf = conf;
        }

        public final String getConf() {
            return this._conf;
        }

        public final ModuleId getModuleId() {
            return this._moduleId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModuleIdConf)) {
                return false;
            }
            return this.getModuleId().equals(((ModuleIdConf)obj).getModuleId()) && this.getConf().equals(((ModuleIdConf)obj).getConf());
        }

        public int hashCode() {
            int hash = 33;
            hash += this.getModuleId().hashCode() * 17;
            return hash += this.getConf().hashCode() * 17;
        }
    }

    private static final class NodeConf {
        private IvyNode _node;
        private String _conf;

        public NodeConf(IvyNode node, String conf) {
            this._node = node;
            this._conf = conf;
        }

        public final String getConf() {
            return this._conf;
        }

        public final IvyNode getNode() {
            return this._node;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeConf)) {
                return false;
            }
            return this.getNode().equals(((NodeConf)obj).getNode()) && this.getConf().equals(((NodeConf)obj).getConf());
        }

        public int hashCode() {
            int hash = 33;
            hash += this.getNode().hashCode() * 17;
            return hash += this.getConf().hashCode() * 17;
        }
    }

    public class Caller {
        private ModuleDescriptor _md;
        private ModuleRevisionId _mrid;
        private Map _confs = new HashMap();
        private DependencyDescriptor _dd;
        private boolean _callerCanExclude;

        public Caller(ModuleDescriptor md, ModuleRevisionId mrid, DependencyDescriptor dd, boolean callerCanExclude) {
            this._md = md;
            this._mrid = mrid;
            this._dd = dd;
            this._callerCanExclude = callerCanExclude;
        }

        public void addConfiguration(String callerConf, String[] dependencyConfs) {
            String[] prevDepConfs = (String[])this._confs.get(callerConf);
            if (prevDepConfs != null) {
                HashSet<String> newDepConfs = new HashSet<String>(Arrays.asList(prevDepConfs));
                newDepConfs.addAll(Arrays.asList(dependencyConfs));
                this._confs.put(callerConf, newDepConfs.toArray(new String[newDepConfs.size()]));
            } else {
                this._confs.put(callerConf, dependencyConfs);
            }
        }

        public String[] getCallerConfigurations() {
            return this._confs.keySet().toArray(new String[this._confs.keySet().size()]);
        }

        public ModuleRevisionId getModuleRevisionId() {
            return this._mrid;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Caller)) {
                return false;
            }
            Caller other = (Caller)obj;
            return ((Object)other._confs).equals(this._confs) && this._mrid.equals(other._mrid);
        }

        public int hashCode() {
            int hash = 31;
            hash = hash * 13 + ((Object)this._confs).hashCode();
            hash = hash * 13 + this._mrid.hashCode();
            return hash;
        }

        public String toString() {
            return this._mrid.toString();
        }

        public ModuleRevisionId getAskedDependencyId() {
            return this._dd.getDependencyRevisionId();
        }

        public ModuleDescriptor getModuleDescriptor() {
            return this._md;
        }

        public boolean canExclude() {
            return this._callerCanExclude || this._dd.canExclude();
        }

        public DependencyDescriptor getDependencyDescriptor() {
            return this._dd;
        }
    }

    public static class EvictionData {
        private IvyNode _node;
        private ConflictManager _conflictManager;
        private Collection _selected;
        private String _rootModuleConf;

        public EvictionData(String rootModuleConf, IvyNode node, ConflictManager conflictManager, Collection selected) {
            this._rootModuleConf = rootModuleConf;
            this._node = node;
            this._conflictManager = conflictManager;
            this._selected = selected;
        }

        public String toString() {
            if (this._selected != null) {
                return this._selected + " in " + this._node + " (" + this._conflictManager + ") [" + this._rootModuleConf + "]";
            }
            return "transitively [" + this._rootModuleConf + "]";
        }

        public ConflictManager getConflictManager() {
            return this._conflictManager;
        }

        public IvyNode getNode() {
            return this._node;
        }

        public Collection getSelected() {
            return this._selected;
        }

        public String getRootModuleConf() {
            return this._rootModuleConf;
        }
    }
}

