/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPProposalCollector;
import org.eclipse.jst.jsp.ui.internal.contentassist.JavaTypeCompletionProposal;
import org.eclipse.jst.jsp.ui.internal.editor.JSPEditorPluginImageHelper;
import org.eclipse.swt.graphics.Image;

public class JavaTypeNameRequestor
extends TypeNameRequestor {
    private int fJSPOffset = -1;
    private int fReplacementLength = -1;
    private List fProposals = new ArrayList();
    private boolean fIgnoreAbstractClasses = false;
    private CompletionProposalLabelProvider fLabelProvider = new CompletionProposalLabelProvider();

    public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
        int offset = this.getJSPOffset();
        int length = this.getReplacementLength();
        if (offset == -1 || length == -1) {
            return;
        }
        if (this.ignoreAbstractClasses() && Flags.isAbstract((int)modifiers)) {
            return;
        }
        Image image = this.calculateImage(modifiers);
        String containerNameString = new String(packageName);
        String typeNameString = String.valueOf(simpleTypeName);
        String fullName = this.concatenateName(containerNameString, typeNameString);
        String simpleName = Signature.getSimpleName((String)fullName);
        StringBuffer buf = new StringBuffer(simpleName);
        String typeQualifier = Signature.getQualifier((String)fullName);
        if (typeQualifier.length() > 0) {
            buf.append(" - ");
            buf.append(typeQualifier);
        }
        JavaTypeCompletionProposal proposal = new JavaTypeCompletionProposal(fullName, offset, length, fullName, image, typeNameString, typeQualifier, 0, true);
        proposal.setTriggerCharacters(JSPProposalCollector.getTypeTriggers());
        this.fProposals.add(proposal);
    }

    private Image calculateImage(int modifiers) {
        CompletionProposal p = CompletionProposal.create((int)9, (int)this.getJSPOffset());
        p.setFlags(modifiers);
        char[] sig = new char[]{'Q'};
        p.setSignature(sig);
        ImageDescriptor descriptor = this.fLabelProvider.createImageDescriptor(p);
        Image image = JSPEditorPluginImageHelper.getInstance().getImage(descriptor);
        return image;
    }

    public String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    int getJSPOffset() {
        return this.fJSPOffset;
    }

    void setJSPOffset(int offset) {
        this.fJSPOffset = offset;
    }

    int getReplacementLength() {
        return this.fReplacementLength;
    }

    void setReplacementLength(int replacementLength) {
        this.fReplacementLength = replacementLength;
    }

    void setIgnoreAbstractClasses(boolean ignore) {
        this.fIgnoreAbstractClasses = ignore;
    }

    boolean ignoreAbstractClasses() {
        return this.fIgnoreAbstractClasses;
    }

    JavaTypeCompletionProposal[] getProposals() {
        return this.fProposals.toArray(new JavaTypeCompletionProposal[this.fProposals.size()]);
    }
}

