/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMVisitor {
    public void visitNode(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                this.visitAttr((Attr)node);
                break;
            }
            case 4: {
                this.visitCDATASection((CDATASection)node);
                break;
            }
            case 8: {
                this.visitComment((Comment)node);
                break;
            }
            case 9: {
                this.visitDocument((Document)node);
                break;
            }
            case 10: {
                this.visitDocumentType((DocumentType)node);
                break;
            }
            case 1: {
                this.visitElement((Element)node);
                break;
            }
            case 7: {
                this.visitProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 3: {
                this.visitText((Text)node);
            }
        }
    }

    protected void visitDocument(Document document) {
        this.visitChildNodesHelper(document);
    }

    protected void visitDocumentType(DocumentType doctype) {
    }

    protected void visitElement(Element element) {
        this.visitAttributesHelper(element);
        this.visitChildNodesHelper(element);
    }

    public void visitAttr(Attr attr) {
    }

    protected void visitText(Text text) {
    }

    protected void visitCDATASection(CDATASection cdataSection) {
    }

    protected void visitComment(Comment comment) {
    }

    protected void visitProcessingInstruction(ProcessingInstruction pi) {
    }

    protected void visitChildNodesHelper(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            this.visitNode(children.item(i));
            ++i;
        }
    }

    protected void visitAttributesHelper(Node node) {
        NamedNodeMap map = node.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            this.visitNode(map.item(i));
            ++i;
        }
    }
}

