/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.scheduler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IStartup;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.IUninstallFeaturesOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.operations.OperationsManager;

public class ScheduledPluginUninstall
implements IStartup {
    public void earlyStartup() {
        URL platformXML = ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation();
        File f = new File(platformXML.getFile());
        f = new File(f.getParentFile(), "toBeUninstalled");
        try {
            if (!f.exists()) {
                return;
            }
            FileInputStream fis = new FileInputStream(f);
            Properties toBeUninstalled = new Properties();
            toBeUninstalled.load(fis);
            fis.close();
            IFeature[] features = new IFeature[toBeUninstalled.size()];
            IConfiguredSite[] configuredSites = new IConfiguredSite[toBeUninstalled.size()];
            IConfiguredSite[] sites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
            Enumeration<Object> featuresToBeDeleted = toBeUninstalled.elements();
            int i = 0;
            while (featuresToBeDeleted.hasMoreElements()) {
                String temp = (String)featuresToBeDeleted.nextElement();
                StringTokenizer stk = new StringTokenizer(temp, ";");
                String targetSite = stk.nextToken();
                String featureName = stk.nextToken();
                int j = 0;
                while (j < sites.length) {
                    if (sites[j].getSite().getURL().toString().equals(targetSite)) {
                        configuredSites[i] = sites[j];
                        IFeatureReference[] siteFeatures = configuredSites[i].getFeatureReferences();
                        int k = 0;
                        while (k < siteFeatures.length) {
                            if (siteFeatures[k].getVersionedIdentifier().toString().equals(featureName)) {
                                features[i] = siteFeatures[k].getFeature(null);
                                break;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            IUninstallFeaturesOperation uninstallFeaturesOperation = ((OperationFactory)OperationsManager.getOperationFactory()).createUninstallFeaturesOperation(configuredSites, features);
            uninstallFeaturesOperation.execute(null, null);
            f.delete();
        }
        catch (IOException iOException) {
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

