module Examples.Simple.Complex where

import qualified Prelude
import Feldspar
import Feldspar.Vector
import Feldspar.Compiler

-- | Creation of complex values, addition and conjugation.
complex1 :: Data (Complex Float)
complex1 = conjugate $ value (3 :+ 4) + value (0 :+ 9)

-- | Constant vector containing complex values.
complex2 :: Data [Complex Float]
complex2 = wrap $ vector
    [ 3 :+ 4 :: Complex Float,    0 :+ 9,    (-13) :+ (-4), 32 :+ 22
    , 0 :+ 0,    10 :+ 9,   3 :+ (-2),     21 :+ 3
    , 10 :+ 4,   2 :+ 2,    0 :+ 1,        0 :+ (-10)
    , (-1) :+ 0, 3 :+ (-3), 5 :+ 55
    ]

-- | Sum of a complex vector.
complex3 :: Data' D256 [Complex Float] -> Data (Complex Float)
complex3 = wrap (sum :: DVector (Complex Float) -> Data (Complex Float))
 
-- | Generic (not compilable) pairwise multiplication of vectors.
complex4 :: (Syntactic a, Num a) => Vector a -> Vector a -> Vector a
complex4 = zipWith (*)

-- | Instance of the generic algorithm for complex values and fixed length arrays.
complex4' :: Data' D256 [Complex Float] -> Data' D256 [Complex Float] -> Data [Complex Float]
complex4' = wrap (complex4 :: DVector (Complex Float) -> DVector (Complex Float) -> DVector (Complex Float))

-- | Real parts of a complex vector.
complex5 :: Data' D256 [Complex Float] -> Data [Float]
complex5 = wrap $ map (realPart :: Data (Complex Float) -> Data Float)
