/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainSocketImpl;
import gnu.java.nio.NIOSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public final class SocketChannelImpl
extends SocketChannel {
    private PlainSocketImpl impl;
    private NIOSocket socket;
    private boolean connectionPending;

    SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.impl = new PlainSocketImpl();
        this.socket = new NIOSocket(this.impl, this);
        this.configureBlocking(true);
    }

    SocketChannelImpl(SelectorProvider selectorProvider, NIOSocket nIOSocket) throws IOException {
        super(selectorProvider);
        this.impl = nIOSocket.getPlainSocketImpl();
        this.socket = nIOSocket;
    }

    public void finalizer() {
        if (this.isConnected()) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    PlainSocketImpl getPlainSocketImpl() {
        return this.impl;
    }

    int getNativeFD() {
        return this.socket.getPlainSocketImpl().getNativeFD();
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.socket.close();
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.socket.setSoTimeout(bl ? 0 : 50);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect(SocketAddress socketAddress) throws IOException {
        boolean bl;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.isConnected()) {
            throw new AlreadyConnectedException();
        }
        if (this.connectionPending) {
            throw new ConnectionPendingException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        if (((InetSocketAddress)socketAddress).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        try {
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            if (this.isBlocking()) {
                this.socket.connect(socketAddress);
                boolean bl2 = true;
                Object var4_5 = null;
                this.socket.getPlainSocketImpl().setInChannelOperation(false);
                return bl2;
            }
            try {
                this.socket.connect(socketAddress, 50);
                bl = true;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.connectionPending = true;
                boolean bl3 = false;
                Object var4_7 = null;
                this.socket.getPlainSocketImpl().setInChannelOperation(false);
                return bl3;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
            throw throwable;
        }
        Object var4_6 = null;
        this.socket.getPlainSocketImpl().setInChannelOperation(false);
        return bl;
    }

    public boolean finishConnect() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isConnected() && !this.connectionPending) {
            throw new NoConnectionPendingException();
        }
        if (this.isConnected()) {
            return true;
        }
        AbstractSelector abstractSelector = this.provider().openSelector();
        this.register(abstractSelector, 8);
        if (this.isBlocking()) {
            abstractSelector.select();
            this.connectionPending = false;
            return true;
        }
        int n = abstractSelector.selectNow();
        if (n == 1) {
            this.connectionPending = false;
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isConnectionPending() {
        return this.connectionPending;
    }

    public Socket socket() {
        return this.socket;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray;
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int n = 0;
        InputStream inputStream = this.socket.getInputStream();
        int n2 = inputStream.available();
        int n3 = byteBuffer.remaining();
        if (!this.isBlocking() && n2 == 0) {
            return 0;
        }
        if (byteBuffer.hasArray()) {
            n = byteBuffer.arrayOffset() + byteBuffer.position();
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[n3];
        }
        int n4 = 0;
        boolean bl = false;
        try {
            this.begin();
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            n4 = inputStream.read(byArray, n, n3);
            bl = true;
        }
        finally {
            Object var9_9 = null;
            this.end(bl);
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
        }
        if (n4 > 0) {
            if (byteBuffer.hasArray()) {
                byteBuffer.position(byteBuffer.position() + n4);
            } else {
                byteBuffer.put(byArray, n, n4);
            }
        }
        int n5 = n4;
        return n5;
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        long l = 0L;
        for (int i = n; i < n2; ++i) {
            l += (long)this.read(byteBufferArray[i]);
        }
        return l;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray;
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int n = 0;
        int n2 = byteBuffer.remaining();
        if (!byteBuffer.hasArray()) {
            byArray = new byte[n2];
            byteBuffer.get(byArray, 0, n2);
        } else {
            n = byteBuffer.arrayOffset() + byteBuffer.position();
            byArray = byteBuffer.array();
        }
        OutputStream outputStream = this.socket.getOutputStream();
        boolean bl = false;
        try {
            this.begin();
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            outputStream.write(byArray, n, n2);
            bl = true;
        }
        finally {
            Object var7_7 = null;
            this.end(bl);
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
        }
        if (byteBuffer.hasArray()) {
            byteBuffer.position(byteBuffer.position() + n2);
        }
        int n3 = n2;
        return n3;
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        long l = 0L;
        for (int i = n; i < n2; ++i) {
            l += (long)this.write(byteBufferArray[i]);
        }
        return l;
    }
}

