/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGData;
import gnu.javax.imageio.png.PNGException;
import gnu.javax.imageio.png.PNGGamma;
import gnu.javax.imageio.png.PNGHeader;
import gnu.javax.imageio.png.PNGICCProfile;
import gnu.javax.imageio.png.PNGPalette;
import gnu.javax.imageio.png.PNGPhys;
import gnu.javax.imageio.png.PNGTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PNGChunk {
    private static long[] crcTable = new long[256];
    public static final int TYPE_HEADER = 1229472850;
    public static final int TYPE_PALETTE = 1347179589;
    public static final int TYPE_DATA = 1229209940;
    public static final int TYPE_TIME = 1950960965;
    public static final int TYPE_END = 1229278788;
    public static final int TYPE_PHYS = 1883789683;
    public static final int TYPE_GAMMA = 1732332865;
    public static final int TYPE_PROFILE = 1766015824;
    private int type;
    protected byte[] data;
    private int crc;

    protected PNGChunk(int n, byte[] byArray, int n2) {
        this.type = n;
        this.data = byArray;
        this.crc = n2;
    }

    protected PNGChunk(int n) {
        this.type = n;
    }

    public static PNGChunk readChunk(InputStream inputStream, boolean bl) throws IOException, PNGException {
        byte[] byArray = new byte[4];
        if (inputStream.read(byArray) != 4) {
            throw new IOException("Could not read chunk length.");
        }
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (inputStream.read(byArray) != 4) {
            throw new IOException("Could not read chunk type.");
        }
        int n2 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        byte[] byArray2 = new byte[n];
        if (inputStream.read(byArray2) != n) {
            throw new IOException("Could not read chunk data.");
        }
        if (inputStream.read(byArray) != 4) {
            throw new IOException("Could not read chunk CRC.");
        }
        int n3 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (bl) {
            return PNGChunk.getChunk(n2, byArray2, n3);
        }
        try {
            return PNGChunk.getChunk(n2, byArray2, n3);
        }
        catch (PNGException pNGException) {
            if (PNGChunk.isEssentialChunk(n2)) {
                throw pNGException;
            }
            return null;
        }
    }

    private static PNGChunk getChunk(int n, byte[] byArray, int n2) throws PNGException {
        switch (n) {
            case 1229472850: {
                return new PNGHeader(n, byArray, n2);
            }
            case 1229209940: {
                return new PNGData(n, byArray, n2);
            }
            case 1347179589: {
                return new PNGPalette(n, byArray, n2);
            }
            case 1950960965: {
                return new PNGTime(n, byArray, n2);
            }
            case 1883789683: {
                return new PNGPhys(n, byArray, n2);
            }
            case 1732332865: {
                return new PNGGamma(n, byArray, n2);
            }
            case 1766015824: {
                return new PNGICCProfile(n, byArray, n2);
            }
        }
        return new PNGChunk(n, byArray, n2);
    }

    private static boolean isEssentialChunk(int n) {
        switch (n) {
            case 1229209940: 
            case 1229278788: 
            case 1229472850: 
            case 1347179589: {
                return true;
            }
        }
        return false;
    }

    public boolean isValidChunk() {
        return this.crc == this.calcCRC();
    }

    public int getType() {
        return this.type;
    }

    public void writeChunk(OutputStream outputStream) throws IOException {
        outputStream.write(PNGChunk.getInt(this.data.length));
        outputStream.write(PNGChunk.getInt(this.type));
        outputStream.write(this.data);
        outputStream.write(PNGChunk.getInt(this.calcCRC()));
    }

    public boolean isEmpty() {
        return this.data.length == 0;
    }

    public static byte[] getInt(int n) {
        long l = (long)n & 0xFFFFFFFFL;
        byte[] byArray = new byte[]{(byte)((l & 0xFF000000L) >> 24), (byte)((l & 0xFF0000L) >> 16), (byte)((l & 0xFF00L) >> 8), (byte)l};
        return byArray;
    }

    private int calcCRC() {
        int n;
        long l = 0xFFFFFFFFL;
        byte[] byArray = PNGChunk.getInt(this.type);
        for (n = 0; n < 4; ++n) {
            l = crcTable[((int)l ^ byArray[n]) & 0xFF] ^ l >> 8;
        }
        for (n = 0; n < this.data.length; ++n) {
            l = crcTable[((int)l ^ this.data[n]) & 0xFF] ^ l >> 8;
        }
        return ~((int)l);
    }

    public String toString() {
        return "PNG Chunk. Type: " + new String(PNGChunk.getInt(this.type)) + " , CRC: " + this.crc + " , calculated CRC: " + this.calcCRC();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                if ((l & 1L) == 1L) {
                    l = 0xEDB88320L ^ l >> 1;
                    continue;
                }
                l >>= 1;
            }
            PNGChunk.crcTable[i] = l;
        }
    }
}

