/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SSLSocket;
import gnu.javax.net.ssl.provider.SessionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

class SSLServerSocket
extends javax.net.ssl.SSLServerSocket {
    private SessionContext sessions;
    private SortedSet enabledProtocols;
    private List enabledSuites;
    private boolean clientMode;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private boolean createSessions;
    private SRPTrustManager srpTrustManager;
    private X509TrustManager trustManager;
    private X509KeyManager keyManager;
    private SecureRandom random;

    private /* synthetic */ void finit$() {
        this.enabledProtocols = new TreeSet(SSLSocket.supportedProtocols);
        this.enabledSuites = new ArrayList(SSLSocket.supportedSuites);
        this.clientMode = false;
        this.needClientAuth = false;
        this.wantClientAuth = false;
        this.createSessions = true;
    }

    SSLServerSocket() throws IOException {
        this.finit$();
    }

    SSLServerSocket(int n) throws IOException {
        super(n);
        this.finit$();
    }

    SSLServerSocket(int n, int n2) throws IOException {
        super(n, n2);
        this.finit$();
    }

    SSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
        this.finit$();
    }

    public String[] getSupportedCipherSuites() {
        return (String[])CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public String[] getEnabledCipherSuites() {
        List list2 = this.enabledSuites;
        synchronized (list2) {
            try {
                String[] stringArray = new String[this.enabledSuites.size()];
                int n = 0;
                String[] stringArray2 = this.enabledSuites.iterator();
                while (stringArray2.hasNext()) {
                    stringArray[n++] = stringArray2.next().toString();
                }
                stringArray2 = stringArray;
                Object var5_5 = null;
                return stringArray2;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (CipherSuite.forName(stringArray[i]) != null) continue;
            throw new IllegalArgumentException("unsupported suite: " + stringArray[i]);
        }
        List list2 = this.enabledSuites;
        synchronized (list2) {
            try {
                this.enabledSuites.clear();
                for (int i = 0; i < stringArray.length; ++i) {
                    CipherSuite cipherSuite = CipherSuite.forName(stringArray[i]);
                    if (this.enabledSuites.contains(cipherSuite)) continue;
                    this.enabledSuites.add(cipherSuite);
                }
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
        }
    }

    public String[] getSupportedProtocols() {
        return new String[]{"SSLv3", "TLSv1", "TLSv1.1"};
    }

    public String[] getEnabledProtocols() {
        SortedSet sortedSet = this.enabledProtocols;
        synchronized (sortedSet) {
            try {
                String[] stringArray = new String[this.enabledProtocols.size()];
                int n = 0;
                String[] stringArray2 = this.enabledProtocols.iterator();
                while (stringArray2.hasNext()) {
                    stringArray[n++] = stringArray2.next().toString();
                }
                stringArray2 = stringArray;
                Object var5_5 = null;
                return stringArray2;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    public void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("SSLv3") || stringArray[i].equalsIgnoreCase("TLSv1") || stringArray[i].equalsIgnoreCase("TLSv1.1")) continue;
            throw new IllegalArgumentException("unsupported protocol: " + stringArray[i]);
        }
        SortedSet sortedSet = this.enabledProtocols;
        synchronized (sortedSet) {
            try {
                this.enabledProtocols.clear();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equalsIgnoreCase("SSLv3")) {
                        this.enabledProtocols.add(ProtocolVersion.SSL_3);
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("TLSv1")) {
                        this.enabledProtocols.add(ProtocolVersion.TLS_1);
                        continue;
                    }
                    this.enabledProtocols.add(ProtocolVersion.TLS_1_1);
                }
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
        }
    }

    public void setUseClientMode(boolean bl) {
        this.clientMode = bl;
    }

    public boolean getUseClientMode() {
        return this.clientMode;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setEnabledSessionCreation(boolean bl) {
        this.setEnableSessionCreation(bl);
    }

    public void setEnableSessionCreation(boolean bl) {
        this.createSessions = bl;
    }

    public boolean getEnableSessionCreation() {
        return this.createSessions;
    }

    public Socket accept() throws IOException {
        SSLSocket sSLSocket = new SSLSocket();
        this.implAccept(sSLSocket);
        sSLSocket.setUseClientMode(this.clientMode);
        sSLSocket.setNeedClientAuth(this.needClientAuth);
        sSLSocket.setWantClientAuth(this.wantClientAuth);
        sSLSocket.setEnableSessionCreation(this.createSessions);
        sSLSocket.setSessionContext(this.sessions);
        sSLSocket.setEnabledCipherSuites(new ArrayList(this.enabledSuites));
        sSLSocket.setEnabledProtocols(new TreeSet(this.enabledProtocols));
        sSLSocket.setSRPTrustManager(this.srpTrustManager);
        sSLSocket.setTrustManager(this.trustManager);
        sSLSocket.setKeyManager(this.keyManager);
        sSLSocket.setRandom(this.random);
        return sSLSocket;
    }

    void setSessionContext(SessionContext sessionContext) {
        this.sessions = sessionContext;
    }

    void setKeyManager(X509KeyManager x509KeyManager) {
        this.keyManager = x509KeyManager;
    }

    void setTrustManager(X509TrustManager x509TrustManager) {
        this.trustManager = x509TrustManager;
    }

    void setSRPTrustManager(SRPTrustManager sRPTrustManager) {
        this.srpTrustManager = sRPTrustManager;
    }

    void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }
}

