/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNamedNodeMap;
import gnu.xml.dom.DomNode;
import gnu.xml.dom.DomNsNode;
import java.util.HashSet;
import java.util.Set;
import javax.xml.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class DomElement
extends DomNsNode
implements Element {
    Set userIdAttrs;
    private DomNamedNodeMap attributes;
    String xmlSpace;

    private /* synthetic */ void finit$() {
        this.xmlSpace = "";
    }

    protected DomElement(DomDocument domDocument, String string, String string2) {
        super((short)1, domDocument, string, string2);
        this.finit$();
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new DomNamedNodeMap(this, 2);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.length != 0;
    }

    public Object clone() {
        DomElement domElement = (DomElement)super.clone();
        if (this.attributes != null) {
            domElement.attributes = new DomNamedNodeMap(domElement, 2);
            DomNode domNode = this.attributes.first;
            while (domNode != null) {
                domElement.attributes.setNamedItemNS(domNode.cloneNode(true));
                domNode = domNode.next;
            }
        }
        return domElement;
    }

    void setOwner(DomDocument domDocument) {
        if (this.attributes != null) {
            DomNode domNode = this.attributes.first;
            while (domNode != null) {
                domNode.setOwner(domDocument);
                domNode = domNode.next;
            }
        }
        super.setOwner(domDocument);
    }

    public void makeReadonly() {
        super.makeReadonly();
        if (this.attributes != null) {
            this.attributes.makeReadonly();
        }
    }

    public final String getTagName() {
        return this.getNodeName();
    }

    public String getAttribute(String string) {
        if ("xml:space" == string) {
            return this.xmlSpace;
        }
        Attr attr = this.getAttributeNode(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2) != null;
    }

    public String getAttributeNS(String string, String string2) {
        Attr attr = this.getAttributeNodeNS(string, string2);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    public void setAttribute(String string, String string2) {
        Attr attr = this.getAttributeNode(string);
        if (attr != null) {
            attr.setNodeValue(string2);
            ((DomAttr)attr).setSpecified(true);
            return;
        }
        attr = this.owner.createAttribute(string);
        attr.setNodeValue(string2);
        this.setAttributeNode(attr);
    }

    public void setAttributeNS(String string, String string2, String string3) {
        if (("xmlns".equals(string2) || string2.startsWith("xmlns:")) && !XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(string)) {
            throw new DomDOMException(14, "setting xmlns attribute to illegal value", this, 0);
        }
        Attr attr = this.getAttributeNodeNS(string, string2);
        if (attr != null) {
            attr.setNodeValue(string3);
            return;
        }
        attr = this.owner.createAttributeNS(string, string2);
        attr.setNodeValue(string3);
        this.setAttributeNodeNS(attr);
    }

    public Attr setAttributeNode(Attr attr) {
        return (Attr)this.getAttributes().setNamedItem(attr);
    }

    public Attr setAttributeNodeNS(Attr attr) {
        return (Attr)this.getAttributes().setNamedItemNS(attr);
    }

    public void removeAttribute(String string) {
        block3: {
            if (this.attributes == null) {
                return;
            }
            try {
                this.attributes.removeNamedItem(string);
            }
            catch (DomDOMException domDOMException) {
                if (domDOMException.code == 8) break block3;
                throw domDOMException;
            }
        }
    }

    public Attr removeAttributeNode(Attr attr) {
        if (this.attributes == null) {
            throw new DomDOMException(8, null, attr, 0);
        }
        return (Attr)this.attributes.removeNamedItem(attr.getNodeName());
    }

    public void removeAttributeNS(String string, String string2) {
        if (this.attributes == null) {
            throw new DomDOMException(8, string2, null, 0);
        }
        this.attributes.removeNamedItemNS(string, string2);
    }

    public String lookupPrefix(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.getNamespaceURI();
        if (string2 != null && string2.equals(string)) {
            return this.getPrefix();
        }
        if (this.attributes != null) {
            DomNode domNode = this.attributes.first;
            while (domNode != null) {
                String string3;
                if (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(domNode.getNamespaceURI()) && (string3 = domNode.getNodeValue()).equals(string)) {
                    return domNode.getLocalName();
                }
                domNode = domNode.next;
            }
        }
        return super.lookupPrefix(string);
    }

    public boolean isDefaultNamespace(String string) {
        String string2 = this.getNamespaceURI();
        if (string2 != null && string2.equals(string)) {
            return this.getPrefix() == null;
        }
        if (this.attributes != null) {
            DomNode domNode = this.attributes.first;
            while (domNode != null) {
                if (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(domNode.getNamespaceURI())) {
                    String string3 = domNode.getNodeName();
                    return XMLConstants.XMLNS_ATTRIBUTE.equals(string3);
                }
                domNode = domNode.next;
            }
        }
        return super.isDefaultNamespace(string);
    }

    public String lookupNamespaceURI(String string) {
        String string2 = this.getNamespaceURI();
        if (string2 != null && this.equal(string, this.getPrefix())) {
            return string2;
        }
        if (this.attributes != null) {
            DomNode domNode = this.attributes.first;
            while (domNode != null) {
                if (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(domNode.getNamespaceURI()) && (string == null ? XMLConstants.XMLNS_ATTRIBUTE.equals(domNode.getNodeName()) : string.equals(domNode.getLocalName()))) {
                    return domNode.getNodeValue();
                }
                domNode = domNode.next;
            }
        }
        return super.lookupNamespaceURI(string);
    }

    public String getBaseURI() {
        Node node2;
        if (this.attributes != null && (node2 = this.attributes.getNamedItemNS("http://www.w3.org/XML/1998/namespace", "base")) != null) {
            return node2.getNodeValue();
        }
        return super.getBaseURI();
    }

    public TypeInfo getSchemaTypeInfo() {
        DomDoctype domDoctype = (DomDoctype)this.owner.getDoctype();
        if (domDoctype != null) {
            return domDoctype.getElementTypeInfo(this.getNodeName());
        }
        return null;
    }

    public void setIdAttribute(String string, boolean bl) {
        NamedNodeMap namedNodeMap = this.getAttributes();
        Attr attr = (Attr)namedNodeMap.getNamedItem(string);
        this.setIdAttributeNode(attr, bl);
    }

    public void setIdAttributeNode(Attr attr, boolean bl) {
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        if (attr == null || attr.getOwnerElement() != this) {
            throw new DomDOMException(8);
        }
        if (bl) {
            if (this.userIdAttrs == null) {
                this.userIdAttrs = new HashSet();
            }
            this.userIdAttrs.add(attr);
        } else if (this.userIdAttrs != null) {
            this.userIdAttrs.remove(attr);
            if (this.userIdAttrs.isEmpty()) {
                this.userIdAttrs = null;
            }
        }
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) {
        NamedNodeMap namedNodeMap = this.getAttributes();
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(string, string2);
        this.setIdAttributeNode(attr, bl);
    }

    public boolean isEqualNode(Node node2) {
        if (!super.isEqualNode(node2)) {
            return false;
        }
        this.getAttributes();
        NamedNodeMap namedNodeMap = node2.getAttributes();
        int n = namedNodeMap.getLength();
        if (namedNodeMap == null || n != this.attributes.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Node node3 = namedNodeMap.item(i);
            if (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(node3.getNamespaceURI())) continue;
            DomNode domNode = this.attributes.first;
            while (domNode != null && (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(domNode.getNamespaceURI()) || !domNode.isEqualNode(node3))) {
                domNode = domNode.next;
            }
            if (domNode != null) continue;
            return false;
        }
        return true;
    }
}

