/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class NonPositiveIntegerType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};

    NonPositiveIntegerType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger"), TypeLibrary.INTEGER);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        if (n == 0) {
            throw new DatatypeException(0, "invalid non-positive integer value");
        }
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '0') continue;
            if (c >= '1' && c <= '9') {
                if (!bl) continue;
                throw new DatatypeException(i, "invalid non-positive integer value");
            }
            if (c == '+' && i == 0) continue;
            if (c == '-' && i == 0) {
                bl = false;
                continue;
            }
            throw new DatatypeException(i, "invalid non-positive integer value");
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

