/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.Annotation;
import gnu.xml.validation.datatype.Facet;
import gnu.xml.validation.datatype.FractionDigitsFacet;
import gnu.xml.validation.datatype.LengthFacet;
import gnu.xml.validation.datatype.MaxExclusiveFacet;
import gnu.xml.validation.datatype.MaxInclusiveFacet;
import gnu.xml.validation.datatype.MaxLengthFacet;
import gnu.xml.validation.datatype.MinExclusiveFacet;
import gnu.xml.validation.datatype.MinInclusiveFacet;
import gnu.xml.validation.datatype.MinLengthFacet;
import gnu.xml.validation.datatype.PatternFacet;
import gnu.xml.validation.datatype.TotalDigitsFacet;
import gnu.xml.validation.datatype.Type;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import javax.xml.namespace.QName;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;

public class SimpleType
extends Type
implements Datatype {
    public static final int ANY = 0;
    public static final int ATOMIC = 1;
    public static final int LIST = 2;
    public static final int UNION = 3;
    public static final int ID_TYPE_NULL = 0;
    public static final int ID_TYPE_ID = 1;
    public static final int ID_TYPE_IDREF = 2;
    public static final int ID_TYPE_IDREFS = 3;
    public final int variety;
    public Set facets;
    public int fundamentalFacets;
    public final SimpleType baseType;
    public final Annotation annotation;

    public SimpleType(QName qName, int n, Set set, int n2, SimpleType simpleType, Annotation annotation) {
        super(qName);
        this.variety = n;
        this.facets = set;
        this.fundamentalFacets = n2;
        this.baseType = simpleType;
        this.annotation = annotation;
    }

    public boolean isValid(String string, ValidationContext validationContext) {
        try {
            this.checkValid(string, validationContext);
            return true;
        }
        catch (DatatypeException datatypeException) {
            return false;
        }
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        if (this.facets != null && !this.facets.isEmpty()) {
            Object object = this.createValue(string, validationContext);
            Iterator iterator = this.facets.iterator();
            block14: while (iterator.hasNext()) {
                Facet facet = (Facet)iterator.next();
                switch (facet.type) {
                    case 1: {
                        LengthFacet lengthFacet = (LengthFacet)facet;
                        if (string.length() == lengthFacet.value) continue block14;
                        throw new DatatypeException("invalid length");
                    }
                    case 2: {
                        MinLengthFacet minLengthFacet = (MinLengthFacet)facet;
                        if (string.length() >= minLengthFacet.value) continue block14;
                        throw new DatatypeException("invalid minimum length");
                    }
                    case 3: {
                        MaxLengthFacet maxLengthFacet = (MaxLengthFacet)facet;
                        if (string.length() <= maxLengthFacet.value) continue block14;
                        throw new DatatypeException("invalid maximum length");
                    }
                    case 4: {
                        PatternFacet patternFacet = (PatternFacet)facet;
                        Matcher matcher = patternFacet.value.matcher(string);
                        if (matcher.find()) continue block14;
                        throw new DatatypeException("invalid match for pattern");
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        MaxInclusiveFacet maxInclusiveFacet = (MaxInclusiveFacet)facet;
                        if (maxInclusiveFacet.matches(object)) continue block14;
                        throw new DatatypeException("beyond upper bound");
                    }
                    case 8: {
                        MaxExclusiveFacet maxExclusiveFacet = (MaxExclusiveFacet)facet;
                        if (maxExclusiveFacet.matches(object)) continue block14;
                        throw new DatatypeException("beyond upper bound");
                    }
                    case 9: {
                        MinExclusiveFacet minExclusiveFacet = (MinExclusiveFacet)facet;
                        if (minExclusiveFacet.matches(object)) continue block14;
                        throw new DatatypeException("beyond lower bound");
                    }
                    case 10: {
                        MinInclusiveFacet minInclusiveFacet = (MinInclusiveFacet)facet;
                        if (minInclusiveFacet.matches(object)) continue block14;
                        throw new DatatypeException("beyond lower bound");
                    }
                    case 11: {
                        TotalDigitsFacet totalDigitsFacet = (TotalDigitsFacet)facet;
                        if (SimpleType.countDigits(string, true) <= totalDigitsFacet.value) continue block14;
                        throw new DatatypeException("too many digits");
                    }
                    case 12: {
                        FractionDigitsFacet fractionDigitsFacet = (FractionDigitsFacet)facet;
                        if (SimpleType.countDigits(string, false) <= fractionDigitsFacet.value) break;
                        throw new DatatypeException("too many fraction digits");
                    }
                }
            }
        }
    }

    private static int countDigits(String string, boolean bl) {
        int n = 0;
        int n2 = string.length();
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                bl2 = true;
                continue;
            }
            if (c < '0' || c > '9' || !bl && !bl2) continue;
            ++n;
        }
        return n;
    }

    public DatatypeStreamingValidator createStreamingValidator(ValidationContext validationContext) {
        throw new UnsupportedOperationException();
    }

    public Object createValue(String string, ValidationContext validationContext) {
        return string;
    }

    public boolean sameValue(Object object, Object object2) {
        return object.equals(object2);
    }

    public int valueHashCode(Object object) {
        return object.hashCode();
    }

    public int getIdType() {
        return 0;
    }

    public boolean isContextDependent() {
        return false;
    }
}

