/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.Serializable;

public class Cursor
implements Serializable {
    static final long serialVersionUID = 8028237497568985504L;
    public static final int DEFAULT_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    private static String[] NAMES = new String[]{"Default Cursor", "Crosshair Cursor", "Text Cursor", "Wait Cursor", "Southwest Resize Cursor", "Southeast Resize Cursor", "Northwest Resize Cursor", "Northeast Resize Cursor", "North Resize Cursor", "South Resize Cursor", "West Resize Cursor", "East Resize Cursor", "Hand Cursor", "Move Cursor"};
    public static final int CUSTOM_CURSOR = -1;
    private static final int PREDEFINED_COUNT = 14;
    protected static Cursor[] predefined = new Cursor[14];
    protected String name;
    int type;

    public Cursor(int n) {
        if (n < 0 || n >= 14) {
            throw new IllegalArgumentException("invalid cursor " + n);
        }
        this.type = n;
        this.name = NAMES[n];
    }

    protected Cursor(String string) {
        this.name = string;
        this.type = -1;
    }

    public static Cursor getPredefinedCursor(int n) {
        if (n < 0 || n >= 14) {
            throw new IllegalArgumentException("invalid cursor " + n);
        }
        if (predefined[n] == null) {
            Cursor.predefined[n] = new Cursor(n);
        }
        return predefined[n];
    }

    public static Cursor getSystemCustomCursor(String string) throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return null;
    }

    public static Cursor getDefaultCursor() {
        return Cursor.getPredefinedCursor(0);
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass() + "[type=" + this.getType() + ",name=" + this.getName() + "]";
    }
}

