/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.Calendar;
import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants,
Cloneable {
    private static final int KNOWN_SIZE = 1;
    private static final int KNOWN_CSIZE = 2;
    private static final int KNOWN_CRC = 4;
    private static final int KNOWN_TIME = 8;
    private static final int KNOWN_EXTRA = 16;
    private static Calendar cal;
    private String name;
    private int size;
    private long compressedSize;
    private int crc;
    private int dostime;
    private short known;
    private short method;
    private byte[] extra;
    private String comment;
    int flags;
    int offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private /* synthetic */ void finit$() {
        this.compressedSize = -1;
        this.known = 0;
        this.method = (short)-1;
        this.extra = null;
        this.comment = null;
    }

    public ZipEntry(String string) {
        this.finit$();
        int n = string.length();
        if (n > 65535) {
            throw new IllegalArgumentException("name length is " + n);
        }
        this.name = string;
    }

    public ZipEntry(ZipEntry zipEntry) {
        this(zipEntry, zipEntry.name);
    }

    ZipEntry(ZipEntry zipEntry, String string) {
        this.finit$();
        this.name = string;
        this.known = zipEntry.known;
        this.size = zipEntry.size;
        this.compressedSize = zipEntry.compressedSize;
        this.crc = zipEntry.crc;
        this.dostime = zipEntry.dostime;
        this.method = zipEntry.method;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
    }

    final void setDOSTime(int n) {
        this.dostime = n;
        this.known = (short)(this.known | 8);
    }

    final int getDOSTime() {
        if ((this.known & 8) == 0) {
            return 0;
        }
        return this.dostime;
    }

    public Object clone() {
        try {
            ZipEntry zipEntry = (ZipEntry)super.clone();
            if (this.extra != null) {
                zipEntry.extra = (byte[])this.extra.clone();
            }
            return zipEntry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long l) {
        Calendar calendar;
        Calendar calendar2 = calendar = ZipEntry.getCalendar();
        synchronized (calendar2) {
            try {
                calendar.setTimeInMillis(l);
                this.dostime = (calendar.get(1) - 1980 & 0x7F) << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
            }
            finally {
                Object var5_4 = null;
            }
            this.known = (short)(this.known | 8);
            return;
        }
    }

    public long getTime() {
        this.parseExtra();
        if ((this.known & 8) == 0) {
            return -1;
        }
        int n = 2 * (this.dostime & 0x1F);
        int n2 = this.dostime >> 5 & 0x3F;
        int n3 = this.dostime >> 11 & 0x1F;
        int n4 = this.dostime >> 16 & 0x1F;
        int n5 = (this.dostime >> 21 & 0xF) - 1;
        int n6 = (this.dostime >> 25 & 0x7F) + 1980;
        try {
            Calendar calendar = cal = ZipEntry.getCalendar();
            synchronized (calendar) {
                try {
                    cal.set(n6, n5, n4, n3, n2, n);
                    long l = cal.getTimeInMillis();
                    Object var10_10 = null;
                    return l;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    throw throwable;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.known = (short)(this.known & 0xFFFFFFF7);
            long l = -1;
            return l;
        }
    }

    private static synchronized Calendar getCalendar() {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        return cal;
    }

    public void setSize(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.size = (int)l;
        this.known = (short)(this.known | 1);
    }

    public long getSize() {
        if ((this.known & 1) != 0) {
            return (long)this.size & 0xFFFFFFFFL;
        }
        return -1;
    }

    public void setCompressedSize(long l) {
        this.compressedSize = l;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCrc(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.crc = (int)l;
        this.known = (short)(this.known | 4);
    }

    public long getCrc() {
        if ((this.known & 4) != 0) {
            return (long)this.crc & 0xFFFFFFFFL;
        }
        return -1;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException();
        }
        this.method = (short)n;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] byArray) {
        if (byArray == null) {
            this.extra = null;
            return;
        }
        if (byArray.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = byArray;
    }

    private void parseExtra() {
        if ((this.known & 0x10) != 0) {
            return;
        }
        if (this.extra == null) {
            this.known = (short)(this.known | 0x10);
            return;
        }
        try {
            int n;
            for (int i = 0; i < this.extra.length; i += n) {
                byte by;
                int n2 = this.extra[i++] & 0xFF | (this.extra[i++] & 0xFF) << 8;
                n = this.extra[i++] & 0xFF | (this.extra[i++] & 0xFF) << 8;
                if (n2 != 21589 || ((by = this.extra[i]) & 1) == 0) continue;
                long l = this.extra[i + 1] & 0xFF | (this.extra[i + 2] & 0xFF) << 8 | (this.extra[i + 3] & 0xFF) << 16 | (this.extra[i + 4] & 0xFF) << 24;
                this.setTime(l);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.known = (short)(this.known | 0x10);
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String string) {
        if (string != null && string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        int n = this.name.length();
        return n > 0 && this.name.charAt(n - 1) == '/';
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

