/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ComponentInputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.basic.SharedUIDefaults;

public class BasicMenuBarUI
extends MenuBarUI {
    protected ChangeListener changeListener = this.createChangeListener();
    protected ContainerListener containerListener = this.createContainerListener();
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler(this);
    protected JMenuBar menuBar;
    private MouseInputListener mouseListener = new MouseInputHandler(this);

    protected ChangeListener createChangeListener() {
        return new ChangeHandler(this);
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuBarUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
        this.menuBar.setOpaque(true);
    }

    protected void installKeyboardActions() {
        Object[] objectArray = (Object[])SharedUIDefaults.get("MenuBar.windowBindings");
        ComponentInputMap componentInputMap = LookAndFeel.makeComponentInputMap(this.menuBar, objectArray);
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, componentInputMap);
        SwingUtilities.replaceUIActionMap(this.menuBar, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("MenuBar.actionMap");
        if (actionMap == null) {
            actionMap = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("MenuBar.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        FocusAction focusAction = new FocusAction();
        actionMapUIResource.put(focusAction.getValue("Name"), focusAction);
        return actionMapUIResource;
    }

    protected void installListeners() {
        this.menuBar.addContainerListener(this.containerListener);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
        this.menuBar.addMouseListener(this.mouseListener);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.menuBar = (JMenuBar)jComponent;
        this.menuBar.setLayout(new BoxLayout(this.menuBar, 0));
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void uninstallDefaults() {
        this.menuBar.setBackground(null);
        this.menuBar.setBorder(null);
        this.menuBar.setFont(null);
        this.menuBar.setForeground(null);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, null);
        SwingUtilities.replaceUIActionMap(this.menuBar, null);
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        this.menuBar.removeMouseListener(this.mouseListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicMenuBarUI this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            MenuElement[] menuElementArray = this.this$0.menuBar.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                JMenu jMenu = this.this$0.menuBar.getMenu(i);
                if (jMenu == null) continue;
                jMenu.setSelected(false);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        MouseInputHandler(BasicMenuBarUI basicMenuBarUI) {
            this.this$0 = basicMenuBarUI;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicMenuBarUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("borderPainted")) {
                this.this$0.menuBar.repaint();
            }
            if (propertyChangeEvent.getPropertyName().equals("margin")) {
                this.this$0.menuBar.repaint();
            }
        }

        PropertyChangeHandler(BasicMenuBarUI basicMenuBarUI) {
            this.this$0 = basicMenuBarUI;
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private /* synthetic */ BasicMenuBarUI this$0;

        public void componentAdded(ContainerEvent containerEvent) {
            this.this$0.menuBar.revalidate();
            this.this$0.menuBar.repaint();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            this.this$0.menuBar.revalidate();
            this.this$0.menuBar.repaint();
        }

        ContainerHandler(BasicMenuBarUI basicMenuBarUI) {
            this.this$0 = basicMenuBarUI;
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private /* synthetic */ BasicMenuBarUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
        }

        ChangeHandler(BasicMenuBarUI basicMenuBarUI) {
            this.this$0 = basicMenuBarUI;
        }
    }

    private static class FocusAction
    extends AbstractAction {
        FocusAction() {
            super("takeFocus");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuBar jMenuBar = (JMenuBar)actionEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = jMenuBar.getMenu(0);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }
    }
}

