/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.NotImplementedException;
import gnu.javax.swing.tree.GnuPath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;

public class BasicTreeUI
extends TreeUI {
    static int WAIT_TILL_EDITING = 900;
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected Dimension preferredMinSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    boolean isEditing;
    TreePath currentVisiblePath;
    int gap;
    int maxHeight;
    Color hashColor;
    PropertyChangeListener propertyChangeListener;
    FocusListener focusListener;
    TreeSelectionListener treeSelectionListener;
    MouseListener mouseListener;
    KeyListener keyListener;
    PropertyChangeListener selectionModelPropertyChangeListener;
    ComponentListener componentListener;
    CellEditorListener cellEditorListener;
    TreeExpansionListener treeExpansionListener;
    TreeModelListener treeModelListener;
    Timer startEditTimer;
    static Icon nullIcon;
    static final MouseEvent EDIT;

    private /* synthetic */ void finit$() {
        this.gap = 4;
    }

    public BasicTreeUI() {
        this.finit$();
        this.validCachedPreferredSize = false;
        this.drawingCache = new Hashtable();
        this.nodeDimensions = this.createNodeDimensions();
        this.configureLayoutCache();
        this.editingRow = -1;
        this.lastSelectedRow = -1;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTreeUI();
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    public void setLeftChildIndent(int n) {
        this.leftChildIndent = n;
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int n) {
        this.rightChildIndent = n;
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean bl) {
        if (bl != this.largeModel) {
            this.tree.removeComponentListener(this.componentListener);
            this.largeModel = bl;
            this.tree.addComponentListener(this.componentListener);
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int n) {
        if (n == 0) {
            n = this.getMaxHeight(this.tree);
        }
        this.treeState.setRowHeight(n);
    }

    protected int getRowHeight() {
        return this.tree.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.completeEditing();
        this.updateRenderer();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected TreeCellRenderer getCellRenderer() {
        if (this.currentCellRenderer != null) {
            return this.currentCellRenderer;
        }
        return this.createDefaultCellRenderer();
    }

    protected void setModel(TreeModel treeModel) {
        this.completeEditing();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.treeModel = this.tree.getModel();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (this.treeState != null) {
            this.treeState.setModel(this.treeModel);
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    protected boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    protected void setShowsRootHandles(boolean bl) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean getShowsRootHandles() {
        return this.tree.getShowsRootHandles();
    }

    protected void setCellEditor(TreeCellEditor treeCellEditor) {
        this.cellEditor = treeCellEditor;
        this.createdCellEditor = true;
    }

    protected TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    protected void setEditable(boolean bl) {
        this.tree.setEditable(bl);
    }

    protected boolean isEditable() {
        return this.tree.isEditable();
    }

    protected void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (treeSelectionModel != null) {
            this.treeSelectionModel = treeSelectionModel;
            this.tree.setSelectionModel(this.treeSelectionModel);
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        return this.treeState.getBounds(treePath, new Rectangle());
    }

    int getMaxHeight(JTree jTree) {
        if (this.maxHeight != 0) {
            return this.maxHeight;
        }
        Icon icon = UIManager.getIcon("Tree.openIcon");
        Icon icon2 = UIManager.getIcon("Tree.closedIcon");
        Icon icon3 = UIManager.getIcon("Tree.leafIcon");
        int n = this.getRowCount(jTree);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = this.isLeaf(i) ? icon3.getIconHeight() : (jTree.isExpanded(i) ? icon.getIconHeight() : icon2.getIconHeight());
            this.maxHeight = Math.max(this.maxHeight, n2 + this.gap);
        }
        this.treeState.setRowHeight(this.maxHeight);
        return this.maxHeight;
    }

    Icon getNodeIcon(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (this.treeModel.isLeaf(object)) {
            return UIManager.getIcon("Tree.leafIcon");
        }
        if (this.treeState.getExpandedState(treePath)) {
            return UIManager.getIcon("Tree.openIcon");
        }
        return UIManager.getIcon("Tree.closedIcon");
    }

    public TreePath getPathForRow(JTree jTree, int n) {
        return this.treeState.getPathForRow(n);
    }

    public int getRowForPath(JTree jTree, TreePath treePath) {
        return this.treeState.getRowForPath(treePath);
    }

    public int getRowCount(JTree jTree) {
        return this.treeState.getRowCount();
    }

    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        return this.treeState.getPathClosestTo(n, n2);
    }

    public boolean isEditing(JTree jTree) {
        return this.isEditing;
    }

    public boolean stopEditing(JTree jTree) {
        if (this.isEditing(jTree)) {
            this.completeEditing(false, false, true);
            this.finish();
        }
        return this.isEditing(jTree) ^ true;
    }

    public void cancelEditing(JTree jTree) {
        this.completeEditing(false, false, false);
        this.finish();
    }

    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        this.startEditing(treePath, null);
    }

    public TreePath getEditingPath(JTree jTree) {
        return this.editingPath;
    }

    protected void prepareForUIInstall() {
        this.lastSelectedRow = -1;
        this.preferredSize = new Dimension();
        this.largeModel = this.tree.isLargeModel();
        this.preferredSize = new Dimension();
        this.setModel(this.tree.getModel());
    }

    protected void completeUIInstall() {
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.updateRenderer();
        this.updateDepthOffset();
        this.setSelectionModel(this.tree.getSelectionModel());
        this.configureLayoutCache();
        this.treeState.setRootVisible(this.tree.isRootVisible());
        this.treeSelectionModel.setRowMapper(this.treeState);
        this.updateSize();
    }

    protected void completeUIUninstall() {
        this.tree = null;
    }

    protected void installComponents() {
        this.currentCellRenderer = this.createDefaultCellRenderer();
        this.rendererPane = this.createCellRendererPane();
        this.createdRenderer = true;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(this);
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return new SelectionModelPropertyChangeHandler(this);
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler(this);
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler(this);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler(this);
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler(this);
    }

    protected AbstractLayoutCache createLayoutCache() {
        return new VariableHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        DefaultTreeCellEditor defaultTreeCellEditor = this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer ? new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer) : new DefaultTreeCellEditor(this.tree, null);
        return defaultTreeCellEditor;
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler(this);
    }

    protected void uninstallListeners() {
        this.tree.removePropertyChangeListener(this.propertyChangeListener);
        this.tree.removeFocusListener(this.focusListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeKeyListener(this.keyListener);
        this.tree.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.removeComponentListener(this.componentListener);
        this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        TreeCellEditor treeCellEditor = this.tree.getCellEditor();
        if (treeCellEditor != null) {
            treeCellEditor.removeCellEditorListener(this.cellEditorListener);
        }
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
    }

    protected void uninstallKeyboardActions() {
        this.tree.getInputMap(1).setParent(null);
        this.tree.getActionMap().setParent(null);
    }

    protected void uninstallComponents() {
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.createdRenderer = false;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected int getVerticalLegBuffer() {
        return this.getRowHeight() / 2;
    }

    protected int getHorizontalLegBuffer() {
        return this.rightChildIndent / 2;
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void updateExpandedDescendants(TreePath treePath) {
        Enumeration enumeration = this.tree.getExpandedDescendants(treePath);
        while (enumeration.hasMoreElements()) {
            this.treeState.setExpandedState((TreePath)enumeration.nextElement(), true);
        }
    }

    protected TreePath getLastChildPath(TreePath treePath) {
        return (TreePath)treePath.getLastPathComponent();
    }

    protected void updateDepthOffset() {
        this.depthOffset += this.getVerticalLegBuffer();
    }

    protected void updateCellEditor() {
        if (this.tree.isEditable() && this.cellEditor == null) {
            this.setCellEditor(this.createDefaultCellEditor());
        }
        this.createdCellEditor = true;
    }

    protected void updateRenderer() {
        if (this.tree != null) {
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            if (treeCellRenderer != null) {
                this.createdRenderer = false;
                this.currentCellRenderer = treeCellRenderer;
                if (this.createdCellEditor) {
                    this.tree.setCellEditor(null);
                }
            } else {
                this.tree.setCellRenderer(this.createDefaultCellRenderer());
                this.createdRenderer = true;
            }
        } else {
            this.currentCellRenderer = null;
            this.createdRenderer = false;
        }
        this.updateCellEditor();
    }

    protected void configureLayoutCache() {
        this.treeState = this.createLayoutCache();
        this.treeState.setNodeDimensions(this.nodeDimensions);
    }

    protected void updateSize() {
        this.preferredSize = null;
        this.updateCachedPreferredSize();
        this.tree.treeDidChange();
    }

    protected void updateCachedPreferredSize() {
        this.validCachedPreferredSize = false;
    }

    protected void pathWasExpanded(TreePath treePath) {
        this.validCachedPreferredSize = false;
        this.treeState.setExpandedState(treePath, true);
        this.tree.repaint();
    }

    protected void pathWasCollapsed(TreePath treePath) {
        this.validCachedPreferredSize = false;
        this.treeState.setExpandedState(treePath, false);
        this.tree.repaint();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tree, "Tree.background", "Tree.foreground", "Tree.font");
        this.hashColor = UIManager.getColor("Tree.hash");
        if (this.hashColor == null) {
            this.hashColor = Color.black;
        }
        this.tree.setOpaque(true);
        this.rightChildIndent = UIManager.getInt("Tree.rightChildIndent");
        this.leftChildIndent = UIManager.getInt("Tree.leftChildIndent");
        this.totalChildIndent = this.rightChildIndent + this.leftChildIndent;
        this.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        this.tree.setRowHeight(this.getRowHeight());
        this.tree.setScrollsOnExpand(UIManager.getBoolean("Tree.scrollsOnExpand"));
        this.setExpandedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.setCollapsedIcon(UIManager.getIcon("Tree.collapsedIcon"));
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)SharedUIDefaults.get("Tree.focusInputMap");
        SwingUtilities.replaceUIInputMap(this.tree, 0, inputMap);
        InputMap inputMap2 = (InputMap)SharedUIDefaults.get("Tree.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.tree, 1, inputMap2);
        SwingUtilities.replaceUIActionMap(this.tree, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Tree.actionMap");
        if (actionMap == null) {
            actionMap = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("Tree.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        AbstractAction abstractAction = new TreeHomeAction(this, -1, "selectFirst");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(this, -1, "selectFirstChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(this, -1, "selectFirstExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(this, 1, "selectLast");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(this, 1, "selectLastChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(this, 1, "selectLastExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(this, -1, "selectPrevious");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(this, -1, "selectPreviousExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(this, -1, "selectPreviousChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(this, 1, "selectNext");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(this, 1, "selectNextExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(this, 1, "selectNextChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeTraverseAction(this, -1, "selectParent");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeTraverseAction(this, 1, "selectChild");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeToggleAction(this, "toggleAndAnchor");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(this, -1, "scrollUpChangeSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(this, -1, "scrollUpExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(this, -1, "scrollUpChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(this, 1, "scrollDownChangeSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(this, 1, "scrollDownExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(this, 1, "scrollDownChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeStartEditingAction(this, "startEditing");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeCancelEditingAction(this, "cancel");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        return actionMapUIResource;
    }

    private int convertModifiers(int n) {
        if ((n & 0x40) != 0) {
            n |= 1;
            n &= 0xFFFFFFBF;
        }
        if ((n & 0x80) != 0) {
            n |= 2;
            n &= 0xFFFFFF7F;
        }
        if ((n & 0x100) != 0) {
            n |= 4;
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x200) != 0) {
            n |= 8;
            n &= 0xFFFFFDFF;
        }
        if ((n & 0x2000) != 0) {
            n |= 0x20;
            n &= 0xFFFFDFFF;
        }
        return n;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.tree.addPropertyChangeListener(this.propertyChangeListener);
        this.focusListener = this.createFocusListener();
        this.tree.addFocusListener(this.focusListener);
        this.treeSelectionListener = this.createTreeSelectionListener();
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.mouseListener = this.createMouseListener();
        this.tree.addMouseListener(this.mouseListener);
        this.keyListener = this.createKeyListener();
        this.tree.addKeyListener(this.keyListener);
        this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener();
        if (this.treeSelectionModel != null && this.selectionModelPropertyChangeListener != null) {
            this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        this.componentListener = this.createComponentListener();
        this.tree.addComponentListener(this.componentListener);
        this.treeExpansionListener = this.createTreeExpansionListener();
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        this.treeModelListener = this.createTreeModelListener();
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        this.cellEditorListener = this.createCellEditorListener();
    }

    public void installUI(JComponent jComponent) {
        this.tree = (JTree)jComponent;
        this.prepareForUIInstall();
        this.installDefaults();
        this.installComponents();
        this.installKeyboardActions();
        this.installListeners();
        this.completeUIInstall();
    }

    protected void uninstallDefaults() {
        this.tree.setFont(null);
        this.tree.setForeground(null);
        this.tree.setBackground(null);
    }

    public void uninstallUI(JComponent jComponent) {
        this.completeEditing();
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        int n = this.treeState.getRowCount();
        if (n == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = jTree.getInsets();
        if (rectangle != null && this.treeModel != null) {
            Object object;
            int n2;
            int n3 = jTree.getClosestRowForLocation(rectangle.x, rectangle.y);
            int n4 = jTree.getClosestRowForLocation(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            if (n4 < n) {
                for (n2 = n4 + 1; n2 < n; ++n2) {
                    object = this.treeState.getPathForRow(n2);
                    if (!this.isLastChild((TreePath)object)) continue;
                    this.paintVerticalPartOfLeg(graphics, rectangle, insets, (TreePath)object);
                }
            }
            n2 = n4 - n3 + 1;
            object = new Rectangle[n2];
            boolean[] blArray = new boolean[n2];
            boolean[] blArray2 = new boolean[n2];
            TreePath[] treePathArray = new TreePath[n2];
            int n5 = 0;
            int n6 = n3;
            while (n6 <= n4) {
                treePathArray[n5] = this.treeState.getPathForRow(n6);
                blArray[n5] = this.treeModel.isLeaf(treePathArray[n5].getLastPathComponent());
                blArray2[n5] = jTree.isExpanded(treePathArray[n5]);
                object[n5] = this.getPathBounds(jTree, treePathArray[n5]);
                this.paintHorizontalPartOfLeg(graphics, rectangle, insets, object[n5], treePathArray[n5], n6, blArray2[n5], false, blArray[n5]);
                if (this.isLastChild(treePathArray[n5])) {
                    this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePathArray[n5]);
                }
                ++n6;
                ++n5;
            }
            n5 = 0;
            n6 = n3;
            while (n6 <= n4) {
                this.paintRow(graphics, rectangle, insets, object[n5], treePathArray[n5], n6, blArray2[n5], false, blArray[n5]);
                ++n6;
                ++n5;
            }
        }
    }

    private boolean isLastChild(TreePath treePath) {
        int n;
        if (treePath instanceof GnuPath) {
            return ((GnuPath)treePath).isLastChild;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return false;
        }
        int n2 = this.treeState.getVisibleChildCount(treePath2);
        return n2 - 1 == (n = this.treeModel.getIndexOfChild(treePath2, treePath.getLastPathComponent()));
    }

    protected void ensureRowsAreVisible(int n, int n2) {
        int n3;
        if (n < n2) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        for (n3 = n; n3 < n2; ++n3) {
            TreePath treePath = this.getPathForRow(this.tree, n3);
            if (this.tree.isVisible(treePath)) continue;
            this.tree.makeVisible(treePath);
        }
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return this.getPreferredSize(this.tree);
        }
        return this.preferredMinSize;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, false);
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        if (!this.validCachedPreferredSize) {
            Rectangle rectangle = this.tree.getBounds();
            this.preferredSize = new Dimension(this.treeState.getPreferredWidth(rectangle), this.treeState.getPreferredHeight());
            this.validCachedPreferredSize = true;
        }
        return this.preferredSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        this.preferredMinSize = this.getPreferredSize(jComponent);
        return this.preferredMinSize;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void completeEditing() {
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        TreeCellEditor treeCellEditor;
        if (!this.isEditing(this.tree)) {
            return;
        }
        if (bl) {
            this.getCellEditor().stopCellEditing();
            this.stopEditingInCompleteEditing = true;
        }
        if (bl2) {
            this.getCellEditor().cancelCellEditing();
            this.stopEditingInCompleteEditing = true;
        }
        if (bl3 && (treeCellEditor = this.getCellEditor()) != null) {
            Object object = treeCellEditor.getCellEditorValue();
            this.treeModel.valueForPathChanged(this.tree.getLeadSelectionPath(), object);
        }
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        this.updateCellEditor();
        TreeCellEditor treeCellEditor = this.getCellEditor();
        if (treeCellEditor != null && (mouseEvent == EDIT || treeCellEditor.shouldSelectCell(mouseEvent)) && treeCellEditor.isCellEditable(mouseEvent)) {
            Rectangle rectangle = this.getPathBounds(this.tree, treePath);
            rectangle.width = this.tree.getWidth() - rectangle.x;
            this.editingPath = treePath;
            this.editingRow = this.tree.getRowForPath(this.editingPath);
            Object object = this.editingPath.getLastPathComponent();
            this.stopEditingInCompleteEditing = false;
            boolean bl = this.tree.isExpanded(this.editingPath);
            this.isEditing = true;
            this.editingComponent = treeCellEditor.getTreeCellEditorComponent(this.tree, object, true, bl, this.isLeaf(this.editingRow), this.editingRow);
            this.tree.removeAll();
            Container container = this.editingComponent.getParent();
            container.setBounds(rectangle);
            this.tree.add(container);
            this.editingComponent.requestFocus();
            return true;
        }
        return false;
    }

    protected void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        if (this.isLocationInExpandControl(treePath, n, n2)) {
            this.handleExpandControlClick(treePath, n, n2);
        }
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        boolean bl = false;
        if (!this.treeModel.isLeaf(treePath.getLastPathComponent())) {
            Icon icon = this.getExpandedIcon();
            int n3 = icon != null ? icon.getIconWidth() : 18;
            Insets insets = this.tree.getInsets();
            int n4 = this.isRootVisible() ? treePath.getPathCount() - 1 : treePath.getPathCount() - 2;
            int n5 = this.getRowX(this.tree.getRowForPath(treePath), n4) - n3 + insets.left;
            bl = n >= n5 && n <= n5 + n3;
        }
        return bl;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        this.toggleExpandState(treePath);
    }

    protected void toggleExpandState(TreePath treePath) {
        if (this.treeState.isExpanded(treePath)) {
            this.tree.collapsePath(treePath);
        } else {
            this.tree.expandPath(treePath);
        }
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return this.tree.getSelectionModel().getSelectionMode() != 1 && (mouseEvent.getModifiersEx() & 0x80) != 0;
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        return this.tree.getSelectionModel().getSelectionMode() != 1 && (mouseEvent.getModifiersEx() & 0x40) != 0;
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        int n;
        boolean bl = false;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && (n = this.tree.getToggleClickCount()) > 0 && mouseEvent.getClickCount() == n) {
            bl = true;
        }
        return bl;
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isToggleSelectionEvent(mouseEvent)) {
            if (this.tree.isPathSelected(treePath)) {
                this.tree.removeSelectionPath(treePath);
            } else {
                this.tree.addSelectionPath(treePath);
                this.tree.setAnchorSelectionPath(treePath);
            }
        } else if (this.isMultiSelectEvent(mouseEvent)) {
            TreePath treePath2 = this.tree.getAnchorSelectionPath();
            if (treePath2 != null) {
                int n = this.getRowForPath(this.tree, treePath2);
                this.tree.addSelectionInterval(n, this.getRowForPath(this.tree, treePath));
            } else {
                this.tree.addSelectionPath(treePath);
            }
        } else {
            this.tree.setSelectionPath(treePath);
            if (this.isToggleEvent(mouseEvent)) {
                this.toggleExpandState(treePath);
            }
        }
    }

    protected boolean isLeaf(int n) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        return this.treeModel.isLeaf(object);
    }

    boolean hasControlIcons() {
        return this.expandedIcon != null || this.collapsedIcon != null;
    }

    Icon getCurrentControlIcon(TreePath treePath) {
        if (this.hasControlIcons()) {
            if (this.tree.isExpanded(treePath)) {
                return this.expandedIcon;
            }
            return this.collapsedIcon;
        }
        if (nullIcon == null) {
            nullIcon = new Icon(this){
                private /* synthetic */ BasicTreeUI this$0;
                {
                    this.this$0 = basicTreeUI;
                }

                public int getIconHeight() {
                    return 0;
                }

                public int getIconWidth() {
                    return 0;
                }

                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                }
            };
        }
        return nullIcon;
    }

    Object getParent(Object object, Object object2) {
        if (object == null || object2 == null || object.equals(object2)) {
            return null;
        }
        if (object2 instanceof TreeNode) {
            return ((TreeNode)object2).getParent();
        }
        return this.findNode(object, object2);
    }

    private Object findNode(Object object, Object object2) {
        if (!this.treeModel.isLeaf(object) && !object.equals(object2)) {
            int n = this.treeModel.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object3 = this.treeModel.getChild(object, i);
                if (object2.equals(object3)) {
                    return object;
                }
                Object object4 = this.findNode(object3, object2);
                if (object4 == null) continue;
                return object4;
            }
        }
        return null;
    }

    void selectPath(JTree jTree, TreePath treePath) {
        if (treePath != null) {
            jTree.setSelectionPath(treePath);
            jTree.setLeadSelectionPath(treePath);
            jTree.makeVisible(treePath);
            jTree.scrollPathToVisible(treePath);
        }
    }

    Object[] getPathToRoot(Object object, int n) {
        if (object == null) {
            if (n == 0) {
                return null;
            }
            return new Object[n];
        }
        Object[] objectArray = this.getPathToRoot(this.getParent(this.treeModel.getRoot(), object), n + 1);
        objectArray[objectArray.length - n - 1] = object;
        return objectArray;
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        graphics.drawLine(n, n2, n, n3);
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        graphics.drawLine(n2, n, n3, n);
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        n2 -= icon.getIconHeight() / 2;
        if ((n -= icon.getIconWidth() / 2) < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        icon.paintIcon(component, graphics, n, n2);
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        for (int i = n2; i < n3; i += 2) {
            graphics.drawLine(i, n, i + 1, n);
        }
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        for (int i = n2; i < n3; i += 2) {
            graphics.drawLine(n, i, n, i + 1);
        }
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.shouldPaintExpandControl(treePath, n, bl, bl2, bl3)) {
            Icon icon = this.getCurrentControlIcon(treePath);
            int n2 = icon.getIconWidth();
            int n3 = rectangle2.x - n2 - this.gap;
            icon.paintIcon(this.tree, graphics, n3, rectangle2.y + rectangle2.height / 2 - icon.getIconHeight() / 2);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (n != 0) {
            this.paintHorizontalLine(graphics, this.tree, rectangle2.y + rectangle2.height / 2, rectangle2.x - this.leftChildIndent - this.gap, rectangle2.x - this.gap);
        }
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        boolean bl;
        Rectangle rectangle2 = this.getPathBounds(this.tree, treePath);
        TreePath treePath2 = treePath.getParentPath();
        if (this.isRootVisible()) {
            bl = treePath2 != null;
        } else {
            boolean bl2 = bl = treePath2 != null && treePath2.getPathCount() > 1;
        }
        if (bl) {
            Rectangle rectangle3 = this.getPathBounds(this.tree, treePath2);
            this.paintVerticalLine(graphics, this.tree, rectangle3.x + 2 * this.gap, rectangle3.y + rectangle3.height / 2, rectangle2.y + rectangle2.height / 2);
        }
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.tree.isPathSelected(treePath);
        boolean bl5 = false;
        Object object = treePath.getLastPathComponent();
        this.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        TreeCellRenderer treeCellRenderer = this.currentCellRenderer;
        boolean bl6 = false;
        if (this.treeSelectionModel != null) {
            bl6 = this.treeSelectionModel.getLeadSelectionRow() == n && this.tree.isFocusOwner();
        }
        Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, object, bl4, bl, bl3, n, bl6);
        this.rendererPane.paintComponent(graphics, component, component.getParent(), rectangle2);
    }

    protected void prepareForUIUninstall() {
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object = treePath.getLastPathComponent();
        return !bl3 && this.hasControlIcons();
    }

    void finish() {
        this.treeState.invalidatePathBounds(this.treeState.getPathForRow(this.editingRow));
        this.editingPath = null;
        this.editingRow = -1;
        this.stopEditingInCompleteEditing = false;
        this.isEditing = false;
        Rectangle rectangle = this.editingComponent.getParent().getBounds();
        this.tree.removeAll();
        this.validCachedPreferredSize = false;
        this.tree.repaint(rectangle);
        this.editingComponent = null;
        this.tree.requestFocus();
    }

    protected int getRowX(int n, int n2) {
        return n2 * this.totalChildIndent;
    }

    static {
        EDIT = new MouseEvent(new Label(), 7, 7, 7, 7, 7, 7, false);
    }

    public class TreeTraverseAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;
        protected int direction;

        public TreeTraverseAction(BasicTreeUI basicTreeUI, int n, String string) {
            this.this$0 = basicTreeUI;
            this.direction = n;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = this.this$0.tree.getLeadSelectionPath();
            if (treePath == null) {
                return;
            }
            String string = (String)this.getValue("Name");
            if (string.equals("selectParent")) {
                if (treePath == null) {
                    return;
                }
                if (this.this$0.tree.isExpanded(treePath)) {
                    this.this$0.tree.collapsePath(treePath);
                } else {
                    TreePath treePath2 = treePath.getParentPath();
                    if (treePath2 != null && (treePath2.getPathCount() != 1 || this.this$0.tree.isRootVisible())) {
                        this.this$0.tree.setSelectionPath(treePath2);
                    }
                }
            } else if (string.equals("selectChild")) {
                Object object = treePath.getLastPathComponent();
                int n = this.this$0.treeModel.getChildCount(object);
                if (n == 0 || this.this$0.treeState.isExpanded(treePath)) {
                    int n2 = this.this$0.tree.getLeadSelectionRow() + 1;
                    if (n2 <= this.this$0.tree.getRowCount()) {
                        this.this$0.tree.setSelectionRow(n2);
                    }
                } else {
                    this.this$0.tree.expandPath(treePath);
                }
            }
            this.this$0.tree.scrollPathToVisible(this.this$0.tree.getLeadSelectionPath());
        }

        public boolean isEnabled() {
            return this.this$0.tree != null && this.this$0.tree.isEnabled();
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeToggleAction(BasicTreeUI basicTreeUI, String string) {
            this.this$0 = basicTreeUI;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.this$0.tree.getLeadSelectionRow();
            if (n != -1 && this.this$0.isLeaf(n)) {
                TreePath treePath = this.this$0.tree.getAnchorSelectionPath();
                TreePath treePath2 = this.this$0.tree.getLeadSelectionPath();
                this.this$0.toggleExpandState(this.this$0.getPathForRow(this.this$0.tree, n));
                this.this$0.tree.setLeadSelectionPath(treePath2);
                this.this$0.tree.setAnchorSelectionPath(treePath);
                this.this$0.tree.scrollPathToVisible(this.this$0.tree.getLeadSelectionPath());
            }
        }

        public boolean isEnabled() {
            return this.this$0.tree != null && this.this$0.tree.isEnabled();
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeSelectionHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath;
            TreePath treePath2;
            if (this.this$0.tree.isEditing()) {
                this.this$0.tree.cancelEditing();
            }
            if ((treePath2 = treeSelectionEvent.getOldLeadSelectionPath()) != (treePath = treeSelectionEvent.getNewLeadSelectionPath())) {
                Rectangle rectangle = this.this$0.treeState.getBounds(treeSelectionEvent.getOldLeadSelectionPath(), new Rectangle());
                Rectangle rectangle2 = this.this$0.treeState.getBounds(treeSelectionEvent.getNewLeadSelectionPath(), new Rectangle());
                if (rectangle != null) {
                    this.this$0.tree.repaint(rectangle);
                }
                if (rectangle2 != null) {
                    this.this$0.tree.repaint(rectangle2);
                }
            }
        }
    }

    public class TreePageAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;
        protected int direction;

        public TreePageAction(BasicTreeUI basicTreeUI, int n, String string) {
            this.this$0 = basicTreeUI;
            this.direction = n;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            boolean bl;
            String string = (String)this.getValue("Name");
            boolean bl2 = string.equals("scrollUpExtendSelection") || string.equals("scrollDownExtendSelection");
            boolean bl3 = bl = string.equals("scrollUpChangeSelection") || string.equals("scrollDownChangeSelection");
            if (!bl2 && !bl && this.this$0.tree.getSelectionModel().getSelectionMode() != 4) {
                bl = true;
            }
            if ((n = this.this$0.getRowCount(this.this$0.tree)) > 0 && this.this$0.treeSelectionModel != null) {
                Dimension dimension = this.this$0.tree.getSize();
                TreePath treePath = this.this$0.tree.getLeadSelectionPath();
                TreePath treePath2 = null;
                Rectangle rectangle = this.this$0.tree.getVisibleRect();
                if (this.direction == -1) {
                    treePath2 = this.this$0.getClosestPathForLocation(this.this$0.tree, rectangle.x, rectangle.y);
                    if (treePath2.equals(treePath)) {
                        rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                        treePath2 = this.this$0.getClosestPathForLocation(this.this$0.tree, rectangle.x, rectangle.y);
                    }
                } else {
                    rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                    treePath2 = this.this$0.getClosestPathForLocation(this.this$0.tree, rectangle.x, rectangle.y);
                    if (treePath2.equals(treePath)) {
                        rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                        treePath2 = this.this$0.getClosestPathForLocation(this.this$0.tree, rectangle.x, rectangle.y);
                    }
                }
                Rectangle rectangle2 = this.this$0.getPathBounds(this.this$0.tree, treePath2);
                rectangle2.x = rectangle.x;
                rectangle2.width = rectangle.width;
                if (this.direction == -1) {
                    rectangle2.height = rectangle.height;
                } else {
                    rectangle2.y -= rectangle.height - rectangle2.height;
                    rectangle2.height = rectangle.height;
                }
                if (bl2) {
                    TreePath treePath3 = this.this$0.tree.getAnchorSelectionPath();
                    if (treePath3 == null) {
                        this.this$0.tree.setSelectionPath(treePath2);
                    } else {
                        int n2 = this.this$0.getRowForPath(this.this$0.tree, treePath2);
                        int n3 = this.this$0.getRowForPath(this.this$0.tree, treePath3);
                        this.this$0.tree.setSelectionInterval(Math.min(n3, n2), Math.max(n3, n2));
                        this.this$0.tree.setAnchorSelectionPath(treePath3);
                        this.this$0.tree.setLeadSelectionPath(treePath2);
                    }
                } else if (bl) {
                    this.this$0.tree.setSelectionPath(treePath2);
                } else {
                    this.this$0.tree.setLeadSelectionPath(treePath2);
                }
                this.this$0.tree.scrollRectToVisible(rectangle2);
            }
        }

        public boolean isEnabled() {
            return this.this$0.tree != null && this.this$0.tree.isEnabled();
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeModelHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.treeState.treeNodesChanged(treeModelEvent);
            this.this$0.tree.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.treeState.treeNodesInserted(treeModelEvent);
            this.this$0.tree.repaint();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.treeState.treeNodesRemoved(treeModelEvent);
            this.this$0.tree.repaint();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getPath().length == 1 && !treeModelEvent.getPath()[0].equals(this.this$0.treeModel.getRoot())) {
                this.this$0.tree.expandPath(new TreePath(this.this$0.treeModel.getRoot()));
            }
            this.this$0.validCachedPreferredSize = false;
            this.this$0.treeState.treeStructureChanged(treeModelEvent);
            this.this$0.tree.repaint();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;
        protected int direction;

        public TreeIncrementAction(BasicTreeUI basicTreeUI, int n, String string) {
            this.this$0 = basicTreeUI;
            this.direction = n;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = this.this$0.tree.getLeadSelectionPath();
            int n = treePath != null ? this.this$0.treeState.getRowForPath(treePath) : 0;
            int n2 = this.this$0.treeState.getRowCount();
            int n3 = n + 1;
            int n4 = n - 1;
            boolean bl = n3 < n2;
            boolean bl2 = n4 >= 0 && n2 > 0;
            String string = (String)this.getValue("Name");
            if (string.equals("selectPreviousChangeLead") && bl2) {
                TreePath treePath2 = this.this$0.treeState.getPathForRow(n4);
                this.this$0.tree.setSelectionPath(treePath2);
                this.this$0.tree.setAnchorSelectionPath(treePath2);
                this.this$0.tree.setLeadSelectionPath(treePath2);
            } else if (string.equals("selectPreviousExtendSelection") && bl2) {
                TreePath treePath3 = this.this$0.treeState.getPathForRow(n4);
                if (this.this$0.tree.isPathSelected(treePath3)) {
                    this.this$0.tree.getSelectionModel().removeSelectionPath(treePath);
                }
                this.this$0.tree.addSelectionPath(treePath3);
                this.this$0.tree.setLeadSelectionPath(treePath3);
            } else if (string.equals("selectPrevious") && bl2) {
                TreePath treePath4 = this.this$0.treeState.getPathForRow(n4);
                this.this$0.tree.setSelectionPath(treePath4);
            } else if (string.equals("selectNext") && bl) {
                TreePath treePath5 = this.this$0.treeState.getPathForRow(n3);
                this.this$0.tree.setSelectionPath(treePath5);
            } else if (string.equals("selectNextExtendSelection") && bl) {
                TreePath treePath6 = this.this$0.treeState.getPathForRow(n3);
                if (this.this$0.tree.isPathSelected(treePath6)) {
                    this.this$0.tree.getSelectionModel().removeSelectionPath(treePath);
                }
                this.this$0.tree.addSelectionPath(treePath6);
                this.this$0.tree.setLeadSelectionPath(treePath6);
            } else if (string.equals("selectNextChangeLead") && bl) {
                TreePath treePath7 = this.this$0.treeState.getPathForRow(n3);
                this.this$0.tree.setSelectionPath(treePath7);
                this.this$0.tree.setAnchorSelectionPath(treePath7);
                this.this$0.tree.setLeadSelectionPath(treePath7);
            }
            this.this$0.tree.scrollPathToVisible(this.this$0.tree.getLeadSelectionPath());
        }

        public boolean isEnabled() {
            return this.this$0.tree != null && this.this$0.tree.isEnabled();
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;
        protected int direction;

        public TreeHomeAction(BasicTreeUI basicTreeUI, int n, String string) {
            this.this$0 = basicTreeUI;
            this.direction = n;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.tree != null) {
                String string = (String)this.getValue("Name");
                if (string.equals("selectFirst")) {
                    this.this$0.ensureRowsAreVisible(0, 0);
                    this.this$0.tree.setSelectionInterval(0, 0);
                }
                if (string.equals("selectFirstChangeLead")) {
                    this.this$0.ensureRowsAreVisible(0, 0);
                    this.this$0.tree.setLeadSelectionPath(this.this$0.getPathForRow(this.this$0.tree, 0));
                }
                if (string.equals("selectFirstExtendSelection")) {
                    this.this$0.ensureRowsAreVisible(0, 0);
                    TreePath treePath = this.this$0.tree.getAnchorSelectionPath();
                    if (treePath == null) {
                        this.this$0.tree.setSelectionInterval(0, 0);
                    } else {
                        int n = this.this$0.getRowForPath(this.this$0.tree, treePath);
                        this.this$0.tree.setSelectionInterval(0, n);
                        this.this$0.tree.setAnchorSelectionPath(treePath);
                        this.this$0.tree.setLeadSelectionPath(this.this$0.getPathForRow(this.this$0.tree, 0));
                    }
                } else if (string.equals("selectLast")) {
                    int n = this.this$0.getRowCount(this.this$0.tree) - 1;
                    this.this$0.ensureRowsAreVisible(n, n);
                    this.this$0.tree.setSelectionInterval(n, n);
                } else if (string.equals("selectLastChangeLead")) {
                    int n = this.this$0.getRowCount(this.this$0.tree) - 1;
                    this.this$0.ensureRowsAreVisible(n, n);
                    this.this$0.tree.setLeadSelectionPath(this.this$0.getPathForRow(this.this$0.tree, n));
                } else if (string.equals("selectLastExtendSelection")) {
                    int n = this.this$0.getRowCount(this.this$0.tree) - 1;
                    this.this$0.ensureRowsAreVisible(n, n);
                    TreePath treePath = this.this$0.tree.getAnchorSelectionPath();
                    if (treePath == null) {
                        this.this$0.tree.setSelectionInterval(n, n);
                    } else {
                        int n2 = this.this$0.getRowForPath(this.this$0.tree, treePath);
                        this.this$0.tree.setSelectionInterval(n, n2);
                        this.this$0.tree.setAnchorSelectionPath(treePath);
                        this.this$0.tree.setLeadSelectionPath(this.this$0.getPathForRow(this.this$0.tree, n));
                    }
                }
            }
            this.this$0.tree.scrollPathToVisible(this.this$0.tree.getLeadSelectionPath());
        }

        public boolean isEnabled() {
            return this.this$0.tree != null && this.this$0.tree.isEnabled();
        }
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeExpansionHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.treeState.setExpandedState(treeExpansionEvent.getPath(), true);
            this.this$0.maxHeight = 0;
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.treeState.setExpandedState(treeExpansionEvent.getPath(), false);
            this.this$0.maxHeight = 0;
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeCancelEditingAction(BasicTreeUI basicTreeUI, String string) {
            this.this$0 = basicTreeUI;
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled() && this.this$0.tree.isEditing()) {
                this.this$0.tree.cancelEditing();
            }
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTreeUI this$0;

        public SelectionModelPropertyChangeHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) throws NotImplementedException {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTreeUI this$0;

        public PropertyChangeHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("rootVisible")) {
                this.this$0.validCachedPreferredSize = false;
                this.this$0.treeState.setRootVisible(this.this$0.tree.isRootVisible());
                this.this$0.tree.repaint();
            } else if (string.equals("selectionModel")) {
                this.this$0.treeSelectionModel = this.this$0.tree.getSelectionModel();
                this.this$0.treeSelectionModel.setRowMapper(this.this$0.treeState);
            } else if (string.equals("model")) {
                this.this$0.setModel(this.this$0.tree.getModel());
            } else if (string.equals("cellRenderer")) {
                this.this$0.setCellRenderer(this.this$0.tree.getCellRenderer());
                if (this.this$0.treeState != null) {
                    this.this$0.treeState.invalidateSizes();
                }
            }
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        private /* synthetic */ BasicTreeUI this$0;

        public NodeDimensionsHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            if (rectangle == null || object == null) {
                return null;
            }
            String string = object.toString();
            Font font = this.this$0.tree.getFont();
            FontMetrics fontMetrics = this.this$0.tree.getToolkit().getFontMetrics(font);
            if (string != null) {
                TreePath treePath = this.this$0.treeState.getPathForRow(n);
                rectangle.x = this.getRowX(n, n2);
                rectangle.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle.width = rectangle.width + this.this$0.getCurrentControlIcon(treePath).getIconWidth() + this.this$0.gap + this.this$0.getNodeIcon(treePath).getIconWidth();
                rectangle.height = this.this$0.getMaxHeight(this.this$0.tree);
                rectangle.y = rectangle.height * n;
            }
            return rectangle;
        }

        protected int getRowX(int n, int n2) {
            return this.this$0.getRowX(n, n2);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicTreeUI this$0;
        protected Component source;
        protected Component destination;

        public MouseInputHandler(BasicTreeUI basicTreeUI, Component component, Component component2, MouseEvent mouseEvent) {
            this.this$0 = basicTreeUI;
            this.source = component;
            this.destination = component2;
        }

        public void mouseClicked(MouseEvent mouseEvent) throws NotImplementedException {
        }

        public void mousePressed(MouseEvent mouseEvent) throws NotImplementedException {
        }

        public void mouseReleased(MouseEvent mouseEvent) throws NotImplementedException {
        }

        public void mouseEntered(MouseEvent mouseEvent) throws NotImplementedException {
        }

        public void mouseExited(MouseEvent mouseEvent) throws NotImplementedException {
        }

        public void mouseDragged(MouseEvent mouseEvent) throws NotImplementedException {
        }

        public void mouseMoved(MouseEvent mouseEvent) throws NotImplementedException {
        }

        protected void removeFromSource() throws NotImplementedException {
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private /* synthetic */ BasicTreeUI this$0;

        static /* synthetic */ BasicTreeUI access$6(MouseHandler mouseHandler, BasicTreeUI basicTreeUI) {
            mouseHandler.this$0 = basicTreeUI;
            return mouseHandler.this$0;
        }

        static BasicTreeUI access$0(MouseHandler mouseHandler) {
            return mouseHandler.this$0;
        }

        public MouseHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.this$0.startEditTimer != null) {
                this.this$0.startEditTimer.stop();
                this.this$0.startEditTimer = null;
            }
            if (this.this$0.tree != null && this.this$0.tree.isEnabled()) {
                int n;
                if (this.this$0.isEditing(this.this$0.tree) && !this.this$0.stopEditing(this.this$0.tree)) {
                    return;
                }
                int n2 = mouseEvent.getX();
                TreePath treePath = this.this$0.getClosestPathForLocation(this.this$0.tree, n2, n = mouseEvent.getY());
                if (treePath != null) {
                    Rectangle rectangle = this.this$0.getPathBounds(this.this$0.tree, treePath);
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        this.this$0.checkForClickInExpandControl(treePath, n2, n);
                    }
                    if (n2 > rectangle.x && n2 <= rectangle.x + rectangle.width) {
                        TreePath treePath2 = this.this$0.tree.getLeadSelectionPath();
                        if (treePath2 != null && treePath2.equals(treePath) && mouseEvent.getClickCount() == 1 && this.this$0.tree.isEditable()) {
                            TreePath treePath3 = treePath;
                            if (this.this$0.startEditTimer != null) {
                                this.this$0.startEditTimer.stop();
                            }
                            this.this$0.startEditTimer = new Timer(WAIT_TILL_EDITING, new ActionListener(this, treePath3){
                                private /* synthetic */ MouseHandler this$1;
                                private /* synthetic */ TreePath val$editPath;
                                {
                                    this.this$1 = mouseHandler;
                                    this.finit$(treePath);
                                }

                                private /* synthetic */ void finit$(TreePath treePath) {
                                    this.val$editPath = treePath;
                                }

                                public void actionPerformed(ActionEvent actionEvent) {
                                    this.this$1.this$0.startEditing(this.val$editPath, EDIT);
                                }
                            });
                            this.this$0.startEditTimer.setRepeats(false);
                            this.this$0.startEditTimer.start();
                        } else if (mouseEvent.getClickCount() == 2) {
                            this.this$0.toggleExpandState(treePath);
                        } else {
                            this.this$0.selectPathForEvent(treePath, mouseEvent);
                        }
                    }
                }
            }
            this.this$0.tree.requestFocusInWindow();
        }

        public void mouseDragged(MouseEvent mouseEvent) throws NotImplementedException {
        }

        public void mouseMoved(MouseEvent mouseEvent) throws NotImplementedException {
        }

        public void mouseReleased(MouseEvent mouseEvent) throws NotImplementedException {
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        private /* synthetic */ BasicTreeUI this$0;
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public KeyHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n;
            char c = Character.toLowerCase(keyEvent.getKeyChar());
            for (n = this.this$0.tree.getLeadSelectionRow() + 1; n < this.this$0.tree.getRowCount(); ++n) {
                if (!this.checkMatch(n, c)) continue;
                this.this$0.tree.setSelectionRow(n);
                this.this$0.tree.scrollRowToVisible(n);
                return;
            }
            for (n = 0; n < this.this$0.tree.getLeadSelectionRow(); ++n) {
                if (!this.checkMatch(n, c)) continue;
                this.this$0.tree.setSelectionRow(n);
                this.this$0.tree.scrollRowToVisible(n);
                return;
            }
        }

        boolean checkMatch(int n, char c) {
            char c2;
            TreePath treePath = this.this$0.treeState.getPathForRow(n);
            String string = treePath.getLastPathComponent().toString();
            return string.length() > 0 && c == Character.toLowerCase(c2 = string.charAt(0));
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicTreeUI this$0;

        public FocusHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.repaintLeadRow();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintLeadRow();
        }

        void repaintLeadRow() {
            TreePath treePath = this.this$0.tree.getLeadSelectionPath();
            if (treePath != null) {
                this.this$0.tree.repaint(this.this$0.tree.getPathBounds(treePath));
            }
        }
    }

    public class CellEditorHandler
    implements CellEditorListener {
        private /* synthetic */ BasicTreeUI this$0;

        public CellEditorHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void editingStopped(ChangeEvent changeEvent) {
            this.this$0.stopEditing(this.this$0.tree);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            this.this$0.cancelEditing(this.this$0.tree);
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        private /* synthetic */ BasicTreeUI this$0;
        protected Timer timer;
        protected JScrollBar scrollBar;

        public ComponentHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = this.getScrollPane();
                if (jScrollPane == null) {
                    this.this$0.updateSize();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            this.this$0.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container container;
            JScrollPane jScrollPane = null;
            for (container = this.this$0.tree.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            if (container instanceof JScrollPane) {
                jScrollPane = (JScrollPane)container;
            }
            return jScrollPane;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                this.this$0.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }

    class TreeStartEditingAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeStartEditingAction(BasicTreeUI basicTreeUI, String string) {
            this.this$0 = basicTreeUI;
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = this.this$0.tree.getLeadSelectionPath();
            if (!this.this$0.tree.isEditing()) {
                this.this$0.tree.startEditingAtPath(treePath);
            }
        }
    }
}

