/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class BoxView
extends CompositeView {
    private int myAxis;
    private boolean[] layoutValid;
    private boolean[] requirementsValid;
    private int[][] spans;
    private int[][] offsets;
    private SizeRequirements[] requirements;
    private int[] span;
    private SizeRequirements[][] childReqs;

    private /* synthetic */ void finit$() {
        this.layoutValid = new boolean[2];
        this.requirementsValid = new boolean[2];
        this.spans = new int[2][];
        this.offsets = new int[2][];
        this.requirements = new SizeRequirements[2];
        this.span = new int[2];
        this.childReqs = new SizeRequirements[2][];
    }

    public BoxView(Element element, int n) {
        super(element);
        this.finit$();
        this.myAxis = n;
        this.layoutValid[0] = false;
        this.layoutValid[1] = false;
        this.span[0] = 0;
        this.span[1] = 0;
        this.requirements[0] = new SizeRequirements();
        this.requirements[1] = new SizeRequirements();
        this.spans[0] = new int[0];
        this.spans[1] = new int[0];
        this.offsets[0] = new int[0];
        this.offsets[1] = new int[0];
    }

    public int getAxis() {
        return this.myAxis;
    }

    public void setAxis(int n) {
        this.myAxis = n;
    }

    public void layoutChanged(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid axis parameter.");
        }
        this.layoutValid[n] = false;
    }

    protected boolean isLayoutValid(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid axis parameter.");
        }
        return this.layoutValid[n];
    }

    protected void paintChild(Graphics graphics, Rectangle rectangle, int n) {
        View view = this.getView(n);
        view.paint(graphics, rectangle);
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3 = 0;
        if (viewArray != null) {
            n3 = viewArray.length;
        }
        int n4 = this.getViewCount();
        int[] nArray = new int[n4 - n2 + n3];
        System.arraycopy(this.spans[0], 0, nArray, 0, n);
        System.arraycopy(this.spans[0], n + n2, nArray, n + n3, n4 - (n + n2));
        this.spans[0] = nArray;
        int[] nArray2 = new int[n4 - n2 + n3];
        System.arraycopy(this.spans[1], 0, nArray2, 0, n);
        System.arraycopy(this.spans[1], n + n2, nArray2, n + n3, n4 - (n + n2));
        this.spans[1] = nArray2;
        int[] nArray3 = new int[n4 - n2 + n3];
        System.arraycopy(this.offsets[0], 0, nArray3, 0, n);
        System.arraycopy(this.offsets[0], n + n2, nArray3, n + n3, n4 - (n + n2));
        this.offsets[0] = nArray3;
        int[] nArray4 = new int[n4 - n2 + n3];
        System.arraycopy(this.offsets[1], 0, nArray4, 0, n);
        System.arraycopy(this.offsets[1], n + n2, nArray4, n + n3, n4 - (n + n2));
        this.offsets[1] = nArray4;
        super.replace(n, n2, viewArray);
        this.layoutValid[0] = false;
        this.requirementsValid[0] = false;
        this.layoutValid[1] = false;
        this.requirementsValid[1] = false;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n = rectangle.x + this.getLeftInset();
        int n2 = rectangle.y + this.getTopInset();
        Rectangle rectangle2 = graphics.getClipBounds();
        Rectangle rectangle3 = new Rectangle();
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            rectangle3.x = n + this.getOffset(0, i);
            rectangle3.y = n2 + this.getOffset(1, i);
            rectangle3.width = this.getSpan(0, i);
            rectangle3.height = this.getSpan(1, i);
            if (!rectangle3.intersects(rectangle2)) continue;
            this.paintChild(graphics, rectangle3, i);
        }
    }

    public float getPreferredSpan(int n) {
        this.updateRequirements(n);
        float f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        return (float)this.requirements[n].preferred + f;
    }

    public float getMaximumSpan(int n) {
        this.updateRequirements(n);
        float f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        return (float)this.requirements[n].maximum + f;
    }

    public float getMinimumSpan(int n) {
        this.updateRequirements(n);
        float f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        return (float)this.requirements[n].minimum + f;
    }

    protected SizeRequirements baselineRequirements(int n, SizeRequirements sizeRequirements) {
        float f;
        int n2;
        this.updateChildRequirements(n);
        SizeRequirements sizeRequirements2 = sizeRequirements;
        if (sizeRequirements2 == null) {
            sizeRequirements2 = new SizeRequirements();
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (n2 = 0; n2 < this.childReqs[n].length; ++n2) {
            float f8 = (float)this.childReqs[n][n2].minimum * this.childReqs[n][n2].alignment;
            float f9 = (float)this.childReqs[n][n2].minimum - f8;
            f2 = Math.max(f8, f2);
            f3 = Math.max(f9, f3);
            f = (float)this.childReqs[n][n2].preferred * this.childReqs[n][n2].alignment;
            float f10 = (float)this.childReqs[n][n2].preferred - f;
            f4 = Math.max(f, f4);
            f5 = Math.max(f10, f5);
            float f11 = (float)this.childReqs[n][n2].maximum * this.childReqs[n][n2].alignment;
            float f12 = (float)this.childReqs[n][n2].maximum - f11;
            f6 = Math.max(f11, f6);
            f7 = Math.max(f12, f7);
        }
        n2 = (int)(f2 + f3);
        int n3 = (int)(f4 + f5);
        int n4 = (int)(f6 + f7);
        f = f4 / (f5 + f4);
        if (Float.isNaN(f)) {
            f = 0.0f;
        }
        sizeRequirements2.alignment = f;
        sizeRequirements2.maximum = n4;
        sizeRequirements2.preferred = n3;
        sizeRequirements2.minimum = n2;
        return sizeRequirements2;
    }

    protected void baselineLayout(int n, int n2, int[] nArray, int[] nArray2) {
        this.updateChildRequirements(n2);
        this.updateRequirements(n2);
        SizeRequirements.calculateAlignedPositions(n, this.requirements[n2], this.childReqs[n2], nArray, nArray2);
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = sizeRequirements;
        if (sizeRequirements2 == null) {
            sizeRequirements2 = new SizeRequirements();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            f += view.getMinimumSpan(n);
            f2 = view.getPreferredSpan(n);
            f3 = view.getMaximumSpan(n);
        }
        sizeRequirements2.minimum = (int)f;
        sizeRequirements2.preferred = (int)f2;
        sizeRequirements2.maximum = (int)f3;
        sizeRequirements2.alignment = 0.5f;
        return sizeRequirements2;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = sizeRequirements;
        if (sizeRequirements2 == null) {
            sizeRequirements2 = new SizeRequirements();
        }
        sizeRequirements2.minimum = 0;
        sizeRequirements2.preferred = 0;
        sizeRequirements2.maximum = 0;
        sizeRequirements2.alignment = 0.5f;
        int n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            sizeRequirements2.minimum = Math.max((int)view.getMinimumSpan(n), sizeRequirements2.minimum);
            sizeRequirements2.preferred = Math.max((int)view.getPreferredSpan(n), sizeRequirements2.preferred);
            sizeRequirements2.maximum = Math.max((int)view.getMaximumSpan(n), sizeRequirements2.maximum);
        }
        return sizeRequirements2;
    }

    protected boolean isBefore(int n, int n2, Rectangle rectangle) {
        boolean bl = false;
        bl = this.myAxis == 0 ? n < rectangle.x : n2 < rectangle.y;
        return bl;
    }

    protected boolean isAfter(int n, int n2, Rectangle rectangle) {
        boolean bl = false;
        bl = this.myAxis == 0 ? n > rectangle.x : n2 > rectangle.y;
        return bl;
    }

    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        View view = null;
        int n3 = this.getViewCount();
        Rectangle rectangle2 = new Rectangle(rectangle);
        for (int i = 0; i < n3; ++i) {
            rectangle2.setBounds(rectangle);
            this.childAllocation(i, rectangle2);
            if (!rectangle2.contains(n, n2)) continue;
            rectangle.setBounds(rectangle2);
            view = this.getView(i);
            break;
        }
        if (view == null && n3 > 0) {
            return this.getView(n3 - 1);
        }
        return view;
    }

    protected void childAllocation(int n, Rectangle rectangle) {
        if (!this.isAllocationValid()) {
            this.layout(rectangle.width, rectangle.height);
        }
        rectangle.x += this.offsets[0][n];
        rectangle.y += this.offsets[1][n];
        rectangle.width = this.spans[0][n];
        rectangle.height = this.spans[1][n];
    }

    protected void layout(int n, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[]{n, n2};
        int n5 = this.getViewCount();
        int n6 = n4 = this.myAxis == 0 ? 1 : 0;
        if (!this.isLayoutValid(n4) || nArray[n4] != this.span[n4]) {
            this.layoutValid[n4] = false;
            this.span[n4] = nArray[n4];
            this.layoutMinorAxis(this.span[n4], n4, this.offsets[n4], this.spans[n4]);
            for (n3 = 0; n3 < n5; ++n3) {
                this.getView(n3).setSize(this.spans[0][n3], this.spans[1][n3]);
            }
            this.layoutValid[n4] = true;
        }
        if (!this.isLayoutValid(this.myAxis) || nArray[this.myAxis] != this.span[this.myAxis]) {
            this.layoutValid[this.myAxis] = false;
            this.span[this.myAxis] = nArray[this.myAxis];
            this.layoutMajorAxis(this.span[this.myAxis], this.myAxis, this.offsets[this.myAxis], this.spans[this.myAxis]);
            for (n3 = 0; n3 < n5; ++n3) {
                this.getView(n3).setSize(this.spans[0][n3], this.spans[1][n3]);
            }
            this.layoutValid[this.myAxis] = true;
        }
        if (!this.layoutValid[this.myAxis]) {
            System.err.println("WARNING: Major axis layout must be valid after layout");
        }
        if (!this.layoutValid[n4]) {
            System.err.println("Minor axis layout must be valid after layout");
        }
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        float f;
        long l = 0L;
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            nArray2[i] = (int)view.getPreferredSpan(n2);
            l = nArray2[i];
        }
        long l2 = (long)n - l;
        float f2 = 0.0f;
        int[] nArray3 = null;
        if (l2 != 0L) {
            long l3 = 0L;
            nArray3 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                int n4;
                View view = this.getView(i);
                if (l2 < 0L) {
                    n4 = (int)view.getMinimumSpan(n2);
                    nArray3[i] = nArray2[i] - n4;
                } else {
                    n4 = (int)view.getMaximumSpan(n2);
                    nArray3[i] = n4 - nArray2[i];
                }
                l3 += (long)n4;
            }
            f = Math.abs(l3 - l);
            f2 = (float)l2 / f;
            f2 = Math.min(f2, 1.0f);
            f2 = Math.max(f2, -1.0f);
        }
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            nArray[i] = n5;
            if (l2 != 0L) {
                f = f2 * (float)nArray3[i];
                int n6 = i;
                nArray2[n6] = nArray2[n6] + Math.round(f);
            }
            n5 = (int)Math.min((long)n5 + (long)nArray2[i], Integer.MAX_VALUE);
        }
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            int n4 = (int)view.getMaximumSpan(n2);
            if (n4 < n) {
                System.err.println("align: " + view);
                float f = view.getAlignment(n2);
                nArray[i] = (int)((float)(n - n4) * f);
                nArray2[i] = n4;
                continue;
            }
            int n5 = (int)view.getMinimumSpan(n2);
            nArray[i] = 0;
            nArray2[i] = Math.max(n5, n);
        }
    }

    protected boolean isAllocationValid() {
        return this.isLayoutValid(0) && this.isLayoutValid(1);
    }

    public int getWidth() {
        return this.span[0];
    }

    public int getHeight() {
        return this.span[1];
    }

    public void setSize(float f, float f2) {
        this.layout((int)f, (int)f2);
    }

    protected int getSpan(int n, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal axis argument");
        }
        return this.spans[n][n2];
    }

    protected int getOffset(int n, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal axis argument");
        }
        return this.offsets[n][n2];
    }

    public float getAlignment(int n) {
        this.updateRequirements(n);
        return this.requirements[n].alignment;
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (bl) {
            this.layoutValid[0] = false;
            this.requirementsValid[0] = false;
        }
        if (bl2) {
            this.layoutValid[1] = false;
            this.requirementsValid[1] = false;
        }
        super.preferenceChanged(view, bl, bl2);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.modelToView(n, shape, bias);
    }

    public int getResizeWeight(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal axis argument");
        }
        int n2 = 1;
        if (n == this.myAxis) {
            n2 = 0;
        }
        return n2;
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Shape shape2 = null;
        if (this.isAllocationValid() && shape != null) {
            shape2 = super.getChildAllocation(n, shape);
        }
        return shape2;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return super.viewToModel(f, f2, shape, biasArray);
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        return super.flipEastAndWestAtEnds(n, bias);
    }

    private void updateChildRequirements(int n) {
        if (!this.isLayoutValid(n)) {
            int n2 = this.getViewCount();
            if (this.childReqs[n] == null || this.childReqs[n].length != n2) {
                this.childReqs[n] = new SizeRequirements[n2];
            }
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                this.childReqs[n][i] = new SizeRequirements((int)view.getMinimumSpan(n), (int)view.getPreferredSpan(n), (int)view.getMaximumSpan(n), view.getAlignment(n));
            }
        }
    }

    private void updateRequirements(int n) {
        if (!this.requirementsValid[n]) {
            this.requirements[n] = n == this.myAxis ? this.calculateMajorAxisRequirements(n, this.requirements[n]) : this.calculateMinorAxisRequirements(n, this.requirements[n]);
            this.requirementsValid[n] = true;
        }
    }
}

