/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.native2ascii;

import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.native2ascii.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Native2ASCII {
    String input;
    String output;
    String encoding;
    boolean reversed;

    private Parser createParser() {
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("native2ascii", true);
        classpathToolParser.setHeader(Messages.getString("Native2ASCII.Usage"));
        classpathToolParser.add(new Option(this, "encoding", Messages.getString("Native2ASCII.EncodingHelp"), Messages.getString("Native2ASCII.EncodingArgName")){
            private /* synthetic */ Native2ASCII this$0;
            {
                this.this$0 = native2ASCII;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                if (this.this$0.encoding != null) {
                    throw new OptionException(Messages.getString("Native2ASCII.EncodingSpecified"));
                }
                this.this$0.encoding = string;
            }
        });
        classpathToolParser.add(new Option(this, "reversed", Messages.getString("Native2ASCII.ReversedHelp")){
            private /* synthetic */ Native2ASCII this$0;
            {
                this.this$0 = native2ASCII;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.reversed = true;
            }
        });
        return classpathToolParser;
    }

    private void run(String[] stringArray) {
        Parser parser = this.createParser();
        parser.parse(stringArray, new HandleFile(this));
        if (this.encoding == null) {
            this.encoding = System.getProperty("file.encoding");
        }
        try {
            String string;
            InputStream inputStream = this.input == null ? System.in : new FileInputStream(this.input);
            OutputStream outputStream = this.output == null ? System.out : new FileOutputStream(this.output);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.encoding));
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, this.encoding)));
            while ((string = bufferedReader.readLine()) != null) {
                StringBuffer stringBuffer = new StringBuffer(string.length() + 80);
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (this.reversed && i + 6 < string.length() && string.charAt(i) == '\\' && string.charAt(i + 1) == 'u') {
                        int n = Integer.parseInt(string.substring(i + 2, i + 6), 16);
                        stringBuffer.append((char)n);
                        i += 5;
                        continue;
                    }
                    if (c <= '\u007f' || this.reversed) {
                        stringBuffer.append(c);
                        continue;
                    }
                    stringBuffer.append("\\u");
                    if (c <= '\u00ff') {
                        stringBuffer.append("00");
                    } else if (c <= '\u0fff') {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(Integer.toHexString(c));
                }
                printWriter.println(stringBuffer.toString());
            }
            bufferedReader.close();
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        new Native2ASCII().run(stringArray);
        String string = System.getProperty("file.encoding");
    }

    private class HandleFile
    extends FileArgumentCallback {
        private /* synthetic */ Native2ASCII this$0;

        public HandleFile(Native2ASCII native2ASCII) {
            this.this$0 = native2ASCII;
        }

        public void notifyFile(String string) throws OptionException {
            if (this.this$0.input == null) {
                this.this$0.input = string;
            } else if (this.this$0.output == null) {
                this.this$0.output = string;
            } else {
                throw new OptionException(Messages.getString("Native2ASCII.TooManyFiles"));
            }
        }
    }
}

