/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools;

import gnu.classpath.tools.MalformedInputEvent;
import gnu.classpath.tools.MalformedInputListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedHashSet;
import java.util.Set;

public class NotifyingInputStreamReader
extends Reader {
    private static final int DEFAULT_INPUT_BUFFER_SIZE = 64;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 64;
    private InputStream in;
    private CharsetDecoder decoder;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    private byte[] readBuffer;
    private int lineNumber = 1;
    private int columnNumber = 0;
    private boolean allInputConsumed = false;
    private boolean decodingFinished = false;
    private boolean flushed = false;
    private Set listeners = new LinkedHashSet();

    public NotifyingInputStreamReader(InputStream in) {
        this(in, System.getProperty("file.encoding", "ISO-8859-1"));
    }

    public NotifyingInputStreamReader(InputStream in, String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        this(in, Charset.forName(charsetName));
    }

    public NotifyingInputStreamReader(InputStream in, Charset charset) {
        this(in, charset.newDecoder());
    }

    public NotifyingInputStreamReader(InputStream in, CharsetDecoder decoder) {
        this.in = in;
        this.decoder = decoder;
        this.charBuffer = CharBuffer.wrap(new char[64]);
        this.charBuffer.position(this.charBuffer.limit());
        this.readBuffer = new byte[64];
        this.byteBuffer = ByteBuffer.wrap(this.readBuffer);
        this.byteBuffer.position(this.byteBuffer.limit());
    }

    public void close() throws IOException {
        this.in.close();
    }

    private void fillCharBuf() throws IOException {
        this.charBuffer.clear();
        block0: while (!this.flushed) {
            CoderResult coderResult;
            int charBufferPositionBefore = this.charBuffer.position();
            if (!this.decodingFinished) {
                coderResult = this.decoder.decode(this.byteBuffer, this.charBuffer, this.allInputConsumed);
                if (this.allInputConsumed) {
                    this.decodingFinished = true;
                }
            } else {
                coderResult = this.decoder.flush(this.charBuffer);
                this.flushed = coderResult.isUnderflow();
            }
            int charBufferPositionAfter = this.charBuffer.position();
            int i = charBufferPositionBefore;
            while (i < charBufferPositionAfter) {
                if ('\n' == this.charBuffer.get(i)) {
                    ++this.lineNumber;
                    this.columnNumber = 0;
                } else {
                    ++this.columnNumber;
                }
                ++i;
            }
            if (coderResult.isOverflow()) break;
            if (coderResult.isUnderflow()) {
                if (this.allInputConsumed) break;
                int nRemainingBytes = 0;
                if (this.byteBuffer.position() > 0) {
                    nRemainingBytes = Math.max(0, this.byteBuffer.limit() - this.byteBuffer.position());
                }
                if (nRemainingBytes > 0) {
                    this.byteBuffer.get(this.readBuffer, 0, nRemainingBytes);
                }
                this.byteBuffer.rewind();
                int nread = this.in.read(this.readBuffer, nRemainingBytes, this.readBuffer.length - nRemainingBytes);
                if (nread < 0) {
                    this.allInputConsumed = true;
                }
                this.byteBuffer.limit(nRemainingBytes + Math.max(0, nread));
                continue;
            }
            if (coderResult.isMalformed()) {
                this.fireMalformedInputEncountered(coderResult.length());
                String replacement = this.decoder.replacement();
                int i2 = 0;
                while (i2 < coderResult.length()) {
                    if (this.charBuffer.remaining() <= replacement.length()) break block0;
                    this.charBuffer.put(replacement);
                    this.byteBuffer.position(this.byteBuffer.position() + 1);
                    ++this.columnNumber;
                    ++i2;
                }
                continue;
            }
            if (coderResult.isUnmappable()) {
                coderResult.throwException();
                continue;
            }
            coderResult.throwException();
        }
        this.charBuffer.flip();
    }

    private void fireMalformedInputEncountered(int length) {
        MalformedInputEvent event = new MalformedInputEvent(this, this.lineNumber, this.columnNumber, length);
        for (MalformedInputListener listener : this.listeners) {
            listener.malformedInputEncountered(event);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int read(char[] cbuf, int offset, int length) throws IOException {
        if (this.flushed) {
            return -1;
        }
        nread = 0;
        ** GOTO lbl13
        {
            copyLen = Math.min(length - nread, this.charBuffer.remaining());
            this.charBuffer.get(cbuf, offset + nread, copyLen);
            nread += copyLen;
            do {
                if (this.charBuffer.hasRemaining() && nread < length) continue block0;
                if (nread >= length) continue;
                this.fillCharBuf();
lbl13:
                // 3 sources

            } while (nread < length && !this.flushed);
        }
        return nread;
    }

    public int read() throws IOException {
        while (!this.flushed) {
            if (this.charBuffer.hasRemaining()) {
                return this.charBuffer.get();
            }
            this.fillCharBuf();
        }
        return -1;
    }

    public boolean ready() {
        return this.charBuffer.hasRemaining() || !this.flushed;
    }

    public void addMalformedInputListener(MalformedInputListener listener) {
        this.listeners.add(listener);
    }

    public void removeMalformedInputListener(MalformedInputListener listener) {
        this.listeners.remove(listener);
    }
}

