/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.doclets;

import com.sun.javadoc.PackageDoc;
import gnu.classpath.tools.doclets.DocletOption;
import gnu.classpath.tools.doclets.InvalidPackageWildcardException;
import gnu.classpath.tools.doclets.PackageMatcher;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class DocletOptionPackageWildcard
extends DocletOption {
    private PackageMatcher packageMatcher;
    private boolean allowAll;
    private boolean specified;

    DocletOptionPackageWildcard(String optionName, boolean allowAll) {
        super(optionName);
        this.allowAll = allowAll;
    }

    public int getLength() {
        return 2;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public boolean set(String[] optionArr) {
        this.specified = true;
        try {
            if (this.allowAll && "all".equals(optionArr[2])) {
                this.packageMatcher = null;
            } else {
                this.packageMatcher = new PackageMatcher();
                StringTokenizer tokenizer = new StringTokenizer(optionArr[2], ":");
                while (tokenizer.hasMoreTokens()) {
                    String packageWildcard = tokenizer.nextToken();
                    this.packageMatcher.addWildcard(packageWildcard);
                }
            }
            return true;
        }
        catch (InvalidPackageWildcardException invalidPackageWildcardException) {
            return false;
        }
    }

    public SortedSet filter(PackageDoc[] packages) {
        if (this.packageMatcher != null) {
            return this.packageMatcher.filter(packages);
        }
        TreeSet<PackageDoc> result = new TreeSet<PackageDoc>();
        int i = 0;
        while (i < packages.length) {
            result.add(packages[i]);
            ++i;
        }
        return result;
    }

    public boolean match(PackageDoc packageDoc) {
        if (this.packageMatcher != null) {
            return this.packageMatcher.match(packageDoc);
        }
        return true;
    }
}

