/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.debug;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.PreciseFilter;
import gnu.java.security.action.GetPropertyAction;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SystemLogger
extends Logger {
    public static final SystemLogger SYSTEM = new SystemLogger();

    static {
        SYSTEM.setFilter(PreciseFilter.GLOBAL);
        String defaults = AccessController.doPrivileged(new GetPropertyAction("gnu.classpath.debug.components"));
        if (defaults != null) {
            StringTokenizer tok = new StringTokenizer(defaults, ",");
            while (tok.hasMoreTokens()) {
                Component c = Component.forName(tok.nextToken());
                if (c != null) {
                    PreciseFilter.GLOBAL.enable(c);
                }
                SYSTEM.log(Level.INFO, "enabled: {0}", c);
            }
        }
    }

    public static SystemLogger getSystemLogger() {
        return SYSTEM;
    }

    private SystemLogger() {
        super("gnu.classpath", null);
    }

    public void logv(Level level, String format, Object ... args) {
        this.log(level, format, args);
    }
}

