/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyboardFocusManager
implements KeyEventDispatcher,
KeyEventPostProcessor {
    public static final int FORWARD_TRAVERSAL_KEYS = 0;
    public static final int BACKWARD_TRAVERSAL_KEYS = 1;
    public static final int UP_CYCLE_TRAVERSAL_KEYS = 2;
    public static final int DOWN_CYCLE_TRAVERSAL_KEYS = 3;
    private static final Set DEFAULT_FORWARD_KEYS;
    private static final Set DEFAULT_BACKWARD_KEYS;
    private static Map currentKeyboardFocusManagers;
    private static Map currentFocusOwners;
    private static Map currentPermanentFocusOwners;
    private static Map currentFocusedWindows;
    private static Map currentActiveWindows;
    private static Map currentFocusCycleRoots;
    private FocusTraversalPolicy defaultPolicy;
    private Set[] defaultFocusKeys = new Set[]{DEFAULT_FORWARD_KEYS, DEFAULT_BACKWARD_KEYS, Collections.EMPTY_SET, Collections.EMPTY_SET};
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    private final ArrayList keyEventDispatchers = new ArrayList();
    private final ArrayList keyEventPostProcessors = new ArrayList();
    private static HashMap focusRequests;

    static {
        HashSet s = new HashSet();
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        DEFAULT_FORWARD_KEYS = Collections.unmodifiableSet(s);
        s = new HashSet();
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 192));
        DEFAULT_BACKWARD_KEYS = Collections.unmodifiableSet(s);
        currentKeyboardFocusManagers = new HashMap();
        currentFocusOwners = new HashMap();
        currentPermanentFocusOwners = new HashMap();
        currentFocusedWindows = new HashMap();
        currentActiveWindows = new HashMap();
        currentFocusCycleRoots = new HashMap();
        focusRequests = new HashMap();
    }

    public static KeyboardFocusManager getCurrentKeyboardFocusManager() {
        ThreadGroup currentGroup = Thread.currentThread().getThreadGroup();
        if (currentKeyboardFocusManagers.get(currentGroup) == null) {
            KeyboardFocusManager.setCurrentKeyboardFocusManager(null);
        }
        return (KeyboardFocusManager)currentKeyboardFocusManagers.get(currentGroup);
    }

    public static void setCurrentKeyboardFocusManager(KeyboardFocusManager m) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AWTPermission("replaceKeyboardFocusManager"));
        }
        ThreadGroup currentGroup = Thread.currentThread().getThreadGroup();
        KeyboardFocusManager manager = m == null ? new DefaultKeyboardFocusManager() : m;
        currentKeyboardFocusManagers.put(currentGroup, manager);
    }

    public Component getFocusOwner() {
        return (Component)this.getObject(currentFocusOwners);
    }

    protected Component getGlobalFocusOwner() {
        return (Component)this.getGlobalObject(currentFocusOwners, true);
    }

    protected void setGlobalFocusOwner(Component owner) {
        if (owner == null || owner.focusable) {
            this.setGlobalObject(currentFocusOwners, owner, "focusOwner");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGlobalFocusOwner() {
        Map map = currentFocusOwners;
        synchronized (map) {
            EventQueue q;
            Component focusOwner = this.getGlobalFocusOwner();
            Component permanentFocusOwner = this.getGlobalPermanentFocusOwner();
            this.setGlobalFocusOwner(null);
            this.setGlobalPermanentFocusOwner(null);
            if (focusOwner != null) {
                q = Toolkit.getDefaultToolkit().getSystemEventQueue();
                if (focusOwner != permanentFocusOwner) {
                    q.postEvent(new FocusEvent(focusOwner, 1005, true));
                } else {
                    q.postEvent(new FocusEvent(focusOwner, 1005, false));
                }
            }
            if (focusOwner != permanentFocusOwner) {
                q = Toolkit.getDefaultToolkit().getSystemEventQueue();
                q.postEvent(new FocusEvent(permanentFocusOwner, 1005, false));
            }
        }
    }

    public Component getPermanentFocusOwner() {
        return (Component)this.getObject(currentPermanentFocusOwners);
    }

    protected Component getGlobalPermanentFocusOwner() {
        return (Component)this.getGlobalObject(currentPermanentFocusOwners, true);
    }

    protected void setGlobalPermanentFocusOwner(Component focusOwner) {
        if (focusOwner == null || focusOwner.focusable) {
            this.setGlobalObject(currentPermanentFocusOwners, focusOwner, "permanentFocusOwner");
        }
    }

    public Window getFocusedWindow() {
        return (Window)this.getObject(currentFocusedWindows);
    }

    protected Window getGlobalFocusedWindow() {
        return (Window)this.getGlobalObject(currentFocusedWindows, true);
    }

    protected void setGlobalFocusedWindow(Window window) {
        if (window == null || window.focusable) {
            this.setGlobalObject(currentFocusedWindows, window, "focusedWindow");
        }
    }

    public Window getActiveWindow() {
        return (Window)this.getObject(currentActiveWindows);
    }

    protected Window getGlobalActiveWindow() {
        return (Window)this.getGlobalObject(currentActiveWindows, true);
    }

    protected void setGlobalActiveWindow(Window window) {
        this.setGlobalObject(currentActiveWindows, window, "activeWindow");
    }

    public FocusTraversalPolicy getDefaultFocusTraversalPolicy() {
        if (this.defaultPolicy == null) {
            this.defaultPolicy = new DefaultFocusTraversalPolicy();
        }
        return this.defaultPolicy;
    }

    public void setDefaultFocusTraversalPolicy(FocusTraversalPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("defaultFocusTraversalPolicy", this.defaultPolicy, policy);
        this.defaultPolicy = policy;
    }

    public void setDefaultFocusTraversalKeys(int id, Set<? extends AWTKeyStroke> keystrokes) {
        String type;
        Set sc;
        Set sb;
        Set sa;
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        if (keystrokes == null) {
            throw new IllegalArgumentException();
        }
        switch (id) {
            case 0: {
                sa = this.defaultFocusKeys[1];
                sb = this.defaultFocusKeys[2];
                sc = this.defaultFocusKeys[3];
                type = "forwardDefaultFocusTraversalKeys";
                break;
            }
            case 1: {
                sa = this.defaultFocusKeys[0];
                sb = this.defaultFocusKeys[2];
                sc = this.defaultFocusKeys[3];
                type = "backwardDefaultFocusTraversalKeys";
                break;
            }
            case 2: {
                sa = this.defaultFocusKeys[0];
                sb = this.defaultFocusKeys[1];
                sc = this.defaultFocusKeys[3];
                type = "upCycleDefaultFocusTraversalKeys";
                break;
            }
            case 3: {
                sa = this.defaultFocusKeys[0];
                sb = this.defaultFocusKeys[1];
                sc = this.defaultFocusKeys[2];
                type = "downCycleDefaultFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = keystrokes.size();
        Iterator<? extends AWTKeyStroke> iter = keystrokes.iterator();
        while (--i >= 0) {
            AWTKeyStroke o = iter.next();
            if (o instanceof AWTKeyStroke && !sa.contains(o) && !sb.contains(o) && !sc.contains(o) && o.keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        keystrokes = Collections.unmodifiableSet(new HashSet<AWTKeyStroke>(keystrokes));
        this.firePropertyChange(type, this.defaultFocusKeys[id], keystrokes);
        this.defaultFocusKeys[id] = keystrokes;
    }

    public Set<AWTKeyStroke> getDefaultFocusTraversalKeys(int id) {
        if (id < 0 || id > 3) {
            throw new IllegalArgumentException();
        }
        return this.defaultFocusKeys[id];
    }

    public Container getCurrentFocusCycleRoot() {
        return (Container)this.getObject(currentFocusCycleRoots);
    }

    protected Container getGlobalCurrentFocusCycleRoot() {
        return (Container)this.getGlobalObject(currentFocusCycleRoots, true);
    }

    public void setGlobalCurrentFocusCycleRoot(Container cycleRoot) {
        this.setGlobalObject(currentFocusCycleRoots, cycleRoot, "currentFocusCycleRoot");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.propertyChangeSupport.addPropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        if (l != null) {
            this.propertyChangeSupport.addPropertyChangeListener(name, l);
        }
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        if (l != null) {
            this.propertyChangeSupport.removePropertyChangeListener(name, l);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String name) {
        return this.propertyChangeSupport.getPropertyChangeListeners(name);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        this.propertyChangeSupport.firePropertyChange(name, o, n);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        if (l != null) {
            this.vetoableChangeSupport.addVetoableChangeListener(l);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (l != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(l);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    public void addVetoableChangeListener(String name, VetoableChangeListener l) {
        if (l != null) {
            this.vetoableChangeSupport.addVetoableChangeListener(name, l);
        }
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener l) {
        if (l != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(name, l);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners(String name) {
        return this.vetoableChangeSupport.getVetoableChangeListeners(name);
    }

    protected void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(name, o, n);
    }

    public void addKeyEventDispatcher(KeyEventDispatcher dispatcher) {
        if (dispatcher != null) {
            this.keyEventDispatchers.add(dispatcher);
        }
    }

    public void removeKeyEventDispatcher(KeyEventDispatcher dispatcher) {
        this.keyEventDispatchers.remove(dispatcher);
    }

    protected List<KeyEventDispatcher> getKeyEventDispatchers() {
        return (List)this.keyEventDispatchers.clone();
    }

    public void addKeyEventPostProcessor(KeyEventPostProcessor postProcessor) {
        if (postProcessor != null) {
            this.keyEventPostProcessors.add(postProcessor);
        }
    }

    public void removeKeyEventPostProcessor(KeyEventPostProcessor postProcessor) {
        this.keyEventPostProcessors.remove(postProcessor);
    }

    protected List<KeyEventPostProcessor> getKeyEventPostProcessors() {
        return (List)this.keyEventPostProcessors.clone();
    }

    public abstract boolean dispatchEvent(AWTEvent var1);

    public final void redispatchEvent(Component target, AWTEvent e) {
        e.isFocusManagerEvent = true;
        target.dispatchEvent(e);
        e.isFocusManagerEvent = false;
    }

    @Override
    public abstract boolean dispatchKeyEvent(KeyEvent var1);

    @Override
    public abstract boolean postProcessKeyEvent(KeyEvent var1);

    public abstract void processKeyEvent(Component var1, KeyEvent var2);

    protected abstract void enqueueKeyEvents(long var1, Component var3);

    protected abstract void dequeueKeyEvents(long var1, Component var3);

    protected abstract void discardKeyEvents(Component var1);

    public abstract void focusNextComponent(Component var1);

    public abstract void focusPreviousComponent(Component var1);

    public abstract void upFocusCycle(Component var1);

    public abstract void downFocusCycle(Container var1);

    public final void focusNextComponent() {
        this.focusNextComponent(null);
    }

    public final void focusPreviousComponent() {
        this.focusPreviousComponent(null);
    }

    public final void upFocusCycle() {
        this.upFocusCycle(null);
    }

    public final void downFocusCycle() {
        Component focusOwner = this.getGlobalFocusOwner();
        if (focusOwner instanceof Container && ((Container)focusOwner).isFocusCycleRoot()) {
            this.downFocusCycle((Container)focusOwner);
        }
    }

    private Object getObject(Map globalMap) {
        ThreadGroup currentGroup = Thread.currentThread().getThreadGroup();
        return globalMap.get(currentGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getGlobalObject(Map globalMap, boolean checkThread) {
        ThreadGroup currentGroup;
        KeyboardFocusManager managerForCallingThread;
        if (checkThread && this != (managerForCallingThread = (KeyboardFocusManager)currentKeyboardFocusManagers.get(currentGroup = Thread.currentThread().getThreadGroup()))) {
            throw new SecurityException("Attempted to retrieve an object from a keyboard focus manager that isn't associated with the current thread group.");
        }
        Map map = globalMap;
        synchronized (map) {
            Collection globalObjects = globalMap.values();
            for (Component globalObject : globalObjects) {
                if (globalObject == null) continue;
                return globalObject;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGlobalObject(Map globalMap, Object newObject, String property) {
        Map map = globalMap;
        synchronized (map) {
            Object oldObject = this.getGlobalObject(globalMap, false);
            Set threadGroups = globalMap.keySet();
            for (ThreadGroup oldThreadGroup : threadGroups) {
                if (globalMap.get(oldThreadGroup) == null) continue;
                globalMap.put(oldThreadGroup, null);
                break;
            }
            ThreadGroup currentGroup = Thread.currentThread().getThreadGroup();
            this.firePropertyChange(property, oldObject, newObject);
            try {
                this.fireVetoableChange(property, oldObject, newObject);
                globalMap.put(currentGroup, newObject);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    static AWTEvent retargetFocusEvent(AWTEvent ev) {
        FocusEvent fe;
        Component target;
        if (ev instanceof FocusEvent && focusRequests.containsKey(target = (fe = (FocusEvent)ev).getComponent())) {
            Component lightweight = (Component)focusRequests.get(target);
            ev = new FocusEvent(lightweight, fe.id, fe.isTemporary());
            focusRequests.remove(target);
        }
        return ev;
    }

    static void addLightweightFocusRequest(Component heavyweight, Component lightweight) {
        focusRequests.put(heavyweight, lightweight);
    }
}

