/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferStrategy;
import java.awt.peer.WindowPeer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window
extends Container
implements Accessible {
    private static final long serialVersionUID = 4497834738069338734L;
    private String warningString = null;
    private int windowSerializedDataVersion = 0;
    private int state = 0;
    private boolean focusableWindowState = true;
    private boolean alwaysOnTop = false;
    private transient Vector ownedWindows = new Vector();
    private transient WindowListener windowListener;
    private transient WindowFocusListener windowFocusListener;
    private transient WindowStateListener windowStateListener;
    private transient boolean shown;
    transient Component windowFocusOwner;
    private static transient long next_window_number;

    Window() {
        this.visible = false;
        this.focusCycleRoot = true;
        this.setLayout(new BorderLayout());
        GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.graphicsConfig = g.getDefaultScreenDevice().getDefaultConfiguration();
    }

    Window(GraphicsConfiguration gc) {
        this();
        this.graphicsConfig = gc;
    }

    public Window(Frame owner) {
        this(owner, owner.getGraphicsConfiguration());
    }

    public Window(Window owner) {
        this(owner, owner.getGraphicsConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window(Window owner, GraphicsConfiguration gc) {
        this();
        Object object = this.getTreeLock();
        synchronized (object) {
            if (owner == null) {
                throw new IllegalArgumentException("owner must not be null");
            }
            this.parent = owner;
            owner.ownedWindows.add(new WeakReference<Window>(this));
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null && !s.checkTopLevelWindow(this)) {
            this.warningString = System.getProperty("awt.appletWarning");
        }
        if (gc != null && gc.getDevice().getType() != 0) {
            throw new IllegalArgumentException("gc must be from a screen device");
        }
        this.graphicsConfig = gc == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : gc;
    }

    @Override
    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public void pack() {
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void show() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.addNotify();
            }
            this.validate();
            if (this.visible) {
                this.toFront();
            } else {
                super.show();
                Iterator e = this.ownedWindows.iterator();
                while (e.hasNext()) {
                    Window w = (Window)((Reference)e.next()).get();
                    if (w != null) {
                        if (!w.isVisible()) continue;
                        w.getPeer().setVisible(true);
                        continue;
                    }
                    e.remove();
                }
            }
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            manager.setGlobalFocusedWindow(this);
            if (!this.shown) {
                FocusTraversalPolicy policy = this.getFocusTraversalPolicy();
                Component initialFocusOwner = null;
                if (policy != null) {
                    initialFocusOwner = policy.getInitialComponent(this);
                }
                if (initialFocusOwner != null) {
                    initialFocusOwner.requestFocusInWindow();
                }
                if (this.windowListener != null || (this.eventMask & 0x40L) != 0L) {
                    WindowEvent ev = new WindowEvent(this, 200);
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    tk.getSystemEventQueue().postEvent(ev);
                }
                this.shown = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void hide() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Iterator e = this.ownedWindows.iterator();
            while (e.hasNext()) {
                Window w = (Window)((Reference)e.next()).get();
                if (w != null) {
                    if (!w.isVisible() || w.getPeer() == null) continue;
                    w.getPeer().setVisible(false);
                    continue;
                }
                e.remove();
            }
        }
        super.hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.hide();
        Object object = this.getTreeLock();
        synchronized (object) {
            Iterator e = this.ownedWindows.iterator();
            while (e.hasNext()) {
                Window w = (Window)((Reference)e.next()).get();
                if (w != null) {
                    w.dispose();
                    continue;
                }
                e.remove();
            }
            int i = 0;
            while (i < this.ncomponents) {
                this.component[i].removeNotify();
                ++i;
            }
            this.removeNotify();
            if (this.windowListener != null || (this.eventMask & 0x40L) != 0L) {
                WindowEvent ev = new WindowEvent(this, 202);
                Toolkit tk = Toolkit.getDefaultToolkit();
                tk.getSystemEventQueue().postEvent(ev);
            }
        }
    }

    public void toBack() {
        if (this.peer != null) {
            if (this.alwaysOnTop) {
                this.setAlwaysOnTop(false);
            }
            ((WindowPeer)this.peer).toBack();
        }
    }

    public void toFront() {
        if (this.peer != null) {
            ((WindowPeer)this.peer).toFront();
        }
    }

    @Override
    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    @Override
    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window[] getOwnedWindows() {
        Window[] trimmedList;
        Object object = this.getTreeLock();
        synchronized (object) {
            Window[] validList = new Window[this.ownedWindows.size()];
            Iterator e = this.ownedWindows.iterator();
            int numValid = 0;
            while (e.hasNext()) {
                Window w = (Window)((Reference)e.next()).get();
                if (w != null) {
                    validList[numValid++] = w;
                    continue;
                }
                e.remove();
            }
            if (numValid != validList.length) {
                trimmedList = new Window[numValid];
                System.arraycopy(validList, 0, trimmedList, 0, numValid);
            } else {
                trimmedList = validList;
            }
        }
        return trimmedList;
    }

    public synchronized void addWindowListener(WindowListener listener) {
        if (listener != null) {
            this.newEventsOnly = true;
            this.windowListener = AWTEventMulticaster.add(this.windowListener, listener);
        }
    }

    public synchronized void removeWindowListener(WindowListener listener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, listener);
    }

    public synchronized WindowListener[] getWindowListeners() {
        return (WindowListener[])AWTEventMulticaster.getListeners((EventListener)this.windowListener, WindowListener.class);
    }

    public synchronized WindowFocusListener[] getWindowFocusListeners() {
        return (WindowFocusListener[])AWTEventMulticaster.getListeners((EventListener)this.windowFocusListener, WindowFocusListener.class);
    }

    public synchronized WindowStateListener[] getWindowStateListeners() {
        return (WindowStateListener[])AWTEventMulticaster.getListeners((EventListener)this.windowStateListener, WindowStateListener.class);
    }

    public void addWindowFocusListener(WindowFocusListener wfl) {
        if (wfl != null) {
            this.newEventsOnly = true;
            this.windowFocusListener = AWTEventMulticaster.add(this.windowFocusListener, wfl);
        }
    }

    public void addWindowStateListener(WindowStateListener wsl) {
        if (wsl != null) {
            this.newEventsOnly = true;
            this.windowStateListener = AWTEventMulticaster.add(this.windowStateListener, wsl);
        }
    }

    public void removeWindowFocusListener(WindowFocusListener wfl) {
        this.windowFocusListener = AWTEventMulticaster.remove(this.windowFocusListener, wfl);
    }

    public void removeWindowStateListener(WindowStateListener wsl) {
        this.windowStateListener = AWTEventMulticaster.remove(this.windowStateListener, wsl);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == WindowListener.class) {
            return this.getWindowListeners();
        }
        return super.getListeners(listenerType);
    }

    @Override
    void dispatchEventImpl(AWTEvent e) {
        if (e.getID() == 101) {
            this.invalidate();
            this.validate();
        }
        super.dispatchEventImpl(e);
    }

    @Override
    protected void processEvent(AWTEvent evt) {
        if (evt instanceof WindowEvent) {
            WindowEvent we = (WindowEvent)evt;
            switch (evt.getID()) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    this.processWindowEvent(we);
                    break;
                }
                case 207: 
                case 208: {
                    this.processWindowFocusEvent(we);
                    break;
                }
                case 209: {
                    this.processWindowStateEvent(we);
                }
            }
        } else {
            super.processEvent(evt);
        }
    }

    protected void processWindowEvent(WindowEvent evt) {
        if (this.windowListener != null) {
            switch (evt.getID()) {
                case 205: {
                    this.windowListener.windowActivated(evt);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(evt);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(evt);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(evt);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(evt);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(evt);
                    break;
                }
                case 200: {
                    this.windowListener.windowOpened(evt);
                }
            }
        }
    }

    public boolean isActive() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return manager.getActiveWindow() == this;
    }

    public boolean isFocused() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return manager.getFocusedWindow() == this;
    }

    public Component getFocusOwner() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = manager.getActiveWindow();
        if (activeWindow == this) {
            return manager.getFocusOwner();
        }
        return null;
    }

    public Component getMostRecentFocusOwner() {
        return this.windowFocusOwner;
    }

    void setFocusOwner(Component windowFocusOwner) {
        this.windowFocusOwner = windowFocusOwner;
    }

    @Override
    public boolean postEvent(Event e) {
        return this.handleEvent(e);
    }

    @Override
    public boolean isShowing() {
        return this.isVisible();
    }

    public void setLocationRelativeTo(Component c) {
        int x = 0;
        int y = 0;
        if (c == null || !c.isShowing()) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Point center = ge.getCenterPoint();
            x = center.x - this.width / 2;
            y = center.y - this.height / 2;
        } else {
            int cWidth = c.getWidth();
            int cHeight = c.getHeight();
            Dimension screenSize = this.getToolkit().getScreenSize();
            x = c.getLocationOnScreen().x;
            y = c.getLocationOnScreen().y;
            if (y + cHeight > screenSize.height) {
                x = screenSize.width / 2 - x <= 0 ? (x - this.width >= 0 ? (x -= this.width) : 0) : (x + cWidth + this.width <= screenSize.width ? (x += cWidth) : screenSize.width - this.width);
                y = screenSize.height - this.height;
            } else if (cWidth > this.width || cHeight > this.height) {
                x = x + this.width > screenSize.width ? screenSize.width - this.width : (x < 0 ? 0 : (x += (cWidth - this.width) / 2));
                y += (cHeight - this.height) / 2;
            } else {
                x = x + this.width > screenSize.width ? screenSize.width - this.width : (x < 0 || x - (this.width - cWidth) / 2 < 0 ? 0 : (x -= (this.width - cWidth) / 2));
                y = y - (this.height - cHeight) / 2 > 0 ? (y -= (this.height - cHeight) / 2) : 0;
            }
        }
        this.setLocation(x, y);
    }

    public void createBufferStrategy(int numBuffers) {
        if (numBuffers < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (!this.isDisplayable()) {
            throw new IllegalStateException("Window.createBufferStrategy: window is not displayable");
        }
        BufferStrategy newStrategy = null;
        try {
            newStrategy = new WindowFlipBufferStrategy(numBuffers);
        }
        catch (AWTException aWTException) {}
        if (newStrategy == null) {
            newStrategy = new WindowBltBufferStrategy(numBuffers, true);
        }
        this.bufferStrategy = newStrategy;
    }

    public void createBufferStrategy(int numBuffers, BufferCapabilities caps) throws AWTException {
        if (numBuffers < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (caps == null) {
            throw new IllegalArgumentException("Window.createBufferStrategy: capabilities object is null");
        }
        this.bufferStrategy = caps.isPageFlipping() ? new WindowFlipBufferStrategy(numBuffers) : new WindowBltBufferStrategy(numBuffers, true);
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public void applyResourceBundle(ResourceBundle rb) {
        this.applyComponentOrientation(ComponentOrientation.getOrientation(rb));
    }

    public void applyResourceBundle(String rbName) {
        ResourceBundle rb = ResourceBundle.getBundle(rbName, Locale.getDefault(), ClassLoader.getSystemClassLoader());
        if (rb != null) {
            this.applyResourceBundle(rb);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTWindow();
        }
        return this.accessibleContext;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration conf = this.graphicsConfig;
        if (conf == null) {
            this.graphicsConfig = conf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return conf;
    }

    protected void processWindowFocusEvent(WindowEvent event) {
        if (this.windowFocusListener != null) {
            switch (event.getID()) {
                case 207: {
                    this.windowFocusListener.windowGainedFocus(event);
                    break;
                }
                case 208: {
                    this.windowFocusListener.windowLostFocus(event);
                    break;
                }
            }
        }
    }

    protected void processWindowStateEvent(WindowEvent event) {
        if (this.windowStateListener != null && event.getID() == 209) {
            this.windowStateListener.windowStateChanged(event);
        }
    }

    public final boolean isFocusableWindow() {
        if (!this.getFocusableWindowState()) {
            return false;
        }
        return this instanceof Dialog || this instanceof Frame;
    }

    public boolean getFocusableWindowState() {
        return this.focusableWindowState;
    }

    public void setFocusableWindowState(boolean focusableWindowState) {
        this.focusableWindowState = focusableWindowState;
    }

    @Override
    public final boolean isFocusCycleRoot() {
        return true;
    }

    @Override
    public final void setFocusCycleRoot(boolean focusCycleRoot) {
    }

    @Override
    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public final boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public final void setAlwaysOnTop(boolean alwaysOnTop) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AWTPermission("setWindowAlwaysOnTop"));
        }
        if (this.alwaysOnTop == alwaysOnTop) {
            return;
        }
        if (alwaysOnTop) {
            this.toFront();
        }
        this.firePropertyChange("alwaysOnTop", this.alwaysOnTop, alwaysOnTop);
        this.alwaysOnTop = alwaysOnTop;
        if (this.peer != null) {
            ((WindowPeer)this.peer).updateAlwaysOnTop();
        } else {
            System.out.println("Null peer?!");
        }
    }

    @Override
    String generateName() {
        return "win" + Window.getUniqueLong();
    }

    @Override
    boolean eventTypeEnabled(int type) {
        boolean enabled = false;
        switch (type) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                enabled = (this.eventMask & 0x40L) != 0L || this.windowListener != null;
                break;
            }
            case 207: 
            case 208: {
                enabled = (this.eventMask & 0x80000L) != 0L || this.windowFocusListener != null;
                break;
            }
            case 209: {
                enabled = (this.eventMask & 0x40000L) != 0L || this.windowStateListener != null;
                break;
            }
            default: {
                enabled = super.eventTypeEnabled(type);
            }
        }
        return enabled;
    }

    private static synchronized long getUniqueLong() {
        return next_window_number++;
    }

    protected class AccessibleAWTWindow
    extends Container.AccessibleAWTContainer {
        private static final long serialVersionUID = 4215068635060671780L;

        protected AccessibleAWTWindow() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (Window.this.isActive()) {
                states.add(AccessibleState.ACTIVE);
            }
            return states;
        }
    }

    private class WindowBltBufferStrategy
    extends Component.BltBufferStrategy {
        WindowBltBufferStrategy(int numBuffers, boolean accelerated) {
            super(Window.this, numBuffers, new BufferCapabilities(new ImageCapabilities(accelerated), new ImageCapabilities(accelerated), BufferCapabilities.FlipContents.COPIED));
        }
    }

    private class WindowFlipBufferStrategy
    extends Component.FlipBufferStrategy {
        WindowFlipBufferStrategy(int numBuffers) throws AWTException {
            super(Window.this, numBuffers, new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED));
        }
    }
}

