#!/bin/sh
echo 'name: concurrent-extra
version: 0.7.0.4
id: concurrent-extra-0.7.0.4-2ed81723e2f7806832fa0eb1371be939

license: BSD3
copyright: (c) 2010-2011 Bas van Dijk & Roel van Dijk
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
            Roel van Dijk <vandijk.roel@gmail.com>
stability: experimental
homepage: https://github.com/basvandijk/concurrent-extra
package-url:
description: The @concurrent-extra@ package offers among other things the
             following selection of synchronisation primitives:
             .
             * @Broadcast@: Wake multiple threads by broadcasting a value.
             .
             * @Event@: Wake multiple threads by signalling an event.
             .
             * @Lock@: Enforce exclusive access to a resource. Also known as a
             binary semaphore or mutex. The package additionally provides an
             alternative that works in the @STM@ monad.
             .
             * @RLock@: A lock which can be acquired multiple times by the same
             thread. Also known as a reentrant mutex.
             .
             * @ReadWriteLock@: Multiple-reader, single-writer locks. Used to
             protect shared resources which may be concurrently read, but only
             sequentially written.
             .
             * @ReadWriteVar@: Concurrent read, sequential write variables.
             .
             Please consult the API documentation of the individual modules for
             more detailed information.
             .
             This package was inspired by the concurrency libraries of Java and
             Python.
category: Concurrency
author: Bas van Dijk <v.dijk.bas@gmail.com>
        Roel van Dijk <vandijk.roel@gmail.com>
pkgpath: devel/hs-concurrent-extra
exposed: True
exposed-modules: Control.Concurrent.Lock
                 Control.Concurrent.STM.Lock Control.Concurrent.RLock
                 Control.Concurrent.Event Control.Concurrent.Broadcast
                 Control.Concurrent.ReadWriteLock Control.Concurrent.ReadWriteVar
hidden-modules: Utils
import-dirs: /usr/local/lib/ghc/concurrent-extra-0.7.0.4
library-dirs: /usr/local/lib/ghc/concurrent-extra-0.7.0.4
hs-libraries: HSconcurrent-extra-0.7.0.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         base-unicode-symbols-0.2.2.3-e834a56b2b862942e8636471602f640f
         stm-2.2.0.1-ed0e458253aaadec34214f73593ad010
         unbounded-delays-0.1.0.4-9dd200ef3a610b653b3f7d093d0b6854
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-concurrent-extra-0.7.0.4/html/concurrent-extra.haddock
haddock-html: /usr/local/share/doc/hs-concurrent-extra-0.7.0.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
