#!/bin/sh
echo 'name: haskell-src-exts
version: 1.11.1
id: haskell-src-exts-1.11.1-733ae65367e6bb54158e7f45c4c6d500

license: BSD3
copyright:
maintainer: Niklas Broberg <d00nibro@chalmers.se>
stability: Stable
homepage: http://code.haskell.org/haskell-src-exts
package-url:
description: Haskell-Source with Extensions (HSE, haskell-src-exts)
             is an extension of the standard haskell-src package,
             and handles most registered syntactic extensions to Haskell, including:
             .
             * Multi-parameter type classes with functional dependencies
             .
             * Indexed type families (including associated types)
             .
             * Empty data declarations
             .
             * GADTs
             .
             * Implicit parameters
             .
             * Template Haskell
             .
             and a few more. All extensions implemented in GHC are supported.
             Apart from these standard extensions,
             it also handles regular patterns as per the HaRP extension
             as well as HSX-style embedded XML syntax.
category: Language
author: Niklas Broberg
pkgpath: lang/hs-haskell-src-exts
exposed: True
exposed-modules: Language.Haskell.Exts Language.Haskell.Exts.Parser
                 Language.Haskell.Exts.Pretty Language.Haskell.Exts.Syntax
                 Language.Haskell.Exts.Extension Language.Haskell.Exts.Build
                 Language.Haskell.Exts.Fixity Language.Haskell.Exts.Comments
                 Language.Haskell.Exts.SrcLoc Language.Haskell.Exts.Annotated
                 Language.Haskell.Exts.Annotated.Syntax
                 Language.Haskell.Exts.Annotated.Fixity
                 Language.Haskell.Exts.Annotated.Build
                 Language.Haskell.Exts.Annotated.ExactPrint
                 Language.Haskell.Exts.Annotated.Simplify
hidden-modules: Language.Haskell.Exts.ExtScheme
                Language.Haskell.Exts.ParseMonad Language.Haskell.Exts.ParseSyntax
                Language.Haskell.Exts.Lexer Language.Haskell.Exts.ParseUtils
                Language.Haskell.Exts.InternalParser
import-dirs: /usr/local/lib/ghc/haskell-src-exts-1.11.1
library-dirs: /usr/local/lib/ghc/haskell-src-exts-1.11.1
hs-libraries: HShaskell-src-exts-1.11.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.2-f538acad67d0b6696484da310d5949cf
         base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         cpphs-1.11-19d88f688a47590ce53e9dffc85af39a
         pretty-1.0.1.2-f2c716197e95f5c78869e6b87f2330d9
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-haskell-src-exts-1.11.1/html/haskell-src-exts.haddock
haddock-html: /usr/local/share/doc/hs-haskell-src-exts-1.11.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
