#!/bin/sh
echo 'name: redis
version: 0.12.1
id: redis-0.12.1-aa1c7b578523d82f9475b60db874c07c

license: MIT
copyright: Copyright (c) 2009-2010 Alexander Bogdanov
maintainer: Alexander Bogdanov <andorn@gmail.com>
stability: beta
homepage:
package-url:
description: Redis (<http://redis.io>) is an open source, BSD licensed, advanced
             key-value store. It is often referred as a data structure server
             since keys can contain different data structures, such as strings,
             hashes, lists, sets and sorted sets.
             .
             This library is a Haskell driver for Redis. It'\''s tested with
             current git version and with v2.4.6 of redis server. It also
             tested with v2.2 and basic functions are works correctly
             but not all of them.
             .
             You can use Test module from the source package to run unit
             tests. Try /runhaskell Test.hs --help/ for usage info. Caution! Do not
             run tests on your working database - test database will be
             flushed.
             .
             There are simple benchmark module included: Benchmark.hs. It shows
             me about two times less requests per second than redis-benchmark
             from server distribution.
             .
             Please let me know if tests or benchmark goes terribly wrong.
             .
             Changes from v0.11:
             .
             - Drop parsec dependency
             .
             - New commands implemented: incrbyfloat and hincrbyfloat
             .
             - Added variadic versions of del, hdel, lpush, rpush, sadd, srem,
             zadd, zrem (named as del_, hdel_ etc.)
             .
             - Fixed compilation with GHC 7.2 (and hopefully with more recent
             versions too), thanks Ben Gamari and Sean Hess for reporting.
             .
             - Using RLock from concurrent-extra fixes multithreading issues,
             thanks Dmitry Dzhus for reporting
             .
             - Hopefully, fix building on Windows (untested), thanks Piotr
             Staszewski and Alexander Dorofeev
category: Database
author: Alexander Bogdanov <andorn@gmail.com>
pkgpath: databases/hs-redis
exposed: True
exposed-modules: Database.Redis.Redis Database.Redis.Monad
                 Database.Redis.ByteStringClass Database.Redis.Monad.State
                 Database.Redis.Utils.Lock Database.Redis.Utils.Monad.Lock
hidden-modules: Database.Redis.Internal Database.Redis.Info
import-dirs: /usr/local/lib/ghc/redis-0.12.1
library-dirs: /usr/local/lib/ghc/redis-0.12.1
hs-libraries: HSredis-0.12.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: MonadCatchIO-mtl-0.3.0.4-71e86801e5931fd974633b3c7e6e1486
         base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         concurrent-extra-0.7.0.4-2ed81723e2f7806832fa0eb1371be939
         containers-0.4.0.0-f1307d32d8f4b51a1487c01f0997b6d9
         mtl-2.0.1.0-3e464329054b7660133198d73c31aca5
         network-2.3.0.5-8b6868c0e6dbf6adced217440d46f03d
         old-time-1.0.0.6-249d424df19da9487f0cb7da3ccb0868
         utf8-string-0.3.6-131bec5ed6c825184d560515f17820d3
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-redis-0.12.1/html/redis.haddock
haddock-html: /usr/local/share/doc/hs-redis-0.12.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
