/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class SubtractionInCompareToInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("subtraction.in.compareto.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/SubtractionInCompareToInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("subtraction.in.compareto.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/SubtractionInCompareToInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SubtractionInCompareToVisitor();
    }

    private static class SubtractionInCompareToVisitor
    extends BaseInspectionVisitor {
        private SubtractionInCompareToVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression exp) {
            if (exp == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/SubtractionInCompareToInspection$SubtractionInCompareToVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(exp);
            if (exp.getROperand() == null) {
                return;
            }
            if (!SubtractionInCompareToVisitor.isSubtraction(exp)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)exp, PsiMethod.class);
            if (!MethodUtils.isCompareTo(method)) {
                return;
            }
            this.registerError((PsiElement)exp, new Object[0]);
        }

        private static boolean isSubtraction(PsiBinaryExpression exp) {
            PsiExpression rhs = exp.getROperand();
            if (rhs == null) {
                return false;
            }
            PsiJavaToken sign = exp.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            return tokenType.equals(JavaTokenType.MINUS);
        }
    }
}

