/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterfaceNeverImplementedInspection
extends BaseInspection {
    public boolean ignoreInterfacesThatOnlyDeclareConstants = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("interface.never.implemented.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/InterfaceNeverImplementedInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("interface.never.implemented.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInterfacesThatOnlyDeclareConstants");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("interface.never.implemented.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/InterfaceNeverImplementedInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InterfaceNeverImplementedVisitor();
    }

    private class InterfaceNeverImplementedVisitor
    extends BaseInspectionVisitor {
        private InterfaceNeverImplementedVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/InterfaceNeverImplementedInspection$InterfaceNeverImplementedVisitor.visitClass must not be null");
            }
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (InterfaceNeverImplementedInspection.this.ignoreInterfacesThatOnlyDeclareConstants && aClass.getMethods().length == 0 && aClass.getFields().length != 0) {
                return;
            }
            if (InheritanceUtil.hasImplementation(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

