/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

public class VariableUsedInInnerClassVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean usedInInnerClass;
    private boolean inInnerClass;

    public VariableUsedInInnerClassVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor.<init> must not be null");
        }
        this.usedInInnerClass = false;
        this.inInnerClass = false;
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor.visitElement must not be null");
        }
        if (!this.usedInInnerClass) {
            super.visitElement(element);
        }
    }

    public void visitClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor.visitClass must not be null");
        }
        if (this.usedInInnerClass) {
            return;
        }
        boolean wasInInnerClass = this.inInnerClass;
        this.inInnerClass = true;
        super.visitClass(psiClass);
        this.inInnerClass = wasInInnerClass;
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor.visitReferenceExpression must not be null");
        }
        if (this.usedInInnerClass) {
            return;
        }
        super.visitReferenceExpression(ref);
        if (!this.inInnerClass) {
            return;
        }
        PsiElement element = ref.resolve();
        if (this.variable.equals(element)) {
            this.usedInInnerClass = true;
        }
    }

    public boolean isUsedInInnerClass() {
        return this.usedInInnerClass;
    }
}

