/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessarilyQualifiedStaticUsageInspection
extends BaseInspection {
    public boolean m_ignoreStaticFieldAccesses = false;
    public boolean m_ignoreStaticMethodCalls = false;
    public boolean m_ignoreStaticAccessFromStaticContext = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)infos[0];
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.problem.descriptor1", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection.buildErrorString must not return null");
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.ignore.field.option", new Object[0]), "m_ignoreStaticFieldAccesses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.ignore.method.option", new Object[0]), "m_ignoreStaticMethodCalls");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("only.report.qualified.static.usages.option", new Object[0]), "m_ignoreStaticAccessFromStaticContext");
        return optionsPanel;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarilyQualifiedStaticUsageFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarilyQualifiedStaticUsageVisitor();
    }

    private class UnnecessarilyQualifiedStaticUsageVisitor
    extends BaseInspectionVisitor {
        private UnnecessarilyQualifiedStaticUsageVisitor() {
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (!this.isUnnecessarilyQualifiedAccess(reference)) {
                return;
            }
            this.registerError((PsiElement)reference, reference);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        private boolean isUnnecessarilyQualifiedAccess(@NotNull PsiJavaCodeReferenceElement referenceElement) {
            PsiClass containingClass;
            PsiMember containingMember;
            PsiTypeElement[] typeParameterElements;
            if (referenceElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection$UnnecessarilyQualifiedStaticUsageVisitor.isUnnecessarilyQualifiedAccess must not be null");
            }
            PsiElement parent = referenceElement.getParent();
            if (parent instanceof PsiJavaCodeReferenceElement || parent instanceof PsiImportStatementBase) {
                return false;
            }
            PsiElement qualifierElement = referenceElement.getQualifier();
            if (!(qualifierElement instanceof PsiJavaCodeReferenceElement)) {
                return false;
            }
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList != null && (typeParameterElements = parameterList.getTypeParameterElements()).length > 0) {
                return false;
            }
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiField && !UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticFieldAccesses || target instanceof PsiMethod && !UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticMethodCalls || target instanceof PsiClass)) {
                return false;
            }
            if (UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticAccessFromStaticContext && (containingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiMember.class)) != null && !containingMember.hasModifierProperty("static")) {
                return false;
            }
            String referenceName = referenceElement.getReferenceName();
            if (referenceName == null) {
                return false;
            }
            PsiReference reference = (PsiReference)qualifierElement;
            PsiElement resolvedQualifier = reference.resolve();
            if (!(resolvedQualifier instanceof PsiClass)) {
                return false;
            }
            PsiClass qualifyingClass = (PsiClass)resolvedQualifier;
            Project project = referenceElement.getProject();
            JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)project);
            PsiResolveHelper resolveHelper = manager.getResolveHelper();
            PsiMember member = (PsiMember)target;
            if (target instanceof PsiField) {
                PsiVariable variable = resolveHelper.resolveReferencedVariable(referenceName, (PsiElement)referenceElement);
                if (variable == null || !variable.equals(member)) {
                    return false;
                }
                PsiMember memberVariable = (PsiMember)variable;
                containingClass = memberVariable.getContainingClass();
            } else if (target instanceof PsiClass) {
                PsiClass aClass = resolveHelper.resolveReferencedClass(referenceName, (PsiElement)referenceElement);
                if (aClass == null || !aClass.equals(member)) {
                    return false;
                }
                containingClass = aClass.getContainingClass();
            } else {
                return this.isMethodAccessibleWithoutQualifier(referenceElement, qualifyingClass);
            }
            return resolvedQualifier.equals(containingClass);
        }

        private boolean isMethodAccessibleWithoutQualifier(PsiJavaCodeReferenceElement referenceElement, PsiClass qualifyingClass) {
            String referenceName = referenceElement.getReferenceName();
            if (referenceName == null) {
                return false;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)referenceElement);
            while (containingClass != null) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = containingClass.findMethodsByName(referenceName, true)) {
                    String name = method.getName();
                    if (!referenceName.equals(name)) continue;
                    return containingClass.equals(qualifyingClass);
                }
                containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
            }
            return false;
        }
    }

    private static class UnnecessarilyQualifiedStaticUsageFix
    extends InspectionGadgetsFix {
        private UnnecessarilyQualifiedStaticUsageFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection$UnnecessarilyQualifiedStaticUsageFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)element;
                PsiElement qualifier = reference.getQualifier();
                if (qualifier == null) {
                    return;
                }
                qualifier.delete();
            }
        }
    }
}

