/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.connections.ssh.SocksAuthenticatorManager;
import com.intellij.cvsSupport2.connections.ssh.SocksProxyData;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.transport.SocketFactory;
import java.io.IOException;
import java.net.Socket;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;

public class SshProxyFactory {
    private SshProxyFactory() {
    }

    @Nullable
    public static ProxyData createAndRegister(ConnectionSettings connectionSettings) {
        SocksProxyData result = null;
        if (!connectionSettings.isUseProxy()) {
            return null;
        }
        int type = connectionSettings.getProxyType();
        if (ProxySettings.SOCKS4 == type || ProxySettings.SOCKS5 == type) {
            result = new SocksProxyData(connectionSettings);
            SocksAuthenticatorManager.getInstance().register(connectionSettings);
        } else if (ProxySettings.HTTP == type) {
            result = new HTTPProxyData(connectionSettings.getProxyHostName(), connectionSettings.getProxyPort(), connectionSettings.getProxyLogin(), connectionSettings.getProxyPassword());
        }
        return result;
    }

    public static Socket createSocket(ConnectionSettings connectionSettings) throws IOException {
        return SocketFactory.open((String)connectionSettings.getHostName(), (int)connectionSettings.getPort(), (ProxyData)SshProxyFactory.createAndRegister(connectionSettings), (int)connectionSettings.getConnectionTimeout());
    }
}

