/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.ReplaceAssignmentWithPostfixExpressionPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssignmentWithPostfixExpressionIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ReplaceAssignmentWithPostfixExpressionPredicate replaceAssignmentWithPostfixExpressionPredicate = new ReplaceAssignmentWithPostfixExpressionPredicate();
        if (replaceAssignmentWithPostfixExpressionPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/opassign/ReplaceAssignmentWithPostfixExpressionIntention.getElementPredicate must not return null");
        }
        return replaceAssignmentWithPostfixExpressionPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiBinaryExpression rhs = (PsiBinaryExpression)assignmentExpression.getRExpression();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        IElementType tokenType = rhs == null ? null : rhs.getOperationTokenType();
        String replacementText = JavaTokenType.MINUS.equals(tokenType) ? lhsText + "--" : lhsText + "++";
        return IntentionPowerPackBundle.message("replace.some.operator.with.other.intention.name", "=", replacementText);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/opassign/ReplaceAssignmentWithPostfixExpressionIntention.processIntention must not be null");
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        PsiExpression rhs = assignmentExpression.getRExpression();
        if (!(rhs instanceof PsiBinaryExpression)) {
            return;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (JavaTokenType.PLUS.equals(tokenType)) {
            ReplaceAssignmentWithPostfixExpressionIntention.replaceExpression(lhsText + "++", (PsiExpression)assignmentExpression);
        } else if (JavaTokenType.MINUS.equals(tokenType)) {
            ReplaceAssignmentWithPostfixExpressionIntention.replaceExpression(lhsText + "--", (PsiExpression)assignmentExpression);
        }
    }
}

