/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ConditionalUtils;
import com.siyeh.ipp.psiutils.EquivalenceChecker;
import com.siyeh.ipp.psiutils.ErrorUtil;

class ReplaceIfWithConditionalPredicate
implements PsiElementPredicate {
    ReplaceIfWithConditionalPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement parent = token.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        if (ErrorUtil.containsError((PsiElement)ifStatement)) {
            return false;
        }
        PsiExpression condition = ifStatement.getCondition();
        if (condition == null) {
            return false;
        }
        if (ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement)) {
            return true;
        }
        if (ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement)) {
            return true;
        }
        return ReplaceIfWithConditionalPredicate.isReplaceableImplicitReturn(ifStatement);
    }

    public static boolean isReplaceableImplicitReturn(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (!((thenBranch = ConditionalUtils.stripBraces(thenBranch)) instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement thenReturnStatement = (PsiReturnStatement)thenBranch;
        PsiExpression thenReturn = thenReturnStatement.getReturnValue();
        if (thenReturn == null) {
            return false;
        }
        PsiType thenType = thenReturn.getType();
        if (thenType == null) {
            return false;
        }
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement elseReturnStatement = (PsiReturnStatement)nextStatement;
        PsiExpression elseReturn = elseReturnStatement.getReturnValue();
        if (elseReturn == null) {
            return false;
        }
        PsiType elseType = elseReturn.getType();
        if (elseType == null) {
            return false;
        }
        return thenType.isAssignableFrom(elseType) || elseType.isAssignableFrom(thenType);
    }

    public static boolean isReplaceableReturn(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (!(thenBranch instanceof PsiReturnStatement) || !(elseBranch instanceof PsiReturnStatement)) {
            return false;
        }
        PsiExpression thenReturn = ((PsiReturnStatement)thenBranch).getReturnValue();
        if (thenReturn == null) {
            return false;
        }
        PsiExpression elseReturn = ((PsiReturnStatement)elseBranch).getReturnValue();
        if (elseReturn == null) {
            return false;
        }
        PsiType thenType = thenReturn.getType();
        PsiType elseType = elseReturn.getType();
        if (thenType == null || elseType == null) {
            return false;
        }
        return thenType.isAssignableFrom(elseType) || elseType.isAssignableFrom(thenType);
    }

    public static boolean isReplaceableAssignment(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch == null) {
            return false;
        }
        if (!ConditionalUtils.isAssignment(thenBranch = ConditionalUtils.stripBraces(thenBranch))) {
            return false;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if ((elseBranch = ConditionalUtils.stripBraces(elseBranch)) == null) {
            return false;
        }
        if (!ConditionalUtils.isAssignment(elseBranch)) {
            return false;
        }
        PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)((PsiExpressionStatement)thenBranch).getExpression();
        PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)((PsiExpressionStatement)elseBranch).getExpression();
        PsiJavaToken thenSign = thenExpression.getOperationSign();
        PsiJavaToken elseSign = elseExpression.getOperationSign();
        IElementType tokenType = thenSign.getTokenType();
        if (!tokenType.equals(elseSign.getTokenType())) {
            return false;
        }
        PsiExpression thenLhs = thenExpression.getLExpression();
        if (thenExpression.getRExpression() == null) {
            return false;
        }
        if (elseExpression.getRExpression() == null) {
            return false;
        }
        PsiExpression thenRhs = thenExpression.getRExpression();
        assert (thenRhs != null);
        PsiType thenType = thenRhs.getType();
        if (thenType == null) {
            return false;
        }
        PsiExpression elseRhs = elseExpression.getRExpression();
        if (elseRhs == null) {
            return false;
        }
        PsiType elseType = elseRhs.getType();
        if (elseType == null) {
            return false;
        }
        if (!thenType.isAssignableFrom(elseType) && !elseType.isAssignableFrom(thenType)) {
            return false;
        }
        PsiExpression elseLhs = elseExpression.getLExpression();
        return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
    }
}

