/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ConvertClosureToMethodIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPredicate myPredicate = new MyPredicate();
        if (myPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/ConvertClosureToMethodIntention.getElementPredicate must not return null");
        }
        return myPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/ConvertClosureToMethodIntention.processIntention must not be null");
        }
        element = element.getParent();
        StringBuilder builder = new StringBuilder(element.getTextLength());
        GrField field = (GrField)element;
        GrClosableBlock block = (GrClosableBlock)field.getInitializerGroovy();
        builder.append(field.getModifierList().getText()).append(' ').append(field.getName());
        builder.append('(');
        if (block.hasParametersSection()) {
            builder.append(block.getParameterList().getText());
        } else {
            builder.append("def it");
        }
        builder.append(") {");
        block.getParameterList().delete();
        block.getLBrace().delete();
        PsiElement psiElement = PsiUtil.skipWhitespaces(block.getFirstChild(), true);
        if (psiElement != null && "->".equals(psiElement.getText())) {
            psiElement.delete();
        }
        builder.append(block.getText());
        GrMethod method = GroovyPsiElementFactory.getInstance(element.getProject()).createMethodFromText(builder.toString());
        field.getParent().replace((PsiElement)method);
    }

    private static class MyPredicate
    implements PsiElementPredicate {
        private MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof GrField)) {
                return false;
            }
            if (((GrField)parent).getNameIdentifierGroovy() != element) {
                return false;
            }
            PsiElement varDeclaration = parent.getParent();
            if (!(varDeclaration instanceof GrVariableDeclaration)) {
                return false;
            }
            if (((GrVariableDeclaration)varDeclaration).getVariables().length != 1) {
                return false;
            }
            GrExpression expression = ((GrField)parent).getInitializerGroovy();
            return expression instanceof GrClosableBlock;
        }
    }
}

