/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;

public class GrEnumTypeDefinitionImpl
extends GrTypeDefinitionImpl
implements GrEnumTypeDefinition {
    @NonNls
    private static final String JAVA_LANG_ENUM = "java.lang.Enum";
    private static final String ENUM_SIMPLE_NAME = "Enum";

    public GrEnumTypeDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl.<init> must not be null");
        }
        super(node);
    }

    public GrEnumTypeDefinitionImpl(GrTypeDefinitionStub stub) {
        super(stub, (IStubElementType)GroovyElementTypes.ENUM_DEFINITION);
    }

    public String toString() {
        return "Enumeration definition";
    }

    @Override
    public GrEnumDefinitionBody getBody() {
        return (GrEnumDefinitionBody)this.findChildByType(GroovyElementTypes.ENUM_BODY);
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.createEnumType()};
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl.getExtendsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    protected String[] getExtendsNames() {
        return new String[]{ENUM_SIMPLE_NAME};
    }

    private PsiClassType createEnumType() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiClass enumClass = facade.findClass(JAVA_LANG_ENUM, this.getResolveScope());
        PsiElementFactory factory = facade.getElementFactory();
        if (enumClass != null) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], (PsiType)factory.createType((PsiClass)this));
            }
            return factory.createType(enumClass, substitutor);
        }
        return factory.createTypeByFQClassName(JAVA_LANG_ENUM, this.getResolveScope());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GrField[] getFields() {
        Object[] objectArray;
        Object[] bodyFields = super.getFields();
        Object[] enumConstants = this.getEnumConstants();
        if (bodyFields.length == 0) {
            objectArray = enumConstants;
            if (enumConstants == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl.getFields must not return null");
            return objectArray;
        }
        if (enumConstants.length == 0) {
            objectArray = bodyFields;
            if (bodyFields == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl.getFields must not return null");
            return objectArray;
        }
        objectArray = (GrField[])ArrayUtil.mergeArrays((Object[])bodyFields, (Object[])enumConstants, GrField.class);
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl.getFields must not return null");
    }

    @Override
    public GrEnumConstant[] getEnumConstants() {
        GrEnumConstantList list = this.getEnumConstantList();
        if (list != null) {
            return list.getEnumConstants();
        }
        return GrEnumConstant.EMPTY_ARRAY;
    }

    @Override
    public GrEnumConstantList getEnumConstantList() {
        GrEnumDefinitionBody enumDefinitionBody = this.getBody();
        if (enumDefinitionBody != null) {
            return enumDefinitionBody.getEnumConstantList();
        }
        return null;
    }
}

