/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import gnu.trove.THashMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDomConvertersRegistry;
import org.jetbrains.idea.maven.dom.converters.MavenPluginCustomParameterValueConverter;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomConfigurationParameter;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.plugin.MavenDomMojo;
import org.jetbrains.idea.maven.dom.plugin.MavenDomParameter;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;

public class MavenPluginConfigurationDomExtender
extends DomExtender<MavenDomConfiguration> {
    public static final Key<ParameterData> PLUGIN_PARAMETER_KEY = Key.create((String)"MavenPluginConfigurationDomExtender.PLUGIN_PARAMETER_KEY");

    public void registerExtensions(@NotNull MavenDomConfiguration config, @NotNull DomExtensionsRegistrar r) {
        if (config == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender.registerExtensions must not be null");
        }
        if (r == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender.registerExtensions must not be null");
        }
        MavenDomPluginModel pluginModel = MavenPluginDomUtil.getMavenPluginModel(config);
        if (pluginModel == null) {
            r.registerCustomChildrenExtension(MavenDomConfigurationParameter.class);
            return;
        }
        for (ParameterData each : MavenPluginConfigurationDomExtender.collectParameters(pluginModel, config)) {
            MavenPluginConfigurationDomExtender.registerPluginParameter(r, each);
        }
    }

    private static Collection<ParameterData> collectParameters(MavenDomPluginModel pluginModel, MavenDomConfiguration config) {
        ArrayList<String> selectedGoals = null;
        MavenDomPluginExecution executionElement = (MavenDomPluginExecution)config.getParentOfType(MavenDomPluginExecution.class, false);
        if (executionElement != null) {
            String goal;
            selectedGoals = new ArrayList<String>();
            String id = executionElement.getId().getStringValue();
            String defaultPrefix = "default-";
            if (id != null && id.startsWith(defaultPrefix) && !StringUtil.isEmptyOrSpaces((String)(goal = id.substring(defaultPrefix.length())))) {
                selectedGoals.add(goal);
            }
            for (MavenDomGoal mavenDomGoal : executionElement.getGoals().getGoals()) {
                selectedGoals.add(mavenDomGoal.getStringValue());
            }
        }
        THashMap namesWithParameters = new THashMap();
        for (MavenDomMojo eachMojo : pluginModel.getMojos().getMojos()) {
            String string = eachMojo.getGoal().getStringValue();
            if (string == null || selectedGoals != null && !selectedGoals.contains(string)) continue;
            for (MavenDomParameter eachParameter : eachMojo.getParameters().getParameters()) {
                String name;
                if (!((Boolean)eachParameter.getEditable().getValue()).booleanValue() || (name = eachParameter.getName().getStringValue()) == null || namesWithParameters.containsKey(name)) continue;
                ParameterData data = new ParameterData(eachParameter);
                MavenPluginConfigurationDomExtender.fillParameterData(name, data, eachMojo);
                namesWithParameters.put(name, data);
            }
        }
        return namesWithParameters.values();
    }

    private static void fillParameterData(String name, ParameterData data, MavenDomMojo mojo) {
        XmlTag config = mojo.getConfiguration().getXmlTag();
        if (config == null) {
            return;
        }
        for (XmlTag each : config.getSubTags()) {
            if (!name.equals(each.getName())) continue;
            data.defaultValue = each.getAttributeValue("default-value");
            data.expression = each.getValue().getText();
        }
    }

    private static void registerPluginParameter(DomExtensionsRegistrar r, ParameterData parameter) {
        String paramName = parameter.parameter.getName().getStringValue();
        String alias = parameter.parameter.getAlias().getStringValue();
        MavenPluginConfigurationDomExtender.registerPluginParameter(r, parameter, paramName);
        if (alias != null) {
            MavenPluginConfigurationDomExtender.registerPluginParameter(r, parameter, alias);
        }
    }

    private static void registerPluginParameter(DomExtensionsRegistrar r, final ParameterData data, final String parameterName) {
        DomExtension e;
        if (MavenPluginConfigurationDomExtender.isCollection(data.parameter)) {
            e = r.registerFixedNumberChildExtension(new XmlName(parameterName), MavenDomConfigurationParameter.class);
            e.addExtender(new DomExtender(){

                public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                    if (domElement == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender$1.registerExtensions must not be null");
                    }
                    if (registrar == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender$1.registerExtensions must not be null");
                    }
                    for (String each : MavenPluginConfigurationDomExtender.collectPossibleNameForCollectionParameter(parameterName)) {
                        DomExtension inner = registrar.registerCollectionChildrenExtension(new XmlName(each), MavenDomConfigurationParameter.class);
                        inner.putUserData(DomExtension.KEY_DECLARATION, (Object)data.parameter);
                    }
                }
            });
        } else {
            e = r.registerFixedNumberChildExtension(new XmlName(parameterName), MavenDomConfigurationParameter.class);
            MavenPluginConfigurationDomExtender.addValueConverter(e, data.parameter);
            MavenPluginConfigurationDomExtender.addRequiredAnnotation(e, data);
        }
        e.putUserData(DomExtension.KEY_DECLARATION, (Object)data.parameter);
        data.parameter.getXmlElement().putUserData(PLUGIN_PARAMETER_KEY, (Object)data);
    }

    private static void addValueConverter(DomExtension e, MavenDomParameter parameter) {
        String type = parameter.getType().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)type)) {
            e.setConverter((Converter)new MavenPluginCustomParameterValueConverter(type), MavenDomConvertersRegistry.getInstance().isSoft(type));
        }
    }

    private static void addRequiredAnnotation(DomExtension e, ParameterData data) {
        if (!StringUtil.isEmptyOrSpaces((String)data.defaultValue) || !StringUtil.isEmptyOrSpaces((String)data.expression)) {
            return;
        }
        String required = data.parameter.getRequired().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)required)) {
            e.addCustomAnnotation((Annotation)((Object)new MyRequired(required)));
        }
    }

    public static List<String> collectPossibleNameForCollectionParameter(String parameterName) {
        String singularName = StringUtil.unpluralize((String)parameterName);
        if (singularName == null) {
            singularName = parameterName;
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] parts = NameUtil.splitNameIntoWords((String)singularName);
        for (int i = 0; i < parts.length; ++i) {
            result.add(StringUtil.decapitalize((String)StringUtil.join((String[])parts, (int)i, (int)parts.length, (String)"")));
        }
        return result;
    }

    private static boolean isCollection(MavenDomParameter parameter) {
        String type = parameter.getType().getStringValue();
        if (type.endsWith("[]")) {
            return true;
        }
        List<String> collectionClasses = Arrays.asList("java.util.List", "java.util.Set", "java.util.Collection");
        return collectionClasses.contains(type);
    }

    private static class MyRequired
    implements Required {
        private final String myRequired;

        public MyRequired(String required) {
            this.myRequired = required;
        }

        public boolean value() {
            return Boolean.valueOf(this.myRequired);
        }

        public boolean nonEmpty() {
            return false;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }

    public static class ParameterData {
        public MavenDomParameter parameter;
        @Nullable
        public String defaultValue;
        @Nullable
        public String expression;

        private ParameterData(MavenDomParameter parameter) {
            this.parameter = parameter;
        }
    }
}

