/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;

public class SvnChangelistListener
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangelistListener");
    private final Project myProject;
    private final SVNChangelistClient myClient;

    public SvnChangelistListener(Project project, SVNChangelistClient client) {
        this.myProject = project;
        this.myClient = client;
    }

    public void changeListAdded(ChangeList list) {
    }

    public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
        if (SvnChangeProvider.ourDefaultListName.equals(fromList.getName())) {
            return;
        }
        List<String> paths = this.getPathsFromChanges(changes);
        for (String path : paths) {
            try {
                this.myClient.doRemoveFromChangelist(new File[]{new File(path)}, SVNDepth.EMPTY, null);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public void changesAdded(Collection<Change> changes, ChangeList toList) {
        if (toList == null) {
            return;
        }
        if (SvnChangeProvider.ourDefaultListName.equals(toList.getName())) {
            return;
        }
        List<String> paths = this.getPathsFromChanges(changes);
        for (String path : paths) {
            try {
                this.myClient.doAddToChangelist(new File[]{new File(path)}, SVNDepth.EMPTY, toList.getName(), null);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public void changeListRemoved(ChangeList list) {
        List<String> paths = this.getPathsFromChanges(list.getChanges());
        for (String path : paths) {
            try {
                this.myClient.doRemoveFromChangelist(new File[]{new File(path)}, SVNDepth.EMPTY, null);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private boolean isUnderSvn(FilePath path) {
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(path);
        return vcs != null && "svn".equals(vcs.getName());
    }

    private List<String> getPathsFromChanges(Collection<Change> changes) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Change change : changes) {
            String path;
            if (change.getBeforeRevision() != null && this.isUnderSvn(change.getBeforeRevision().getFile()) && !paths.contains(path = change.getBeforeRevision().getFile().getIOFile().getAbsolutePath())) {
                paths.add(path);
            }
            if (change.getAfterRevision() == null || !this.isUnderSvn(change.getAfterRevision().getFile()) || paths.contains(path = change.getAfterRevision().getFile().getIOFile().getAbsolutePath())) continue;
            paths.add(path);
        }
        return paths;
    }

    public void changeListChanged(ChangeList list) {
    }

    public void changeListRenamed(ChangeList list, String oldName) {
        if (Comparing.equal((String)list.getName(), (String)oldName)) {
            return;
        }
        if (SvnChangeProvider.ourDefaultListName.equals(list.getName())) {
            this.changeListRemoved(list);
            return;
        }
        List<String> paths = this.getPathsFromChanges(list.getChanges());
        for (String path : paths) {
            try {
                this.myClient.doAddToChangelist(new File[]{new File(path)}, SVNDepth.EMPTY, list.getName(), null);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public void changeListCommentChanged(ChangeList list, String oldComment) {
    }

    public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
        String[] stringArray;
        if (fromList.getName().equals(toList.getName())) {
            return;
        }
        if (SvnChangeProvider.ourDefaultListName.equals(toList.getName())) {
            this.changeListRemoved(toList);
            return;
        }
        if (SvnChangeProvider.ourDefaultListName.equals(fromList.getName())) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fromList.getName();
        }
        String[] fromLists = stringArray;
        List<String> paths = this.getPathsFromChanges(changes);
        for (String path : paths) {
            try {
                this.myClient.doAddToChangelist(new File[]{new File(path)}, SVNDepth.EMPTY, toList.getName(), fromLists);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
    }

    public void unchangedFileStatusChanged() {
    }

    public void changeListUpdateDone() {
    }

    @Nullable
    public static String getCurrentMapping(Project project, final File file) {
        SvnVcs vcs = SvnVcs.getInstance(project);
        SVNChangelistClient client = vcs.createChangelistClient();
        try {
            final Ref refResult = new Ref();
            ISVNChangelistHandler handler = new ISVNChangelistHandler(){

                public void handle(File path, String changelistName) {
                    if (refResult.isNull() && Comparing.equal((Object)path, (Object)file)) {
                        refResult.set((Object)changelistName);
                    }
                }
            };
            if (file.exists()) {
                client.doGetChangeLists(file, null, SVNDepth.EMPTY, handler);
            } else if (file.getParentFile() != null) {
                client.doGetChangeLists(file.getParentFile(), null, SVNDepth.IMMEDIATES, handler);
            }
            return (String)refResult.get();
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public static void putUnderList(Project project, String list, File after) throws SVNException {
        block2: {
            SvnVcs vcs = SvnVcs.getInstance(project);
            SVNChangelistClient client = vcs.createChangelistClient();
            try {
                client.doAddToChangelist(new File[]{after}, SVNDepth.EMPTY, list, null);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                if (SVNErrorCode.WC_NOT_DIRECTORY.equals((Object)e.getErrorMessage().getErrorCode()) || SVNErrorCode.WC_NOT_FILE.equals((Object)e.getErrorMessage().getErrorCode())) break block2;
                throw e;
            }
        }
    }

    public static void removeFromList(Project project, File after) throws SVNException {
        block2: {
            SvnVcs vcs = SvnVcs.getInstance(project);
            SVNChangelistClient client = vcs.createChangelistClient();
            try {
                client.doRemoveFromChangelist(new File[]{after}, SVNDepth.EMPTY, null);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                if (SVNErrorCode.WC_NOT_DIRECTORY.equals((Object)e.getErrorMessage().getErrorCode()) || SVNErrorCode.WC_NOT_FILE.equals((Object)e.getErrorMessage().getErrorCode())) break block2;
                throw e;
            }
        }
    }
}

