/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.uiDesigner.wizard.BeanProperty;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

final class BeanPropertyTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JTextField myEditorComponent = new JTextField();

    public BeanPropertyTableCellEditor() {
        this.myEditorComponent.setBorder(null);
    }

    @Override
    public Object getCellEditorValue() {
        String propertyName = this.myEditorComponent.getText().trim();
        if (propertyName.length() != 0) {
            return new BeanProperty(propertyName, "java.lang.String");
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        BeanProperty property = (BeanProperty)value;
        if (property != null) {
            this.myEditorComponent.setText(property.myName);
        } else {
            this.myEditorComponent.setText(null);
        }
        return this.myEditorComponent;
    }
}

