/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import git4idea.GitRemote;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeUtil;
import git4idea.ui.GitUIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class GitPullDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JComboBox myGitRoot;
    private JLabel myCurrentBranch;
    private JComboBox myStrategy;
    private JCheckBox myNoCommitCheckBox;
    private JCheckBox mySquashCommitCheckBox;
    private JCheckBox myNoFastForwardCheckBox;
    private JCheckBox myAddLogInformationCheckBox;
    private JComboBox myRemote;
    private JButton myGetBranchesButton;
    private ElementsChooser<String> myBranchChooser;
    private final Project myProject;

    public GitPullDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.getString("pull.title"));
        this.myProject = project;
        GitUIUtil.setupRootChooser(this.myProject, roots, defaultRoot, this.myGitRoot, this.myCurrentBranch);
        this.myGitRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitPullDialog.this.updateRemotes();
            }
        });
        this.setOKButtonText(GitBundle.getString("pull.button"));
        this.updateRemotes();
        this.setupBranches();
        this.setupGetBranches();
        ElementsChooser.ElementsMarkListener<String> listener = new ElementsChooser.ElementsMarkListener<String>(){

            public void elementMarkChanged(String element, boolean isMarked) {
                GitPullDialog.this.validateDialog();
            }
        };
        this.myBranchChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)listener);
        listener.elementMarkChanged(null, true);
        GitUIUtil.imply(this.mySquashCommitCheckBox, true, this.myNoCommitCheckBox, true);
        GitUIUtil.imply(this.mySquashCommitCheckBox, true, this.myAddLogInformationCheckBox, false);
        GitUIUtil.exclusive(this.mySquashCommitCheckBox, true, this.myNoFastForwardCheckBox, true);
        GitMergeUtil.setupStrategies(this.myBranchChooser, this.myStrategy);
        this.init();
    }

    private void setupBranches() {
        ((JTextField)this.myRemote.getEditor().getEditorComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitPullDialog.this.updateBranches();
            }
        });
        this.updateBranches();
    }

    private void validateDialog() {
        if (this.getRemote().trim().length() == 0) {
            this.setOKActionEnabled(false);
            return;
        }
        this.setOKActionEnabled(this.myBranchChooser.getMarkedElements().size() != 0);
    }

    private void setupGetBranches() {
        final JTextField textField = (JTextField)this.myRemote.getEditor().getEditorComponent();
        DocumentAdapter listener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitPullDialog.this.validateDialog();
                GitPullDialog.this.myGetBranchesButton.setEnabled(textField.getText().trim().length() != 0);
            }
        };
        textField.getDocument().addDocumentListener((DocumentListener)listener);
        listener.changedUpdate(null);
        this.myGetBranchesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitSimpleHandler h = new GitSimpleHandler(GitPullDialog.this.myProject, GitPullDialog.this.gitRoot(), GitCommand.LS_REMOTE);
                h.addParameters("--heads", GitPullDialog.this.myRemote.getSelectedItem().toString());
                String output = GitHandlerUtil.doSynchronously(h, GitBundle.getString("pull.getting.remote.branches"), h.printableCommandLine());
                if (output == null) {
                    return;
                }
                GitPullDialog.this.myBranchChooser.removeAllElements();
                for (String line : output.split("\n")) {
                    if (line.length() == 0) continue;
                    int pos = line.lastIndexOf(47);
                    if (pos == -1) {
                        pos = line.lastIndexOf(9);
                    }
                    GitPullDialog.this.myBranchChooser.addElement((Object)line.substring(pos + 1), false);
                }
            }
        });
    }

    public GitLineHandler pullHandler() {
        String strategy;
        GitLineHandler h = new GitLineHandler(this.myProject, this.gitRoot(), GitCommand.PULL);
        h.ignoreErrorCode(1);
        h.addParameters("--no-stat");
        if (this.myNoCommitCheckBox.isSelected()) {
            h.addParameters("--no-commit");
        } else if (this.myAddLogInformationCheckBox.isSelected()) {
            h.addParameters("--log");
        }
        if (this.mySquashCommitCheckBox.isSelected()) {
            h.addParameters("--squash");
        }
        if (this.myNoFastForwardCheckBox.isSelected()) {
            h.addParameters("--no-ff");
        }
        if (!GitMergeUtil.DEFAULT_STRATEGY.equals(strategy = (String)this.myStrategy.getSelectedItem())) {
            h.addParameters("--strategy", strategy);
        }
        h.addParameters("-v");
        h.addParameters(this.getRemote());
        List markedBranches = this.myBranchChooser.getMarkedElements();
        h.addParameters(ArrayUtil.toStringArray((Collection)markedBranches));
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranches() {
        try {
            String item = this.getRemote();
            this.myBranchChooser.removeAllElements();
            GitRemote r = null;
            int count = this.myRemote.getItemCount();
            for (int i = 0; i < count; ++i) {
                GitRemote candidate = (GitRemote)this.myRemote.getItemAt(i);
                if (!candidate.name().equals(item)) continue;
                r = candidate;
                break;
            }
            if (r == null) {
                return;
            }
            GitRemote.Info ri = r.localInfo(this.myProject, this.gitRoot());
            String toSelect = ri.getRemoteForLocal(this.currentBranch());
            for (String trackedBranch : ri.trackedBranches()) {
                this.myBranchChooser.addElement((Object)trackedBranch, trackedBranch.equals(toSelect));
            }
        }
        catch (VcsException e) {
            GitVcs.getInstance(this.myProject).showErrors(Collections.singletonList(e), GitBundle.getString("pull.retrieving.remotes"));
        }
        finally {
            this.validateDialog();
        }
    }

    @Nullable
    private String currentBranch() {
        String text = this.myCurrentBranch.getText();
        return text.equals(GitUIUtil.NO_CURRENT_BRANCH) ? null : text;
    }

    private void updateRemotes() {
        GitUIUtil.setupRemotes(this.myProject, this.gitRoot(), this.currentBranch(), this.myRemote, true);
    }

    public VirtualFile gitRoot() {
        return (VirtualFile)this.myGitRoot.getSelectedItem();
    }

    private void createUIComponents() {
        this.myBranchChooser = new ElementsChooser(true);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Pull";
    }

    public String getRemote() {
        return ((JTextField)this.myRemote.getEditor().getEditorComponent()).getText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JComboBox jComboBox2;
        JLabel jLabel;
        JComboBox jComboBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRoot = jComboBox3 = new JComboBox();
        jComboBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox3, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jLabel.setText("  ");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("pull.remote"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.branches"));
        jPanel.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.strategy"));
        jPanel.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myStrategy = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.strategy"));
        jPanel.add(jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNoCommitCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.commit.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.commit"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySquashCommitCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.squash.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.squash.commit"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNoFastForwardCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.fast.forward.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.fast.forward"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddLogInformationCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.add.log.information.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.add.log.information"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myRemote = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("pull.remote.tooltip"));
        jComboBox.setEditable(true);
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myGetBranchesButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("pull.get.branches"));
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("pull.get.branches.tooltip"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        ElementsChooser<String> elementsChooser = this.myBranchChooser;
        jPanel.add((Component)elementsChooser, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 7, null, null, null));
        jLabel2.setLabelFor(jComboBox3);
        jLabel4.setLabelFor(jComboBox);
        jLabel6.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

