/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.config.GitConfigUtil;
import git4idea.vfs.GitConfigListener;
import git4idea.vfs.GitRootsListener;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitIgnoreTracker {
    private final ProjectLevelVcsManager myVcsManager;
    private Project myProject;
    private final GitVcs myVcs;
    private static final String LOCAL_EXCLUDE = ".git/info/exclude";
    private static final String[] LOCAL_EXCLUDE_ARRAY = ".git/info/exclude".split("/");
    private static final String GIT_FOLDER = ".git";
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final GitRootsListener myVcsListener;
    private final MyFileListener myFileListener;
    private GitConfigListener myConfigListener;
    private final Map<VirtualFile, String> myExcludeFiles = new HashMap();
    private final Set<String> myExcludeFilesPaths = new HashSet();
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";

    public GitIgnoreTracker(Project project, GitVcs vcs) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        this.myVcsListener = new GitRootsListener(){

            @Override
            public void gitRootsChanged() {
                GitIgnoreTracker.this.scan();
            }
        };
        this.myConfigListener = new GitConfigListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void configChanged(@NotNull VirtualFile gitRoot, @Nullable VirtualFile configFile) {
                String oldPath;
                if (gitRoot == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/vfs/GitIgnoreTracker$2.configChanged must not be null");
                }
                Map map = GitIgnoreTracker.this.myExcludeFiles;
                synchronized (map) {
                    if (!GitIgnoreTracker.this.myExcludeFiles.containsKey(gitRoot)) {
                        return;
                    }
                    oldPath = (String)GitIgnoreTracker.this.myExcludeFiles.get(gitRoot);
                }
                String newPath = GitIgnoreTracker.this.getExcludeFile(gitRoot);
                if (oldPath == null ? newPath == null : oldPath.equals(newPath)) {
                    return;
                }
                Map map2 = GitIgnoreTracker.this.myExcludeFiles;
                synchronized (map2) {
                    GitIgnoreTracker.this.myExcludeFiles.put(gitRoot, newPath);
                    GitIgnoreTracker.this.myExcludeFilesPaths.clear();
                    GitIgnoreTracker.this.myExcludeFilesPaths.addAll(GitIgnoreTracker.this.myExcludeFiles.values());
                }
                GitIgnoreTracker.this.myDirtyScopeManager.dirDirtyRecursively(gitRoot);
            }
        };
        this.myVcs.addGitRootsListener(this.myVcsListener);
        this.myVcs.addGitConfigListener(this.myConfigListener);
        this.myFileListener = new MyFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myFileListener);
        this.scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() {
        VirtualFile[] contentRoots = this.myVcsManager.getRootsUnderVcs((AbstractVcs)this.myVcs);
        if (contentRoots == null || contentRoots.length == 0) {
            return;
        }
        HashMap newRoots = new HashMap();
        for (VirtualFile root : contentRoots) {
            VirtualFile gitRoot = GitIgnoreTracker.scanParents(root);
            if (newRoots.containsKey((Object)gitRoot)) continue;
            newRoots.put((Object)gitRoot, (Object)this.getExcludeFile(gitRoot));
        }
        Map<VirtualFile, String> map = this.myExcludeFiles;
        synchronized (map) {
            this.myExcludeFiles.clear();
            this.myExcludeFiles.putAll((Map<VirtualFile, String>)newRoots);
            this.myExcludeFilesPaths.clear();
            this.myExcludeFilesPaths.addAll(this.myExcludeFiles.values());
        }
    }

    @Nullable
    private String getExcludeFile(VirtualFile gitRoot) {
        try {
            VirtualFile fileForPath;
            String file = GitConfigUtil.getValue(this.myProject, gitRoot, "core.excludesfile");
            file = this.fixFileName(file);
            if (file != null && file.trim().length() != 0 && (fileForPath = LocalFileSystem.getInstance().findFileByPath(file)) != null) {
                return fileForPath.getPath();
            }
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        return null;
    }

    private String fixFileName(String file) {
        if (SystemInfo.isWindows && file != null && file.startsWith("/")) {
            int cp = CYGDRIVE_PREFIX.length();
            if (file.startsWith(CYGDRIVE_PREFIX) && file.length() > cp + 3 && Character.isLetter(file.charAt(cp)) && file.charAt(cp + 1) == '/') {
                return String.valueOf(file.charAt(cp)) + ":" + file.substring(cp + 1);
            }
            if (file.length() > 3 && Character.isLetter(file.charAt(1)) && file.charAt(2) == '/') {
                return String.valueOf(file.charAt(1)) + ":" + file.substring(2);
            }
            File gitDir = new File(this.myVcs.getSettings().getGitExecutable()).getParentFile();
            if (gitDir != null) {
                gitDir = gitDir.getParentFile();
            }
            if (gitDir != null) {
                return new File(gitDir, file.substring(1)).getPath();
            }
        }
        return file;
    }

    @Nullable
    private static VirtualFile scanParents(VirtualFile root) {
        VirtualFile meta = root.findChild(GIT_FOLDER);
        if (meta != null) {
            root.findFileByRelativePath(LOCAL_EXCLUDE);
            return root;
        }
        VirtualFile parent = root.getParent();
        if (parent != null) {
            return GitIgnoreTracker.scanParents(parent);
        }
        return null;
    }

    public void dispose() {
        this.myVcs.removeGitRootsListener(this.myVcsListener);
        this.myVcs.removeGitConfigListener(this.myConfigListener);
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myFileListener);
    }

    class MyFileListener
    extends VirtualFileAdapter {
        MyFileListener() {
        }

        public void fileCreated(VirtualFileEvent event) {
            this.checkIgnoreConfigChange(event.getFile());
        }

        public void beforeFileDeletion(VirtualFileEvent event) {
            this.checkIgnoreConfigChange(event.getFile());
        }

        public void beforeFileMovement(VirtualFileMoveEvent event) {
            if (".gitignore".equals(event.getFileName())) {
                GitIgnoreTracker.this.myDirtyScopeManager.dirDirtyRecursively(event.getNewParent());
                GitIgnoreTracker.this.myDirtyScopeManager.dirDirtyRecursively(event.getOldParent());
            }
            this.checkExcludeFile(event.getOldParent().findChild(event.getFileName()));
        }

        public void fileMoved(VirtualFileMoveEvent event) {
            this.checkExcludeFile(event.getNewParent().findChild(event.getFileName()));
        }

        public void fileCopied(VirtualFileCopyEvent event) {
            this.checkIgnoreConfigChange(event.getFile());
        }

        public void contentsChanged(VirtualFileEvent event) {
            this.checkIgnoreConfigChange(event.getFile());
        }

        private void checkIgnoreConfigChange(VirtualFile file) {
            if (".gitignore".equals(file.getName())) {
                VirtualFile parent = file.getParent();
                if (parent != null) {
                    GitIgnoreTracker.this.myDirtyScopeManager.dirDirtyRecursively(parent);
                }
                return;
            }
            VirtualFile base = GitUtil.getPossibleBase(file, LOCAL_EXCLUDE_ARRAY);
            if (base != null) {
                GitIgnoreTracker.this.myDirtyScopeManager.dirDirtyRecursively(base);
                return;
            }
            this.checkExcludeFile(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkExcludeFile(VirtualFile file) {
            String path = file.getPath();
            LinkedList toDirty = null;
            Map map = GitIgnoreTracker.this.myExcludeFiles;
            synchronized (map) {
                if (GitIgnoreTracker.this.myExcludeFilesPaths.contains(path)) {
                    toDirty = new LinkedList();
                    for (Map.Entry entry : GitIgnoreTracker.this.myExcludeFiles.entrySet()) {
                        if (!path.equals(entry.getValue())) continue;
                        toDirty.add(entry.getKey());
                    }
                }
            }
            if (toDirty != null) {
                for (VirtualFile f : toDirty) {
                    GitIgnoreTracker.this.myDirtyScopeManager.dirDirtyRecursively(f);
                }
            }
        }
    }
}

