/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class LookupElementDecorator<T extends LookupElement>
extends LookupElement {
    private final T myDelegate;

    protected LookupElementDecorator(T delegate) {
        this.myDelegate = delegate;
        this.myDelegate.copyUserDataTo((UserDataHolderBase)this);
        PrefixMatcher matcher = ((LookupElement)((Object)delegate)).getPrefixMatcher();
        if (matcher != PrefixMatcher.FALSE_MATCHER) {
            boolean prefixStillMatches = CompletionService.getCompletionService().prefixMatches(this, matcher);
            assert (prefixStillMatches);
        }
    }

    public T getDelegate() {
        return this.myDelegate;
    }

    @Override
    public boolean setPrefixMatcher(@NotNull PrefixMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementDecorator.setPrefixMatcher must not be null");
        }
        ((LookupElement)((Object)this.myDelegate)).setPrefixMatcher(matcher);
        return super.setPrefixMatcher(matcher);
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = ((LookupElement)((Object)this.myDelegate)).getLookupString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElementDecorator.getLookupString must not return null");
        }
        return string;
    }

    @Override
    public Set<String> getAllLookupStrings() {
        return ((LookupElement)((Object)this.myDelegate)).getAllLookupStrings();
    }

    @Override
    @NotNull
    public Object getObject() {
        Object object = ((LookupElement)((Object)this.myDelegate)).getObject();
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElementDecorator.getObject must not return null");
        }
        return object;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        ((LookupElement)((Object)this.myDelegate)).handleInsert(context);
    }

    @Override
    public String toString() {
        return ((LookupElement)((Object)this.myDelegate)).toString();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        ((LookupElement)((Object)this.myDelegate)).renderElement(presentation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LookupElementDecorator that = (LookupElementDecorator)((Object)o);
        return this.myDelegate.equals(that.myDelegate);
    }

    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    @NotNull
    public static <T extends LookupElement> LookupElementDecorator<T> withInsertHandler(@NotNull T element, @NotNull InsertHandler<? super LookupElementDecorator<T>> insertHandler) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementDecorator.withInsertHandler must not be null");
        }
        if (insertHandler == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementDecorator.withInsertHandler must not be null");
        }
        InsertingDecorator<T> insertingDecorator = new InsertingDecorator<T>(element, insertHandler);
        if (insertingDecorator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElementDecorator.withInsertHandler must not return null");
        }
        return insertingDecorator;
    }

    @NotNull
    public static <T extends LookupElement> LookupElementDecorator<T> withRenderer(@NotNull T element, @NotNull LookupElementRenderer<? super LookupElementDecorator<T>> visagiste) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementDecorator.withRenderer must not be null");
        }
        if (visagiste == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementDecorator.withRenderer must not be null");
        }
        VisagisteDecorator<T> visagisteDecorator = new VisagisteDecorator<T>(element, visagiste);
        if (visagisteDecorator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElementDecorator.withRenderer must not return null");
        }
        return visagisteDecorator;
    }

    @Override
    public <T> T as(Class<T> aClass) {
        T t = super.as(aClass);
        return t == null ? ((LookupElement)((Object)this.myDelegate)).as(aClass) : t;
    }

    @Override
    public boolean isCaseSensitive() {
        return ((LookupElement)((Object)this.myDelegate)).isCaseSensitive();
    }

    private static class VisagisteDecorator<T extends LookupElement>
    extends LookupElementDecorator<T> {
        private final LookupElementRenderer<? super LookupElementDecorator<T>> myVisagiste;

        public VisagisteDecorator(T element, LookupElementRenderer<? super LookupElementDecorator<T>> visagiste) {
            super(element);
            this.myVisagiste = visagiste;
        }

        @Override
        public void renderElement(LookupElementPresentation presentation) {
            this.myVisagiste.renderElement(this, presentation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VisagisteDecorator that = (VisagisteDecorator)((Object)o);
            return this.myVisagiste.getClass().equals(that.myVisagiste.getClass());
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myVisagiste.getClass().hashCode();
            return result;
        }
    }

    private static class InsertingDecorator<T extends LookupElement>
    extends LookupElementDecorator<T> {
        private final InsertHandler<? super LookupElementDecorator<T>> myInsertHandler;

        public InsertingDecorator(T element, InsertHandler<? super LookupElementDecorator<T>> insertHandler) {
            super(element);
            this.myInsertHandler = insertHandler;
        }

        @Override
        public void handleInsert(InsertionContext context) {
            this.myInsertHandler.handleInsert(context, this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InsertingDecorator that = (InsertingDecorator)((Object)o);
            return this.myInsertHandler.equals(that.myInsertHandler);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myInsertHandler.hashCode();
            return result;
        }
    }
}

